/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.OneNoteDirectFileResource;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class OneNoteLegacyDumpStrings {
    public static int MIN_STRING_LENGTH = 8;
    public static float ACCEPTABLE_ALPHA_TO_OTHER_CHAR_RATIO = 0.6f;
    public static long BUFFER_SIZE = 1000000L;
    OneNoteDirectFileResource oneNoteDirectFileResource;
    XHTMLContentHandler xhtml;

    public OneNoteLegacyDumpStrings(OneNoteDirectFileResource oneNoteDirectFileResource, XHTMLContentHandler xhtml) {
        this.oneNoteDirectFileResource = oneNoteDirectFileResource;
        this.xhtml = xhtml;
    }

    public void dump() throws TikaException, SAXException {
        this.dumpAscii();
        this.dumpUtf16LE();
    }

    private void dumpAscii() throws SAXException, TikaException {
        try {
            long pos;
            this.oneNoteDirectFileResource.position(0L);
            UnsynchronizedByteArrayOutputStream os = UnsynchronizedByteArrayOutputStream.builder().get();
            long sz = this.oneNoteDirectFileResource.size();
            while ((pos = this.oneNoteDirectFileResource.position()) != sz) {
                long nextBufferSize = BUFFER_SIZE;
                if (sz - pos < BUFFER_SIZE) {
                    nextBufferSize = sz - pos;
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate((int)nextBufferSize);
                this.oneNoteDirectFileResource.read(byteBuffer);
                for (long i = 0L; i < nextBufferSize - 1L; ++i) {
                    byte b = byteBuffer.get((int)i);
                    if (b >= 32 && b < 127) {
                        os.write((int)b);
                        continue;
                    }
                    if (os.size() >= MIN_STRING_LENGTH) {
                        this.writeIfUseful(os);
                    }
                    os.reset();
                }
                if (os.size() < MIN_STRING_LENGTH) continue;
                this.writeIfUseful(os);
            }
        }
        catch (IOException e) {
            throw new TikaException("Could not extract text from legacy OneNote document", (Throwable)e);
        }
    }

    private void dumpUtf16LE() throws SAXException, TikaException {
        try {
            long pos;
            this.oneNoteDirectFileResource.position(0L);
            UnsynchronizedByteArrayOutputStream os = UnsynchronizedByteArrayOutputStream.builder().get();
            long sz = this.oneNoteDirectFileResource.size();
            long bufSize = BUFFER_SIZE;
            if (bufSize % 2L == 1L) {
                ++bufSize;
            }
            while ((pos = this.oneNoteDirectFileResource.position()) != sz) {
                long nextBufferSize = bufSize;
                if (sz - pos < bufSize) {
                    nextBufferSize = sz - pos;
                }
                ByteBuffer byteBuffer = ByteBuffer.allocate((int)nextBufferSize);
                this.oneNoteDirectFileResource.read(byteBuffer);
                for (long i = 0L; i < nextBufferSize - 1L; ++i) {
                    int c1 = byteBuffer.get((int)i) & 0xFF;
                    byte c2 = byteBuffer.get((int)i + 1);
                    if (c2 == 0 && c1 >= 32) {
                        ++i;
                        os.write(c1);
                        continue;
                    }
                    if (os.size() >= MIN_STRING_LENGTH) {
                        this.writeIfUseful(os);
                    }
                    os.reset();
                }
                if (os.size() < MIN_STRING_LENGTH) continue;
                this.writeIfUseful(os);
            }
        }
        catch (IOException e) {
            throw new TikaException("Could not extract text from legacy OneNote document", (Throwable)e);
        }
    }

    private void writeIfUseful(UnsynchronizedByteArrayOutputStream os) throws SAXException {
        String str = os.toString(StandardCharsets.ISO_8859_1);
        String[] spl = str.split(" ");
        if (spl.length > 1) {
            int numAlpha = 0;
            for (int i = 0; i < str.length(); ++i) {
                if (!Character.isAlphabetic(str.charAt(i)) && !Character.isWhitespace(i)) continue;
                ++numAlpha;
            }
            float ratioAlphaToOtherChars = (float)numAlpha / (float)str.length();
            if (ratioAlphaToOtherChars > ACCEPTABLE_ALPHA_TO_OTHER_CHAR_RATIO) {
                this.xhtml.characters(str);
                this.xhtml.characters("\n");
            }
        }
    }
}

