/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import javafx.geometry.NodeOrientation;
import javafx.scene.TraversalDirection;

public enum Direction {
    UP(false),
    DOWN(true),
    LEFT(false),
    RIGHT(true),
    NEXT(true),
    NEXT_IN_LINE(true),
    PREVIOUS(false);

    private final boolean forward;

    private Direction(boolean bl) {
        this.forward = bl;
    }

    public boolean isForward() {
        return this.forward;
    }

    public Direction getDirectionForNodeOrientation(NodeOrientation nodeOrientation) {
        if (nodeOrientation == NodeOrientation.RIGHT_TO_LEFT) {
            switch (this.ordinal()) {
                case 2: {
                    return RIGHT;
                }
                case 3: {
                    return LEFT;
                }
            }
        }
        return this;
    }

    public static Direction of(TraversalDirection traversalDirection) {
        return switch (traversalDirection) {
            default -> throw new MatchException(null, null);
            case TraversalDirection.DOWN -> DOWN;
            case TraversalDirection.LEFT -> LEFT;
            case TraversalDirection.NEXT -> NEXT;
            case TraversalDirection.PREVIOUS -> PREVIOUS;
            case TraversalDirection.RIGHT -> RIGHT;
            case TraversalDirection.UP -> UP;
        };
    }
}

