/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.BrokerRegistrationResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;

public class BrokerRegistrationRequest
extends AbstractRequest {
    private final BrokerRegistrationRequestData data;

    public BrokerRegistrationRequest(BrokerRegistrationRequestData data, short version) {
        super(ApiKeys.BROKER_REGISTRATION, version);
        this.data = data;
    }

    @Override
    public BrokerRegistrationRequestData data() {
        return this.data;
    }

    @Override
    public BrokerRegistrationResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()));
    }

    public static BrokerRegistrationRequest parse(Readable readable, short version) {
        return new BrokerRegistrationRequest(new BrokerRegistrationRequestData(readable, version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<BrokerRegistrationRequest> {
        private final BrokerRegistrationRequestData data;

        public Builder(BrokerRegistrationRequestData data) {
            super(ApiKeys.BROKER_REGISTRATION);
            this.data = data;
        }

        @Override
        public short oldestAllowedVersion() {
            if (this.data.isMigratingZkBroker()) {
                return 1;
            }
            return 0;
        }

        @Override
        public BrokerRegistrationRequest build(short version) {
            if (version < 4) {
                BrokerRegistrationRequestData newData = this.data.duplicate();
                newData.features().removeIf(feature -> feature.minSupportedVersion() == 0);
                return new BrokerRegistrationRequest(newData, version);
            }
            return new BrokerRegistrationRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

