/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.Timer;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class PulseTracker
implements ActionListener {
    private static WeakHashMap<JButton, PulseTracker> trackers = new WeakHashMap();
    private static WeakHashMap<JButton, Long> cycles = new WeakHashMap();
    private WeakReference<JButton> buttonRef;
    private Timer timer;

    private PulseTracker(JButton jbutton) {
        this.buttonRef = new WeakReference<JButton>(jbutton);
        this.timer = new Timer(50, this);
        this.timer.setCoalesce(true);
        trackers.put(jbutton, this);
        cycles.put(jbutton, 0L);
    }

    private static boolean isInFocusedWindow(Component component) {
        if (component == null) {
            return false;
        }
        if (component.isFocusOwner()) {
            return true;
        }
        if (component instanceof Container) {
            for (Component comp : ((Container)component).getComponents()) {
                if (!PulseTracker.isInFocusedWindow(comp)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasGlassPane(Component component) {
        if (component == null) {
            return false;
        }
        Component glassPane = null;
        if (component instanceof JDialog) {
            glassPane = ((JDialog)component).getGlassPane();
        }
        if (component instanceof JFrame) {
            glassPane = ((JFrame)component).getGlassPane();
        }
        return glassPane != null && glassPane.isVisible();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton jButton = (JButton)this.buttonRef.get();
        if (jButton == null) {
            return;
        }
        if (PulseTracker.hasGlassPane(jButton.getTopLevelAncestor())) {
            return;
        }
        if (!PulseTracker.isPulsating(jButton)) {
            PulseTracker tracker = trackers.get(jButton);
            tracker.stopTimer();
            tracker.buttonRef.clear();
            trackers.remove(jButton);
            cycles.remove(jButton);
        } else if (!PulseTracker.isInFocusedWindow(jButton.getTopLevelAncestor()) && !PulseTracker.isAttentionDrawingCloseButton(jButton)) {
            PulseTracker.update(jButton);
        } else if (jButton.isEnabled()) {
            long oldCycle = cycles.get(jButton);
            if (oldCycle == 20L) {
                oldCycle = PulseTracker.isAttentionDrawingCloseButton(jButton) ? -80L : 0L;
            }
            cycles.put(jButton, oldCycle + 1L);
        } else if (cycles.get(jButton) != 0L) {
            cycles.put(jButton, 0L);
        }
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            jButton.repaint();
        }
    }

    private void startTimer() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    private void stopTimer() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    private boolean isRunning() {
        return this.timer.isRunning();
    }

    public static void update(JButton jButton) {
        boolean hasFocus = PulseTracker.isInFocusedWindow(jButton.getTopLevelAncestor());
        PulseTracker tracker = trackers.get(jButton);
        if (!hasFocus) {
            if (tracker == null) {
                return;
            }
            if (cycles.get(jButton) == 0L) {
                return;
            }
            cycles.put(jButton, 0L);
        } else {
            if (tracker != null) {
                tracker.startTimer();
                return;
            }
            tracker = new PulseTracker(jButton);
            tracker.startTimer();
            trackers.put(jButton, tracker);
            long initialCycle = PulseTracker.isAttentionDrawingCloseButton(jButton) ? -80L : 0L;
            cycles.put(jButton, initialCycle);
        }
    }

    public static long getCycles(JButton jButton) {
        Long cycleCount = cycles.get(jButton);
        if (cycleCount == null) {
            return 0L;
        }
        long result = cycleCount;
        if (result < 0L) {
            result = 0L;
        }
        return result;
    }

    public static boolean isAnimating(JButton jButton) {
        PulseTracker tracker = trackers.get(jButton);
        if (tracker == null) {
            return false;
        }
        return tracker.isRunning();
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("PulseTracker: \n");
        sb.append("\t" + trackers.size() + " trackers, " + cycles.size() + " cycles");
        return sb.toString();
    }

    public static boolean isAttentionDrawingCloseButton(JButton jButton) {
        if (SubstanceCoreUtilities.isTitleCloseButton(jButton)) {
            boolean isWindowModified = false;
            for (Container comp = jButton; comp != null; comp = comp.getParent()) {
                if (comp instanceof JInternalFrame) {
                    JInternalFrame jif = (JInternalFrame)comp;
                    isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                    break;
                }
                if (comp instanceof JRootPane) {
                    JRootPane jrp = (JRootPane)comp;
                    isWindowModified = Boolean.TRUE.equals(jrp.getClientProperty("windowModified"));
                    break;
                }
                if (!(comp instanceof JInternalFrame.JDesktopIcon)) continue;
                JInternalFrame.JDesktopIcon jdi = (JInternalFrame.JDesktopIcon)comp;
                JInternalFrame jif = jdi.getInternalFrame();
                isWindowModified = Boolean.TRUE.equals(jif.getClientProperty("windowModified"));
                break;
            }
            if (isWindowModified) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPulsating(JButton jButton) {
        boolean isDefault = jButton.isDefaultButton();
        if (isDefault) {
            return true;
        }
        return PulseTracker.isAttentionDrawingCloseButton(jButton);
    }

    public static void stopAllTimers() {
        for (PulseTracker tracker : trackers.values()) {
            tracker.stopTimer();
        }
    }
}

