/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxTmpFile;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxBlob
extends IfxObject {
    private static final short TYPE_IS_BYTE = 0;
    private static final short TYPE_IS_TEXT = 1;
    private static final short TYPE_IS_BLOB = 2;
    private static final short TYPE_IS_CLOB = 3;
    protected static final short BLOBISNULL = 1;
    protected static final short BLOB_TYPE_BYTES = 0;
    protected static final short BLOB_TYPE_STREAM = 1;
    protected byte[] blobDesc = null;
    protected int tb_start = 1;
    protected int tb_end = 0;
    protected int tb_size;
    protected short tb_flags;
    protected InputStream BlobInputStream;
    protected IfxTmpFile tempBlobFile = null;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short ifxType = 0;

    IfxBlob() throws SQLException {
        this.blobDesc = new byte[56];
        this.nullify();
    }

    public IfxBlob(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
    }

    public IfxBlob(byte[] blobBuffer) {
        this.fromBytes(blobBuffer);
    }

    protected short getBlobType() {
        return this.blobType;
    }

    protected boolean isBlobByteType() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 3");
        }
        return this.blobType == 0;
    }

    protected boolean isIfxTextType() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 3");
        }
        return this.ifxType == 1;
    }

    protected byte[] getBlobBuffer() {
        return this.blobBuffer;
    }

    protected void setBlobBuffer(byte[] buffer) {
        this.blobBuffer = buffer;
    }

    protected int getBlobLength() {
        return this.tb_end - this.tb_start + 1;
    }

    protected void setBlobLength(int size, int start, int end) {
        this.tb_size = size;
        this.tb_start = start;
        this.tb_end = end;
    }

    protected void setBlobLength(int size) {
        this.setBlobLength(size, 1, size);
    }

    protected InputStream getBlobInputStream() {
        return this.BlobInputStream;
    }

    protected void setBlobFileName() {
        if (this.tempBlobFile != null) {
            this.tempBlobFile.close();
            this.tempBlobFile = null;
        }
    }

    protected boolean isBlobLoaded() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 4");
        }
        return this.isBlob_loaded;
    }

    protected void setLoaded() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 5");
        }
        this.isBlob_loaded = true;
    }

    @Override
    public void fromIfx(byte[] b) throws SQLException {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int size) throws SQLException {
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(b, offset, this.blobDesc, 0, 56);
        byte[] bIntSize = new byte[4];
        byte[] bIntStart = new byte[4];
        byte[] bIntEnd = new byte[4];
        byte[] bShort = new byte[2];
        System.arraycopy(b, 16 + offset, bIntSize, 0, 4);
        System.arraycopy(b, 8 + offset, bIntStart, 0, 4);
        System.arraycopy(b, 12 + offset, bIntEnd, 0, 4);
        this.setBlobLength(IfxToJavaType.IfxToJavaInt(bIntSize), IfxToJavaType.IfxToJavaInt(bIntStart), IfxToJavaType.IfxToJavaInt(bIntEnd));
        boolean XPS = this.conn.isXPS();
        if (XPS) {
            this.tb_size = this.tb_end - this.tb_start + 1;
        }
        System.arraycopy(b, 38 + offset, bShort, 0, 2);
        this.tb_flags = IfxToJavaType.IfxToJavaSmallInt(bShort);
        if (this.tb_flags != 1) {
            this.isBlob_loaded = false;
            this.blobType = 0;
            this.unnullify();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 6");
        }
    }

    @Override
    public byte[] toIfx() {
        byte[] bint = new byte[4];
        bint = JavaToIfxType.JavaToIfxInt(this.tb_size);
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(bint, 0, this.blobDesc, 16, 4);
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 7");
        }
        return this.blobDesc;
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            if (this.blobDesc == null) {
                this.blobDesc = new byte[56];
            }
            this.blobDesc[39] = 1;
            return this.blobDesc;
        }
        return this.toIfx();
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 8");
        }
        if (this.tempBlobFile != null) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(99, "IfxBlob() : - 8_1");
            }
            try {
                return this.tempBlobFile.getInputStream();
            }
            catch (Exception e) {
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(99, "IfxBlob:toAsciiStream(): " + e.getMessage());
                }
                SQLException sqlException = IfxErrMsg.getSQLException(-79701, e.toString(), this.conn);
                sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
                throw sqlException;
            }
        }
        if (this.blobBuffer != null) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(99, "IfxBlob() : - 8_2");
            }
            return new ByteArrayInputStream(this.blobBuffer);
        }
        return null;
    }

    @Override
    public void fromInputStream(InputStream fin, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length must be less than Integer.MAX_VALUE for this data type");
        }
        this.fromInputStream(fin, (int)length);
    }

    @Override
    public void fromInputStream(InputStream fin, int length) throws SQLException {
        this.setBlobLength(length);
        this.BlobInputStream = fin instanceof IfxLobInputStream ? ((IfxLobInputStream)fin).getStream() : fin;
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.blobBuffer = null;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.dumpTblob();
            this.writeTrace(99, "IfxBlob.fromInputStream() : - 1");
        }
    }

    @Override
    public void fromCharacterStream(Reader x, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length must be less than Integer.MAX_VALUE for this data type");
        }
        this.fromCharacterStream(x, (int)length);
    }

    @Override
    public void fromCharacterStream(Reader x, int length) throws SQLException {
        if (length < 0) {
            throw IfxErrMsg.getSQLException(-79716, "Cannot read from Reader/InputStream into a TEXT/BYTE field w/o a length specified", this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob: fromCharacterStream() start...");
        }
        if (length > 0 && x != null) {
            char[] c = new char[length];
            int readLen = 0;
            int offset = 0;
            BufferedReader reader = new BufferedReader(x);
            try {
                if (reader.ready()) {
                    readLen = reader.read(c, offset, length);
                    if (TraceFlag.isTraceEnabled()) {
                        this.writeTrace(99, "IfxBlob: fromcharacterStream():readLen=" + readLen);
                    }
                    this.setBlobLength(readLen);
                    this.blobBuffer = new String(c).getBytes();
                }
                this.setBlobLength(0);
                this.blobBuffer = null;
            }
            catch (Exception e) {
                if (TraceFlag.isTraceEnabled()) {
                    this.writeTrace(99, "IfxBlob:fromCharacterStream(): " + e.getMessage());
                }
                SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
                sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
                throw sqlException;
            }
        } else {
            this.setBlobLength(0);
            this.blobBuffer = (byte[])(x != null && length == 0 ? new byte[0] : null);
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob: fromCharacterStream() end...");
        }
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob: toCharacterStream() start...");
        }
        if (this.isNull()) {
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(99, "IfxBlob: toCharacterStream() end...");
            }
            return null;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob: toCharacterStream() end...");
        }
        return new StringReader(this.toString());
    }

    @Override
    public void fromAsciiStream(InputStream fin, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length must be less than Integer.MAX_VALUE for this data type");
        }
        this.fromAsciiStream(fin, (int)length);
    }

    @Override
    public void fromAsciiStream(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
        this.ifxType = 1;
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromBinaryStream(InputStream fin, int length) throws SQLException {
        this.fromInputStream(fin, length);
        this.ifxType = 0;
    }

    @Override
    public String toString() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 10");
        }
        if (this.blobBuffer != null) {
            try {
                if (((IfxObject)this).ifxType == 12 || ((IfxObject)this).ifxType == 101) {
                    if (((IfxSqliConnect)this.conn).isConvText()) {
                        return IfxToJavaType.IfxToJavaChar(this.blobBuffer, 0, this.blobBuffer.length, ((IfxSqliConnect)this.conn).getclEncoding(), ((IfxSqliConnect)this.conn).encoption);
                    }
                    return IfxToJavaType.IfxToJavaChar(this.blobBuffer, 0, this.blobBuffer.length, ((IfxSqliConnect)this.conn).returnEnc(), ((IfxSqliConnect)this.conn).encoption);
                }
                return new String(this.blobBuffer);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.tempBlobFile != null) {
            int size;
            InputStream in;
            try {
                in = this.tempBlobFile.getInputStream();
                size = in.available();
            }
            catch (Exception e) {
                return null;
            }
            byte[] ary = new byte[size];
            int count = 0;
            try {
                byte buf = (byte)in.read();
                while (buf != -1) {
                    ary[count] = buf;
                    ++count;
                    buf = (byte)in.read();
                }
                in.close();
            }
            catch (Exception e) {
                return null;
            }
            if (((IfxObject)this).ifxType == 12 || ((IfxObject)this).ifxType == 101) {
                try {
                    if (((IfxSqliConnect)this.conn).isConvText()) {
                        return IfxToJavaType.IfxToJavaChar(ary, 0, ary.length, ((IfxSqliConnect)this.conn).getclEncoding(), ((IfxSqliConnect)this.conn).encoption);
                    }
                    return IfxToJavaType.IfxToJavaChar(ary, 0, ary.length, ((IfxSqliConnect)this.conn).returnEnc(), ((IfxSqliConnect)this.conn).encoption);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return new String(ary);
        }
        return null;
    }

    @Override
    public void fromString(String S) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 10");
        }
        if (S == null) {
            this.setBlobLength(0);
            this.blobBuffer = null;
            this.nullify();
        } else {
            String dbEnc = this.conn.getdbEncoding();
            try {
                this.blobBuffer = dbEnc != null ? S.getBytes(dbEnc) : S.getBytes();
                this.setBlobLength(this.blobBuffer.toString().length());
                this.unnullify();
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob.fromString() : - 2");
        }
    }

    @Override
    public Object toObject() throws SQLException {
        if (((IfxObject)this).ifxType == 12) {
            return this.toString();
        }
        return this.toBytes();
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob() : - 11");
        }
        if (this.blobBuffer != null) {
            return (byte[])this.blobBuffer.clone();
        }
        if (this.tempBlobFile != null) {
            int size;
            InputStream fd;
            try {
                fd = this.tempBlobFile.getInputStream();
                size = fd.available();
            }
            catch (Exception e) {
                return null;
            }
            byte[] b = new byte[size];
            try {
                fd.read(b, 0, size);
                fd.close();
            }
            catch (Exception e) {
                return null;
            }
            return b;
        }
        return null;
    }

    @Override
    public void fromBytes(byte[] blobBuffer) {
        if (blobBuffer == null) {
            this.setBlobLength(0);
            this.blobBuffer = null;
        } else {
            this.setBlobLength(blobBuffer.length);
            this.blobBuffer = blobBuffer;
            this.unnullify();
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(99, "IfxBlob.fromBytes() : - 2");
        }
    }

    @Override
    public Blob toBlob() throws SQLException {
        IfxBblob blob = null;
        if (this.tempBlobFile != null) {
            try {
                blob = new IfxBblob(this.tempBlobFile);
            }
            catch (Exception e) {
                return null;
            }
        } else if (this.blobBuffer != null) {
            blob = new IfxBblob(this.blobBuffer);
        } else {
            return null;
        }
        blob.setLoadFlag();
        if (blob.smb != null) {
            ((IfxSqliConnect)this.conn).addToBlobList(blob.smb);
        }
        blob.setIfxLobType((short)0);
        blob.setSize(this.getBlobLength());
        return blob;
    }

    @Override
    public Clob toClob() throws SQLException {
        IfxCblob clob = null;
        if (this.tempBlobFile != null) {
            try {
                clob = new IfxCblob(this.tempBlobFile);
            }
            catch (Exception e) {
                return null;
            }
        } else if (this.blobBuffer != null) {
            clob = new IfxCblob((Connection)this.conn, this.blobBuffer);
        } else {
            return null;
        }
        clob.setLoadFlag();
        if (clob.smb != null) {
            ((IfxSqliConnect)this.conn).addToBlobList(clob.smb);
        }
        clob.setIfxLobType((short)1);
        clob.setSize(this.getBlobLength());
        return clob;
    }

    @Override
    public void fromBlob(Blob blob) throws SQLException {
        if (blob instanceof IfxLob) {
            short type = ((IfxLob)((Object)blob)).getIfxLobType();
            if (type == 2 || type == 0) {
                this.fromBinaryStream(((IfxLob)((Object)blob)).getStreamImd(), (int)blob.length());
            }
        } else {
            this.fromBinaryStream(blob.getBinaryStream(), (int)blob.length());
        }
    }

    @Override
    public void fromClob(Clob clob) throws SQLException {
        if (clob instanceof IfxLob) {
            short type = ((IfxLob)((Object)clob)).getIfxLobType();
            if (type == 3 || type == 1) {
                this.fromAsciiStream(((IfxLob)((Object)clob)).getStreamImd(), (int)clob.length());
            }
        } else {
            this.fromAsciiStream(clob.getAsciiStream(), (int)clob.length());
        }
    }

    @Override
    public void clear() {
        this.isBlob_loaded = false;
        this.ifxType = 0;
        if (this.tempBlobFile != null) {
            this.tempBlobFile.close();
        }
        this.blobBuffer = null;
        this.tempBlobFile = null;
        super.clear();
    }

    void dumpTblob() {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(3, "    tb_size: " + this.tb_size);
            this.writeTrace(3, "    tb_flags: " + this.tb_flags);
        }
    }
}

