/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.runtime.OptimizedCallTarget;

public abstract class OptimizedFastThreadLocal
extends AbstractFastThreadLocal {
    protected OptimizedFastThreadLocal() {
    }

    public abstract void set(Object[] var1);

    public abstract Object[] get();

    public final <C> C fastGet(int index, Class<C> castType, boolean invalidateOnNull, boolean nonNullResult) {
        if (CompilerDirectives.inCompiledCode()) {
            CompilerAsserts.partialEvaluationConstant((int)index);
            CompilerAsserts.partialEvaluationConstant(castType);
            Object[] array = this.get();
            if (array == null) {
                if (invalidateOnNull) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return null;
            }
            Object v = OptimizedCallTarget.castArrayFixedLength(array, index + 1)[index];
            C result = OptimizedCallTarget.unsafeCast(v, castType, true, nonNullResult, true);
            return result;
        }
        Object[] data = this.get();
        if (data == null) {
            return null;
        }
        Object result = data[index];
        assert (castType == null || result == null || result.getClass() == castType) : "Invalid exact type returned";
        return (C)result;
    }
}

