/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.StopIterationBuiltins;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.bytecode.SendNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateInline(value=false)
public abstract class SendNode
extends PNodeWithContext {
    public abstract boolean execute(VirtualFrame var1, int var2, Object var3, Object var4);

    @Specialization
    static boolean doGenerator(VirtualFrame virtualFrame, int stackTop, PGenerator generator, Object arg, @Bind Node inliningTarget, @Cached CommonGeneratorBuiltins.SendNode sendNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Exclusive @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
        try {
            Object value = sendNode.execute(virtualFrame, generator, arg);
            virtualFrame.setObject(stackTop, value);
            return false;
        }
        catch (PException e) {
            SendNode.handleException(virtualFrame, e, inliningTarget, stopIterationProfile, getValue, stackTop);
            return true;
        }
    }

    @Specialization(guards={"hasIterSlot(slots)"}, limit="1")
    static boolean doIterator(VirtualFrame virtualFrame, int stackTop, Object iter, PNone arg, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlots, @Bind(value="getSlots.execute(inliningTarget, iter)") TpSlots slots, @Cached TpSlotIterNext.CallSlotTpIterNextNode callIterNext, @Cached.Exclusive @Cached InlinedBranchProfile exhaustedNoException, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Exclusive @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
        try {
            Object value = callIterNext.execute(virtualFrame, inliningTarget, slots.tp_iternext(), iter);
            virtualFrame.setObject(stackTop, value);
            return false;
        }
        catch (IteratorExhausted e) {
            exhaustedNoException.enter(inliningTarget);
            virtualFrame.setObject(stackTop, null);
            virtualFrame.setObject(stackTop - 1, (Object)PNone.NONE);
            return true;
        }
        catch (PException e) {
            SendNode.handleException(virtualFrame, e, inliningTarget, stopIterationProfile, getValue, stackTop);
            return true;
        }
    }

    protected static boolean hasIterSlot(TpSlots slots) {
        return PyIterCheckNode.checkSlots(slots);
    }

    @Fallback
    static boolean doOther(VirtualFrame virtualFrame, int stackTop, Object obj, Object arg, @Bind Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethodNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Exclusive @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
        try {
            Object value = callMethodNode.execute((Frame)virtualFrame, inliningTarget, obj, BuiltinNames.T_SEND, arg);
            virtualFrame.setObject(stackTop, value);
            return false;
        }
        catch (PException e) {
            SendNode.handleException(virtualFrame, e, inliningTarget, stopIterationProfile, getValue, stackTop);
            return true;
        }
    }

    private static void handleException(VirtualFrame frame, PException e, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, StopIterationBuiltins.StopIterationValueNode getValue, int stackTop) {
        e.expectStopIteration(inliningTarget, stopIterationProfile);
        Object value = getValue.execute((PBaseException)e.getUnreifiedException());
        frame.setObject(stackTop, null);
        frame.setObject(stackTop - 1, value);
    }

    public static SendNode create() {
        return SendNodeGen.create();
    }
}

