/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ExtLayoutStrategy;
import com.oracle.truffle.api.object.FieldInfo;
import com.oracle.truffle.api.object.LayoutImpl;
import com.oracle.truffle.api.object.ObjectStorageOptions;
import com.oracle.truffle.api.object.ObsolescenceStrategy;
import com.oracle.truffle.api.object.ShapeExt;
import com.oracle.truffle.api.object.ShapeImpl;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graalvm.nativeimage.ImageInfo;

final class ExtLayout
extends LayoutImpl {
    public static final boolean TraceReshape = ObjectStorageOptions.booleanOption("truffle.object.TraceReshape", false);
    public static final boolean PrimitiveLocations = ObjectStorageOptions.booleanOption("truffle.object.PrimitiveLocations", true);
    public static final boolean IntegerLocations = ObjectStorageOptions.booleanOption("truffle.object.IntegerLocations", true);
    public static final boolean DoubleLocations = ObjectStorageOptions.booleanOption("truffle.object.DoubleLocations", true);
    public static final boolean LongLocations = ObjectStorageOptions.booleanOption("truffle.object.LongLocations", true);
    public static final boolean BooleanLocations = ObjectStorageOptions.booleanOption("truffle.object.BooleanLocations", true);
    public static final boolean InObjectFields = ObjectStorageOptions.booleanOption("truffle.object.InObjectFields", true);
    public static final boolean UseVarHandle = ObjectStorageOptions.booleanOption("truffle.object.UseVarHandle", false);
    public static final boolean NewFinalSpeculation = ObjectStorageOptions.booleanOption("truffle.object.NewFinalSpeculation", true);
    public static final boolean NewTypeSpeculation = ObjectStorageOptions.booleanOption("truffle.object.NewTypeSpeculation", true);
    public static final int MaxMergeDepth = Integer.getInteger("truffle.object.MaxMergeDepth", 32);
    public static final int MaxMergeDiff = Integer.getInteger("truffle.object.MaxMergeDiff", 2);
    private final ExtLayoutStrategy strategy;
    private final List<FieldInfo> objectFields;
    private final List<FieldInfo> primitiveFields;
    private final int primitiveFieldMaxSize;

    ExtLayout(Class<? extends DynamicObject> dynamicObjectClass, ExtLayoutStrategy strategy, LayoutInfo layoutInfo, int allowedImplicitCasts) {
        super(dynamicObjectClass, strategy, allowedImplicitCasts);
        this.strategy = strategy;
        this.objectFields = layoutInfo.objectFields;
        this.primitiveFields = layoutInfo.primitiveFields;
        this.primitiveFieldMaxSize = layoutInfo.primitiveFieldMaxSize;
    }

    private static LayoutInfo getOrCreateLayoutInfo(Class<? extends DynamicObject> dynamicObjectClass, MethodHandles.Lookup layoutLookup) {
        Objects.requireNonNull(dynamicObjectClass, "DynamicObject layout class");
        return LayoutInfo.getOrCreateNewLayoutInfo(dynamicObjectClass, layoutLookup);
    }

    private static ExtLayout getOrCreateLayout(Class<? extends DynamicObject> clazz, MethodHandles.Lookup layoutLookup, int implicitCastFlags, ExtLayoutStrategy strategy) {
        Objects.requireNonNull(clazz, "DynamicObject layout class");
        LayoutImpl.Key key = new LayoutImpl.Key(clazz, implicitCastFlags, strategy);
        ExtLayout layout = (ExtLayout)LAYOUT_MAP.get(key);
        if (layout != null) {
            return layout;
        }
        ExtLayout newLayout = new ExtLayout(clazz, strategy, ExtLayout.getOrCreateLayoutInfo(clazz, layoutLookup), implicitCastFlags);
        layout = LAYOUT_MAP.putIfAbsent(key, newLayout);
        return layout == null ? newLayout : layout;
    }

    static ExtLayout createLayoutImpl(Class<? extends DynamicObject> clazz, MethodHandles.Lookup layoutLookup, int implicitCastFlags, ExtLayoutStrategy strategy) {
        return ExtLayout.getOrCreateLayout(clazz, layoutLookup, implicitCastFlags, strategy);
    }

    static ExtLayout createLayoutImpl(Class<? extends DynamicObject> clazz, MethodHandles.Lookup layoutLookup, int implicitCastFlags) {
        return ExtLayout.createLayoutImpl(clazz, layoutLookup, implicitCastFlags, ObsolescenceStrategy.singleton());
    }

    static void registerLayoutClass(Class<? extends DynamicObject> type, MethodHandles.Lookup layoutLookup) {
        ExtLayout.createLayoutImpl(type, layoutLookup, 0);
    }

    @Override
    protected ShapeImpl newShape(Object objectType, Object sharedData, int flags, Assumption constantObjectAssumption) {
        return new ShapeExt(this, sharedData, objectType, flags, constantObjectAssumption);
    }

    @Override
    protected int getObjectFieldCount() {
        return this.objectFields.size();
    }

    FieldInfo getObjectField(int index) {
        return this.objectFields.get(index);
    }

    FieldInfo getPrimitiveField(int index) {
        return this.primitiveFields.get(index);
    }

    static int getFieldSizeByClass(Class<?> c) {
        if (c.equals(Boolean.class) || c.equals(Byte.class) || c.equals(Byte.TYPE) || c.equals(Boolean.TYPE)) {
            return 1;
        }
        if (c.equals(Short.class) || c.equals(Character.class) || c.equals(Character.TYPE) || c.equals(Short.TYPE)) {
            return 2;
        }
        if (c.equals(Float.class) || c.equals(Integer.class) || c.equals(Float.TYPE) || c.equals(Integer.TYPE)) {
            return 4;
        }
        if (c.equals(Double.class) || c.equals(Long.class) || c.equals(Double.TYPE) || c.equals(Long.TYPE)) {
            return 8;
        }
        throw new IllegalArgumentException("Field size for class " + String.valueOf(c) + " is not supported.");
    }

    @Override
    protected int getPrimitiveFieldCount() {
        return this.primitiveFields.size();
    }

    public int getPrimitiveFieldMaxSize() {
        return this.primitiveFieldMaxSize;
    }

    @Override
    public String toString() {
        return this.clazz.getName() + "(" + this.objectFields.size() + "," + this.primitiveFields.size() + ")";
    }

    @Override
    protected boolean hasObjectExtensionArray() {
        return true;
    }

    @Override
    protected boolean hasPrimitiveExtensionArray() {
        return true;
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator() {
        ExtLayout layout = this;
        return this.getStrategy().createAllocator(layout);
    }

    @Override
    public ExtLayoutStrategy getStrategy() {
        return this.strategy;
    }

    private static final class LayoutInfo {
        final Class<? extends DynamicObject> clazz;
        final List<FieldInfo> objectFields;
        final List<FieldInfo> primitiveFields;
        final int primitiveFieldMaxSize;

        static LayoutInfo getOrCreateNewLayoutInfo(Class<? extends DynamicObject> dynamicObjectClass, MethodHandles.Lookup layoutLookup) {
            LayoutInfo layoutInfo = (LayoutInfo)LayoutImpl.LAYOUT_INFO_MAP.get(dynamicObjectClass);
            if (layoutInfo != null) {
                return layoutInfo;
            }
            if (ImageInfo.inImageRuntimeCode()) {
                throw new IllegalStateException("Layout not initialized ahead-of-time: " + String.valueOf(dynamicObjectClass));
            }
            return LayoutInfo.createLayoutInfo(dynamicObjectClass, layoutLookup);
        }

        private static LayoutInfo createLayoutInfo(Class<? extends DynamicObject> dynamicObjectClass, MethodHandles.Lookup layoutLookup) {
            LayoutInfo newLayoutInfo = new LayoutInfo(dynamicObjectClass, layoutLookup);
            LayoutInfo layoutInfo = (LayoutInfo)LayoutImpl.LAYOUT_INFO_MAP.putIfAbsent(dynamicObjectClass, newLayoutInfo);
            return layoutInfo == null ? newLayoutInfo : layoutInfo;
        }

        LayoutInfo(Class<? extends DynamicObject> clazz, MethodHandles.Lookup layoutLookup) {
            this.clazz = clazz.asSubclass(DynamicObject.class);
            ArrayList<FieldInfo> objectFieldList = new ArrayList<FieldInfo>();
            ArrayList<FieldInfo> primitiveFieldList = new ArrayList<FieldInfo>();
            LayoutInfo.collectFields(clazz, DynamicObject.class, layoutLookup, objectFieldList, primitiveFieldList);
            Collections.sort(objectFieldList);
            Collections.sort(primitiveFieldList);
            if (objectFieldList.size() + primitiveFieldList.size() > 1000) {
                throw new IllegalArgumentException("Too many @DynamicField annotated fields.");
            }
            this.objectFields = List.copyOf(objectFieldList);
            this.primitiveFields = List.copyOf(primitiveFieldList);
            int maxFieldSize = 0;
            for (FieldInfo fieldInfo : this.primitiveFields) {
                int fieldSize = ExtLayout.getFieldSizeByClass(fieldInfo.type());
                maxFieldSize = Math.max(maxFieldSize, fieldSize);
            }
            this.primitiveFieldMaxSize = maxFieldSize;
        }

        private static Class<? extends DynamicObject> collectFields(Class<? extends DynamicObject> clazz, Class<? extends DynamicObject> stop, MethodHandles.Lookup layoutLookup, List<FieldInfo> objectFieldList, List<FieldInfo> primitiveFieldList) {
            if (clazz == DynamicObject.class || clazz == stop) {
                return clazz;
            }
            Class<? extends DynamicObject> layoutClass = LayoutInfo.collectFields(clazz.getSuperclass().asSubclass(DynamicObject.class), stop, layoutLookup, objectFieldList, primitiveFieldList);
            Class<? extends Annotation> dynamicFieldAnnotation = DynamicObject.getDynamicFieldAnnotation();
            boolean hasDynamicFields = false;
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) {
                    assert (!field.isAnnotationPresent(dynamicFieldAnnotation));
                    continue;
                }
                if (field.getAnnotation(dynamicFieldAnnotation) == null) continue;
                LayoutInfo.checkDynamicFieldType(field);
                assert (field.getDeclaringClass() == clazz);
                VarHandle varHandle = null;
                if (layoutLookup != null) {
                    try {
                        MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(clazz, layoutLookup);
                        varHandle = privateLookup.findVarHandle(clazz, field.getName(), field.getType());
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                } else if (UseVarHandle) continue;
                hasDynamicFields = true;
                if (field.getType() == Object.class) {
                    objectFieldList.add(FieldInfo.fromField(field, varHandle));
                    continue;
                }
                if (field.getType() == Integer.TYPE) {
                    primitiveFieldList.add(FieldInfo.fromField(field, varHandle));
                    continue;
                }
                if (field.getType() != Long.TYPE) continue;
                primitiveFieldList.add(FieldInfo.fromField(field, varHandle));
            }
            if (hasDynamicFields) {
                layoutClass = clazz;
            }
            return layoutClass;
        }

        private static void checkDynamicFieldType(Field field) {
            if (field.getType() != Object.class && field.getType() != Integer.TYPE && field.getType() != Long.TYPE) {
                throw new IllegalArgumentException("@DynamicField annotated field type must be either Object or int or long: " + String.valueOf(field));
            }
            if (Modifier.isFinal(field.getModifiers())) {
                throw new IllegalArgumentException("@DynamicField annotated field must not be final: " + String.valueOf(field));
            }
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.clazz.getName() + "]";
        }
    }
}

