/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.classMembers.ClassMembersRefactoringSupport;
import com.intellij.refactoring.classMembers.DependentMembersCollectorBase;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.refactoring.classes.PyDependentClassMembersCollector;
import com.jetbrains.python.refactoring.classes.PyMemberInfoStorage;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.move.moduleMembers.PyDependentModuleMembersCollector;
import java.util.Iterator;

public final class PyMembersRefactoringSupport
implements ClassMembersRefactoringSupport<PyElement> {
    public static PyMemberInfoStorage getSelectedMemberInfos(PyClass clazz, PsiElement element1, PsiElement element2) {
        PyMemberInfoStorage infoStorage = new PyMemberInfoStorage(clazz);
        Iterator iterator = infoStorage.getClassMemberInfos(clazz).iterator();
        while (iterator.hasNext()) {
            PyMemberInfo member;
            PyElement function = (PyElement)(member = (PyMemberInfo)((Object)iterator.next())).getMember();
            member.setChecked(PsiTreeUtil.isAncestor((PsiElement)function, (PsiElement)element1, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)function, (PsiElement)element2, (boolean)false));
        }
        return infoStorage;
    }

    public DependentMembersCollectorBase<?, ? extends PyElement> createDependentMembersCollector(PyElement clazz, PyElement superClass) {
        if (clazz instanceof PyClass) {
            PyClass pyClass = (PyClass)clazz;
            return new PyDependentClassMembersCollector(pyClass, (PyClass)superClass);
        }
        if (clazz instanceof PyFile) {
            PyFile pyFile = (PyFile)clazz;
            return new PyDependentModuleMembersCollector(pyFile);
        }
        return null;
    }

    public boolean isProperMember(MemberInfoBase member) {
        return true;
    }
}

