/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import mediathek.daten.DatenFilm;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.dialog.DialogFilmBeschreibung;
import mediathek.gui.tabs.tab_film.SenderIconLabel;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.CopyToClipboardAction;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.SwingErrorDialog;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXHyperlink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilmDescriptionPanel
extends JPanel {
    private final JScrollPane scrollPane1 = new JScrollPane();
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final SenderIconLabel lblIcon = new SenderIconLabel();
    private final JLabel lblThema = new JLabel();
    private final JLabel lblTitel = new JLabel();
    private final JTextArea textArea = new JTextArea();
    private final JXHyperlink hyperlink = new JXHyperlink();
    private DatenFilm currentFilm;

    public FilmDescriptionPanel() {
        this.initComponents();
        this.hyperlink.addActionListener(actionEvent -> {
            if (!this.hyperlink.getToolTipText().isEmpty()) {
                String toolTipText = this.hyperlink.getToolTipText();
                if (Desktop.isDesktopSupported()) {
                    Desktop d = Desktop.getDesktop();
                    if (d.isSupported(Desktop.Action.BROWSE)) {
                        try {
                            d.browse(new URI(toolTipText));
                        }
                        catch (Exception ex) {
                            SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Es trat ein Fehler beim \u00d6ffnen des Links auf.\nSollte dies h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.", ex);
                        }
                    } else {
                        this.openUrl(toolTipText);
                    }
                } else {
                    this.openUrl(toolTipText);
                }
            }
        });
        this.createPopupMenu();
        this.setAllFieldsEmpty();
    }

    private void createPopupMenu() {
        JMenuItem item = new JMenuItem("Beschreibung \u00e4ndern...");
        item.addActionListener(actionEvent -> {
            DialogFilmBeschreibung dialog = new DialogFilmBeschreibung(MediathekGui.ui(), this.currentFilm);
            dialog.setVisible(true);
        });
        this.popupMenu.add(item);
        this.popupMenu.addSeparator();
        item = new JMenuItem("Beschreibung in Zwischenablage kopieren");
        item.addActionListener(actionEvent -> GuiFunktionen.copyToClipboard(this.currentFilm.getDescription()));
        this.popupMenu.add(item);
        item = new JMenuItem("Filmbasisinformationen in Zwischenablage kopieren");
        item.addActionListener(actionEvent -> {
            String sb = this.currentFilm.getSender() + " - " + this.currentFilm.getThema() + " - " + this.currentFilm.getTitle();
            GuiFunktionen.copyToClipboard(sb);
        });
        this.popupMenu.add(item);
        this.popupMenu.addSeparator();
        item = new JMenuItem("Auswahl kopieren");
        item.addActionListener(actionEvent -> {
            boolean selected;
            boolean bl = selected = this.textArea.getSelectionEnd() - this.textArea.getSelectionStart() > 0;
            if (!selected) {
                JOptionPane.showMessageDialog(this, "Kein Text markiert!", "MediathekView", 0);
            } else {
                String text = this.textArea.getSelectedText();
                GuiFunktionen.copyToClipboard(text);
            }
        });
        this.popupMenu.add(item);
        this.setComponentPopupMenu(this.popupMenu);
        this.textArea.setComponentPopupMenu(this.popupMenu);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout(new LC().hideMode(3), new AC().fill().gap().grow().fill(), new AC().gap().gap().gap()));
        this.lblIcon.setPreferredSize(new Dimension(96, 96));
        this.lblIcon.setVerticalAlignment(1);
        this.add((Component)this.lblIcon, new CC().cell(new int[]{0, 0, 1, 3}).alignX("center").alignY("top").grow(new float[]{0.0f, 0.0f}));
        this.lblThema.setFont(this.lblThema.getFont().deriveFont(this.lblThema.getFont().getStyle() | 1));
        this.add((Component)this.lblThema, new CC().cell(new int[]{1, 0}));
        this.lblTitel.setFont(this.lblTitel.getFont().deriveFont(this.lblTitel.getFont().getStyle() | 1));
        this.add((Component)this.lblTitel, new CC().cell(new int[]{1, 1}));
        this.scrollPane1.setPreferredSize(new Dimension(299, 75));
        this.scrollPane1.setMaximumSize(new Dimension(Integer.MAX_VALUE, 75));
        this.scrollPane1.setMinimumSize(new Dimension(23, 75));
        this.scrollPane1.setHorizontalScrollBarPolicy(31);
        this.textArea.setEditable(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.scrollPane1.setViewportView(this.textArea);
        this.add((Component)this.scrollPane1, new CC().cell(new int[]{1, 2}).grow());
        this.add((Component)this.hyperlink, new CC().cell(new int[]{1, 3}));
    }

    public void setCurrentFilm(@Nullable DatenFilm film) {
        if (film == null) {
            this.setAllFieldsEmpty();
        } else {
            this.showFilmDescription(film);
        }
        this.currentFilm = film;
    }

    public void install(@NotNull JTabbedPane tabbedPane, @NotNull JTable tabelle, @NotNull Supplier<Optional<DatenFilm>> filmSupplier) {
        tabbedPane.add("Beschreibung", this);
        tabelle.getSelectionModel().addListSelectionListener(listSelectionEvent -> ((Optional)filmSupplier.get()).ifPresentOrElse(this::setCurrentFilm, () -> this.setCurrentFilm(null)));
    }

    private void setAllFieldsEmpty() {
        this.hyperlink.setVisible(false);
        this.hyperlink.setText("");
        this.hyperlink.setToolTipText("");
        this.hyperlink.setComponentPopupMenu(null);
        this.textArea.setText("");
        this.lblIcon.setIcon(null);
        this.lblThema.setText("");
        this.lblTitel.setText("");
    }

    private void openUrl(String url) {
        UrlHyperlinkAction.openURL(url);
    }

    private void showFilmDescription(@NotNull DatenFilm film) {
        this.lblThema.setText(film.getThema());
        this.lblTitel.setText(film.getTitle());
        this.hyperlink.setVisible(true);
        try {
            this.hyperlink.setText("Link zur Webseite");
            this.hyperlink.setClicked(false);
            JPopupMenu popup = new JPopupMenu();
            popup.add(new CopyToClipboardAction(film.getWebsiteUrl()));
            this.hyperlink.setComponentPopupMenu(popup);
        }
        catch (Exception e) {
            this.hyperlink.setText("Link nicht verf\u00fcgbar");
        }
        this.hyperlink.setToolTipText(film.getWebsiteUrl());
        this.textArea.setText(film.getDescription());
        SwingUtilities.invokeLater(() -> this.scrollPane1.getVerticalScrollBar().setValue(0));
        this.lblIcon.setSender(film.getSender());
    }
}

