/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.SVGIconUtilities;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditHistoryDialog
extends JDialog {
    private static final String CONFIG_X = "edit_history.x";
    private static final String CONFIG_Y = "edit_history.y";
    private static final String CONFIG_HEIGHT = "edit_history.height";
    private static final String CONFIG_WIDTH = "edit_history.width";
    private final EventList<String> eventList;
    private final Function<Integer, Integer> inc_op = f -> f + 1;
    private final Function<Integer, Integer> dec_op = f -> f - 1;
    private final DeleteKeyAdapter keyAdapter = new DeleteKeyAdapter(this);
    private boolean keyAdapterInstalled;
    private static final Logger logger = LogManager.getLogger();
    private JList<String> list;
    private JButton btnDeleteEntries;
    private JButton btnUp;
    private JButton btnDown;

    public EditHistoryDialog(Window owner, final JMenuItem menuItem, EventList<String> eventList) {
        super(owner);
        this.initComponents();
        this.eventList = eventList;
        menuItem.setEnabled(false);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ EditHistoryDialog this$0;
            {
                EditHistoryDialog editHistoryDialog = this$0;
                Objects.requireNonNull(editHistoryDialog);
                this.this$0 = editHistoryDialog;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                menuItem.setEnabled(true);
                this.this$0.savePosition();
            }
        });
        DefaultEventListModel model = GlazedListsSwing.eventListModelWithThreadProxyList(eventList);
        this.list.setModel((ListModel<String>)model);
        this.list.getSelectionModel().addListSelectionListener(l -> {
            if (l.getValueIsAdjusting()) {
                return;
            }
            this.adjustButtons();
        });
        this.adjustButtons();
        this.btnDeleteEntries.addActionListener(l -> this.deleteEntries());
        this.btnUp.addActionListener(l -> {
            int idx = this.list.getSelectedIndex();
            idx = this.moveEntry(idx, this.dec_op);
            this.list.setSelectedIndex(idx);
        });
        this.btnDown.addActionListener(l -> {
            int idx = this.list.getSelectedIndex();
            idx = this.moveEntry(idx, this.inc_op);
            this.list.setSelectedIndex(idx);
        });
        this.restorePosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEntries() {
        ArrayList<String> changeList = new ArrayList<String>();
        ListModel<String> listModel = this.list.getModel();
        for (int idx : this.list.getSelectedIndices()) {
            changeList.add(listModel.getElementAt(idx));
        }
        Lock lock = this.eventList.getReadWriteLock().writeLock();
        lock.lock();
        try {
            changeList.forEach(arg_0 -> this.eventList.remove(arg_0));
        }
        finally {
            lock.unlock();
        }
        changeList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int moveEntry(int idx, Function<Integer, Integer> operator) {
        Lock lock = this.eventList.getReadWriteLock().writeLock();
        lock.lock();
        try {
            String obj = (String)this.eventList.get(idx);
            this.eventList.remove(idx);
            idx = operator.apply(idx);
            this.eventList.add(idx, (Object)obj);
        }
        finally {
            lock.unlock();
        }
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePosition() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int x = config.getInt(CONFIG_X);
            int y = config.getInt(CONFIG_Y);
            int width = config.getInt(CONFIG_WIDTH);
            int height = config.getInt(CONFIG_HEIGHT);
            this.setSize(width, height);
            this.setLocation(x, y);
        }
        catch (NoSuchElementException x) {
        }
        catch (Exception ex) {
            logger.error("Unhandled exception", (Throwable)ex);
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePosition() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.WRITE);
            Dimension size = this.getSize();
            Point location = this.getLocation();
            config.setProperty(CONFIG_WIDTH, (Object)size.width);
            config.setProperty(CONFIG_HEIGHT, (Object)size.height);
            config.setProperty(CONFIG_X, (Object)location.x);
            config.setProperty(CONFIG_Y, (Object)location.y);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    private void adjustButtons() {
        int itemCount = this.list.getSelectionModel().getSelectedItemsCount();
        boolean singleSelection = itemCount == 1;
        this.btnDeleteEntries.setEnabled(itemCount > 0);
        this.btnUp.setEnabled(singleSelection);
        this.btnDown.setEnabled(singleSelection);
        if (singleSelection) {
            int idx = this.list.getSelectionModel().getLeadSelectionIndex();
            if (idx == 0) {
                this.btnUp.setEnabled(false);
            }
            if (idx == this.list.getModel().getSize() - 1) {
                this.btnDown.setEnabled(false);
            }
        }
        this.setupKeyListener(itemCount);
    }

    private void setupKeyListener(int itemCount) {
        if (itemCount > 0) {
            if (!this.keyAdapterInstalled) {
                this.list.addKeyListener(this.keyAdapter);
                this.keyAdapterInstalled = true;
            }
        } else if (this.keyAdapterInstalled) {
            this.list.removeKeyListener(this.keyAdapter);
            this.keyAdapterInstalled = false;
        }
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.list = new JList();
        JToolBar toolBar1 = new JToolBar();
        this.btnDeleteEntries = new JButton();
        this.btnDeleteEntries.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg"));
        this.btnUp = new JButton();
        this.btnUp.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/arrow-up.svg"));
        this.btnDown = new JButton();
        this.btnDown.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/arrow-down.svg"));
        this.setTitle("Suchhistorie bearbeiten");
        this.setDefaultCloseOperation(2);
        this.setType(Window.Type.UTILITY);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setLayout(new BorderLayout());
        contentPanel.setLayout(new BorderLayout());
        scrollPane1.setViewportView(this.list);
        contentPanel.add((Component)scrollPane1, "Center");
        toolBar1.setFloatable(false);
        this.btnDeleteEntries.setToolTipText("Ausgew\u00e4hlte Eintr\u00e4ge l\u00f6schen");
        toolBar1.add(this.btnDeleteEntries);
        this.btnUp.setToolTipText("Element nach oben verschieben");
        toolBar1.add(this.btnUp);
        this.btnDown.setToolTipText("Element nach unten verschieben");
        toolBar1.add(this.btnDown);
        contentPanel.add((Component)toolBar1, "North");
        dialogPane.add((Component)contentPanel, "Center");
        contentPane.add((Component)dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class DeleteKeyAdapter
    extends KeyAdapter {
        final /* synthetic */ EditHistoryDialog this$0;

        private DeleteKeyAdapter(EditHistoryDialog editHistoryDialog) {
            EditHistoryDialog editHistoryDialog2 = editHistoryDialog;
            Objects.requireNonNull(editHistoryDialog2);
            this.this$0 = editHistoryDialog2;
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                e.consume();
                this.this$0.deleteEntries();
            }
        }
    }
}

