/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog.subripmerge;

import com.github.kokorin.jaffree.ffmpeg.FFmpeg;
import com.github.kokorin.jaffree.ffmpeg.Input;
import com.github.kokorin.jaffree.ffmpeg.Output;
import com.github.kokorin.jaffree.ffmpeg.UrlInput;
import com.github.kokorin.jaffree.ffmpeg.UrlOutput;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.tool.FileDialogs;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.LanguageCode;
import mediathek.tool.SwingErrorDialog;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;

public class MergeSubripVideoDialog
extends JDialog {
    private static final Logger logger = LogManager.getLogger();
    private static final Pattern PATTERN = Pattern.compile("\\[(.*?)]");
    private JTextField tfSubripFilePath;
    private JButton btnSelectInputSubrip;
    private JTextField tfVideoFilePath;
    private JButton btnSelectInputVideo;
    private JComboBox<String> cbLanguage;
    private JTextField tfVideoOutputPath;
    private JButton btnSelectVideoOutputPath;
    private JXBusyLabel busyLabel;
    private JButton btnCancel;
    private JButton btnMerge;

    public MergeSubripVideoDialog(Window owner) {
        super(owner);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.btnMerge);
        this.busyLabel.setVisible(false);
        this.btnMerge.setEnabled(false);
        this.fillLanguageComboBox();
        this.cbLanguage.setSelectedItem(this.getLanguageText(LanguageCode.de));
        this.btnCancel.addActionListener(e -> this.dispose());
        this.setupTextFieldListener();
        this.btnSelectInputSubrip.addActionListener(e -> {
            File file = FileDialogs.chooseLoadFileLocation(this, "Untertitel w\u00e4hlen", "");
            if (file != null) {
                String fileStr = file.getAbsolutePath();
                if (!fileStr.toLowerCase().endsWith(".srt")) {
                    JOptionPane.showMessageDialog(this, "Untertiteldatei muss auf .srt enden.", "MediathekView", 0);
                    this.tfSubripFilePath.setText("");
                } else {
                    this.tfSubripFilePath.setText(file.getAbsolutePath());
                }
            }
        });
        this.btnSelectInputVideo.addActionListener(e -> {
            File file = FileDialogs.chooseLoadFileLocation(this, "Video w\u00e4hlen", "");
            if (file != null) {
                this.tfVideoFilePath.setText(file.getAbsolutePath());
            } else {
                this.tfVideoFilePath.setText("");
            }
        });
        this.btnSelectVideoOutputPath.addActionListener(e -> {
            File file = FileDialogs.chooseSaveFileLocation(this, "Videospeicherort w\u00e4hlen", "");
            if (file != null) {
                this.tfVideoOutputPath.setText(file.getAbsolutePath());
            } else {
                this.tfVideoOutputPath.setText("");
            }
        });
        this.btnMerge.addActionListener(evt -> {
            try {
                String lang = (String)this.cbLanguage.getSelectedItem();
                if (lang == null) {
                    throw new IllegalArgumentException("Native language selected is null");
                }
                Matcher matcher = PATTERN.matcher(lang);
                if (!matcher.find()) {
                    throw new IllegalArgumentException("Could not get ISO 639 3 letter code");
                }
                lang = matcher.group(1);
                this.busyLabel.setVisible(true);
                this.busyLabel.setBusy(true);
                this.btnMerge.setEnabled(false);
                this.btnCancel.setEnabled(false);
                Path ffmpegPath = GuiFunktionenProgramme.findExecutableOnPath("ffmpeg").getParent();
                FFmpeg ffmpeg = FFmpeg.atPath((Path)ffmpegPath).setOverwriteOutput(true).addArgument("-xerror").addInput((Input)UrlInput.fromUrl((String)this.tfVideoFilePath.getText())).addInput((Input)UrlInput.fromUrl((String)this.tfSubripFilePath.getText())).addOutput((Output)UrlOutput.toUrl((String)this.tfVideoOutputPath.getText())).addArguments("-c", "copy").addArguments("-c:s", "mov_text").addArgument("-metadata:s:s:0").addArgument("language=" + lang);
                ((CompletableFuture)ffmpeg.executeAsync().toCompletableFuture().thenAccept(e -> SwingUtilities.invokeLater(() -> {
                    this.shutdownMergeProcess();
                    JOptionPane.showMessageDialog(this, "Das Zusammenf\u00fchren war erfolgreich", "MediathekView", 1);
                    this.dispose();
                }))).exceptionally(ex -> {
                    SwingUtilities.invokeLater(() -> {
                        this.shutdownMergeProcess();
                        SwingErrorDialog.showExceptionMessage(this, "Der Vorgang war fehlerhaft", ex);
                        this.dispose();
                    });
                    return null;
                });
            }
            catch (Exception e2) {
                logger.error("Error occured while merging video", (Throwable)e2);
                this.shutdownMergeProcess();
                SwingErrorDialog.showExceptionMessage(this, "Es ist ein Fehler aufgetreten.", e2);
            }
        });
    }

    private void setupTextFieldListener() {
        DocumentListener documentListener = new DocumentListener(this){
            final /* synthetic */ MergeSubripVideoDialog this$0;
            {
                MergeSubripVideoDialog mergeSubripVideoDialog = this$0;
                Objects.requireNonNull(mergeSubripVideoDialog);
                this.this$0 = mergeSubripVideoDialog;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButtonState();
            }

            private void updateButtonState() {
                boolean allFieldsFilled = !this.this$0.tfSubripFilePath.getText().trim().isEmpty() && !this.this$0.tfVideoFilePath.getText().trim().isEmpty() && !this.this$0.tfVideoOutputPath.getText().trim().isEmpty();
                this.this$0.btnMerge.setEnabled(allFieldsFilled);
            }
        };
        this.tfSubripFilePath.getDocument().addDocumentListener(documentListener);
        this.tfVideoFilePath.getDocument().addDocumentListener(documentListener);
        this.tfVideoOutputPath.getDocument().addDocumentListener(documentListener);
    }

    private void shutdownMergeProcess() {
        this.busyLabel.setBusy(false);
        this.busyLabel.setVisible(false);
        this.btnCancel.setEnabled(true);
    }

    private String getLanguageText(LanguageCode code) {
        return String.format("%s [%s]", code.nativeName(), code.getISO3Language());
    }

    public void fillLanguageComboBox() {
        ArrayList<String> languages = new ArrayList<String>();
        for (LanguageCode item : LanguageCode.values()) {
            languages.add(this.getLanguageText(item));
        }
        this.cbLanguage.setModel(new DefaultComboBoxModel<String>(languages.toArray(new String[0])));
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JLabel label1 = new JLabel();
        this.tfSubripFilePath = new JTextField();
        this.btnSelectInputSubrip = new JButton();
        JLabel label2 = new JLabel();
        this.tfVideoFilePath = new JTextField();
        this.btnSelectInputVideo = new JButton();
        JLabel label3 = new JLabel();
        this.cbLanguage = new JComboBox();
        JLabel label4 = new JLabel();
        this.tfVideoOutputPath = new JTextField();
        this.btnSelectVideoOutputPath = new JButton();
        this.busyLabel = new JXBusyLabel();
        JPanel buttonBar = new JPanel();
        this.btnCancel = new JButton();
        this.btnMerge = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("Untertitel zu Video hinzuf\u00fcgen");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setLayout(new BorderLayout());
        label1.setText("Untertitel-Datei:");
        label1.setHorizontalAlignment(4);
        this.tfSubripFilePath.setToolTipText("Pfad zur Untertiteldatei im Subrip Text Format (.srt)");
        this.btnSelectInputSubrip.setText("...");
        label2.setText("Video-Datei:");
        label2.setHorizontalAlignment(4);
        this.tfVideoFilePath.setToolTipText("Pfad zu einer von ffmpeg unterst\u00fctzten Videodatei als Eingabemedium");
        this.btnSelectInputVideo.setText("...");
        label3.setText("Sprache:");
        label3.setHorizontalAlignment(4);
        this.cbLanguage.setToolTipText("Sprache der Untertitel");
        label4.setText("Zieldatei:");
        label4.setHorizontalAlignment(4);
        this.btnSelectVideoOutputPath.setText("...");
        this.busyLabel.setText("F\u00fchre Video und Untertitel zusammen");
        GroupLayout contentPanelLayout = new GroupLayout(contentPanel);
        contentPanel.setLayout(contentPanelLayout);
        contentPanelLayout.setHorizontalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addContainerGap().addGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(label2, -1, 104, Short.MAX_VALUE).addComponent(label3, -2, 98, -2).addComponent(label1, -1, 104, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.tfVideoFilePath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectInputVideo, -2, 33, -2)).addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.tfSubripFilePath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectInputSubrip, -2, 33, -2)).addGroup(contentPanelLayout.createSequentialGroup().addComponent(this.cbLanguage, -2, 155, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.TRAILING, contentPanelLayout.createSequentialGroup().addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(contentPanelLayout.createSequentialGroup().addComponent(label4, -2, 104, -2).addGap(6, 6, 6).addComponent(this.tfVideoOutputPath, -2, 368, -2)).addGroup(GroupLayout.Alignment.LEADING, contentPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent((Component)this.busyLabel, -2, -1, -2))).addGap(6, 6, 6).addComponent(this.btnSelectVideoOutputPath, -2, 33, -2))).addContainerGap()));
        contentPanelLayout.setVerticalGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addContainerGap().addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelectInputSubrip).addComponent(this.tfSubripFilePath, -2, -1, -2).addComponent(label1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label3).addComponent(this.cbLanguage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelectInputVideo).addComponent(label2).addComponent(this.tfVideoFilePath, -2, -1, -2)).addGap(18, 18, 18).addGroup(contentPanelLayout.createParallelGroup().addGroup(contentPanelLayout.createSequentialGroup().addGap(7, 7, 7).addComponent(label4)).addComponent(this.tfVideoOutputPath, -2, -1, -2).addComponent(this.btnSelectVideoOutputPath)).addGap(18, 18, 18).addComponent((Component)this.busyLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 0, 80};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.btnCancel.setText("Abbrechen");
        buttonBar.add((Component)this.btnCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.btnMerge.setText("Zusammenf\u00fchren");
        buttonBar.add((Component)this.btnMerge, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

