
#ifndef LIBKOMMIT_EXPORT_H
#define LIBKOMMIT_EXPORT_H

#ifdef LIBKOMMIT_STATIC_DEFINE
#  define LIBKOMMIT_EXPORT
#  define LIBKOMMIT_NO_EXPORT
#else
#  ifndef LIBKOMMIT_EXPORT
#    ifdef libkommit_EXPORTS
        /* We are building this library */
#      define LIBKOMMIT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define LIBKOMMIT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef LIBKOMMIT_NO_EXPORT
#    define LIBKOMMIT_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef LIBKOMMIT_DECL_DEPRECATED
#  define LIBKOMMIT_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef LIBKOMMIT_DECL_DEPRECATED_EXPORT
#  define LIBKOMMIT_DECL_DEPRECATED_EXPORT LIBKOMMIT_EXPORT LIBKOMMIT_DECL_DEPRECATED
#endif

#ifndef LIBKOMMIT_DECL_DEPRECATED_NO_EXPORT
#  define LIBKOMMIT_DECL_DEPRECATED_NO_EXPORT LIBKOMMIT_NO_EXPORT LIBKOMMIT_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef LIBKOMMIT_NO_DEPRECATED
#    define LIBKOMMIT_NO_DEPRECATED
#  endif
#endif
#include <libkommit_version.h>

#define LIBKOMMIT_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(LIBKOMMIT_NO_DEPRECATED)
#  undef LIBKOMMIT_DEPRECATED
#  define LIBKOMMIT_DEPRECATED_EXPORT LIBKOMMIT_EXPORT
#  define LIBKOMMIT_DEPRECATED_NO_EXPORT LIBKOMMIT_NO_EXPORT
#elif defined(LIBKOMMIT_NO_DEPRECATED_WARNINGS)
#  define LIBKOMMIT_DEPRECATED
#  define LIBKOMMIT_DEPRECATED_EXPORT LIBKOMMIT_EXPORT
#  define LIBKOMMIT_DEPRECATED_NO_EXPORT LIBKOMMIT_NO_EXPORT
#else
#  define LIBKOMMIT_DEPRECATED LIBKOMMIT_DECL_DEPRECATED
#  define LIBKOMMIT_DEPRECATED_EXPORT LIBKOMMIT_DECL_DEPRECATED_EXPORT
#  define LIBKOMMIT_DEPRECATED_NO_EXPORT LIBKOMMIT_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define LIBKOMMIT_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define LIBKOMMIT_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef LIBKOMMIT_NO_DEPRECATED
#  define LIBKOMMIT_DISABLE_DEPRECATED_BEFORE_AND_AT LIBKOMMIT_VERSION
#endif
#ifdef LIBKOMMIT_NO_DEPRECATED_WARNINGS
#  define LIBKOMMIT_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef LIBKOMMIT_DEPRECATED_WARNINGS_SINCE
#  ifdef LIBKOMMIT_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define LIBKOMMIT_DEPRECATED_WARNINGS_SINCE LIBKOMMIT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define LIBKOMMIT_DEPRECATED_WARNINGS_SINCE LIBKOMMIT_VERSION
#  endif
#endif

#ifndef LIBKOMMIT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define LIBKOMMIT_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef LIBKOMMIT_DEPRECATED
#  define LIBKOMMIT_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > LIBKOMMIT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define LIBKOMMIT_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* LIBKOMMIT_EXPORT_H */
