# Commands
from esphome.components.const import CONF_DRAW_ROUNDING
from esphome.const import CONF_INVERT_COLORS, CONF_SWAP_XY

SW_RESET_CMD = 0x01
SLEEP_IN = 0x10
SLEEP_OUT = 0x11
NORON = 0x13
INVERT_OFF = 0x20
INVERT_ON = 0x21
ALL_ON = 0x23
WRAM = 0x24
MIPI = 0x26
DISPLAY_OFF = 0x28
DISPLAY_ON = 0x29
RASET = 0x2B
CASET = 0x2A
WDATA = 0x2C
TEON = 0x35
MADCTL_CMD = 0x36
PIXFMT = 0x3A
BRIGHTNESS = 0x51
SWIRE1 = 0x5A
SWIRE2 = 0x5B
PAGESEL = 0xFE


class DriverChip:
    chips = {}

    def __init__(self, name: str, defaults=None):
        name = name.upper()
        self.name = name
        self.chips[name] = self
        self.initsequence = []
        self.defaults = defaults or {}

    def cmd(self, c, *args):
        """
        Add a command sequence to the init sequence
        :param c: The command (8 bit)
        :param args: zero or more arguments (8 bit values)
        """
        self.initsequence.extend([c, len(args)] + list(args))

    def delay(self, ms):
        self.initsequence.extend([ms, 0xFF])


chip = DriverChip("RM67162")
chip.cmd(PIXFMT, 0x55)
chip.cmd(BRIGHTNESS, 0)

chip = DriverChip("RM690B0")
chip.cmd(PAGESEL, 0x20)
chip.cmd(MIPI, 0x0A)
chip.cmd(WRAM, 0x80)
chip.cmd(SWIRE1, 0x51)
chip.cmd(SWIRE2, 0x2E)
chip.cmd(PAGESEL, 0x00)
chip.cmd(0xC2, 0x00)
chip.delay(10)
chip.cmd(TEON, 0x00)
chip.cmd(PIXFMT, 0x55)
chip.cmd(NORON)

chip = DriverChip("AXS15231", {CONF_DRAW_ROUNDING: 8, CONF_SWAP_XY: False})
chip.cmd(0xBB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0xA5)
chip.cmd(0xC1, 0x33)
chip.cmd(0xBB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)

chip = DriverChip(
    "JC4832W535",
    {
        CONF_DRAW_ROUNDING: 8,
        CONF_SWAP_XY: False,
    },
)
chip.cmd(DISPLAY_OFF)
chip.delay(20)
chip.cmd(SLEEP_IN)
chip.delay(80)
chip.cmd(SLEEP_OUT)
chip.cmd(INVERT_OFF)
# A magic sequence to enable the windowed drawing mode
chip.cmd(0xBB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5A, 0xA5)
chip.cmd(0xC1, 0x33)
chip.cmd(0xBB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00)

chip = DriverChip("JC3636W518", {CONF_INVERT_COLORS: True})
chip.cmd(0xF0, 0x08)
chip.cmd(0xF2, 0x08)
chip.cmd(0x9B, 0x51)
chip.cmd(0x86, 0x53)
chip.cmd(0xF2, 0x80)
chip.cmd(0xF0, 0x00)
chip.cmd(0xF0, 0x01)
chip.cmd(0xF1, 0x01)
chip.cmd(0xB0, 0x54)
chip.cmd(0xB1, 0x3F)
chip.cmd(0xB2, 0x2A)
chip.cmd(0xB4, 0x46)
chip.cmd(0xB5, 0x34)
chip.cmd(0xB6, 0xD5)
chip.cmd(0xB7, 0x30)
chip.cmd(0xBA, 0x00)
chip.cmd(0xBB, 0x08)
chip.cmd(0xBC, 0x08)
chip.cmd(0xBD, 0x00)
chip.cmd(0xC0, 0x80)
chip.cmd(0xC1, 0x10)
chip.cmd(0xC2, 0x37)
chip.cmd(0xC3, 0x80)
chip.cmd(0xC4, 0x10)
chip.cmd(0xC5, 0x37)
chip.cmd(0xC6, 0xA9)
chip.cmd(0xC7, 0x41)
chip.cmd(0xC8, 0x51)
chip.cmd(0xC9, 0xA9)
chip.cmd(0xCA, 0x41)
chip.cmd(0xCB, 0x51)
chip.cmd(0xD0, 0x91)
chip.cmd(0xD1, 0x68)
chip.cmd(0xD2, 0x69)
chip.cmd(0xF5, 0x00, 0xA5)
chip.cmd(0xDD, 0x3F)
chip.cmd(0xDE, 0x3F)
chip.cmd(0xF1, 0x10)
chip.cmd(0xF0, 0x00)
chip.cmd(0xF0, 0x02)
chip.cmd(
    0xE0,
    0x70,
    0x09,
    0x12,
    0x0C,
    0x0B,
    0x27,
    0x38,
    0x54,
    0x4E,
    0x19,
    0x15,
    0x15,
    0x2C,
    0x2F,
)
chip.cmd(
    0xE1,
    0x70,
    0x08,
    0x11,
    0x0C,
    0x0B,
    0x27,
    0x38,
    0x43,
    0x4C,
    0x18,
    0x14,
    0x14,
    0x2B,
    0x2D,
)
chip.cmd(0xF0, 0x10)
chip.cmd(0xF3, 0x10)
chip.cmd(0xE0, 0x08)
chip.cmd(0xE1, 0x00)
chip.cmd(0xE2, 0x00)
chip.cmd(0xE3, 0x00)
chip.cmd(0xE4, 0xE0)
chip.cmd(0xE5, 0x06)
chip.cmd(0xE6, 0x21)
chip.cmd(0xE7, 0x00)
chip.cmd(0xE8, 0x05)
chip.cmd(0xE9, 0x82)
chip.cmd(0xEA, 0xDF)
chip.cmd(0xEB, 0x89)
chip.cmd(0xEC, 0x20)
chip.cmd(0xED, 0x14)
chip.cmd(0xEE, 0xFF)
chip.cmd(0xEF, 0x00)
chip.cmd(0xF8, 0xFF)
chip.cmd(0xF9, 0x00)
chip.cmd(0xFA, 0x00)
chip.cmd(0xFB, 0x30)
chip.cmd(0xFC, 0x00)
chip.cmd(0xFD, 0x00)
chip.cmd(0xFE, 0x00)
chip.cmd(0xFF, 0x00)
chip.cmd(0x60, 0x42)
chip.cmd(0x61, 0xE0)
chip.cmd(0x62, 0x40)
chip.cmd(0x63, 0x40)
chip.cmd(0x64, 0x02)
chip.cmd(0x65, 0x00)
chip.cmd(0x66, 0x40)
chip.cmd(0x67, 0x03)
chip.cmd(0x68, 0x00)
chip.cmd(0x69, 0x00)
chip.cmd(0x6A, 0x00)
chip.cmd(0x6B, 0x00)
chip.cmd(0x70, 0x42)
chip.cmd(0x71, 0xE0)
chip.cmd(0x72, 0x40)
chip.cmd(0x73, 0x40)
chip.cmd(0x74, 0x02)
chip.cmd(0x75, 0x00)
chip.cmd(0x76, 0x40)
chip.cmd(0x77, 0x03)
chip.cmd(0x78, 0x00)
chip.cmd(0x79, 0x00)
chip.cmd(0x7A, 0x00)
chip.cmd(0x7B, 0x00)
chip.cmd(0x80, 0x48)
chip.cmd(0x81, 0x00)
chip.cmd(0x82, 0x05)
chip.cmd(0x83, 0x02)
chip.cmd(0x84, 0xDD)
chip.cmd(0x85, 0x00)
chip.cmd(0x86, 0x00)
chip.cmd(0x87, 0x00)
chip.cmd(0x88, 0x48)
chip.cmd(0x89, 0x00)
chip.cmd(0x8A, 0x07)
chip.cmd(0x8B, 0x02)
chip.cmd(0x8C, 0xDF)
chip.cmd(0x8D, 0x00)
chip.cmd(0x8E, 0x00)
chip.cmd(0x8F, 0x00)
chip.cmd(0x90, 0x48)
chip.cmd(0x91, 0x00)
chip.cmd(0x92, 0x09)
chip.cmd(0x93, 0x02)
chip.cmd(0x94, 0xE1)
chip.cmd(0x95, 0x00)
chip.cmd(0x96, 0x00)
chip.cmd(0x97, 0x00)
chip.cmd(0x98, 0x48)
chip.cmd(0x99, 0x00)
chip.cmd(0x9A, 0x0B)
chip.cmd(0x9B, 0x02)
chip.cmd(0x9C, 0xE3)
chip.cmd(0x9D, 0x00)
chip.cmd(0x9E, 0x00)
chip.cmd(0x9F, 0x00)
chip.cmd(0xA0, 0x48)
chip.cmd(0xA1, 0x00)
chip.cmd(0xA2, 0x04)
chip.cmd(0xA3, 0x02)
chip.cmd(0xA4, 0xDC)
chip.cmd(0xA5, 0x00)
chip.cmd(0xA6, 0x00)
chip.cmd(0xA7, 0x00)
chip.cmd(0xA8, 0x48)
chip.cmd(0xA9, 0x00)
chip.cmd(0xAA, 0x06)
chip.cmd(0xAB, 0x02)
chip.cmd(0xAC, 0xDE)
chip.cmd(0xAD, 0x00)
chip.cmd(0xAE, 0x00)
chip.cmd(0xAF, 0x00)
chip.cmd(0xB0, 0x48)
chip.cmd(0xB1, 0x00)
chip.cmd(0xB2, 0x08)
chip.cmd(0xB3, 0x02)
chip.cmd(0xB4, 0xE0)
chip.cmd(0xB5, 0x00)
chip.cmd(0xB6, 0x00)
chip.cmd(0xB7, 0x00)
chip.cmd(0xB8, 0x48)
chip.cmd(0xB9, 0x00)
chip.cmd(0xBA, 0x0A)
chip.cmd(0xBB, 0x02)
chip.cmd(0xBC, 0xE2)
chip.cmd(0xBD, 0x00)
chip.cmd(0xBE, 0x00)
chip.cmd(0xBF, 0x00)
chip.cmd(0xC0, 0x12)
chip.cmd(0xC1, 0xAA)
chip.cmd(0xC2, 0x65)
chip.cmd(0xC3, 0x74)
chip.cmd(0xC4, 0x47)
chip.cmd(0xC5, 0x56)
chip.cmd(0xC6, 0x00)
chip.cmd(0xC7, 0x88)
chip.cmd(0xC8, 0x99)
chip.cmd(0xC9, 0x33)
chip.cmd(0xD0, 0x21)
chip.cmd(0xD1, 0xAA)
chip.cmd(0xD2, 0x65)
chip.cmd(0xD3, 0x74)
chip.cmd(0xD4, 0x47)
chip.cmd(0xD5, 0x56)
chip.cmd(0xD6, 0x00)
chip.cmd(0xD7, 0x88)
chip.cmd(0xD8, 0x99)
chip.cmd(0xD9, 0x33)
chip.cmd(0xF3, 0x01)
chip.cmd(0xF0, 0x00)
chip.cmd(0xF0, 0x01)
chip.cmd(0xF1, 0x01)
chip.cmd(0xA0, 0x0B)
chip.cmd(0xA3, 0x2A)
chip.cmd(0xA5, 0xC3)
chip.cmd(PIXFMT, 0x55)


DriverChip("Custom")
