// third_party/blink/public/mojom/feature_policy/policy_value.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEATURE_POLICY_POLICY_VALUE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEATURE_POLICY_POLICY_VALUE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/feature_policy/policy_value.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class PolicyValueDataView;


}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PolicyValueDataView> {
  using Data = ::blink::mojom::internal::PolicyValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class PolicyValueType : int32_t {
  
  kNull = 0,
  
  kBool = 1,
  
  kDecDouble = 2,
  
  kEnum = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PolicyValueType value);
inline bool IsKnownEnumValue(PolicyValueType value) {
  return internal::PolicyValueType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PolicyValueDataView {
 public:
  using Tag = internal::PolicyValue_Data::PolicyValue_Tag;

  PolicyValueDataView() {}

  PolicyValueDataView(
      internal::PolicyValue_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_null_value() const { return data_->tag == Tag::NULL_VALUE; }
  bool null_value() const {
    DCHECK(is_null_value());
    return data_->data.f_null_value;
  }
  bool is_bool_value() const { return data_->tag == Tag::BOOL_VALUE; }
  bool bool_value() const {
    DCHECK(is_bool_value());
    return data_->data.f_bool_value;
  }
  bool is_dec_double_value() const { return data_->tag == Tag::DEC_DOUBLE_VALUE; }
  double dec_double_value() const {
    DCHECK(is_dec_double_value());
    return data_->data.f_dec_double_value;
  }
  bool is_enum_value() const { return data_->tag == Tag::ENUM_VALUE; }
  int32_t enum_value() const {
    DCHECK(is_enum_value());
    return data_->data.f_enum_value;
  }

 private:
  internal::PolicyValue_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::PolicyValueType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PolicyValueType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::PolicyValueType, ::blink::mojom::PolicyValueType> {
  static ::blink::mojom::PolicyValueType ToMojom(::blink::mojom::PolicyValueType input) { return input; }
  static bool FromMojom(::blink::mojom::PolicyValueType input, ::blink::mojom::PolicyValueType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyValueType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PolicyValueType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::PolicyValueType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PolicyValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PolicyValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PolicyValue_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::blink::mojom::internal::PolicyValue_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::blink::mojom::PolicyValueDataView::Tag::NULL_VALUE: {
        decltype(Traits::null_value(input))
            in_null_value = Traits::null_value(input);
        result->data.f_null_value = in_null_value;
        break;
      }
      case ::blink::mojom::PolicyValueDataView::Tag::BOOL_VALUE: {
        decltype(Traits::bool_value(input))
            in_bool_value = Traits::bool_value(input);
        result->data.f_bool_value = in_bool_value;
        break;
      }
      case ::blink::mojom::PolicyValueDataView::Tag::DEC_DOUBLE_VALUE: {
        decltype(Traits::dec_double_value(input))
            in_dec_double_value = Traits::dec_double_value(input);
        result->data.f_dec_double_value = in_dec_double_value;
        break;
      }
      case ::blink::mojom::PolicyValueDataView::Tag::ENUM_VALUE: {
        decltype(Traits::enum_value(input))
            in_enum_value = Traits::enum_value(input);
        result->data.f_enum_value = in_enum_value;
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::PolicyValue_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PolicyValueDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEATURE_POLICY_POLICY_VALUE_MOJOM_SHARED_H_