// services/viz/public/mojom/compositing/copy_output_request.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-forward.h"
#include "gpu/ipc/common/mailbox.mojom-forward.h"
#include "gpu/ipc/common/sync_token.mojom-forward.h"
#include "services/viz/public/mojom/compositing/copy_output_result.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "services/viz/public/cpp/compositing/copy_output_request_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {

class CopyOutputResultSenderProxy;

template <typename ImplRefTraits>
class CopyOutputResultSenderStub;

class CopyOutputResultSenderRequestValidator;


class  CopyOutputResultSender
    : public CopyOutputResultSenderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CopyOutputResultSenderInterfaceBase;
  using Proxy_ = CopyOutputResultSenderProxy;

  template <typename ImplRefTraits>
  using Stub_ = CopyOutputResultSenderStub<ImplRefTraits>;

  using RequestValidator_ = CopyOutputResultSenderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendResultMinVersion = 0,
  };
  virtual ~CopyOutputResultSender() {}

  
  virtual void SendResult(::std::unique_ptr<::viz::CopyOutputResult> result) = 0;
};



class  CopyOutputResultSenderProxy
    : public CopyOutputResultSender {
 public:
  using InterfaceType = CopyOutputResultSender;

  explicit CopyOutputResultSenderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendResult(::std::unique_ptr<::viz::CopyOutputResult> result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CopyOutputResultSenderStubDispatch {
 public:
  static bool Accept(CopyOutputResultSender* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CopyOutputResultSender* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CopyOutputResultSender>>
class CopyOutputResultSenderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CopyOutputResultSenderStub() {}
  ~CopyOutputResultSenderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CopyOutputResultSenderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CopyOutputResultSenderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CopyOutputResultSenderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  CopyOutputRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CopyOutputRequest, T>::value>;
  using DataView = CopyOutputRequestDataView;
  using Data_ = internal::CopyOutputRequest_Data;

  template <typename... Args>
  static CopyOutputRequestPtr New(Args&&... args) {
    return CopyOutputRequestPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CopyOutputRequestPtr From(const U& u) {
    return mojo::TypeConverter<CopyOutputRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CopyOutputRequest>::Convert(*this);
  }


  CopyOutputRequest();

  CopyOutputRequest(
      ::viz::mojom::CopyOutputResultFormat result_format,
      const ::gfx::Vector2d& scale_from,
      const ::gfx::Vector2d& scale_to,
      const base::Optional<::base::UnguessableToken>& source,
      const base::Optional<::gfx::Rect>& area,
      const base::Optional<::gfx::Rect>& result_selection,
      ::mojo::PendingRemote<CopyOutputResultSender> result_sender);

  ~CopyOutputRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CopyOutputRequestPtr>
  CopyOutputRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CopyOutputRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CopyOutputRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CopyOutputRequest_UnserializedMessageContext<
            UserType, CopyOutputRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CopyOutputRequest::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CopyOutputRequest::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CopyOutputRequest_UnserializedMessageContext<
            UserType, CopyOutputRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CopyOutputRequest::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::viz::mojom::CopyOutputResultFormat result_format;
  
  ::gfx::Vector2d scale_from;
  
  ::gfx::Vector2d scale_to;
  
  base::Optional<::base::UnguessableToken> source;
  
  base::Optional<::gfx::Rect> area;
  
  base::Optional<::gfx::Rect> result_selection;
  
  ::mojo::PendingRemote<CopyOutputResultSender> result_sender;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CopyOutputRequest);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CopyOutputRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CopyOutputRequestPtr CopyOutputRequest::Clone() const {
  return New(
      mojo::Clone(result_format),
      mojo::Clone(scale_from),
      mojo::Clone(scale_to),
      mojo::Clone(source),
      mojo::Clone(area),
      mojo::Clone(result_selection),
      mojo::Clone(result_sender)
  );
}

template <typename T, CopyOutputRequest::EnableIfSame<T>*>
bool CopyOutputRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->result_format, other_struct.result_format))
    return false;
  if (!mojo::Equals(this->scale_from, other_struct.scale_from))
    return false;
  if (!mojo::Equals(this->scale_to, other_struct.scale_to))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->area, other_struct.area))
    return false;
  if (!mojo::Equals(this->result_selection, other_struct.result_selection))
    return false;
  if (!mojo::Equals(this->result_sender, other_struct.result_sender))
    return false;
  return true;
}

template <typename T, CopyOutputRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.result_format, rhs.result_format))
    return true;
  if (std::less<>{}(rhs.result_format, lhs.result_format))
    return false;
  if (std::less<>{}(lhs.scale_from, rhs.scale_from))
    return true;
  if (std::less<>{}(rhs.scale_from, lhs.scale_from))
    return false;
  if (std::less<>{}(lhs.scale_to, rhs.scale_to))
    return true;
  if (std::less<>{}(rhs.scale_to, lhs.scale_to))
    return false;
  if (std::less<>{}(lhs.source, rhs.source))
    return true;
  if (std::less<>{}(rhs.source, lhs.source))
    return false;
  if (std::less<>{}(lhs.area, rhs.area))
    return true;
  if (std::less<>{}(rhs.area, lhs.area))
    return false;
  if (std::less<>{}(lhs.result_selection, rhs.result_selection))
    return true;
  if (std::less<>{}(rhs.result_selection, lhs.result_selection))
    return false;
  if (std::less<>{}(lhs.result_sender, rhs.result_sender))
    return true;
  if (std::less<>{}(rhs.result_sender, lhs.result_sender))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace viz

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::CopyOutputRequest::DataView,
                                         ::viz::mojom::CopyOutputRequestPtr> {
  static bool IsNull(const ::viz::mojom::CopyOutputRequestPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::CopyOutputRequestPtr* output) { output->reset(); }

  static decltype(::viz::mojom::CopyOutputRequest::result_format) result_format(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->result_format;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::scale_from)& scale_from(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->scale_from;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::scale_to)& scale_to(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->scale_to;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::source)& source(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->source;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::area)& area(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->area;
  }

  static const decltype(::viz::mojom::CopyOutputRequest::result_selection)& result_selection(
      const ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->result_selection;
  }

  static  decltype(::viz::mojom::CopyOutputRequest::result_sender)& result_sender(
       ::viz::mojom::CopyOutputRequestPtr& input) {
    return input->result_sender;
  }

  static bool Read(::viz::mojom::CopyOutputRequest::DataView input, ::viz::mojom::CopyOutputRequestPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_REQUEST_MOJOM_H_