/*
 * Module code.
 *
 * Generated by SIP 6.12.0
 */

#include "sipAPI_analysis.h"

#line 21 "auto_generated/raster/qgsrastercalculator.sip"
#include "qgsrastercalculator.h"
#line 12 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"

#line 35 "/build/qgis/src/build/python/core/auto_generated/raster/qgsrasterlayer.sip"
#include "qgsrasterlayer.h"
#line 16 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 19 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 22 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"


PyDoc_STRVAR(doc_QgsRasterCalculatorEntry_rasterEntries, "rasterEntries() -> list[QgsRasterCalculatorEntry]\n"
"Creates a list of raster entries from the current project.\n"
"\n"
"If there is more than one layer with the same data source only one of\n"
"them is added to the list, duplicate names are also handled by appending\n"
"an _n integer to the base name.\n"
"\n"
":return: the list of raster entries form the current project\n"
"\n"
".. versionadded:: 3.6");

extern "C" {static PyObject *meth_QgsRasterCalculatorEntry_rasterEntries(PyObject *, PyObject *);}
static PyObject *meth_QgsRasterCalculatorEntry_rasterEntries(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QVector< ::QgsRasterCalculatorEntry>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QVector< ::QgsRasterCalculatorEntry>(::QgsRasterCalculatorEntry::rasterEntries());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QVector_0100QgsRasterCalculatorEntry, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsRasterCalculatorEntry, sipName_rasterEntries, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsRasterCalculatorEntry(void *, int);}
static void release_QgsRasterCalculatorEntry(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsRasterCalculatorEntry(Py_ssize_t);}
static void *array_QgsRasterCalculatorEntry(Py_ssize_t sipNrElem)
{
    return new ::QgsRasterCalculatorEntry[sipNrElem];
}


extern "C" {static void array_delete_QgsRasterCalculatorEntry(void *);}
static void array_delete_QgsRasterCalculatorEntry(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipCpp);
}


extern "C" {static void assign_QgsRasterCalculatorEntry(void *, Py_ssize_t, void *);}
static void assign_QgsRasterCalculatorEntry(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipSrc);
}


extern "C" {static void *copy_QgsRasterCalculatorEntry(const void *, Py_ssize_t);}
static void *copy_QgsRasterCalculatorEntry(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsRasterCalculatorEntry(reinterpret_cast<const ::QgsRasterCalculatorEntry *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsRasterCalculatorEntry(sipSimpleWrapper *);}
static void dealloc_QgsRasterCalculatorEntry(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsRasterCalculatorEntry(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsRasterCalculatorEntry(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsRasterCalculatorEntry(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsRasterCalculatorEntry *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsRasterCalculatorEntry();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsRasterCalculatorEntry* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsRasterCalculatorEntry, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsRasterCalculatorEntry(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsRasterCalculatorEntry[] = {
    {sipName_rasterEntries, meth_QgsRasterCalculatorEntry_rasterEntries, METH_VARARGS, doc_QgsRasterCalculatorEntry_rasterEntries}
};


extern "C" {static PyObject *varget_QgsRasterCalculatorEntry_bandNumber(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsRasterCalculatorEntry_bandNumber(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
    ::QgsRasterCalculatorEntry *sipCpp = reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipSelf);

    sipVal = sipCpp->bandNumber;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_QgsRasterCalculatorEntry_bandNumber(void *, PyObject *, PyObject *);}
static int varset_QgsRasterCalculatorEntry_bandNumber(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::QgsRasterCalculatorEntry *sipCpp = reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->bandNumber = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsRasterCalculatorEntry_raster(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsRasterCalculatorEntry_raster(void *sipSelf, PyObject *, PyObject *)
{
    ::QgsRasterLayer*sipVal;
    ::QgsRasterCalculatorEntry *sipCpp = reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipSelf);

    sipVal = sipCpp->raster;

    return sipConvertFromType(sipVal, sipType_QgsRasterLayer, SIP_NULLPTR);
}


extern "C" {static int varset_QgsRasterCalculatorEntry_raster(void *, PyObject *, PyObject *);}
static int varset_QgsRasterCalculatorEntry_raster(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::QgsRasterLayer*sipVal;
    ::QgsRasterCalculatorEntry *sipCpp = reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::QgsRasterLayer *>(sipForceConvertToType(sipPy, sipType_QgsRasterLayer, SIP_NULLPTR, 0, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->raster = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsRasterCalculatorEntry_ref(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsRasterCalculatorEntry_ref(void *sipSelf, PyObject *, PyObject *)
{
    ::QString*sipVal;
    ::QgsRasterCalculatorEntry *sipCpp = reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipSelf);

    sipVal = &sipCpp->ref;

    return sipConvertFromType(sipVal, sipType_QString, SIP_NULLPTR);
}


extern "C" {static int varset_QgsRasterCalculatorEntry_ref(void *, PyObject *, PyObject *);}
static int varset_QgsRasterCalculatorEntry_ref(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::QString*sipVal;
    ::QgsRasterCalculatorEntry *sipCpp = reinterpret_cast< ::QgsRasterCalculatorEntry *>(sipSelf);

    int sipIsErr = 0;
    int sipValState;
    sipVal = reinterpret_cast< ::QString *>(sipForceConvertToType(sipPy, sipType_QString, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->ref = *sipVal;

    sipReleaseType(sipVal, sipType_QString, sipValState);

    return 0;
}

sipVariableDef variables_QgsRasterCalculatorEntry[] = {
    {InstanceVariable, sipName_bandNumber, (PyMethodDef *)varget_QgsRasterCalculatorEntry_bandNumber, (PyMethodDef *)varset_QgsRasterCalculatorEntry_bandNumber, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_raster, (PyMethodDef *)varget_QgsRasterCalculatorEntry_raster, (PyMethodDef *)varset_QgsRasterCalculatorEntry_raster, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_ref, (PyMethodDef *)varget_QgsRasterCalculatorEntry_ref, (PyMethodDef *)varset_QgsRasterCalculatorEntry_ref, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_QgsRasterCalculatorEntry, "Represents an individual raster layer/band number entry within a raster\n"
"calculation.\n"
"\n"
"");


static pyqt5ClassPluginDef plugin_QgsRasterCalculatorEntry = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsRasterCalculatorEntry = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsRasterCalculatorEntry,
        SIP_NULLPTR,
        &plugin_QgsRasterCalculatorEntry,
    },
    {
        sipNameNr_QgsRasterCalculatorEntry,
        {0, 0, 1},
        1, methods_QgsRasterCalculatorEntry,
        0, SIP_NULLPTR,
        3, variables_QgsRasterCalculatorEntry,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsRasterCalculatorEntry,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsRasterCalculatorEntry,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsRasterCalculatorEntry,
    assign_QgsRasterCalculatorEntry,
    array_QgsRasterCalculatorEntry,
    copy_QgsRasterCalculatorEntry,
    release_QgsRasterCalculatorEntry,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsRasterCalculatorEntry,
    sizeof (::QgsRasterCalculatorEntry),
};

#line 21 "auto_generated/raster/qgsrastercalcnode.sip"
#include "qgsrastercalcnode.h"
#line 359 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"

#line 19 "auto_generated/raster/qgsrastermatrix.sip"
#include "qgsrastermatrix.h"
#line 363 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 366 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 139 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 369 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 36 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 372 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 375 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"


PyDoc_STRVAR(doc_QgsRasterCalcNode_type, "type(self) -> QgsRasterCalcNode.Type");

extern "C" {static PyObject *meth_QgsRasterCalcNode_type(PyObject *, PyObject *);}
static PyObject *meth_QgsRasterCalcNode_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsRasterCalcNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsRasterCalcNode, &sipCpp))
        {
            ::QgsRasterCalcNode::Type sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->type();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QgsRasterCalcNode_Type);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsRasterCalcNode, sipName_type, doc_QgsRasterCalcNode_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsRasterCalcNode_setLeft, "setLeft(self, left: Optional[QgsRasterCalcNode])");

extern "C" {static PyObject *meth_QgsRasterCalcNode_setLeft(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsRasterCalcNode_setLeft(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsRasterCalcNode* a0;
        ::QgsRasterCalcNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_left,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsRasterCalcNode, &sipCpp, sipType_QgsRasterCalcNode, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setLeft(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsRasterCalcNode, sipName_setLeft, doc_QgsRasterCalcNode_setLeft);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsRasterCalcNode_setRight, "setRight(self, right: Optional[QgsRasterCalcNode])");

extern "C" {static PyObject *meth_QgsRasterCalcNode_setRight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsRasterCalcNode_setRight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsRasterCalcNode* a0;
        ::QgsRasterCalcNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_right,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsRasterCalcNode, &sipCpp, sipType_QgsRasterCalcNode, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setRight(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsRasterCalcNode, sipName_setRight, doc_QgsRasterCalcNode_setRight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsRasterCalcNode_toString, "toString(self, cStyle: bool = False) -> str\n"
"Returns a string representation of the expression\n"
"\n"
":param cStyle: if ``True`` operators will follow C syntax\n"
"\n"
".. versionadded:: 3.6");

extern "C" {static PyObject *meth_QgsRasterCalcNode_toString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsRasterCalcNode_toString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0 = 0;
        const ::QgsRasterCalcNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cStyle,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_QgsRasterCalcNode, &sipCpp, &a0))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->toString(a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsRasterCalcNode, sipName_toString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsRasterCalcNode_findNodes, "findNodes(self, type: QgsRasterCalcNode.Type) -> list[QgsRasterCalcNode]\n"
"Returns a list of nodes of a specific ``type``\n"
"\n"
".. versionadded:: 3.6");

extern "C" {static PyObject *meth_QgsRasterCalcNode_findNodes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsRasterCalcNode_findNodes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsRasterCalcNode::Type a0;
        const ::QgsRasterCalcNode *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_QgsRasterCalcNode, &sipCpp, sipType_QgsRasterCalcNode_Type, &a0))
        {
            QList<const ::QgsRasterCalcNode*>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QList<const ::QgsRasterCalcNode*>(sipCpp->findNodes(a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QList_0111QgsRasterCalcNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsRasterCalcNode, sipName_findNodes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsRasterCalcNode_parseRasterCalcString, "parseRasterCalcString(str: Optional[str], parserErrorMsg: Optional[str]) -> Optional[QgsRasterCalcNode]");

extern "C" {static PyObject *meth_QgsRasterCalcNode_parseRasterCalcString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsRasterCalcNode_parseRasterCalcString(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QString* a1;
        int a1State = 0;

        static const char *sipKwdList[] = {
            sipName_str,
            sipName_parserErrorMsg,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1J1", sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            ::QgsRasterCalcNode*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsRasterCalcNode::parseRasterCalcString(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(a1, sipType_QString, a1State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(a1, sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QgsRasterCalcNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsRasterCalcNode, sipName_parseRasterCalcString, doc_QgsRasterCalcNode_parseRasterCalcString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsRasterCalcNode_referencedLayerNames, "referencedLayerNames(self) -> list[str]\n"
"Returns a list of raster layer names that are referenced in the formula\n"
"without the quotation marks. It uses\n"
"QgsRasterCalcNode.cleanRasterReferences\n"
"\n"
".. note::\n"
"\n"
"   since QGIS 3.22");

extern "C" {static PyObject *meth_QgsRasterCalcNode_referencedLayerNames(PyObject *, PyObject *);}
static PyObject *meth_QgsRasterCalcNode_referencedLayerNames(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsRasterCalcNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsRasterCalcNode, &sipCpp))
        {
            ::QStringList*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QStringList(sipCpp->referencedLayerNames());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsRasterCalcNode, sipName_referencedLayerNames, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsRasterCalcNode_cleanRasterReferences, "cleanRasterReferences(self) -> list[str]\n"
"Returns a list of raster layer references that are addressed in the\n"
"formula, without quotation marks.\n"
"\n"
".. note::\n"
"\n"
"   since QGIS 3.22");

extern "C" {static PyObject *meth_QgsRasterCalcNode_cleanRasterReferences(PyObject *, PyObject *);}
static PyObject *meth_QgsRasterCalcNode_cleanRasterReferences(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsRasterCalcNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsRasterCalcNode, &sipCpp))
        {
            ::QStringList*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QStringList(sipCpp->cleanRasterReferences());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsRasterCalcNode, sipName_cleanRasterReferences, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsRasterCalcNode(void *, int);}
static void release_QgsRasterCalcNode(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsRasterCalcNode *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsRasterCalcNode(Py_ssize_t);}
static void *array_QgsRasterCalcNode(Py_ssize_t sipNrElem)
{
    return new ::QgsRasterCalcNode[sipNrElem];
}


extern "C" {static void array_delete_QgsRasterCalcNode(void *);}
static void array_delete_QgsRasterCalcNode(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsRasterCalcNode *>(sipCpp);
}


extern "C" {static void dealloc_QgsRasterCalcNode(sipSimpleWrapper *);}
static void dealloc_QgsRasterCalcNode(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsRasterCalcNode(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsRasterCalcNode(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsRasterCalcNode(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsRasterCalcNode *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsRasterCalcNode();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        double a0;

        static const char *sipKwdList[] = {
            sipName_number,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "d", &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsRasterCalcNode(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        ::QgsRasterMatrix* a0;

        static const char *sipKwdList[] = {
            sipName_matrix,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8", sipType_QgsRasterMatrix, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsRasterCalcNode(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        ::QgsRasterCalcNode::Operator a0;
        ::QgsRasterCalcNode* a1;
        ::QgsRasterCalcNode* a2;

        static const char *sipKwdList[] = {
            sipName_op,
            sipName_left,
            sipName_right,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "EJ8J8", sipType_QgsRasterCalcNode_Operator, &a0, sipType_QgsRasterCalcNode, &a1, sipType_QgsRasterCalcNode, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsRasterCalcNode(a0, a1, a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        ::QString* a0;
        int a0State = 0;
        QVector< ::QgsRasterCalcNode*>* a1;
        int a1State = 0;

        static const char *sipKwdList[] = {
            sipName_functionName,
            sipName_functionArgs,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1", sipType_QString, &a0, &a0State, sipType_QVector_0101QgsRasterCalcNode, &a1, &a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsRasterCalcNode(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a0, sipType_QString, a0State);
            sipReleaseType(a1, sipType_QVector_0101QgsRasterCalcNode, a1State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a0, sipType_QString, a0State);
            sipReleaseType(a1, sipType_QVector_0101QgsRasterCalcNode, a1State);

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;

        static const char *sipKwdList[] = {
            sipName_rasterName,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsRasterCalcNode(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsRasterCalcNode[] = {
    {sipName_cleanRasterReferences, meth_QgsRasterCalcNode_cleanRasterReferences, METH_VARARGS, doc_QgsRasterCalcNode_cleanRasterReferences},
    {sipName_findNodes, SIP_MLMETH_CAST(meth_QgsRasterCalcNode_findNodes), METH_VARARGS|METH_KEYWORDS, doc_QgsRasterCalcNode_findNodes},
    {sipName_parseRasterCalcString, SIP_MLMETH_CAST(meth_QgsRasterCalcNode_parseRasterCalcString), METH_VARARGS|METH_KEYWORDS, doc_QgsRasterCalcNode_parseRasterCalcString},
    {sipName_referencedLayerNames, meth_QgsRasterCalcNode_referencedLayerNames, METH_VARARGS, doc_QgsRasterCalcNode_referencedLayerNames},
    {sipName_setLeft, SIP_MLMETH_CAST(meth_QgsRasterCalcNode_setLeft), METH_VARARGS|METH_KEYWORDS, doc_QgsRasterCalcNode_setLeft},
    {sipName_setRight, SIP_MLMETH_CAST(meth_QgsRasterCalcNode_setRight), METH_VARARGS|METH_KEYWORDS, doc_QgsRasterCalcNode_setRight},
    {sipName_toString, SIP_MLMETH_CAST(meth_QgsRasterCalcNode_toString), METH_VARARGS|METH_KEYWORDS, doc_QgsRasterCalcNode_toString},
    {sipName_type, meth_QgsRasterCalcNode_type, METH_VARARGS, doc_QgsRasterCalcNode_type}
};

static sipEnumMemberDef enummembers_QgsRasterCalcNode[] = {
    {sipName_opABS, static_cast<int>(::QgsRasterCalcNode::opABS), 80},
    {sipName_opACOS, static_cast<int>(::QgsRasterCalcNode::opACOS), 80},
    {sipName_opAND, static_cast<int>(::QgsRasterCalcNode::opAND), 80},
    {sipName_opASIN, static_cast<int>(::QgsRasterCalcNode::opASIN), 80},
    {sipName_opATAN, static_cast<int>(::QgsRasterCalcNode::opATAN), 80},
    {sipName_opCOS, static_cast<int>(::QgsRasterCalcNode::opCOS), 80},
    {sipName_opDIV, static_cast<int>(::QgsRasterCalcNode::opDIV), 80},
    {sipName_opEQ, static_cast<int>(::QgsRasterCalcNode::opEQ), 80},
    {sipName_opGE, static_cast<int>(::QgsRasterCalcNode::opGE), 80},
    {sipName_opGT, static_cast<int>(::QgsRasterCalcNode::opGT), 80},
    {sipName_opLE, static_cast<int>(::QgsRasterCalcNode::opLE), 80},
    {sipName_opLOG, static_cast<int>(::QgsRasterCalcNode::opLOG), 80},
    {sipName_opLOG10, static_cast<int>(::QgsRasterCalcNode::opLOG10), 80},
    {sipName_opLT, static_cast<int>(::QgsRasterCalcNode::opLT), 80},
    {sipName_opMAX, static_cast<int>(::QgsRasterCalcNode::opMAX), 80},
    {sipName_opMIN, static_cast<int>(::QgsRasterCalcNode::opMIN), 80},
    {sipName_opMINUS, static_cast<int>(::QgsRasterCalcNode::opMINUS), 80},
    {sipName_opMUL, static_cast<int>(::QgsRasterCalcNode::opMUL), 80},
    {sipName_opNE, static_cast<int>(::QgsRasterCalcNode::opNE), 80},
    {sipName_opNONE, static_cast<int>(::QgsRasterCalcNode::opNONE), 80},
    {sipName_opOR, static_cast<int>(::QgsRasterCalcNode::opOR), 80},
    {sipName_opPLUS, static_cast<int>(::QgsRasterCalcNode::opPLUS), 80},
    {sipName_opPOW, static_cast<int>(::QgsRasterCalcNode::opPOW), 80},
    {sipName_opSIGN, static_cast<int>(::QgsRasterCalcNode::opSIGN), 80},
    {sipName_opSIN, static_cast<int>(::QgsRasterCalcNode::opSIN), 80},
    {sipName_opSQRT, static_cast<int>(::QgsRasterCalcNode::opSQRT), 80},
    {sipName_opTAN, static_cast<int>(::QgsRasterCalcNode::opTAN), 80},
    {sipName_tFunction, static_cast<int>(::QgsRasterCalcNode::tFunction), 81},
    {sipName_tMatrix, static_cast<int>(::QgsRasterCalcNode::tMatrix), 81},
    {sipName_tNumber, static_cast<int>(::QgsRasterCalcNode::tNumber), 81},
    {sipName_tOperator, static_cast<int>(::QgsRasterCalcNode::tOperator), 81},
    {sipName_tRasterRef, static_cast<int>(::QgsRasterCalcNode::tRasterRef), 81},
};

PyDoc_STRVAR(doc_QgsRasterCalcNode, "Represents a node in a raster calculator.\n"
"\n"
"QgsRasterCalcNode()\n"
"\n"
"QgsRasterCalcNode(number: float)\n"
"\n"
"QgsRasterCalcNode(matrix: Optional[QgsRasterMatrix])\n"
"\n"
"QgsRasterCalcNode(op: QgsRasterCalcNode.Operator, left: Optional[QgsRasterCalcNode], right: Optional[QgsRasterCalcNode])\n"
"\n"
"QgsRasterCalcNode(functionName: Optional[str], functionArgs: Iterable[QgsRasterCalcNode])\n"
"Constructor for the tFunction type\n"
"\n"
"QgsRasterCalcNode(rasterName: Optional[str])");


static pyqt5ClassPluginDef plugin_QgsRasterCalcNode = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsRasterCalcNode = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsRasterCalcNode,
        SIP_NULLPTR,
        &plugin_QgsRasterCalcNode,
    },
    {
        sipNameNr_QgsRasterCalcNode,
        {0, 0, 1},
        8, methods_QgsRasterCalcNode,
        32, enummembers_QgsRasterCalcNode,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsRasterCalcNode,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsRasterCalcNode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsRasterCalcNode,
    SIP_NULLPTR,
    array_QgsRasterCalcNode,
    SIP_NULLPTR,
    release_QgsRasterCalcNode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsRasterCalcNode,
    sizeof (::QgsRasterCalcNode),
};

#line 22 "auto_generated/raster/qgskde.sip"
#include "qgskde.h"
#line 1177 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"

#line 22 "auto_generated/raster/qgskde.sip"
#include "qgskde.h"
#line 1181 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 1184 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 21 "/build/qgis/src/build/python/core/auto_generated/qgsfeaturesource.sip"
#include "qgsfeaturesource.h"
#line 1187 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"


/* Call the instance's destructor. */
extern "C" {static void release_QgsKernelDensityEstimation_Parameters(void *, int);}
static void release_QgsKernelDensityEstimation_Parameters(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsKernelDensityEstimation_Parameters(Py_ssize_t);}
static void *array_QgsKernelDensityEstimation_Parameters(Py_ssize_t sipNrElem)
{
    return new ::QgsKernelDensityEstimation::Parameters[sipNrElem];
}


extern "C" {static void array_delete_QgsKernelDensityEstimation_Parameters(void *);}
static void array_delete_QgsKernelDensityEstimation_Parameters(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipCpp);
}


extern "C" {static void assign_QgsKernelDensityEstimation_Parameters(void *, Py_ssize_t, void *);}
static void assign_QgsKernelDensityEstimation_Parameters(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSrc);
}


extern "C" {static void *copy_QgsKernelDensityEstimation_Parameters(const void *, Py_ssize_t);}
static void *copy_QgsKernelDensityEstimation_Parameters(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsKernelDensityEstimation::Parameters(reinterpret_cast<const ::QgsKernelDensityEstimation::Parameters *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsKernelDensityEstimation_Parameters(sipSimpleWrapper *);}
static void dealloc_QgsKernelDensityEstimation_Parameters(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsKernelDensityEstimation_Parameters(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsKernelDensityEstimation_Parameters(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsKernelDensityEstimation_Parameters(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsKernelDensityEstimation::Parameters *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsKernelDensityEstimation::Parameters();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsKernelDensityEstimation::Parameters* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsKernelDensityEstimation_Parameters, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsKernelDensityEstimation::Parameters(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static PyObject *varget_QgsKernelDensityEstimation_Parameters_decayRatio(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsKernelDensityEstimation_Parameters_decayRatio(void *sipSelf, PyObject *, PyObject *)
{
    double sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = sipCpp->decayRatio;

    return PyFloat_FromDouble(sipVal);
}


extern "C" {static int varset_QgsKernelDensityEstimation_Parameters_decayRatio(void *, PyObject *, PyObject *);}
static int varset_QgsKernelDensityEstimation_Parameters_decayRatio(void *sipSelf, PyObject *sipPy, PyObject *)
{
    double sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = PyFloat_AsDouble(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->decayRatio = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsKernelDensityEstimation_Parameters_outputValues(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsKernelDensityEstimation_Parameters_outputValues(void *sipSelf, PyObject *, PyObject *)
{
    ::QgsKernelDensityEstimation::OutputValues sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = sipCpp->outputValues;

    return sipConvertFromEnum(static_cast<int>(sipVal), sipType_QgsKernelDensityEstimation_OutputValues);
}


extern "C" {static int varset_QgsKernelDensityEstimation_Parameters_outputValues(void *, PyObject *, PyObject *);}
static int varset_QgsKernelDensityEstimation_Parameters_outputValues(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::QgsKernelDensityEstimation::OutputValues sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = (::QgsKernelDensityEstimation::OutputValues)sipConvertToEnum(sipPy, sipType_QgsKernelDensityEstimation_OutputValues);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->outputValues = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsKernelDensityEstimation_Parameters_pixelSize(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsKernelDensityEstimation_Parameters_pixelSize(void *sipSelf, PyObject *, PyObject *)
{
    double sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = sipCpp->pixelSize;

    return PyFloat_FromDouble(sipVal);
}


extern "C" {static int varset_QgsKernelDensityEstimation_Parameters_pixelSize(void *, PyObject *, PyObject *);}
static int varset_QgsKernelDensityEstimation_Parameters_pixelSize(void *sipSelf, PyObject *sipPy, PyObject *)
{
    double sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = PyFloat_AsDouble(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->pixelSize = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsKernelDensityEstimation_Parameters_radius(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsKernelDensityEstimation_Parameters_radius(void *sipSelf, PyObject *, PyObject *)
{
    double sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = sipCpp->radius;

    return PyFloat_FromDouble(sipVal);
}


extern "C" {static int varset_QgsKernelDensityEstimation_Parameters_radius(void *, PyObject *, PyObject *);}
static int varset_QgsKernelDensityEstimation_Parameters_radius(void *sipSelf, PyObject *sipPy, PyObject *)
{
    double sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = PyFloat_AsDouble(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->radius = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsKernelDensityEstimation_Parameters_radiusField(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsKernelDensityEstimation_Parameters_radiusField(void *sipSelf, PyObject *, PyObject *)
{
    ::QString*sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = &sipCpp->radiusField;

    return sipConvertFromType(sipVal, sipType_QString, SIP_NULLPTR);
}


extern "C" {static int varset_QgsKernelDensityEstimation_Parameters_radiusField(void *, PyObject *, PyObject *);}
static int varset_QgsKernelDensityEstimation_Parameters_radiusField(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::QString*sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    int sipIsErr = 0;
    int sipValState;
    sipVal = reinterpret_cast< ::QString *>(sipForceConvertToType(sipPy, sipType_QString, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->radiusField = *sipVal;

    sipReleaseType(sipVal, sipType_QString, sipValState);

    return 0;
}


extern "C" {static PyObject *varget_QgsKernelDensityEstimation_Parameters_shape(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsKernelDensityEstimation_Parameters_shape(void *sipSelf, PyObject *, PyObject *)
{
    ::QgsKernelDensityEstimation::KernelShape sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = sipCpp->shape;

    return sipConvertFromEnum(static_cast<int>(sipVal), sipType_QgsKernelDensityEstimation_KernelShape);
}


extern "C" {static int varset_QgsKernelDensityEstimation_Parameters_shape(void *, PyObject *, PyObject *);}
static int varset_QgsKernelDensityEstimation_Parameters_shape(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::QgsKernelDensityEstimation::KernelShape sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = (::QgsKernelDensityEstimation::KernelShape)sipConvertToEnum(sipPy, sipType_QgsKernelDensityEstimation_KernelShape);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->shape = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsKernelDensityEstimation_Parameters_source(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsKernelDensityEstimation_Parameters_source(void *sipSelf, PyObject *, PyObject *)
{
    ::QgsFeatureSource*sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = sipCpp->source;

    return sipConvertFromType(sipVal, sipType_QgsFeatureSource, SIP_NULLPTR);
}


extern "C" {static int varset_QgsKernelDensityEstimation_Parameters_source(void *, PyObject *, PyObject *);}
static int varset_QgsKernelDensityEstimation_Parameters_source(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::QgsFeatureSource*sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::QgsFeatureSource *>(sipForceConvertToType(sipPy, sipType_QgsFeatureSource, SIP_NULLPTR, 0, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->source = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsKernelDensityEstimation_Parameters_weightField(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsKernelDensityEstimation_Parameters_weightField(void *sipSelf, PyObject *, PyObject *)
{
    ::QString*sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    sipVal = &sipCpp->weightField;

    return sipConvertFromType(sipVal, sipType_QString, SIP_NULLPTR);
}


extern "C" {static int varset_QgsKernelDensityEstimation_Parameters_weightField(void *, PyObject *, PyObject *);}
static int varset_QgsKernelDensityEstimation_Parameters_weightField(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::QString*sipVal;
    ::QgsKernelDensityEstimation::Parameters *sipCpp = reinterpret_cast< ::QgsKernelDensityEstimation::Parameters *>(sipSelf);

    int sipIsErr = 0;
    int sipValState;
    sipVal = reinterpret_cast< ::QString *>(sipForceConvertToType(sipPy, sipType_QString, SIP_NULLPTR, SIP_NOT_NONE, &sipValState, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->weightField = *sipVal;

    sipReleaseType(sipVal, sipType_QString, sipValState);

    return 0;
}

sipVariableDef variables_QgsKernelDensityEstimation_Parameters[] = {
    {InstanceVariable, sipName_decayRatio, (PyMethodDef *)varget_QgsKernelDensityEstimation_Parameters_decayRatio, (PyMethodDef *)varset_QgsKernelDensityEstimation_Parameters_decayRatio, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_outputValues, (PyMethodDef *)varget_QgsKernelDensityEstimation_Parameters_outputValues, (PyMethodDef *)varset_QgsKernelDensityEstimation_Parameters_outputValues, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_pixelSize, (PyMethodDef *)varget_QgsKernelDensityEstimation_Parameters_pixelSize, (PyMethodDef *)varset_QgsKernelDensityEstimation_Parameters_pixelSize, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_radius, (PyMethodDef *)varget_QgsKernelDensityEstimation_Parameters_radius, (PyMethodDef *)varset_QgsKernelDensityEstimation_Parameters_radius, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_radiusField, (PyMethodDef *)varget_QgsKernelDensityEstimation_Parameters_radiusField, (PyMethodDef *)varset_QgsKernelDensityEstimation_Parameters_radiusField, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_shape, (PyMethodDef *)varget_QgsKernelDensityEstimation_Parameters_shape, (PyMethodDef *)varset_QgsKernelDensityEstimation_Parameters_shape, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_source, (PyMethodDef *)varget_QgsKernelDensityEstimation_Parameters_source, (PyMethodDef *)varset_QgsKernelDensityEstimation_Parameters_source, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_weightField, (PyMethodDef *)varget_QgsKernelDensityEstimation_Parameters_weightField, (PyMethodDef *)varset_QgsKernelDensityEstimation_Parameters_weightField, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_QgsKernelDensityEstimation_Parameters, "\1QgsKernelDensityEstimation.Parameters()\n"
"QgsKernelDensityEstimation.Parameters(a0: QgsKernelDensityEstimation.Parameters)");


static pyqt5ClassPluginDef plugin_QgsKernelDensityEstimation_Parameters = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsKernelDensityEstimation_Parameters = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsKernelDensityEstimation__Parameters,
        SIP_NULLPTR,
        &plugin_QgsKernelDensityEstimation_Parameters,
    },
    {
        sipNameNr_Parameters,
        {63, 255, 0},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        8, variables_QgsKernelDensityEstimation_Parameters,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsKernelDensityEstimation_Parameters,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsKernelDensityEstimation_Parameters,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsKernelDensityEstimation_Parameters,
    assign_QgsKernelDensityEstimation_Parameters,
    array_QgsKernelDensityEstimation_Parameters,
    copy_QgsKernelDensityEstimation_Parameters,
    release_QgsKernelDensityEstimation_Parameters,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsKernelDensityEstimation_Parameters,
    sizeof (::QgsKernelDensityEstimation::Parameters),
};

#line 22 "auto_generated/raster/qgskde.sip"
#include "qgskde.h"
#line 1618 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"

#line 22 "auto_generated/raster/qgskde.sip"
#include "qgskde.h"
#line 1622 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 1625 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"
#line 28 "/build/qgis/src/build/python/core/auto_generated/qgsfeature.sip"
#include "qgsfeature.h"
#if (SIP_VERSION >= 0x040900 && SIP_VERSION < 0x040c01)
#define sipType_QVariant ((sipWrapperType *) sipTypeAsPyTypeObject (sipType_QVariant))
#endif
#line 1631 "/build/qgis/src/build/python/analysis/build/_analysis/sip_analysispart10.cpp"


PyDoc_STRVAR(doc_QgsKernelDensityEstimation_run, "run(self) -> QgsKernelDensityEstimation.Result\n"
"Runs the KDE calculation across the whole layer at once. Either call\n"
"this method, or manually call\n"
":py:func:`~QgsKernelDensityEstimation.run`,\n"
":py:func:`~QgsKernelDensityEstimation.addFeature` and\n"
":py:func:`~QgsKernelDensityEstimation.finalise` separately.");

extern "C" {static PyObject *meth_QgsKernelDensityEstimation_run(PyObject *, PyObject *);}
static PyObject *meth_QgsKernelDensityEstimation_run(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsKernelDensityEstimation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsKernelDensityEstimation, &sipCpp))
        {
            ::QgsKernelDensityEstimation::Result sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->run();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QgsKernelDensityEstimation_Result);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsKernelDensityEstimation, sipName_run, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsKernelDensityEstimation_prepare, "prepare(self) -> QgsKernelDensityEstimation.Result\n"
"Prepares the output file for writing and setups up the surface\n"
"calculation. This must be called before adding features via\n"
":py:func:`~QgsKernelDensityEstimation.addFeature`.\n"
"\n"
".. seealso:: :py:func:`addFeature`\n"
"\n"
".. seealso:: :py:func:`finalise`");

extern "C" {static PyObject *meth_QgsKernelDensityEstimation_prepare(PyObject *, PyObject *);}
static PyObject *meth_QgsKernelDensityEstimation_prepare(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsKernelDensityEstimation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsKernelDensityEstimation, &sipCpp))
        {
            ::QgsKernelDensityEstimation::Result sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->prepare();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QgsKernelDensityEstimation_Result);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsKernelDensityEstimation, sipName_prepare, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsKernelDensityEstimation_addFeature, "addFeature(self, feature: QgsFeature) -> QgsKernelDensityEstimation.Result\n"
"Adds a single feature to the KDE surface.\n"
":py:func:`~QgsKernelDensityEstimation.prepare` must be called before\n"
"adding features.\n"
"\n"
".. seealso:: :py:func:`prepare`\n"
"\n"
".. seealso:: :py:func:`finalise`");

extern "C" {static PyObject *meth_QgsKernelDensityEstimation_addFeature(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsKernelDensityEstimation_addFeature(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsFeature* a0;
        ::QgsKernelDensityEstimation *sipCpp;

        static const char *sipKwdList[] = {
            sipName_feature,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsKernelDensityEstimation, &sipCpp, sipType_QgsFeature, &a0))
        {
            ::QgsKernelDensityEstimation::Result sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->addFeature(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QgsKernelDensityEstimation_Result);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsKernelDensityEstimation, sipName_addFeature, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsKernelDensityEstimation_finalise, "finalise(self) -> QgsKernelDensityEstimation.Result\n"
"Finalises the output file. Must be called after adding all features via\n"
":py:func:`~QgsKernelDensityEstimation.addFeature`.\n"
"\n"
".. seealso:: :py:func:`prepare`\n"
"\n"
".. seealso:: :py:func:`addFeature`");

extern "C" {static PyObject *meth_QgsKernelDensityEstimation_finalise(PyObject *, PyObject *);}
static PyObject *meth_QgsKernelDensityEstimation_finalise(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsKernelDensityEstimation *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsKernelDensityEstimation, &sipCpp))
        {
            ::QgsKernelDensityEstimation::Result sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->finalise();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QgsKernelDensityEstimation_Result);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsKernelDensityEstimation, sipName_finalise, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsKernelDensityEstimation(void *, int);}
static void release_QgsKernelDensityEstimation(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsKernelDensityEstimation *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsKernelDensityEstimation(sipSimpleWrapper *);}
static void dealloc_QgsKernelDensityEstimation(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsKernelDensityEstimation(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsKernelDensityEstimation(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsKernelDensityEstimation(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsKernelDensityEstimation *sipCpp = SIP_NULLPTR;

    {
        const ::QgsKernelDensityEstimation::Parameters* a0;
        const ::QString* a1;
        int a1State = 0;
        const ::QString* a2;
        int a2State = 0;

        static const char *sipKwdList[] = {
            sipName_parameters,
            sipName_outputFile,
            sipName_outputFormat,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J1J1", sipType_QgsKernelDensityEstimation_Parameters, &a0, sipType_QString, &a1, &a1State, sipType_QString, &a2, &a2State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsKernelDensityEstimation(*a0, *a1, *a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsKernelDensityEstimation[] = {
    {sipName_addFeature, SIP_MLMETH_CAST(meth_QgsKernelDensityEstimation_addFeature), METH_VARARGS|METH_KEYWORDS, doc_QgsKernelDensityEstimation_addFeature},
    {sipName_finalise, meth_QgsKernelDensityEstimation_finalise, METH_VARARGS, doc_QgsKernelDensityEstimation_finalise},
    {sipName_prepare, meth_QgsKernelDensityEstimation_prepare, METH_VARARGS, doc_QgsKernelDensityEstimation_prepare},
    {sipName_run, meth_QgsKernelDensityEstimation_run, METH_VARARGS, doc_QgsKernelDensityEstimation_run}
};

static sipEnumMemberDef enummembers_QgsKernelDensityEstimation[] = {
    {sipName_DriverError, static_cast<int>(::QgsKernelDensityEstimation::Result::DriverError), 67},
    {sipName_Epanechnikov, static_cast<int>(::QgsKernelDensityEstimation::KernelShape::Epanechnikov), 64},
    {sipName_FileCreationError, static_cast<int>(::QgsKernelDensityEstimation::Result::FileCreationError), 67},
    {sipName_InvalidParameters, static_cast<int>(::QgsKernelDensityEstimation::Result::InvalidParameters), 67},
    {sipName_Quartic, static_cast<int>(::QgsKernelDensityEstimation::KernelShape::Quartic), 64},
    {sipName_RasterIoError, static_cast<int>(::QgsKernelDensityEstimation::Result::RasterIoError), 67},
    {sipName_Raw, static_cast<int>(::QgsKernelDensityEstimation::OutputValues::Raw), 65},
    {sipName_Scaled, static_cast<int>(::QgsKernelDensityEstimation::OutputValues::Scaled), 65},
    {sipName_Success, static_cast<int>(::QgsKernelDensityEstimation::Result::Success), 67},
    {sipName_Triangular, static_cast<int>(::QgsKernelDensityEstimation::KernelShape::Triangular), 64},
    {sipName_Triweight, static_cast<int>(::QgsKernelDensityEstimation::KernelShape::Triweight), 64},
    {sipName_Uniform, static_cast<int>(::QgsKernelDensityEstimation::KernelShape::Uniform), 64},
};

PyDoc_STRVAR(doc_QgsKernelDensityEstimation, "Performs Kernel Density Estimation (\"heatmap\") calculations on a vector\n"
"layer.\n"
"\n"
"QgsKernelDensityEstimation(parameters: QgsKernelDensityEstimation.Parameters, outputFile: Optional[str], outputFormat: Optional[str])\n"
"Constructor for QgsKernelDensityEstimation. Requires a Parameters object\n"
"specifying the options to use to generate the surface. The output path\n"
"and file format are also required.");


static pyqt5ClassPluginDef plugin_QgsKernelDensityEstimation = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__analysis_QgsKernelDensityEstimation = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsKernelDensityEstimation,
        SIP_NULLPTR,
        &plugin_QgsKernelDensityEstimation,
    },
    {
        sipNameNr_QgsKernelDensityEstimation,
        {0, 0, 1},
        4, methods_QgsKernelDensityEstimation,
        12, enummembers_QgsKernelDensityEstimation,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsKernelDensityEstimation,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsKernelDensityEstimation,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsKernelDensityEstimation,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsKernelDensityEstimation,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsKernelDensityEstimation),
};
