/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtOpenGL.h"

#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtOpenGL/qopenglframebufferobject.sip"
#include <qopenglframebufferobject.h>
#line 29 "/build/pyqt6/src/pyqt6-6.9.1/build/QtOpenGL/sipQtOpenGLQOpenGLFramebufferObject.cpp"

#line 30 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qsize.sip"
#include <qsize.h>
#line 33 "/build/pyqt6/src/pyqt6-6.9.1/build/QtOpenGL/sipQtOpenGLQOpenGLFramebufferObject.cpp"
#line 96 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtOpenGL/qopenglframebufferobject.sip"
#include <qopenglframebufferobject.h>
#line 36 "/build/pyqt6/src/pyqt6-6.9.1/build/QtOpenGL/sipQtOpenGLQOpenGLFramebufferObject.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 39 "/build/pyqt6/src/pyqt6-6.9.1/build/QtOpenGL/sipQtOpenGLQOpenGLFramebufferObject.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 42 "/build/pyqt6/src/pyqt6-6.9.1/build/QtOpenGL/sipQtOpenGLQOpenGLFramebufferObject.cpp"
#line 33 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtGui/qimage.sip"
#include <qimage.h>
#line 45 "/build/pyqt6/src/pyqt6-6.9.1/build/QtOpenGL/sipQtOpenGLQOpenGLFramebufferObject.cpp"
#line 890 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 48 "/build/pyqt6/src/pyqt6-6.9.1/build/QtOpenGL/sipQtOpenGLQOpenGLFramebufferObject.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtOpenGL/qopenglframebufferobject.sip"
// The defaults are different for desktop OpenGL and OpenGL/ES so pretend the
// latter is the former.
#if defined(QT_OPENGL_ES)
#undef  GL_RGBA8
#define GL_RGBA8        GL_RGBA
#endif
#line 56 "/build/pyqt6/src/pyqt6-6.9.1/build/QtOpenGL/sipQtOpenGLQOpenGLFramebufferObject.cpp"


class sipQOpenGLFramebufferObject : public ::QOpenGLFramebufferObject
{
public:
    sipQOpenGLFramebufferObject(const ::QSize&, ::GLenum);
    sipQOpenGLFramebufferObject(int, int, ::GLenum);
    sipQOpenGLFramebufferObject(const ::QSize&, ::QOpenGLFramebufferObject::Attachment, ::GLenum, ::GLenum);
    sipQOpenGLFramebufferObject(int, int, ::QOpenGLFramebufferObject::Attachment, ::GLenum, ::GLenum);
    sipQOpenGLFramebufferObject(const ::QSize&, const ::QOpenGLFramebufferObjectFormat&);
    sipQOpenGLFramebufferObject(int, int, const ::QOpenGLFramebufferObjectFormat&);
    ~sipQOpenGLFramebufferObject();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQOpenGLFramebufferObject(const sipQOpenGLFramebufferObject &);
    sipQOpenGLFramebufferObject &operator = (const sipQOpenGLFramebufferObject &);
};

sipQOpenGLFramebufferObject::sipQOpenGLFramebufferObject(const ::QSize& a0, ::GLenum a1): ::QOpenGLFramebufferObject(a0, a1), sipPySelf(SIP_NULLPTR)
{
}

sipQOpenGLFramebufferObject::sipQOpenGLFramebufferObject(int a0, int a1, ::GLenum a2): ::QOpenGLFramebufferObject(a0, a1, a2), sipPySelf(SIP_NULLPTR)
{
}

sipQOpenGLFramebufferObject::sipQOpenGLFramebufferObject(const ::QSize& a0, ::QOpenGLFramebufferObject::Attachment a1, ::GLenum a2, ::GLenum a3): ::QOpenGLFramebufferObject(a0, a1, a2, a3), sipPySelf(SIP_NULLPTR)
{
}

sipQOpenGLFramebufferObject::sipQOpenGLFramebufferObject(int a0, int a1, ::QOpenGLFramebufferObject::Attachment a2, ::GLenum a3, ::GLenum a4): ::QOpenGLFramebufferObject(a0, a1, a2, a3, a4), sipPySelf(SIP_NULLPTR)
{
}

sipQOpenGLFramebufferObject::sipQOpenGLFramebufferObject(const ::QSize& a0, const ::QOpenGLFramebufferObjectFormat& a1): ::QOpenGLFramebufferObject(a0, a1), sipPySelf(SIP_NULLPTR)
{
}

sipQOpenGLFramebufferObject::sipQOpenGLFramebufferObject(int a0, int a1, const ::QOpenGLFramebufferObjectFormat& a2): ::QOpenGLFramebufferObject(a0, a1, a2), sipPySelf(SIP_NULLPTR)
{
}

sipQOpenGLFramebufferObject::~sipQOpenGLFramebufferObject()
{
    sipInstanceDestroyedEx(&sipPySelf);
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_format, "format(self) -> QOpenGLFramebufferObjectFormat");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_format(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_format(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            ::QOpenGLFramebufferObjectFormat*sipRes;

            sipRes = new ::QOpenGLFramebufferObjectFormat(sipCpp->format());

            return sipConvertFromNewType(sipRes, sipType_QOpenGLFramebufferObjectFormat, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_format, doc_QOpenGLFramebufferObject_format);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_isValid(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_isValid, doc_QOpenGLFramebufferObject_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_isBound, "isBound(self) -> bool");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_isBound(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_isBound(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isBound();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_isBound, doc_QOpenGLFramebufferObject_isBound);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_bind, "bind(self) -> bool");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_bind(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_bind(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->bind();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_bind, doc_QOpenGLFramebufferObject_bind);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_release, "release(self) -> bool");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_release(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_release(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->release();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_release, doc_QOpenGLFramebufferObject_release);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_width, "width(self) -> int");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_width(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_width(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->width();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_width, doc_QOpenGLFramebufferObject_width);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_height, "height(self) -> int");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_height(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_height(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->height();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_height, doc_QOpenGLFramebufferObject_height);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_texture, "texture(self) -> int");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_texture(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_texture(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->texture();

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_texture, doc_QOpenGLFramebufferObject_texture);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_textures, "textures(self) -> list[int]");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_textures(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_textures(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            ::QList<uint>*sipRes;

            sipRes = new ::QList<uint>(sipCpp->textures());

            return sipConvertFromNewType(sipRes, sipType_QList_1900, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_textures, doc_QOpenGLFramebufferObject_textures);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_size, "size(self) -> QSize");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_size(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            ::QSize*sipRes;

            sipRes = new ::QSize(sipCpp->size());

            return sipConvertFromNewType(sipRes, sipType_QSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_size, doc_QOpenGLFramebufferObject_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_toImage, "toImage(self, flipped: bool = True) -> QImage\n"
"toImage(self, flipped: bool, colorAttachmentIndex: int) -> QImage");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_toImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_toImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0 = 1;
        const ::QOpenGLFramebufferObject *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flipped,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp, &a0))
        {
            ::QImage*sipRes;

            sipRes = new ::QImage(sipCpp->toImage(a0));

            return sipConvertFromNewType(sipRes, sipType_QImage, SIP_NULLPTR);
        }
    }

    {
        bool a0;
        int a1;
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "Bbi", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp, &a0, &a1))
        {
            ::QImage*sipRes;

            sipRes = new ::QImage(sipCpp->toImage(a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QImage, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_toImage, doc_QOpenGLFramebufferObject_toImage);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_attachment, "attachment(self) -> QOpenGLFramebufferObject.Attachment");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_attachment(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_attachment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            ::QOpenGLFramebufferObject::Attachment sipRes;

            sipRes = sipCpp->attachment();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QOpenGLFramebufferObject_Attachment);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_attachment, doc_QOpenGLFramebufferObject_attachment);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_setAttachment, "setAttachment(self, attachment: QOpenGLFramebufferObject.Attachment)");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_setAttachment(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_setAttachment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLFramebufferObject::Attachment a0;
        ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp, sipType_QOpenGLFramebufferObject_Attachment, &a0))
        {
            sipCpp->setAttachment(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_setAttachment, doc_QOpenGLFramebufferObject_setAttachment);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_handle, "handle(self) -> int");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_handle(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_handle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->handle();

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_handle, doc_QOpenGLFramebufferObject_handle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_bindDefault, "bindDefault() -> bool");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_bindDefault(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_bindDefault(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            bool sipRes;

            sipRes = ::QOpenGLFramebufferObject::bindDefault();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_bindDefault, doc_QOpenGLFramebufferObject_bindDefault);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_hasOpenGLFramebufferObjects, "hasOpenGLFramebufferObjects() -> bool");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_hasOpenGLFramebufferObjects(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_hasOpenGLFramebufferObjects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            bool sipRes;

            sipRes = ::QOpenGLFramebufferObject::hasOpenGLFramebufferObjects();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_hasOpenGLFramebufferObjects, doc_QOpenGLFramebufferObject_hasOpenGLFramebufferObjects);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_hasOpenGLFramebufferBlit, "hasOpenGLFramebufferBlit() -> bool");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_hasOpenGLFramebufferBlit(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_hasOpenGLFramebufferBlit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            bool sipRes;

            sipRes = ::QOpenGLFramebufferObject::hasOpenGLFramebufferBlit();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_hasOpenGLFramebufferBlit, doc_QOpenGLFramebufferObject_hasOpenGLFramebufferBlit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_blitFramebuffer, "blitFramebuffer(target: Optional[QOpenGLFramebufferObject], targetRect: QRect, source: Optional[QOpenGLFramebufferObject], sourceRect: QRect, buffers: int = GL_COLOR_BUFFER_BIT, filter: int = GL_NEAREST)\n"
"blitFramebuffer(target: Optional[QOpenGLFramebufferObject], source: Optional[QOpenGLFramebufferObject], buffers: int = GL_COLOR_BUFFER_BIT, filter: int = GL_NEAREST)\n"
"blitFramebuffer(target: Optional[QOpenGLFramebufferObject], targetRect: QRect, source: Optional[QOpenGLFramebufferObject], sourceRect: QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int)\n"
"blitFramebuffer(target: Optional[QOpenGLFramebufferObject], targetRect: QRect, source: Optional[QOpenGLFramebufferObject], sourceRect: QRect, buffers: int, filter: int, readColorAttachmentIndex: int, drawColorAttachmentIndex: int, restorePolicy: QOpenGLFramebufferObject.FramebufferRestorePolicy)");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_blitFramebuffer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_blitFramebuffer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLFramebufferObject* a0;
        const ::QRect* a1;
        ::QOpenGLFramebufferObject* a2;
        const ::QRect* a3;
        ::GLbitfield a4 = GL_COLOR_BUFFER_BIT;
        ::GLenum a5 = GL_NEAREST;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_buffers,
            sipName_filter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ8J9J8J9|uu", &sipSelf, sipType_QOpenGLFramebufferObject, &a0, sipType_QRect, &a1, sipType_QOpenGLFramebufferObject, &a2, sipType_QRect, &a3, &a4, &a5))
        {
            ::QOpenGLFramebufferObject::blitFramebuffer(a0, *a1, a2, *a3, a4, a5);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QOpenGLFramebufferObject* a0;
        ::QOpenGLFramebufferObject* a1;
        ::GLbitfield a2 = GL_COLOR_BUFFER_BIT;
        ::GLenum a3 = GL_NEAREST;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_buffers,
            sipName_filter,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ8J8|uu", &sipSelf, sipType_QOpenGLFramebufferObject, &a0, sipType_QOpenGLFramebufferObject, &a1, &a2, &a3))
        {
            ::QOpenGLFramebufferObject::blitFramebuffer(a0, a1, a2, a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QOpenGLFramebufferObject* a0;
        const ::QRect* a1;
        ::QOpenGLFramebufferObject* a2;
        const ::QRect* a3;
        ::GLbitfield a4;
        ::GLenum a5;
        int a6;
        int a7;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "CJ8J9J8J9uuii", &sipSelf, sipType_QOpenGLFramebufferObject, &a0, sipType_QRect, &a1, sipType_QOpenGLFramebufferObject, &a2, sipType_QRect, &a3, &a4, &a5, &a6, &a7))
        {
            ::QOpenGLFramebufferObject::blitFramebuffer(a0, *a1, a2, *a3, a4, a5, a6, a7);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QOpenGLFramebufferObject* a0;
        const ::QRect* a1;
        ::QOpenGLFramebufferObject* a2;
        const ::QRect* a3;
        ::GLbitfield a4;
        ::GLenum a5;
        int a6;
        int a7;
        ::QOpenGLFramebufferObject::FramebufferRestorePolicy a8;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "CJ8J9J8J9uuiiE", &sipSelf, sipType_QOpenGLFramebufferObject, &a0, sipType_QRect, &a1, sipType_QOpenGLFramebufferObject, &a2, sipType_QRect, &a3, &a4, &a5, &a6, &a7, sipType_QOpenGLFramebufferObject_FramebufferRestorePolicy, &a8))
        {
            ::QOpenGLFramebufferObject::blitFramebuffer(a0, *a1, a2, *a3, a4, a5, a6, a7, a8);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_blitFramebuffer, doc_QOpenGLFramebufferObject_blitFramebuffer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_takeTexture, "takeTexture(self) -> int\n"
"takeTexture(self, colorAttachmentIndex: int) -> int");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_takeTexture(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_takeTexture(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->takeTexture();

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    {
        int a0;
        ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp, &a0))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->takeTexture(a0);

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_takeTexture, doc_QOpenGLFramebufferObject_takeTexture);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_addColorAttachment, "addColorAttachment(self, size: QSize, internal_format: int = 0)\n"
"addColorAttachment(self, width: int, height: int, internal_format: int = 0)");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_addColorAttachment(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_addColorAttachment(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSize* a0;
        ::GLenum a1 = 0;
        ::QOpenGLFramebufferObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_internal_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|u", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp, sipType_QSize, &a0, &a1))
        {
            sipCpp->addColorAttachment(*a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        ::GLenum a2 = 0;
        ::QOpenGLFramebufferObject *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_internal_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|u", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp, &a0, &a1, &a2))
        {
            sipCpp->addColorAttachment(a0, a1, a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_addColorAttachment, doc_QOpenGLFramebufferObject_addColorAttachment);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QOpenGLFramebufferObject_sizes, "sizes(self) -> list[QSize]");

extern "C" {static PyObject *meth_QOpenGLFramebufferObject_sizes(PyObject *, PyObject *);}
static PyObject *meth_QOpenGLFramebufferObject_sizes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QOpenGLFramebufferObject *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QOpenGLFramebufferObject, &sipCpp))
        {
            QList< ::QSize>*sipRes;

            sipRes = new QList< ::QSize>(sipCpp->sizes());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QOpenGLFramebufferObject, sipName_sizes, doc_QOpenGLFramebufferObject_sizes);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QOpenGLFramebufferObject(void *, int);}
static void release_QOpenGLFramebufferObject(void *sipCppV, int sipState)
{
    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQOpenGLFramebufferObject *>(sipCppV);
    else
        delete reinterpret_cast< ::QOpenGLFramebufferObject *>(sipCppV);
}


extern "C" {static void dealloc_QOpenGLFramebufferObject(sipSimpleWrapper *);}
static void dealloc_QOpenGLFramebufferObject(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQOpenGLFramebufferObject *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QOpenGLFramebufferObject(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QOpenGLFramebufferObject(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QOpenGLFramebufferObject(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQOpenGLFramebufferObject *sipCpp = SIP_NULLPTR;

    {
        const ::QSize* a0;
        ::GLenum a1 = GL_TEXTURE_2D;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_target,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9|u", sipType_QSize, &a0, &a1))
        {
            sipCpp = new sipQOpenGLFramebufferObject(*a0, a1);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int a0;
        int a1;
        ::GLenum a2 = GL_TEXTURE_2D;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_target,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "ii|u", &a0, &a1, &a2))
        {
            sipCpp = new sipQOpenGLFramebufferObject(a0, a1, a2);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::QSize* a0;
        ::QOpenGLFramebufferObject::Attachment a1;
        ::GLenum a2 = GL_TEXTURE_2D;
        ::GLenum a3 = GL_RGBA8;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_target,
            sipName_internal_format,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9E|uu", sipType_QSize, &a0, sipType_QOpenGLFramebufferObject_Attachment, &a1, &a2, &a3))
        {
            sipCpp = new sipQOpenGLFramebufferObject(*a0, a1, a2, a3);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int a0;
        int a1;
        ::QOpenGLFramebufferObject::Attachment a2;
        ::GLenum a3 = GL_TEXTURE_2D;
        ::GLenum a4 = GL_RGBA8;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_target,
            sipName_internal_format,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiE|uu", &a0, &a1, sipType_QOpenGLFramebufferObject_Attachment, &a2, &a3, &a4))
        {
            sipCpp = new sipQOpenGLFramebufferObject(a0, a1, a2, a3, a4);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::QSize* a0;
        const ::QOpenGLFramebufferObjectFormat* a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J9", sipType_QSize, &a0, sipType_QOpenGLFramebufferObjectFormat, &a1))
        {
            sipCpp = new sipQOpenGLFramebufferObject(*a0, *a1);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        int a0;
        int a1;
        const ::QOpenGLFramebufferObjectFormat* a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "iiJ9", &a0, &a1, sipType_QOpenGLFramebufferObjectFormat, &a2))
        {
            sipCpp = new sipQOpenGLFramebufferObject(a0, a1, *a2);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QOpenGLFramebufferObject[] = {
    {sipName_addColorAttachment, SIP_MLMETH_CAST(meth_QOpenGLFramebufferObject_addColorAttachment), METH_VARARGS|METH_KEYWORDS, doc_QOpenGLFramebufferObject_addColorAttachment},
    {sipName_attachment, meth_QOpenGLFramebufferObject_attachment, METH_VARARGS, doc_QOpenGLFramebufferObject_attachment},
    {sipName_bind, meth_QOpenGLFramebufferObject_bind, METH_VARARGS, doc_QOpenGLFramebufferObject_bind},
    {sipName_bindDefault, meth_QOpenGLFramebufferObject_bindDefault, METH_VARARGS, doc_QOpenGLFramebufferObject_bindDefault},
    {sipName_blitFramebuffer, SIP_MLMETH_CAST(meth_QOpenGLFramebufferObject_blitFramebuffer), METH_VARARGS|METH_KEYWORDS, doc_QOpenGLFramebufferObject_blitFramebuffer},
    {sipName_format, meth_QOpenGLFramebufferObject_format, METH_VARARGS, doc_QOpenGLFramebufferObject_format},
    {sipName_handle, meth_QOpenGLFramebufferObject_handle, METH_VARARGS, doc_QOpenGLFramebufferObject_handle},
    {sipName_hasOpenGLFramebufferBlit, meth_QOpenGLFramebufferObject_hasOpenGLFramebufferBlit, METH_VARARGS, doc_QOpenGLFramebufferObject_hasOpenGLFramebufferBlit},
    {sipName_hasOpenGLFramebufferObjects, meth_QOpenGLFramebufferObject_hasOpenGLFramebufferObjects, METH_VARARGS, doc_QOpenGLFramebufferObject_hasOpenGLFramebufferObjects},
    {sipName_height, meth_QOpenGLFramebufferObject_height, METH_VARARGS, doc_QOpenGLFramebufferObject_height},
    {sipName_isBound, meth_QOpenGLFramebufferObject_isBound, METH_VARARGS, doc_QOpenGLFramebufferObject_isBound},
    {sipName_isValid, meth_QOpenGLFramebufferObject_isValid, METH_VARARGS, doc_QOpenGLFramebufferObject_isValid},
    {sipName_release, meth_QOpenGLFramebufferObject_release, METH_VARARGS, doc_QOpenGLFramebufferObject_release},
    {sipName_setAttachment, meth_QOpenGLFramebufferObject_setAttachment, METH_VARARGS, doc_QOpenGLFramebufferObject_setAttachment},
    {sipName_size, meth_QOpenGLFramebufferObject_size, METH_VARARGS, doc_QOpenGLFramebufferObject_size},
    {sipName_sizes, meth_QOpenGLFramebufferObject_sizes, METH_VARARGS, doc_QOpenGLFramebufferObject_sizes},
    {sipName_takeTexture, meth_QOpenGLFramebufferObject_takeTexture, METH_VARARGS, doc_QOpenGLFramebufferObject_takeTexture},
    {sipName_texture, meth_QOpenGLFramebufferObject_texture, METH_VARARGS, doc_QOpenGLFramebufferObject_texture},
    {sipName_textures, meth_QOpenGLFramebufferObject_textures, METH_VARARGS, doc_QOpenGLFramebufferObject_textures},
    {sipName_toImage, SIP_MLMETH_CAST(meth_QOpenGLFramebufferObject_toImage), METH_VARARGS|METH_KEYWORDS, doc_QOpenGLFramebufferObject_toImage},
    {sipName_width, meth_QOpenGLFramebufferObject_width, METH_VARARGS, doc_QOpenGLFramebufferObject_width}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QOpenGLFramebufferObject[] = {
    {sipName_NoAttachment, static_cast<int>(::QOpenGLFramebufferObject::NoAttachment)},
    {sipName_CombinedDepthStencil, static_cast<int>(::QOpenGLFramebufferObject::CombinedDepthStencil)},
    {sipName_Depth, static_cast<int>(::QOpenGLFramebufferObject::Depth)},
    {sipName_DontRestoreFramebufferBinding, static_cast<int>(::QOpenGLFramebufferObject::DontRestoreFramebufferBinding)},
    {sipName_RestoreFramebufferBindingToDefault, static_cast<int>(::QOpenGLFramebufferObject::RestoreFramebufferBindingToDefault)},
    {sipName_RestoreFrameBufferBinding, static_cast<int>(::QOpenGLFramebufferObject::RestoreFrameBufferBinding)},
    {0, 0}
};

PyDoc_STRVAR(doc_QOpenGLFramebufferObject, "\1QOpenGLFramebufferObject(size: QSize, target: int = GL_TEXTURE_2D)\n"
"QOpenGLFramebufferObject(width: int, height: int, target: int = GL_TEXTURE_2D)\n"
"QOpenGLFramebufferObject(size: QSize, attachment: QOpenGLFramebufferObject.Attachment, target: int = GL_TEXTURE_2D, internal_format: int = GL_RGBA8)\n"
"QOpenGLFramebufferObject(width: int, height: int, attachment: QOpenGLFramebufferObject.Attachment, target: int = GL_TEXTURE_2D, internal_format: int = GL_RGBA8)\n"
"QOpenGLFramebufferObject(size: QSize, format: QOpenGLFramebufferObjectFormat)\n"
"QOpenGLFramebufferObject(width: int, height: int, format: QOpenGLFramebufferObjectFormat)");


sipClassTypeDef sipTypeDef_QtOpenGL_QOpenGLFramebufferObject = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QOpenGLFramebufferObject,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QOpenGLFramebufferObject,
        {0, 0, 1},
        21, methods_QOpenGLFramebufferObject,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QOpenGLFramebufferObject, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QOpenGLFramebufferObject,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QOpenGLFramebufferObject,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QOpenGLFramebufferObject,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QOpenGLFramebufferObject,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QOpenGLFramebufferObject),
};
