/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtBluetooth.h"

#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qlowenergycontroller.sip"
#include <qlowenergycontroller.h>
#line 29 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"

#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qbluetoothdeviceinfo.sip"
#include <qbluetoothdeviceinfo.h>
#line 33 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qbluetoothaddress.sip"
#include <qbluetoothaddress.h>
#line 36 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qobject.sip"
#include <qobject.h>
#line 39 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qbluetoothuuid.sip"
#include <qbluetoothuuid.h>
#line 42 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qlowenergyconnectionparameters.sip"
#include <qlowenergyconnectionparameters.h>
#line 45 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qlowenergyservice.sip"
#include <qlowenergyservice.h>
#line 48 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qlowenergyservicedata.sip"
#include <qlowenergyservicedata.h>
#line 51 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qlowenergyadvertisingparameters.sip"
#include <qlowenergyadvertisingparameters.h>
#line 54 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtBluetooth/qlowenergyadvertisingdata.sip"
#include <qlowenergyadvertisingdata.h>
#line 57 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 60 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 63 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 154 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 68 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 71 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 74 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 277 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 77 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 254 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 80 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 83 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 86 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 89 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 135 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 92 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 150 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qtextstream.sip"
#include <qtextstream.h>
#line 97 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qthread.sip"
#include <qthread.h>
#line 100 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qanystringview.sip"
#include <qanystringview.h>
#line 103 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 25 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qflags.sip"
#include <qglobal.h>
#line 106 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qregularexpression.sip"
#include <qregularexpression.h>
#line 109 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 112 "/build/pyqt6/src/pyqt6-6.9.1/build/QtBluetooth/sipQtBluetoothQLowEnergyController.cpp"


PyDoc_STRVAR(doc_QLowEnergyController_localAddress, "localAddress(self) -> QBluetoothAddress");

extern "C" {static PyObject *meth_QLowEnergyController_localAddress(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_localAddress(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            ::QBluetoothAddress*sipRes;

            sipRes = new ::QBluetoothAddress(sipCpp->localAddress());

            return sipConvertFromNewType(sipRes, sipType_QBluetoothAddress, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_localAddress, doc_QLowEnergyController_localAddress);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_remoteAddress, "remoteAddress(self) -> QBluetoothAddress");

extern "C" {static PyObject *meth_QLowEnergyController_remoteAddress(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_remoteAddress(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            ::QBluetoothAddress*sipRes;

            sipRes = new ::QBluetoothAddress(sipCpp->remoteAddress());

            return sipConvertFromNewType(sipRes, sipType_QBluetoothAddress, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_remoteAddress, doc_QLowEnergyController_remoteAddress);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_state, "state(self) -> QLowEnergyController.ControllerState");

extern "C" {static PyObject *meth_QLowEnergyController_state(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_state(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            ::QLowEnergyController::ControllerState sipRes;

            sipRes = sipCpp->state();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QLowEnergyController_ControllerState);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_state, doc_QLowEnergyController_state);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_remoteAddressType, "remoteAddressType(self) -> QLowEnergyController.RemoteAddressType");

extern "C" {static PyObject *meth_QLowEnergyController_remoteAddressType(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_remoteAddressType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            ::QLowEnergyController::RemoteAddressType sipRes;

            sipRes = sipCpp->remoteAddressType();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QLowEnergyController_RemoteAddressType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_remoteAddressType, doc_QLowEnergyController_remoteAddressType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_setRemoteAddressType, "setRemoteAddressType(self, type: QLowEnergyController.RemoteAddressType)");

extern "C" {static PyObject *meth_QLowEnergyController_setRemoteAddressType(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_setRemoteAddressType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLowEnergyController::RemoteAddressType a0;
        ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QLowEnergyController, &sipCpp, sipType_QLowEnergyController_RemoteAddressType, &a0))
        {
            sipCpp->setRemoteAddressType(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_setRemoteAddressType, doc_QLowEnergyController_setRemoteAddressType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_connectToDevice, "connectToDevice(self)");

extern "C" {static PyObject *meth_QLowEnergyController_connectToDevice(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_connectToDevice(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            sipCpp->connectToDevice();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_connectToDevice, doc_QLowEnergyController_connectToDevice);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_disconnectFromDevice, "disconnectFromDevice(self)");

extern "C" {static PyObject *meth_QLowEnergyController_disconnectFromDevice(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_disconnectFromDevice(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            sipCpp->disconnectFromDevice();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_disconnectFromDevice, doc_QLowEnergyController_disconnectFromDevice);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_discoverServices, "discoverServices(self)");

extern "C" {static PyObject *meth_QLowEnergyController_discoverServices(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_discoverServices(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            sipCpp->discoverServices();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_discoverServices, doc_QLowEnergyController_discoverServices);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_services, "services(self) -> list[QBluetoothUuid]");

extern "C" {static PyObject *meth_QLowEnergyController_services(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_services(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            QList< ::QBluetoothUuid>*sipRes;

            sipRes = new QList< ::QBluetoothUuid>(sipCpp->services());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QBluetoothUuid, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_services, doc_QLowEnergyController_services);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_createServiceObject, "createServiceObject(self, service: QBluetoothUuid, parent: Optional[QObject] = None) -> Optional[QLowEnergyService]");

extern "C" {static PyObject *meth_QLowEnergyController_createServiceObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_createServiceObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid* a0;
        ::QObject* a1 = 0;
        sipWrapper *sipOwner = SIP_NULLPTR;
        ::QLowEnergyController *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_parent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|JH", &sipSelf, sipType_QLowEnergyController, &sipCpp, sipType_QBluetoothUuid, &a0, sipType_QObject, &a1, &sipOwner))
        {
            ::QLowEnergyService*sipRes;

            sipRes = sipCpp->createServiceObject(*a0, a1);

            return sipConvertFromNewType(sipRes, sipType_QLowEnergyService, (PyObject *)sipOwner);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_createServiceObject, doc_QLowEnergyController_createServiceObject);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_error, "error(self) -> QLowEnergyController.Error");

extern "C" {static PyObject *meth_QLowEnergyController_error(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_error(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            ::QLowEnergyController::Error sipRes;

            sipRes = sipCpp->error();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QLowEnergyController_Error);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_error, doc_QLowEnergyController_error);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_errorString, "errorString(self) -> str");

extern "C" {static PyObject *meth_QLowEnergyController_errorString(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_errorString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->errorString());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_errorString, doc_QLowEnergyController_errorString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_remoteName, "remoteName(self) -> str");

extern "C" {static PyObject *meth_QLowEnergyController_remoteName(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_remoteName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->remoteName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_remoteName, doc_QLowEnergyController_remoteName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_mtu, "mtu(self) -> int");

extern "C" {static PyObject *meth_QLowEnergyController_mtu(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_mtu(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->mtu();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_mtu, doc_QLowEnergyController_mtu);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_createCentral, "createCentral(remoteDevice: QBluetoothDeviceInfo, parent: Optional[QObject] = None) -> Optional[QLowEnergyController]\n"
"createCentral(remoteDevice: QBluetoothDeviceInfo, localDevice: QBluetoothAddress, parent: Optional[QObject] = None) -> Optional[QLowEnergyController]");

extern "C" {static PyObject *meth_QLowEnergyController_createCentral(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_createCentral(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo* a0;
        ::QObject* a1 = 0;
        sipWrapper *sipOwner = SIP_NULLPTR;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_parent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ9|JH", &sipSelf, sipType_QBluetoothDeviceInfo, &a0, sipType_QObject, &a1, &sipOwner))
        {
            ::QLowEnergyController*sipRes;

            sipRes = ::QLowEnergyController::createCentral(*a0, a1);

            return sipConvertFromNewType(sipRes, sipType_QLowEnergyController, (PyObject *)sipOwner);
        }
    }

    {
        const ::QBluetoothDeviceInfo* a0;
        const ::QBluetoothAddress* a1;
        ::QObject* a2 = 0;
        sipWrapper *sipOwner = SIP_NULLPTR;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_parent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ9J9|JH", &sipSelf, sipType_QBluetoothDeviceInfo, &a0, sipType_QBluetoothAddress, &a1, sipType_QObject, &a2, &sipOwner))
        {
            ::QLowEnergyController*sipRes;

            sipRes = ::QLowEnergyController::createCentral(*a0, *a1, a2);

            return sipConvertFromNewType(sipRes, sipType_QLowEnergyController, (PyObject *)sipOwner);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_createCentral, doc_QLowEnergyController_createCentral);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_createPeripheral, "createPeripheral(localDevice: QBluetoothAddress, parent: Optional[QObject] = None) -> Optional[QLowEnergyController]\n"
"createPeripheral(parent: Optional[QObject] = None) -> Optional[QLowEnergyController]");

extern "C" {static PyObject *meth_QLowEnergyController_createPeripheral(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_createPeripheral(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothAddress* a0;
        ::QObject* a1 = 0;
        sipWrapper *sipOwner = SIP_NULLPTR;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_parent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "CJ9|JH", &sipSelf, sipType_QBluetoothAddress, &a0, sipType_QObject, &a1, &sipOwner))
        {
            ::QLowEnergyController*sipRes;

            sipRes = ::QLowEnergyController::createPeripheral(*a0, a1);

            return sipConvertFromNewType(sipRes, sipType_QLowEnergyController, (PyObject *)sipOwner);
        }
    }

    {
        ::QObject* a0 = 0;
        sipWrapper *sipOwner = SIP_NULLPTR;

        static const char *sipKwdList[] = {
            sipName_parent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "C|JH", &sipSelf, sipType_QObject, &a0, &sipOwner))
        {
            ::QLowEnergyController*sipRes;

            sipRes = ::QLowEnergyController::createPeripheral(a0);

            return sipConvertFromNewType(sipRes, sipType_QLowEnergyController, (PyObject *)sipOwner);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_createPeripheral, doc_QLowEnergyController_createPeripheral);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_startAdvertising, "startAdvertising(self, parameters: QLowEnergyAdvertisingParameters, advertisingData: QLowEnergyAdvertisingData, scanResponseData: QLowEnergyAdvertisingData = QLowEnergyAdvertisingData())");

extern "C" {static PyObject *meth_QLowEnergyController_startAdvertising(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_startAdvertising(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyAdvertisingParameters* a0;
        const ::QLowEnergyAdvertisingData* a1;
        const ::QLowEnergyAdvertisingData& a2def = QLowEnergyAdvertisingData();
        const ::QLowEnergyAdvertisingData* a2 = &a2def;
        ::QLowEnergyController *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_scanResponseData,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9|J9", &sipSelf, sipType_QLowEnergyController, &sipCpp, sipType_QLowEnergyAdvertisingParameters, &a0, sipType_QLowEnergyAdvertisingData, &a1, sipType_QLowEnergyAdvertisingData, &a2))
        {
            sipCpp->startAdvertising(*a0, *a1, *a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_startAdvertising, doc_QLowEnergyController_startAdvertising);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_stopAdvertising, "stopAdvertising(self)");

extern "C" {static PyObject *meth_QLowEnergyController_stopAdvertising(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_stopAdvertising(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            sipCpp->stopAdvertising();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_stopAdvertising, doc_QLowEnergyController_stopAdvertising);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_addService, "addService(self, service: QLowEnergyServiceData, parent: Optional[QObject] = None) -> Optional[QLowEnergyService]");

extern "C" {static PyObject *meth_QLowEnergyController_addService(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_addService(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyServiceData* a0;
        ::QObject* a1 = 0;
        sipWrapper *sipOwner = SIP_NULLPTR;
        ::QLowEnergyController *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_parent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|JH", &sipSelf, sipType_QLowEnergyController, &sipCpp, sipType_QLowEnergyServiceData, &a0, sipType_QObject, &a1, &sipOwner))
        {
            ::QLowEnergyService*sipRes;

            sipRes = sipCpp->addService(*a0, a1);

            return sipConvertFromNewType(sipRes, sipType_QLowEnergyService, (PyObject *)sipOwner);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_addService, doc_QLowEnergyController_addService);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_requestConnectionUpdate, "requestConnectionUpdate(self, parameters: QLowEnergyConnectionParameters)");

extern "C" {static PyObject *meth_QLowEnergyController_requestConnectionUpdate(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_requestConnectionUpdate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyConnectionParameters* a0;
        ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QLowEnergyController, &sipCpp, sipType_QLowEnergyConnectionParameters, &a0))
        {
            sipCpp->requestConnectionUpdate(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_requestConnectionUpdate, doc_QLowEnergyController_requestConnectionUpdate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_role, "role(self) -> QLowEnergyController.Role");

extern "C" {static PyObject *meth_QLowEnergyController_role(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_role(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            ::QLowEnergyController::Role sipRes;

            sipRes = sipCpp->role();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QLowEnergyController_Role);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_role, doc_QLowEnergyController_role);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_remoteDeviceUuid, "remoteDeviceUuid(self) -> QBluetoothUuid");

extern "C" {static PyObject *meth_QLowEnergyController_remoteDeviceUuid(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_remoteDeviceUuid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            ::QBluetoothUuid*sipRes;

            sipRes = new ::QBluetoothUuid(sipCpp->remoteDeviceUuid());

            return sipConvertFromNewType(sipRes, sipType_QBluetoothUuid, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_remoteDeviceUuid, doc_QLowEnergyController_remoteDeviceUuid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QLowEnergyController_readRssi, "readRssi(self)");

extern "C" {static PyObject *meth_QLowEnergyController_readRssi(PyObject *, PyObject *);}
static PyObject *meth_QLowEnergyController_readRssi(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QLowEnergyController *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QLowEnergyController, &sipCpp))
        {
            sipCpp->readRssi();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QLowEnergyController, sipName_readRssi, doc_QLowEnergyController_readRssi);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QLowEnergyController(void *, const sipTypeDef *);}
static void *cast_QLowEnergyController(void *sipCppV, const sipTypeDef *targetType)
{
    ::QLowEnergyController *sipCpp = reinterpret_cast< ::QLowEnergyController *>(sipCppV);

    if (targetType == sipType_QLowEnergyController)
        return sipCppV;

    if (targetType == sipType_QObject)
        return static_cast< ::QObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QLowEnergyController(void *, int);}
static void release_QLowEnergyController(void *sipCppV, int)
{
    ::QLowEnergyController *sipCpp = reinterpret_cast< ::QLowEnergyController *>(sipCppV);

    if (QThread::currentThread() == sipCpp->thread())
        delete sipCpp;
    else
        sipCpp->deleteLater();
}


extern "C" {static void dealloc_QLowEnergyController(sipSimpleWrapper *);}
static void dealloc_QLowEnergyController(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QLowEnergyController(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QLowEnergyController[] = {{9, 0, 1}};


static PyMethodDef methods_QLowEnergyController[] = {
    {sipName_addService, SIP_MLMETH_CAST(meth_QLowEnergyController_addService), METH_VARARGS|METH_KEYWORDS, doc_QLowEnergyController_addService},
    {sipName_connectToDevice, meth_QLowEnergyController_connectToDevice, METH_VARARGS, doc_QLowEnergyController_connectToDevice},
    {sipName_createCentral, SIP_MLMETH_CAST(meth_QLowEnergyController_createCentral), METH_VARARGS|METH_KEYWORDS, doc_QLowEnergyController_createCentral},
    {sipName_createPeripheral, SIP_MLMETH_CAST(meth_QLowEnergyController_createPeripheral), METH_VARARGS|METH_KEYWORDS, doc_QLowEnergyController_createPeripheral},
    {sipName_createServiceObject, SIP_MLMETH_CAST(meth_QLowEnergyController_createServiceObject), METH_VARARGS|METH_KEYWORDS, doc_QLowEnergyController_createServiceObject},
    {sipName_disconnectFromDevice, meth_QLowEnergyController_disconnectFromDevice, METH_VARARGS, doc_QLowEnergyController_disconnectFromDevice},
    {sipName_discoverServices, meth_QLowEnergyController_discoverServices, METH_VARARGS, doc_QLowEnergyController_discoverServices},
    {sipName_error, meth_QLowEnergyController_error, METH_VARARGS, doc_QLowEnergyController_error},
    {sipName_errorString, meth_QLowEnergyController_errorString, METH_VARARGS, doc_QLowEnergyController_errorString},
    {sipName_localAddress, meth_QLowEnergyController_localAddress, METH_VARARGS, doc_QLowEnergyController_localAddress},
    {sipName_mtu, meth_QLowEnergyController_mtu, METH_VARARGS, doc_QLowEnergyController_mtu},
    {sipName_readRssi, meth_QLowEnergyController_readRssi, METH_VARARGS, doc_QLowEnergyController_readRssi},
    {sipName_remoteAddress, meth_QLowEnergyController_remoteAddress, METH_VARARGS, doc_QLowEnergyController_remoteAddress},
    {sipName_remoteAddressType, meth_QLowEnergyController_remoteAddressType, METH_VARARGS, doc_QLowEnergyController_remoteAddressType},
    {sipName_remoteDeviceUuid, meth_QLowEnergyController_remoteDeviceUuid, METH_VARARGS, doc_QLowEnergyController_remoteDeviceUuid},
    {sipName_remoteName, meth_QLowEnergyController_remoteName, METH_VARARGS, doc_QLowEnergyController_remoteName},
    {sipName_requestConnectionUpdate, meth_QLowEnergyController_requestConnectionUpdate, METH_VARARGS, doc_QLowEnergyController_requestConnectionUpdate},
    {sipName_role, meth_QLowEnergyController_role, METH_VARARGS, doc_QLowEnergyController_role},
    {sipName_services, meth_QLowEnergyController_services, METH_VARARGS, doc_QLowEnergyController_services},
    {sipName_setRemoteAddressType, meth_QLowEnergyController_setRemoteAddressType, METH_VARARGS, doc_QLowEnergyController_setRemoteAddressType},
    {sipName_startAdvertising, SIP_MLMETH_CAST(meth_QLowEnergyController_startAdvertising), METH_VARARGS|METH_KEYWORDS, doc_QLowEnergyController_startAdvertising},
    {sipName_state, meth_QLowEnergyController_state, METH_VARARGS, doc_QLowEnergyController_state},
    {sipName_stopAdvertising, meth_QLowEnergyController_stopAdvertising, METH_VARARGS, doc_QLowEnergyController_stopAdvertising}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QLowEnergyController[] = {
    {sipName_UnconnectedState, static_cast<int>(::QLowEnergyController::UnconnectedState)},
    {sipName_ConnectingState, static_cast<int>(::QLowEnergyController::ConnectingState)},
    {sipName_ConnectedState, static_cast<int>(::QLowEnergyController::ConnectedState)},
    {sipName_DiscoveringState, static_cast<int>(::QLowEnergyController::DiscoveringState)},
    {sipName_DiscoveredState, static_cast<int>(::QLowEnergyController::DiscoveredState)},
    {sipName_ClosingState, static_cast<int>(::QLowEnergyController::ClosingState)},
    {sipName_AdvertisingState, static_cast<int>(::QLowEnergyController::AdvertisingState)},
    {sipName_NoError, static_cast<int>(::QLowEnergyController::NoError)},
    {sipName_UnknownError, static_cast<int>(::QLowEnergyController::UnknownError)},
    {sipName_UnknownRemoteDeviceError, static_cast<int>(::QLowEnergyController::UnknownRemoteDeviceError)},
    {sipName_NetworkError, static_cast<int>(::QLowEnergyController::NetworkError)},
    {sipName_InvalidBluetoothAdapterError, static_cast<int>(::QLowEnergyController::InvalidBluetoothAdapterError)},
    {sipName_ConnectionError, static_cast<int>(::QLowEnergyController::ConnectionError)},
    {sipName_AdvertisingError, static_cast<int>(::QLowEnergyController::AdvertisingError)},
    {sipName_RemoteHostClosedError, static_cast<int>(::QLowEnergyController::RemoteHostClosedError)},
    {sipName_AuthorizationError, static_cast<int>(::QLowEnergyController::AuthorizationError)},
    {sipName_MissingPermissionsError, static_cast<int>(::QLowEnergyController::MissingPermissionsError)},
    {sipName_RssiReadError, static_cast<int>(::QLowEnergyController::RssiReadError)},
    {sipName_PublicAddress, static_cast<int>(::QLowEnergyController::PublicAddress)},
    {sipName_RandomAddress, static_cast<int>(::QLowEnergyController::RandomAddress)},
    {sipName_CentralRole, static_cast<int>(::QLowEnergyController::CentralRole)},
    {sipName_PeripheralRole, static_cast<int>(::QLowEnergyController::PeripheralRole)},
    {0, 0}
};


/* Define this type's signals. */
static const pyqt6QtSignal signals_QLowEnergyController[] = {
    {"rssiRead(qint16)", "\1rssiRead(self, rssi: int)", SIP_NULLPTR, SIP_NULLPTR},
    {"mtuChanged(int)", "\1mtuChanged(self, mtu: int)", SIP_NULLPTR, SIP_NULLPTR},
    {"connectionUpdated(QLowEnergyConnectionParameters)", "\1connectionUpdated(self, parameters: QLowEnergyConnectionParameters)", SIP_NULLPTR, SIP_NULLPTR},
    {"discoveryFinished()", "\1discoveryFinished(self)", SIP_NULLPTR, SIP_NULLPTR},
    {"serviceDiscovered(QBluetoothUuid)", "\1serviceDiscovered(self, newService: QBluetoothUuid)", SIP_NULLPTR, SIP_NULLPTR},
    {"errorOccurred(QLowEnergyController::Error)", "\1errorOccurred(self, newError: QLowEnergyController.Error)", SIP_NULLPTR, SIP_NULLPTR},
    {"stateChanged(QLowEnergyController::ControllerState)", "\1stateChanged(self, state: QLowEnergyController.ControllerState)", SIP_NULLPTR, SIP_NULLPTR},
    {"disconnected()", "\1disconnected(self)", SIP_NULLPTR, SIP_NULLPTR},
    {"connected()", "\1connected(self)", SIP_NULLPTR, SIP_NULLPTR},
    {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
};


static pyqt6ClassPluginDef plugin_QLowEnergyController = {
    &::QLowEnergyController::staticMetaObject,
    signals_QLowEnergyController,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtBluetooth_QLowEnergyController = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QLowEnergyController,
        SIP_NULLPTR,
        &plugin_QLowEnergyController,
    },
    {
        sipNameNr_QLowEnergyController,
        {0, 0, 1},
        23, methods_QLowEnergyController,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QLowEnergyController, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    SIP_NULLPTR,
    -1,
    -1,
    supers_QLowEnergyController,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QLowEnergyController,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QLowEnergyController,
    cast_QLowEnergyController,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
