
#include "procstatd.h"
#include <dirent.h>

int sendline(int fd, char *buffer, int length);

static FILE* fpp_loadavg = NULL;
static FILE* fpp_stat = NULL;

void init_quiklist() {
	fpp_loadavg = fopen( "/proc/loadavg", "r" );
	fpp_stat    = fopen( "/proc/stat", "r" );

	return;
}

void get_and_send_quiklist() {
	int i;
	char* rtn;

	if( (fpp_loadavg==NULL) || (fpp_stat==NULL) ) {
		init_quiklist();
	}

	outbuf[0] = 'l';
	outbuf[1] = 'o';
	outbuf[2] = 'a';
	outbuf[3] = 'd';
	outbuf[4] = ' ';

	/* read /proc/loadavg */
	rewind( fpp_loadavg );
	fgets( outbuf+5, 128, fpp_loadavg );
	i = 0;
	while( (outbuf[i]!=0) && (outbuf[i]!=10) ) {
		i++;
	}
	outbuf[i] = '|';
	outbuf[i+1] = 0;
	i++;

	/* read /proc/stat */
	rewind( fpp_stat );
	while( 1 ) {
		rtn = fgets( outbuf+i, 1024, fpp_stat );
		if( rtn == NULL ) {
			break;
		}

		/* throw out the "intr " line */
		/* : yes, of course, this could be strncmp() !! */
		if( (outbuf[i]!='i') || (outbuf[i+1]!='n')
		    || (outbuf[i+2]!='t') || (outbuf[i+3]!='r')
		    || (outbuf[i+4]!=' ') ) {
			while( (outbuf[i]!=0) && (outbuf[i]!=10) ) {
				i++;
			}
			outbuf[i] = '|';
			outbuf[i+1] = 0;
			i++;
		}
	}

	/* buflen = strlen(outbuf); */
	sendline( client_fd, outbuf, i );

	if(verbose) printf("data sent = %s\n",outbuf);

	return;
}

