// Copyright 2020 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: security/v1beta1/peer_authentication.proto

// $schema: istio.security.v1beta1.PeerAuthentication
// $title: PeerAuthentication
// $description: Peer authentication configuration for workloads.
// $location: https://istio.io/docs/reference/config/security/peer_authentication.html
// $aliases: [/docs/reference/config/security/v1beta1/peer_authentication]

// PeerAuthentication defines mutual TLS (mTLS) requirements for incoming connections.
//
// In sidecar mode, PeerAuthentication determines whether or not mTLS is allowed or required
// for connections to an Envoy proxy sidecar.
//
// In ambient mode, security is transparently enabled for a pod by the ztunnel node agent.
// (Traffic between proxies uses the HBONE protocol, which includes encryption with mTLS.)
// Because of this, `DISABLE` mode is not supported.
// `STRICT` mode is useful to ensure that connections that bypass the mesh are not possible.
//
// Examples:
//
// Policy to require mTLS traffic for all workloads under namespace `foo`:
// ```yaml
// apiVersion: security.istio.io/v1
// kind: PeerAuthentication
// metadata:
//   name: default
//   namespace: foo
// spec:
//   mtls:
//     mode: STRICT
// ```
// For mesh level, put the policy in root-namespace according to your Istio installation.
//
// Policies to allow both mTLS and plaintext traffic for all workloads under namespace `foo`, but
// require mTLS for workload `finance`.
// ```yaml
// apiVersion: security.istio.io/v1
// kind: PeerAuthentication
// metadata:
//   name: default
//   namespace: foo
// spec:
//   mtls:
//     mode: PERMISSIVE
// ---
// apiVersion: security.istio.io/v1
// kind: PeerAuthentication
// metadata:
//   name: finance
//   namespace: foo
// spec:
//   selector:
//     matchLabels:
//       app: finance
//   mtls:
//     mode: STRICT
// ```
// Policy that enables strict mTLS for all `finance` workloads, but leaves the port `8080` to
// plaintext. Note the port value in the `portLevelMtls` field refers to the port
// of the workload, not the port of the Kubernetes service.
// ```yaml
// apiVersion: security.istio.io/v1
// kind: PeerAuthentication
// metadata:
//   name: default
//   namespace: foo
// spec:
//   selector:
//     matchLabels:
//       app: finance
//   mtls:
//     mode: STRICT
//   portLevelMtls:
//     8080:
//       mode: DISABLE
// ```
// Policy that inherits mTLS mode from namespace (or mesh) settings, and disables
// mTLS for workload port `8080`.
// ```yaml
// apiVersion: security.istio.io/v1
// kind: PeerAuthentication
// metadata:
//   name: default
//   namespace: foo
// spec:
//   selector:
//     matchLabels:
//       app: finance
//   mtls:
//     mode: UNSET
//   portLevelMtls:
//     8080:
//       mode: DISABLE
// ```

package v1beta1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1beta1 "istio.io/api/type/v1beta1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type PeerAuthentication_MutualTLS_Mode int32

const (
	// Inherit from parent, if has one. Otherwise treated as `PERMISSIVE`.
	PeerAuthentication_MutualTLS_UNSET PeerAuthentication_MutualTLS_Mode = 0
	// Connection is not tunneled.
	PeerAuthentication_MutualTLS_DISABLE PeerAuthentication_MutualTLS_Mode = 1
	// Connection can be either plaintext or mTLS tunnel.
	PeerAuthentication_MutualTLS_PERMISSIVE PeerAuthentication_MutualTLS_Mode = 2
	// Connection is an mTLS tunnel (TLS with client cert must be presented).
	PeerAuthentication_MutualTLS_STRICT PeerAuthentication_MutualTLS_Mode = 3
)

// Enum value maps for PeerAuthentication_MutualTLS_Mode.
var (
	PeerAuthentication_MutualTLS_Mode_name = map[int32]string{
		0: "UNSET",
		1: "DISABLE",
		2: "PERMISSIVE",
		3: "STRICT",
	}
	PeerAuthentication_MutualTLS_Mode_value = map[string]int32{
		"UNSET":      0,
		"DISABLE":    1,
		"PERMISSIVE": 2,
		"STRICT":     3,
	}
)

func (x PeerAuthentication_MutualTLS_Mode) Enum() *PeerAuthentication_MutualTLS_Mode {
	p := new(PeerAuthentication_MutualTLS_Mode)
	*p = x
	return p
}

func (x PeerAuthentication_MutualTLS_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PeerAuthentication_MutualTLS_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_security_v1beta1_peer_authentication_proto_enumTypes[0].Descriptor()
}

func (PeerAuthentication_MutualTLS_Mode) Type() protoreflect.EnumType {
	return &file_security_v1beta1_peer_authentication_proto_enumTypes[0]
}

func (x PeerAuthentication_MutualTLS_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PeerAuthentication_MutualTLS_Mode.Descriptor instead.
func (PeerAuthentication_MutualTLS_Mode) EnumDescriptor() ([]byte, []int) {
	return file_security_v1beta1_peer_authentication_proto_rawDescGZIP(), []int{0, 0, 0}
}

// <!-- crd generation tags
// +cue-gen:PeerAuthentication:groupName:security.istio.io
// +cue-gen:PeerAuthentication:versions:v1beta1,v1
// +cue-gen:PeerAuthentication:storageVersion
// +cue-gen:PeerAuthentication:annotations:helm.sh/resource-policy=keep
// +cue-gen:PeerAuthentication:labels:app=istio-pilot,chart=istio,istio=security,heritage=Tiller,release=istio
// +cue-gen:PeerAuthentication:subresource:status
// +cue-gen:PeerAuthentication:scope:Namespaced
// +cue-gen:PeerAuthentication:resource:categories=istio-io,security-istio-io,shortNames=pa
// +cue-gen:PeerAuthentication:preserveUnknownFields:false
// +cue-gen:PeerAuthentication:printerColumn:name=Mode,type=string,JSONPath=.spec.mtls.mode,description="Defines the mTLS mode used for peer authentication."
// +cue-gen:PeerAuthentication:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=security.istio.io/v1beta1
// +genclient
// +k8s:deepcopy-gen=true
// -->
// +kubebuilder:validation:XValidation:message="portLevelMtls requires selector",rule="has(self.portLevelMtls) ? self.index({}, selector, matchLabels).size() > 0 : true"
type PeerAuthentication struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The selector determines the workloads to apply the PeerAuthentication on. The selector will match with workloads in the
	// same namespace as the policy. If the policy is in the root namespace, the selector will additionally match with workloads in all namespace.
	//
	// If not set, the policy will be applied to all workloads in the same namespace as the policy. If it is in the root namespace, it would be applied
	// to all workloads in the mesh.
	Selector *v1beta1.WorkloadSelector `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// Mutual TLS settings for workload. If not defined, inherit from parent.
	Mtls *PeerAuthentication_MutualTLS `protobuf:"bytes,2,opt,name=mtls,proto3" json:"mtls,omitempty"`
	// Port specific mutual TLS settings. These only apply when a workload selector
	// is specified. The port refers to the port of the workload, not the port of the
	// Kubernetes service.
	// +kubebuilder:validation:XValidation:message="port must be between 1-65535",rule="self.all(key, 0 < int(key) && int(key) <= 65535)"
	// +kubebuilder:validation:MinProperties=1
	PortLevelMtls map[uint32]*PeerAuthentication_MutualTLS `protobuf:"bytes,3,rep,name=port_level_mtls,json=portLevelMtls,proto3" json:"port_level_mtls,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PeerAuthentication) Reset() {
	*x = PeerAuthentication{}
	mi := &file_security_v1beta1_peer_authentication_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PeerAuthentication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeerAuthentication) ProtoMessage() {}

func (x *PeerAuthentication) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_peer_authentication_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeerAuthentication.ProtoReflect.Descriptor instead.
func (*PeerAuthentication) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_peer_authentication_proto_rawDescGZIP(), []int{0}
}

func (x *PeerAuthentication) GetSelector() *v1beta1.WorkloadSelector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *PeerAuthentication) GetMtls() *PeerAuthentication_MutualTLS {
	if x != nil {
		return x.Mtls
	}
	return nil
}

func (x *PeerAuthentication) GetPortLevelMtls() map[uint32]*PeerAuthentication_MutualTLS {
	if x != nil {
		return x.PortLevelMtls
	}
	return nil
}

// Mutual TLS settings.
type PeerAuthentication_MutualTLS struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Defines the mTLS mode used for peer authentication.
	Mode          PeerAuthentication_MutualTLS_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.security.v1beta1.PeerAuthentication_MutualTLS_Mode" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PeerAuthentication_MutualTLS) Reset() {
	*x = PeerAuthentication_MutualTLS{}
	mi := &file_security_v1beta1_peer_authentication_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PeerAuthentication_MutualTLS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeerAuthentication_MutualTLS) ProtoMessage() {}

func (x *PeerAuthentication_MutualTLS) ProtoReflect() protoreflect.Message {
	mi := &file_security_v1beta1_peer_authentication_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeerAuthentication_MutualTLS.ProtoReflect.Descriptor instead.
func (*PeerAuthentication_MutualTLS) Descriptor() ([]byte, []int) {
	return file_security_v1beta1_peer_authentication_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PeerAuthentication_MutualTLS) GetMode() PeerAuthentication_MutualTLS_Mode {
	if x != nil {
		return x.Mode
	}
	return PeerAuthentication_MutualTLS_UNSET
}

var File_security_v1beta1_peer_authentication_proto protoreflect.FileDescriptor

const file_security_v1beta1_peer_authentication_proto_rawDesc = "" +
	"\n" +
	"*security/v1beta1/peer_authentication.proto\x12\x16istio.security.v1beta1\x1a\x1btype/v1beta1/selector.proto\"\x98\x04\n" +
	"\x12PeerAuthentication\x12@\n" +
	"\bselector\x18\x01 \x01(\v2$.istio.type.v1beta1.WorkloadSelectorR\bselector\x12H\n" +
	"\x04mtls\x18\x02 \x01(\v24.istio.security.v1beta1.PeerAuthentication.MutualTLSR\x04mtls\x12e\n" +
	"\x0fport_level_mtls\x18\x03 \x03(\v2=.istio.security.v1beta1.PeerAuthentication.PortLevelMtlsEntryR\rportLevelMtls\x1a\x96\x01\n" +
	"\tMutualTLS\x12M\n" +
	"\x04mode\x18\x01 \x01(\x0e29.istio.security.v1beta1.PeerAuthentication.MutualTLS.ModeR\x04mode\":\n" +
	"\x04Mode\x12\t\n" +
	"\x05UNSET\x10\x00\x12\v\n" +
	"\aDISABLE\x10\x01\x12\x0e\n" +
	"\n" +
	"PERMISSIVE\x10\x02\x12\n" +
	"\n" +
	"\x06STRICT\x10\x03\x1av\n" +
	"\x12PortLevelMtlsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\rR\x03key\x12J\n" +
	"\x05value\x18\x02 \x01(\v24.istio.security.v1beta1.PeerAuthentication.MutualTLSR\x05value:\x028\x01B\x1fZ\x1distio.io/api/security/v1beta1b\x06proto3"

var (
	file_security_v1beta1_peer_authentication_proto_rawDescOnce sync.Once
	file_security_v1beta1_peer_authentication_proto_rawDescData []byte
)

func file_security_v1beta1_peer_authentication_proto_rawDescGZIP() []byte {
	file_security_v1beta1_peer_authentication_proto_rawDescOnce.Do(func() {
		file_security_v1beta1_peer_authentication_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_security_v1beta1_peer_authentication_proto_rawDesc), len(file_security_v1beta1_peer_authentication_proto_rawDesc)))
	})
	return file_security_v1beta1_peer_authentication_proto_rawDescData
}

var file_security_v1beta1_peer_authentication_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_security_v1beta1_peer_authentication_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_security_v1beta1_peer_authentication_proto_goTypes = []any{
	(PeerAuthentication_MutualTLS_Mode)(0), // 0: istio.security.v1beta1.PeerAuthentication.MutualTLS.Mode
	(*PeerAuthentication)(nil),             // 1: istio.security.v1beta1.PeerAuthentication
	(*PeerAuthentication_MutualTLS)(nil),   // 2: istio.security.v1beta1.PeerAuthentication.MutualTLS
	nil,                                    // 3: istio.security.v1beta1.PeerAuthentication.PortLevelMtlsEntry
	(*v1beta1.WorkloadSelector)(nil),       // 4: istio.type.v1beta1.WorkloadSelector
}
var file_security_v1beta1_peer_authentication_proto_depIdxs = []int32{
	4, // 0: istio.security.v1beta1.PeerAuthentication.selector:type_name -> istio.type.v1beta1.WorkloadSelector
	2, // 1: istio.security.v1beta1.PeerAuthentication.mtls:type_name -> istio.security.v1beta1.PeerAuthentication.MutualTLS
	3, // 2: istio.security.v1beta1.PeerAuthentication.port_level_mtls:type_name -> istio.security.v1beta1.PeerAuthentication.PortLevelMtlsEntry
	0, // 3: istio.security.v1beta1.PeerAuthentication.MutualTLS.mode:type_name -> istio.security.v1beta1.PeerAuthentication.MutualTLS.Mode
	2, // 4: istio.security.v1beta1.PeerAuthentication.PortLevelMtlsEntry.value:type_name -> istio.security.v1beta1.PeerAuthentication.MutualTLS
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_security_v1beta1_peer_authentication_proto_init() }
func file_security_v1beta1_peer_authentication_proto_init() {
	if File_security_v1beta1_peer_authentication_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_security_v1beta1_peer_authentication_proto_rawDesc), len(file_security_v1beta1_peer_authentication_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_security_v1beta1_peer_authentication_proto_goTypes,
		DependencyIndexes: file_security_v1beta1_peer_authentication_proto_depIdxs,
		EnumInfos:         file_security_v1beta1_peer_authentication_proto_enumTypes,
		MessageInfos:      file_security_v1beta1_peer_authentication_proto_msgTypes,
	}.Build()
	File_security_v1beta1_peer_authentication_proto = out.File
	file_security_v1beta1_peer_authentication_proto_goTypes = nil
	file_security_v1beta1_peer_authentication_proto_depIdxs = nil
}
