/*
 * Intel Indeo 2 codec
 * copyright (c) 2005 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_INDEO2DATA_H
#define AVCODEC_INDEO2DATA_H

#include <stdint.h>

#define IR2_CODES 143
static const uint8_t ir2_tab[IR2_CODES][2] = {
    { 0x01,  3 }, { 0x02,  3 }, { 0x80,  3 }, { 0x03,  3 }, { 0x04,  5 },
    { 0x81,  5 }, { 0x05,  5 }, { 0x06,  5 }, { 0x82,  5 }, { 0x83,  5 },
    { 0x07,  5 }, { 0x08,  5 }, { 0x84,  6 }, { 0x09,  6 }, { 0x0A,  6 },
    { 0x0B,  6 }, { 0x0C,  6 }, { 0x0D,  6 }, { 0x0E,  6 }, { 0x85,  6 },
    { 0x0F,  8 }, { 0x10,  8 }, { 0x86,  8 }, { 0x87,  8 }, { 0x11,  8 },
    { 0x12,  8 }, { 0x13,  8 }, { 0x14,  8 }, { 0x88,  8 }, { 0x15,  8 },
    { 0x16,  8 }, { 0x89,  8 }, { 0x17,  8 }, { 0x18,  8 }, { 0x8A,  8 },
    { 0x19,  8 }, { 0x1A,  9 }, { 0x8B,  9 }, { 0x1B,  9 }, { 0x1C,  9 },
    { 0x8C,  9 }, { 0x1D,  9 }, { 0x1E,  9 }, { 0x8D,  9 }, { 0x1F,  9 },
    { 0x20,  9 }, { 0x8E,  9 }, { 0x21,  9 }, { 0x22,  9 }, { 0x8F,  9 },
    { 0x23,  9 }, { 0x24,  9 }, { 0x25, 10 }, { 0x26, 10 }, { 0x27, 10 },
    { 0x28, 10 }, { 0x29, 10 }, { 0x2A, 10 }, { 0x2B, 10 }, { 0x2C, 10 },
    { 0x2D, 10 }, { 0x2E, 10 }, { 0x2F, 10 }, { 0x30, 10 }, { 0x31, 10 },
    { 0x32, 10 }, { 0x33, 10 }, { 0x34, 10 }, { 0x35, 13 }, { 0x36, 13 },
    { 0x37, 13 }, { 0x38, 13 }, { 0x39, 13 }, { 0x3A, 13 }, { 0x3B, 13 },
    { 0x3C, 13 }, { 0x3D, 13 }, { 0x3E, 13 }, { 0x3F, 13 }, { 0x40, 13 },
    { 0x41, 13 }, { 0x42, 13 }, { 0x43, 13 }, { 0x44, 13 }, { 0x45, 13 },
    { 0x46, 13 }, { 0x47, 13 }, { 0x48, 13 }, { 0x49, 13 }, { 0x4A, 13 },
    { 0x4B, 13 }, { 0x4C, 13 }, { 0x4D, 13 }, { 0x4E, 13 }, { 0x4F, 13 },
    { 0x50, 13 }, { 0x51, 13 }, { 0x52, 13 }, { 0x53, 13 }, { 0x54, 13 },
    { 0x55, 13 }, { 0x56, 13 }, { 0x57, 13 }, { 0x58, 13 }, { 0x59, 13 },
    { 0x5A, 13 }, { 0x5B, 13 }, { 0x5C, 13 }, { 0x5D, 13 }, { 0x5E, 13 },
    { 0x5F, 13 }, { 0x60, 13 }, { 0x61, 13 }, { 0x62, 13 }, { 0x63, 13 },
    { 0x64, 13 }, { 0x65, 13 }, { 0x66, 13 }, { 0x67, 13 }, { 0x68, 13 },
    { 0x69, 13 }, { 0x6A, 13 }, { 0x6B, 13 }, { 0x6C, 13 }, { 0x6D, 13 },
    { 0x6E, 13 }, { 0x6F, 13 }, { 0x70, 13 }, { 0x71, 13 }, { 0x72, 13 },
    { 0x73, 13 }, { 0x74, 13 }, { 0x75, 14 }, { 0x76, 14 }, { 0x77, 14 },
    { 0x78, 14 }, { 0x79, 14 }, { 0x7A, 14 }, { 0x7B, 14 }, { 0x7C, 14 },
    { 0x7D, 14 }, { 0x7E, 14 }, { 0x7F, 14 },
};

static const uint8_t ir2_delta_table[4][256] = {
    { 0x80, 0x80, 0x84, 0x84, 0x7C, 0x7C, 0x7F, 0x85,
      0x81, 0x7B, 0x85, 0x7F, 0x7B, 0x81, 0x8C, 0x8C,
      0x74, 0x74, 0x83, 0x8D, 0x7D, 0x73, 0x8D, 0x83,
      0x73, 0x7D, 0x77, 0x89, 0x89, 0x77, 0x89, 0x77,
      0x77, 0x89, 0x8C, 0x95, 0x74, 0x6B, 0x95, 0x8C,
      0x6B, 0x74, 0x7C, 0x90, 0x84, 0x70, 0x90, 0x7C,
      0x70, 0x84, 0x96, 0x96, 0x6A, 0x6A, 0x82, 0x98,
      0x7E, 0x68, 0x98, 0x82, 0x68, 0x7E, 0x97, 0xA2,
      0x69, 0x5E, 0xA2, 0x97, 0x5E, 0x69, 0xA2, 0xA2,
      0x5E, 0x5E, 0x8B, 0xA3, 0x75, 0x5D, 0xA3, 0x8B,
      0x5D, 0x75, 0x71, 0x95, 0x8F, 0x6B, 0x95, 0x71,
      0x6B, 0x8F, 0x78, 0x9D, 0x88, 0x63, 0x9D, 0x78,
      0x63, 0x88, 0x7F, 0xA7, 0x81, 0x59, 0xA7, 0x7F,
      0x59, 0x81, 0xA4, 0xB1, 0x5C, 0x4F, 0xB1, 0xA4,
      0x4F, 0x5C, 0x96, 0xB1, 0x6A, 0x4F, 0xB1, 0x96,
      0x4F, 0x6A, 0xB2, 0xB2, 0x4E, 0x4E, 0x65, 0x9B,
      0x9B, 0x65, 0x9B, 0x65, 0x65, 0x9B, 0x89, 0xB4,
      0x77, 0x4C, 0xB4, 0x89, 0x4C, 0x77, 0x6A, 0xA3,
      0x96, 0x5D, 0xA3, 0x6A, 0x5D, 0x96, 0x73, 0xAC,
      0x8D, 0x54, 0xAC, 0x73, 0x54, 0x8D, 0xB4, 0xC3,
      0x4C, 0x3D, 0xC3, 0xB4, 0x3D, 0x4C, 0xA4, 0xC3,
      0x5C, 0x3D, 0xC3, 0xA4, 0x3D, 0x5C, 0xC4, 0xC4,
      0x3C, 0x3C, 0x96, 0xC6, 0x6A, 0x3A, 0xC6, 0x96,
      0x3A, 0x6A, 0x7C, 0xBA, 0x84, 0x46, 0xBA, 0x7C,
      0x46, 0x84, 0x5B, 0xAB, 0xA5, 0x55, 0xAB, 0x5B,
      0x55, 0xA5, 0x63, 0xB4, 0x9D, 0x4C, 0xB4, 0x63,
      0x4C, 0x9D, 0x86, 0xCA, 0x7A, 0x36, 0xCA, 0x86,
      0x36, 0x7A, 0xB6, 0xD7, 0x4A, 0x29, 0xD7, 0xB6,
      0x29, 0x4A, 0xC8, 0xD7, 0x38, 0x29, 0xD7, 0xC8,
      0x29, 0x38, 0xA4, 0xD8, 0x5C, 0x28, 0xD8, 0xA4,
      0x28, 0x5C, 0x6C, 0xC1, 0x94, 0x3F, 0xC1, 0x6C,
      0x3F, 0x94, 0xD9, 0xD9, 0x27, 0x27, 0x80, 0x80, },
    { 0x80, 0x80, 0x85, 0x85, 0x7B, 0x7B, 0x7E, 0x87,
      0x82, 0x79, 0x87, 0x7E, 0x79, 0x82, 0x8F, 0x8F,
      0x71, 0x71, 0x84, 0x8F, 0x7C, 0x71, 0x8F, 0x84,
      0x71, 0x7C, 0x75, 0x8B, 0x8B, 0x75, 0x8B, 0x75,
      0x75, 0x8B, 0x8E, 0x9A, 0x72, 0x66, 0x9A, 0x8E,
      0x66, 0x72, 0x7B, 0x93, 0x85, 0x6D, 0x93, 0x7B,
      0x6D, 0x85, 0x9B, 0x9B, 0x65, 0x65, 0x82, 0x9D,
      0x7E, 0x63, 0x9D, 0x82, 0x63, 0x7E, 0x9B, 0xA8,
      0x65, 0x58, 0xA8, 0x9B, 0x58, 0x65, 0xA9, 0xA9,
      0x57, 0x57, 0x8D, 0xAA, 0x73, 0x56, 0xAA, 0x8D,
      0x56, 0x73, 0x6E, 0x99, 0x92, 0x67, 0x99, 0x6E,
      0x67, 0x92, 0x76, 0xA2, 0x8A, 0x5E, 0xA2, 0x76,
      0x5E, 0x8A, 0x7F, 0xAF, 0x81, 0x51, 0xAF, 0x7F,
      0x51, 0x81, 0xAB, 0xBA, 0x55, 0x46, 0xBA, 0xAB,
      0x46, 0x55, 0x9A, 0xBB, 0x66, 0x45, 0xBB, 0x9A,
      0x45, 0x66, 0xBB, 0xBB, 0x45, 0x45, 0x60, 0xA0,
      0xA0, 0x60, 0xA0, 0x60, 0x60, 0xA0, 0x8B, 0xBE,
      0x75, 0x42, 0xBE, 0x8B, 0x42, 0x75, 0x66, 0xAA,
      0x9A, 0x56, 0xAA, 0x66, 0x56, 0x9A, 0x70, 0xB5,
      0x90, 0x4B, 0xB5, 0x70, 0x4B, 0x90, 0xBE, 0xCF,
      0x42, 0x31, 0xCF, 0xBE, 0x31, 0x42, 0xAB, 0xD0,
      0x55, 0x30, 0xD0, 0xAB, 0x30, 0x55, 0xD1, 0xD1,
      0x2F, 0x2F, 0x9A, 0xD3, 0x66, 0x2D, 0xD3, 0x9A,
      0x2D, 0x66, 0x7B, 0xC5, 0x85, 0x3B, 0xC5, 0x7B,
      0x3B, 0x85, 0x54, 0xB4, 0xAC, 0x4C, 0xB4, 0x54,
      0x4C, 0xAC, 0x5E, 0xBE, 0xA2, 0x42, 0xBE, 0x5E,
      0x42, 0xA2, 0x87, 0xD8, 0x79, 0x28, 0xD8, 0x87,
      0x28, 0x79, 0xC0, 0xE8, 0x40, 0x18, 0xE8, 0xC0,
      0x18, 0x40, 0xD5, 0xE8, 0x2B, 0x18, 0xE8, 0xD5,
      0x18, 0x2B, 0xAB, 0xE9, 0x55, 0x17, 0xE9, 0xAB,
      0x17, 0x55, 0x68, 0xCD, 0x98, 0x33, 0xCD, 0x68,
      0x33, 0x98, 0xEA, 0xEA, 0x16, 0x16, 0x80, 0x80, },
    { 0x80, 0x80, 0x86, 0x86, 0x7A, 0x7A, 0x7E, 0x88,
      0x82, 0x78, 0x88, 0x7E, 0x78, 0x82, 0x92, 0x92,
      0x6E, 0x6E, 0x85, 0x92, 0x7B, 0x6E, 0x92, 0x85,
      0x6E, 0x7B, 0x73, 0x8D, 0x8D, 0x73, 0x8D, 0x73,
      0x73, 0x8D, 0x91, 0x9E, 0x6F, 0x62, 0x9E, 0x91,
      0x62, 0x6F, 0x79, 0x97, 0x87, 0x69, 0x97, 0x79,
      0x69, 0x87, 0xA0, 0xA0, 0x60, 0x60, 0x83, 0xA2,
      0x7D, 0x5E, 0xA2, 0x83, 0x5E, 0x7D, 0xA0, 0xB0,
      0x60, 0x50, 0xB0, 0xA0, 0x50, 0x60, 0xB1, 0xB1,
      0x4F, 0x4F, 0x8F, 0xB2, 0x71, 0x4E, 0xB2, 0x8F,
      0x4E, 0x71, 0x6B, 0x9E, 0x95, 0x62, 0x9E, 0x6B,
      0x62, 0x95, 0x74, 0xA9, 0x8C, 0x57, 0xA9, 0x74,
      0x57, 0x8C, 0x7F, 0xB8, 0x81, 0x48, 0xB8, 0x7F,
      0x48, 0x81, 0xB4, 0xC5, 0x4C, 0x3B, 0xC5, 0xB4,
      0x3B, 0x4C, 0x9F, 0xC6, 0x61, 0x3A, 0xC6, 0x9F,
      0x3A, 0x61, 0xC6, 0xC6, 0x3A, 0x3A, 0x59, 0xA7,
      0xA7, 0x59, 0xA7, 0x59, 0x59, 0xA7, 0x8D, 0xCA,
      0x73, 0x36, 0xCA, 0x8D, 0x36, 0x73, 0x61, 0xB2,
      0x9F, 0x4E, 0xB2, 0x61, 0x4E, 0x9F, 0x6D, 0xBF,
      0x93, 0x41, 0xBF, 0x6D, 0x41, 0x93, 0xCA, 0xDF,
      0x36, 0x21, 0xDF, 0xCA, 0x21, 0x36, 0xB3, 0xDF,
      0x4D, 0x21, 0xDF, 0xB3, 0x21, 0x4D, 0xE1, 0xE1,
      0x1F, 0x1F, 0x9F, 0xE3, 0x61, 0x1D, 0xE3, 0x9F,
      0x1D, 0x61, 0x7A, 0xD3, 0x86, 0x2D, 0xD3, 0x7A,
      0x2D, 0x86, 0x4C, 0xBE, 0xB4, 0x42, 0xBE, 0x4C,
      0x42, 0xB4, 0x57, 0xCA, 0xA9, 0x36, 0xCA, 0x57,
      0x36, 0xA9, 0x88, 0xE9, 0x78, 0x17, 0xE9, 0x88,
      0x17, 0x78, 0xCC, 0xFB, 0x34, 0x05, 0xFB, 0xCC,
      0x05, 0x34, 0xE6, 0xFB, 0x1A, 0x05, 0xFB, 0xE6,
      0x05, 0x1A, 0xB4, 0xFD, 0x4C, 0x03, 0xFD, 0xB4,
      0x03, 0x4C, 0x63, 0xDC, 0x9D, 0x24, 0xDC, 0x63,
      0x24, 0x9D, 0xFE, 0xFE, 0x02, 0x02, 0x80, 0x80, },
    { 0x80, 0x80, 0x87, 0x87, 0x79, 0x79, 0x7E, 0x89,
      0x82, 0x77, 0x89, 0x7E, 0x77, 0x82, 0x95, 0x95,
      0x6B, 0x6B, 0x86, 0x96, 0x7A, 0x6A, 0x96, 0x86,
      0x6A, 0x7A, 0x70, 0x90, 0x90, 0x70, 0x90, 0x70,
      0x70, 0x90, 0x94, 0xA4, 0x6C, 0x5C, 0xA4, 0x94,
      0x5C, 0x6C, 0x78, 0x9B, 0x88, 0x65, 0x9B, 0x78,
      0x65, 0x88, 0xA6, 0xA6, 0x5A, 0x5A, 0x83, 0xA9,
      0x7D, 0x57, 0xA9, 0x83, 0x57, 0x7D, 0xA6, 0xB9,
      0x5A, 0x47, 0xB9, 0xA6, 0x47, 0x5A, 0xBA, 0xBA,
      0x46, 0x46, 0x92, 0xBC, 0x6E, 0x44, 0xBC, 0x92,
      0x44, 0x6E, 0x67, 0xA3, 0x99, 0x5D, 0xA3, 0x67,
      0x5D, 0x99, 0x72, 0xB0, 0x8E, 0x50, 0xB0, 0x72,
      0x50, 0x8E, 0x7F, 0xC3, 0x81, 0x3D, 0xC3, 0x7F,
      0x3D, 0x81, 0xBE, 0xD2, 0x42, 0x2E, 0xD2, 0xBE,
      0x2E, 0x42, 0xA5, 0xD4, 0x5B, 0x2C, 0xD4, 0xA5,
      0x2C, 0x5B, 0xD4, 0xD4, 0x2C, 0x2C, 0x52, 0xAE,
      0xAE, 0x52, 0xAE, 0x52, 0x52, 0xAE, 0x8F, 0xD8,
      0x71, 0x28, 0xD8, 0x8F, 0x28, 0x71, 0x5B, 0xBB,
      0xA5, 0x45, 0xBB, 0x5B, 0x45, 0xA5, 0x69, 0xCB,
      0x97, 0x35, 0xCB, 0x69, 0x35, 0x97, 0xD8, 0xF0,
      0x28, 0x10, 0xF0, 0xD8, 0x10, 0x28, 0xBD, 0xF1,
      0x43, 0x0F, 0xF1, 0xBD, 0x0F, 0x43, 0xF3, 0xF3,
      0x0D, 0x0D, 0xA5, 0xF6, 0x5B, 0x0A, 0xF6, 0xA5,
      0x0A, 0x5B, 0x78, 0xE2, 0x88, 0x1E, 0xE2, 0x78,
      0x1E, 0x88, 0x42, 0xC9, 0xBE, 0x37, 0xC9, 0x42,
      0x37, 0xBE, 0x4F, 0xD8, 0xB1, 0x28, 0xD8, 0x4F,
      0x28, 0xB1, 0x8A, 0xFD, 0x76, 0x03, 0xFD, 0x8A,
      0x03, 0x76, 0xDB, 0xFF, 0x25, 0x01, 0xFF, 0xDB,
      0x01, 0x25, 0xF9, 0xFF, 0x07, 0x01, 0xFF, 0xF9,
      0x01, 0x07, 0xBE, 0xFF, 0x42, 0x01, 0xFF, 0xBE,
      0x01, 0x42, 0x5E, 0xED, 0xA2, 0x13, 0xED, 0x5E,
      0x13, 0xA2, 0xFF, 0xFF, 0x01, 0x01, 0x80, 0x80, },
};

#endif /* AVCODEC_INDEO2DATA_H */
