/*
==============================================================================

                                 DOOM Retro
           The classic, refined DOOM source port. For Windows PC.

==============================================================================

    Copyright © 1993-2025 by id Software LLC, a ZeniMax Media company.
    Copyright © 2013-2025 by Brad Harding <mailto:brad@doomretro.com>.

    This file is a part of DOOM Retro.

    DOOM Retro is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation, either version 3 of the license, or (at your
    option) any later version.

    DOOM Retro is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with DOOM Retro. If not, see <https://www.gnu.org/licenses/>.

    DOOM is a registered trademark of id Software LLC, a ZeniMax Media
    company, in the US and/or other countries, and is used without
    permission. All other trademarks are the property of their respective
    holders. DOOM Retro is in no way affiliated with nor endorsed by
    id Software.

==============================================================================
*/

#include "p_fix.h"
#include "r_defs.h"

vertexfix_t vertexfix[] =
{
   // mission, episode, map, vertex,  oldx,  oldy,  newx,  newy

    { doom,          1,   3,    771,  -328, -1920,  -320, -1920 },

    { doom,          2,   2,   1344,  1312,  3992,  1312,  4000 },

    { doom,          2,   6,    646,    64,  2008,    66,  2006 },
    { doom,          2,   6,    647,   112,  1960,   111,  1961 },
    { doom,          2,   6,    648,  -368,  1960,  -367,  1961 },
    { doom,          2,   6,    649,  -320,  2008,  -322,  2006 },

    { doom,          2,   7,    255,  2880,   624,  2880,   629 },
    { doom,          2,   7,    378,  3824,   640,  3828,   640 },
    { doom,          2,   7,    379,  3840,   624,  3840,   629 },
    { doom,          2,   7,    379,  2896,   640,  2892,   640 },
    { doom,          2,   7,    381,  2896,   640,  2892,   640 },
    { doom,          2,   7,    393,  1944,  1024,  1952,  1024 },
    { doom,          2,   7,    495,  1944,   960,  1952,   960 },

    { doom2,         1,   1,    288,  1984,  3784,  1984,  3776 },
    { doom2,         1,   1,    288,   320,  1416,   320,  1408 },

    { doom2,         1,   2,    273,   736,  1216,   736,  1208 },
    { doom2,         1,   2,    289,  2336,  2952,  2336,  2944 },

    { -1,            0,   0,      0,     0,     0,     0,     0 }
};

linefix_t linefix[] =
{
   // mission,    episode, map, linedef, side, toptexture, middletexture, bottomtexture,  offset, rowoffset, flags,                     special,                                             tag

    { doom,             1,   1,     159,    1, "",         "",            "",            DEFAULT,   DEFAULT, ML_SECRET,                 DEFAULT,                                         DEFAULT },
    { doom,             1,   1,     471,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_LowerToLowestFloor_ChangesTexture,      DEFAULT },
    { doom,             1,   1,     477,    1, "",         "",            "",            DEFAULT,   DEFAULT, ML_SECRET,                 DEFAULT,                                         DEFAULT },
    { doom,             1,   1,     479,    1, "",         "",            "",            DEFAULT,   DEFAULT, ML_SECRET,                 DEFAULT,                                         DEFAULT },
    { doom,             1,   1,     480,    1, "",         "",            "",            DEFAULT,   DEFAULT, ML_SECRET,                 DEFAULT,                                         DEFAULT },
    { doom,             1,   1,     482,    1, "",         "",            "",            DEFAULT,   DEFAULT, (ML_DONTDRAW | ML_SECRET), DEFAULT,                                         DEFAULT },
    { doom,             1,   1,     483,    1, "",         "",            "",            DEFAULT,   DEFAULT, (ML_DONTDRAW | ML_SECRET), DEFAULT,                                         DEFAULT },

    { doom,             1,   2,     134,    1, "STARTAN2", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   2,     574,    0, "",         "",            "",            DEFAULT,       -24, ML_DRAWASWALL,             DEFAULT,                                         DEFAULT },
    { doom,             1,   2,     575,    0, "",         "",            "",               -128,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   2,     576,    0, "",         "-",           "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             1,   2,     577,    0, "",         "-",           "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             1,   2,     578,    0, "",         "-",           "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             1,   2,     689,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             1,   4,     321,    0, "",         "",            "STEP2",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   4,     327,    0, "",         "",            "STEP2",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   4,     338,    0, "",         "",            "STEP2",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   4,     346,    0, "",         "",            "STEP2",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   4,     608,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             1,   4,     609,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             1,   4,     693,    1, "BROWN1",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             1,   6,      30,    0, "",         "",            "",                  1,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   6,      31,    0, "",         "",            "",                  2,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   6,    1026,    0, "",         "SUPPORT2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             1,   7,     447,    0, "",         "-",           "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             1,   7,     450,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DRAWASWALL,             DEFAULT,                                         DEFAULT },
    { doom,             1,   7,     451,    0, "",         "-",           "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             1,   7,     452,    0, "",         "-",           "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             1,   7,     744,    1, "",         "",            "TEKWALL1",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   7,     745,    1, "",         "",            "TEKWALL1",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   7,     746,    1, "",         "",            "TEKWALL1",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   7,     747,    1, "",         "",            "TEKWALL1",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             1,   7,     916,    0, "",         "",            "",                 64,        88, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             1,   8,     176,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_TRIGGER666,             DEFAULT,                                         DEFAULT },

    { doom,             2,   1,      11,    0, "STONE2",   "",            "STONE2",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     174,    0, "",         "",            "",                 87,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     182,    0, "",         "",            "",                 64,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     239,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     240,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     242,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     243,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     244,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     245,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     246,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     247,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     250,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     251,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     252,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     253,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     254,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     255,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     256,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     257,    0, "",         "",            "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     323,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   1,     324,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             2,   2,     536,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DR_Door_Yellow_OpenWaitClose,                    DEFAULT },
    { doom,             2,   2,     547,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DR_Door_Yellow_OpenWaitClose,                    DEFAULT },
    { doom,             2,   2,     947,    1, "BROWN1",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   2,     722,    1, "",         "",            "",                192,      -104, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   2,    1494,    1, "ICKWALL2", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   2,    1505,    0, "",         "",            "",                  0,       -96, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   2,    1506,    0, "",         "",            "",                 64,       -96, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   2,    1596,    1, "WOOD1",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             2,   3,     267,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     268,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     270,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     271,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     502,    1, "",         "MIDVINE2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     518,    0, "",         "",            "",            DEFAULT,        32, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     611,    1, "",         "MIDVINE2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     871,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     872,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     905,    1, "",         "MIDBRN1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     906,    1, "",         "MIDBRN1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     907,    1, "",         "MIDBRN1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     908,    1, "",         "MIDBRN1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     936,    1, "",         "MIDVINE2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   3,     938,    1, "",         "MIDVINE2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             2,   4,     485,    0, "",         "",            "",                 32,       -40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     498,    0, "",         "",            "",            DEFAULT,       -40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     551,    1, "PIPE4",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     865,    1, "",         "",            "STEP5",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     866,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     876,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     931,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     932,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     933,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     934,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             2,   4,     935,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             2,   4,     936,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             2,   4,     955,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,     999,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,    1000,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,    1001,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,    1002,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,    1003,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,    1062,    0, "GRAYVINE", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   4,    1071,    0, "MARBLE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             2,   5,     184,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             2,   5,     382,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                             100 },
    { doom,             2,   5,     388,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                             100 },
    { doom,             2,   5,     590,    0, "",         "",            "STEP1",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   5,     590,    1, "BROVINE",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   5,    1027,    1, "COMPSPAN", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   5,    1045,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             2,   5,    1059,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },

    { doom,             2,   6,       0,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             2,   6,      51,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             2,   6,     302,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             2,   6,     460,    0, "",         "",            "",                -12,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     461,    0, "",         "",            "",                 -8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     462,    0, "",         "",            "",                -12,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     463,    0, "",         "",            "",                -12,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     464,    0, "",         "",            "",                 -8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     465,    0, "",         "",            "",                -12,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     466,    0, "",         "",            "",                 -8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     475,    0, "",         "",            "",                 12,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     478,    0, "",         "",            "",                 12,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     482,    0, "",         "",            "",                  8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     499,    0, "",         "",            "",                  8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     501,    0, "",         "",            "",                 10,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     747,    0, "",         "",            "",                  0,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     750,    0, "",         "",            "",                  0,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     756,    0, "",         "",            "",                 -1,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     757,    0, "",         "",            "",                 -1,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     758,    0, "",         "",            "",                 -1,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,     779,    0, "",         "",            "",                 -1,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   6,    1091,    1, "COMPSPAN", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             2,   7,      38,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,      40,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,      42,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,      45,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,      48,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     193,    1, "BROWNHUG", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     209,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     216,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     235,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     285,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     315,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     345,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     346,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     347,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     359,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     467,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     468,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     469,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     470,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     484,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     485,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     486,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     491,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     492,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     493,    0, "",         "",            "",            DEFAULT,        56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     673,    0, "",         "",            "",            DEFAULT,        36, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     674,    0, "",         "",            "",            DEFAULT,        36, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     675,    0, "",         "",            "",            DEFAULT,        36, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     676,    0, "",         "",            "",            DEFAULT,        36, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     677,    0, "",         "",            "",            DEFAULT,        36, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     678,    0, "",         "",            "",            DEFAULT,        36, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     991,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     992,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     993,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     994,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     995,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     996,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,     997,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1125,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                               DEFAULT },
    { doom,             2,   7,    1286,    0, "",         "",            "SHAWN2",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1362,    0, "",         "",            "",               -182,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1363,    0, "",         "",            "",               -118,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1364,    0, "",         "",            "",                -24,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1365,    0, "",         "",            "",                -91,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1366,    0, "",         "",            "",                  0,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1367,    0, "",         "",            "",                 64,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1368,    0, "",         "",            "",               -209,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1369,    0, "",         "",            "",                -17,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1437,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1438,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1439,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1440,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1441,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1442,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1443,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1444,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1445,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1446,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1447,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1448,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1449,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1450,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1451,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1452,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1453,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1454,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1455,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1456,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1457,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1458,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1459,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1460,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1461,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1462,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1463,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1464,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1465,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1466,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1467,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1468,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1469,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1470,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1471,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1472,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1473,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1474,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1475,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1476,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1477,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1478,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1479,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1480,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1481,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1482,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1483,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1484,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1485,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1486,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1487,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1488,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1489,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1490,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1491,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1492,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1493,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1494,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1495,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1496,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1497,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1498,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1499,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1500,    0, "",         "",            "",                 -9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1501,    0, "",         "",            "",                  9,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1502,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1503,    0, "",         "",            "",                 50,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1504,    0, "",         "",            "",                 66,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1505,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   7,    1506,    0, "",         "",            "",                107,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             2,   9,     110,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   9,     115,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   9,     121,    1, "SW1LION",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   9,     123,    1, "GSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             2,   9,     140,    1, "GSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             3,   2,     146,    1, "",         "MIDVINE1",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   2,     152,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   2,     154,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   2,     452,    0, "",         "",            "",            DEFAULT,        -7, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   2,     454,    0, "",         "",            "",            DEFAULT,        -7, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             3,   3,     790,    0, "",         "",            "",            DEFAULT,        -6, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   3,     791,    0, "",         "",            "",            DEFAULT,        -6, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   3,     854,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   3,     855,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   3,     910,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             3,   3,     994,    1, "SLADWALL", "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   3,     995,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   3,     996,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   3,    1055,    0, "",         "NUKESLAD",    "",                  0,         0, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   3,    1056,    0, "",         "NUKESLAD",    "",                 56,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   3,    1057,    0, "",         "NUKESLAD",    "",                 56,         0, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             3,   4,       4,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,     470,    0, "BIGDOOR2", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,     659,    0, "",         "",            "",                  0,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,     660,    0, "",         "",            "",                  0,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,     674,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,     675,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,     776,    0, "",         "",            "",                -23,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,     778,    0, "",         "",            "",                 23,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,     781,    0, "",         "",            "",                -23,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,     783,    0, "",         "",            "",                 11,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   4,    1069,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                               DEFAULT },

    { doom,             3,   5,     557,    0, "",         "",            "",                160,       112, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   5,     833,    0, "",         "FIREWALL",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   5,     834,    0, "",         "FIREWALL",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   5,     836,    0, "",         "FIREWALL",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   5,     839,    0, "",         "FIREWALL",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   5,    1125,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             3,   5,    1283,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             3,   5,    1284,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             3,   5,    1285,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             3,   5,    1291,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             3,   5,    1295,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             3,   5,    1299,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             3,   5,    1329,    1, "",         "",            "METAL",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   5,    1330,    1, "",         "",            "METAL",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             3,   6,     298,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Teleport_MonstersOnly,                        DEFAULT },
    { doom,             3,   6,     299,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Teleport_MonstersOnly,                        DEFAULT },
    { doom,             3,   6,     408,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     410,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     412,    1, "",         "BRNSMAL1",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     414,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     550,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     569,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     580,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     666,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     668,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     669,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     670,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     671,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             3,   6,     672,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },

    { doom,             3,   7,      71,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,      72,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,      73,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,      74,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,      75,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,      76,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,      77,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,      78,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     102,    0, "",         "",            "",            DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     221,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     222,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     223,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     224,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     225,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     226,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     227,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     228,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     229,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     230,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     231,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     232,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     233,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     234,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     235,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     236,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     237,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     238,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     615,    0, "",         "",            "",                 87,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     625,    0, "",         "",            "",                 64,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     683,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     684,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     685,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     686,    0, "",         "",            "GSTONE2",     DEFAULT,       -24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     845,    0, "",         "",            "",            DEFAULT,       -32, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     846,    0, "",         "",            "",            DEFAULT,       -32, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     901,    1, "",         "",            "STEP2",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   7,     971,    1, "SP_HOT1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             3,   9,      24,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DR_Door_OpenWaitClose_AlsoMonsters,              DEFAULT },
    { doom,             3,   9,     102,    1, "",         "",            "STONE",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             3,   9,     445,    1, "",         "",            "GRAY4",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             4,   1,      14,    0, "",         "",            "",                  3,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      15,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      23,    0, "",         "",            "",                 48,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      24,    0, "",         "",            "",                 48,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      26,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      27,    0, "",         "",            "",                  3,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      58,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      63,    0, "",         "",            "",                 11,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      64,    0, "",         "",            "",                -34,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      66,    0, "",         "",            "",                 23,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      67,    0, "",         "",            "",                 23,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      68,    0, "",         "",            "",                 23,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      72,    0, "",         "",            "",                 23,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      80,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      81,    0, "",         "",            "",                 48,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      83,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      84,    0, "",         "",            "",                 48,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      91,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      92,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      95,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,      96,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     124,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     126,    0, "",         "",            "",            DEFAULT,        -1, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     156,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     165,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     192,    0, "",         "",            "",                 23,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     193,    0, "",         "",            "",                 33,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     194,    0, "",         "",            "",                 23,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     195,    0, "",         "",            "",                 33,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     214,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     215,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     227,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     230,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     252,    1, "SUPPORT3", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     253,    1, "SUPPORT3", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     254,    1, "SUPPORT3", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     255,    1, "SUPPORT3", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     293,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     294,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     298,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     299,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     306,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     325,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     341,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     342,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     381,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     382,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     437,    0, "",         "",            "",                 40,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     446,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     447,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     451,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     452,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     456,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     458,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     466,    0, "",         "",            "",                 -4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     468,    0, "",         "",            "",                 -8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   1,     470,    0, "GSTONE1",  "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             4,   2,     165,    1, "WOOD5",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     219,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     220,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     221,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     236,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     416,    0, "",         "",            "",                 18,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     417,    0, "",         "",            "",                 18,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     584,    0, "",         "",            "",               -143,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     585,    0, "",         "",            "",                128,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     587,    0, "",         "",            "",            DEFAULT,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     588,    0, "",         "",            "",            DEFAULT,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     591,    0, "",         "",            "",                -96,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     690,    0, "",         "",            "",                100,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     619,    0, "",         "",            "",                 36,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     620,    0, "",         "",            "",                 52,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     621,    0, "",         "",            "",                 84,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     622,    0, "",         "",            "",                -64,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     623,    0, "",         "",            "",                -16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   2,     630,    0, "",         "",            "",                -48,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             4,   3,      46,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   WR_Lift_LowerWaitRaise,                          DEFAULT },
    { doom,             4,   3,     364,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             4,   3,     365,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             4,   3,     735,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToLowestCeiling,                   DEFAULT },
    { doom,             4,   3,     808,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },

    { doom,             4,   4,      15,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      16,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      86,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      87,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      88,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      89,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      90,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      91,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      92,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      93,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      94,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      95,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      96,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,      97,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     427,    1, "BROWNHUG", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     428,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     429,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     430,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     431,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     432,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     433,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     434,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     435,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     436,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     437,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     438,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     439,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     440,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     441,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     442,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     443,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     444,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     445,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     446,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     447,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     448,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     449,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     450,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     451,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     452,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     453,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     454,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     455,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     456,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     457,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     458,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     459,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     558,    1, "BROWNHUG", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     567,    0, "BROWNHUG", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     572,    0, "BROWNHUG", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     585,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     586,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     589,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     590,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     596,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     597,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     602,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     603,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     608,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     609,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     614,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     615,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     619,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     620,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     624,    0, "",         "",            "",                -58,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   4,     625,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             4,   5,       0,    0, "",         "",            "FIRELAV3",    DEFAULT,         3, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,       5,    1, "",         "",            "FIRELAV3",    DEFAULT,         3, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,      19,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,      35,    1, "",         "",            "FIRELAV3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     109,    1, "GSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     155,    1, "",         "",            "FIRELAV3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     182,    0, "",         "",            "FIRELAV3",    DEFAULT,         3, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     183,    0, "",         "",            "FIRELAV3",    DEFAULT,         3, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     184,    0, "",         "",            "FIRELAV3",    DEFAULT,         3, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     308,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             4,   5,     309,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             4,   5,     310,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             4,   5,     311,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             4,   5,     312,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             4,   5,     331,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom,             4,   5,     367,    0, "",         "",            "FIRELAV3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     368,    0, "",         "",            "FIRELAV3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     407,    0, "",         "",            "FIRELAV3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     408,    0, "",         "",            "FIRELAV3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     625,    1, "",         "",            "FIRELAV3",    DEFAULT,         3, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     711,    1, "",         "",            "FIRELAV3",    DEFAULT,         3, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     713,    1, "",         "",            "FIRELAV3",    DEFAULT,         3, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     974,    0, "",         "",            "",            DEFAULT,       -56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     975,    0, "",         "",            "",            DEFAULT,       -56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     976,    0, "",         "",            "",            DEFAULT,       -56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     977,    0, "",         "",            "",            DEFAULT,       -56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     978,    0, "",         "",            "",            DEFAULT,       -56, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     985,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     986,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     987,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     988,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     989,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     990,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     991,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     992,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     993,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     994,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     995,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     996,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     997,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     998,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,     999,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1000,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1001,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1002,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1003,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1004,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1005,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1006,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1007,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1008,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1009,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1010,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1011,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1012,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1013,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1014,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1015,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   5,    1016,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             4,   6,     192,    0, "",         "",            "",                 56,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     450,    0, "",         "",            "",                -23,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     452,    0, "",         "",            "",                -23,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     475,    1, "MARBLE2",  "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     476,    1, "MARBLE2",  "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     479,    1, "MARBLE2",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     480,    1, "MARBLE2",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     481,    1, "MARBLE2",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     482,    1, "MARBLE2",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     814,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     817,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     819,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     822,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     823,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     826,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     828,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     831,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     848,    0, "",         "",            "",                -16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     850,    0, "",         "",            "",                -16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     855,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     858,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     860,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     863,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     865,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     868,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     870,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     873,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     887,    0, "",         "",            "",                -16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,     889,    0, "",         "",            "",                -16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   6,    1129,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_TRIGGER666,             DEFAULT,                                         DEFAULT },

    { doom,             4,   7,     279,    0, "",         "",            "",            DEFAULT,       142, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     325,    1, "",         "BRNBIGR",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     326,    1, "",         "BRNBIGC",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     327,    1, "",         "BRNBIGL",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     451,    1, "",         "BRNBIGR",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     452,    1, "",         "BRNBIGC",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     453,    1, "",         "BRNBIGL",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     475,    0, "",         "",            "",            DEFAULT,       142, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     477,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     478,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     989,    0, "",         "",            "",            DEFAULT,        94, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   7,     991,    0, "",         "",            "",            DEFAULT,        94, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             4,   8,      69,    0, "",         "",            "",                 24,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,      94,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     103,    1, "",         "",            "SUPPORT3",          4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     191,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     192,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     193,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     194,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     222,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     223,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     224,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     225,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     226,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     227,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     228,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     229,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     232,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     233,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     234,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     236,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     231,    0, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, ML_TRIGGER666,             DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     418,    0, "",         "SP_HOT1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     419,    0, "",         "SP_HOT1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     420,    0, "",         "SP_HOT1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     425,    0, "",         "SP_HOT1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     513,    0, "",         "",            "",            DEFAULT,       -16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     570,    0, "",         "",            "",            DEFAULT,       -16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     576,    0, "",         "",            "",            DEFAULT,       -16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     579,    0, "",         "",            "",            DEFAULT,       -16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     596,    0, "",         "",            "",            DEFAULT,       -16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,     604,    0, "",         "",            "",            DEFAULT,       -16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,    1203,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,    1204,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,    1230,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,    1232,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,    1234,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,    1235,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,    1238,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   8,    1240,    0, "",         "",            "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             4,   9,    1583,    0, "",         "",            "",            DEFAULT,      -120, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   9,    1584,    0, "",         "",            "",                 64,      -120, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom,             4,   9,    1585,    0, "",         "",            "",            DEFAULT,      -120, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom,             5,   1,     212,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   1,     213,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   1,     214,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   1,     215,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   1,     218,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   1,     219,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },

    { doom,             5,   4,    1727,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   4,    2048,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   4,    2050,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   4,    2063,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },

    { doom,             5,   7,    1142,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   7,    1650,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   7,    2113,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom,             5,   7,    2114,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },

   // mission,    episode, map, linedef, side, toptexture, middletexture, bottomtexture,  offset, rowoffset, flags,                     special,                                             tag

    { doom2,            1,   1,     169,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   1,     334,    1, "",         "MIDBARS3",    "BROWNGRN",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   1,     335,    1, "",         "MIDBARS3",    "BROWNGRN",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   1,     369,    1, "",         "MIDBARS3",    "BROWNGRN",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,   2,     327,    0, "",         "",            "STONE4",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   2,     328,    0, "",         "",            "STONE4",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   2,     338,    0, "",         "",            "STONE4",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   2,     339,    0, "",         "",            "STONE4",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,   4,       3,    1, "",         "",            "STUCCO",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,      92,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,      94,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,      96,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,      98,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     101,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     103,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     104,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     106,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     108,    0, "STONE",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     109,    0, "STONE",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     110,    0, "STONE",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     111,    0, "STONE",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     127,    0, "STONE",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     128,    0, "STONE",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     187,    1, "",         "",            "STUCCO",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     200,    1, "",         "",            "STUCCO",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     201,    1, "",         "",            "STUCCO",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   4,     456,    1, "SUPPORT3", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,   5,     489,    1, "SUPPORT3", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   5,     560,    1, "SUPPORT3", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,   6,     104,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   6,     111,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   6,     171,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },

    { doom2,            1,   7,     162,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_TRIGGER666,             DEFAULT,                                         DEFAULT },
    { doom2,            1,   7,     168,    1, "",         "",            "TANROCK4",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,   8,     101,    1, "BRICK7",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   8,     219,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     220,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     221,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     222,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     223,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     224,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     225,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     226,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     227,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     228,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     229,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     230,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,   8,     232,    0, "",         "",            "STEP2",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,   8,     270,    1, "COMPTALL", "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { doom2,            1,   8,     276,    1, "COMPTALL", "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { doom2,            1,   8,     598,    0, "",         "GRAY5",       "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  10,     638,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  10,     782,    0, "",         "",            "",                103,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  10,     786,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DR_Door_OpenWaitClose_AlsoMonsters,              DEFAULT },
    { doom2,            1,  10,     880,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  10,     899,    1, "",         "-",           "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  10,     900,    1, "",         "-",           "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  10,     901,    1, "",         "-",           "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  10,     902,    1, "",         "-",           "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  12,      41,    0, "",         "",            "",            DEFAULT,        48, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,      45,    0, "",         "",            "",                 -8,        48, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,     218,    0, "",         "",            "",            DEFAULT,        32, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,     223,    0, "",         "",            "",            DEFAULT,        32, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,     269,    0, "",         "PANEL6",      "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,     311,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom2,            1,  12,     549,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,     556,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,     557,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,     558,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,     632,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                               DEFAULT },
    { doom2,            1,  12,     648,    1, "",         "",            "PIPES",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  12,     773,    1, "",         "",            "PANCASE2",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  13,     147,    0, "",         "",            "",                 22,       112, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     268,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     270,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { doom2,            1,  13,     273,    1, "GRAYVINE", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     305,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     308,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     318,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     320,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     321,    1, "",         "",            "",                123,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     331,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     529,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     546,    1, "",         "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     547,    1, "",         "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     548,    1, "",         "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     553,    1, "",         "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     574,    0, "",         "",            "",                  2,        32, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     575,    0, "",         "",            "",                -24,        32, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     581,    0, "",         "",            "",                  2,        32, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     582,    0, "",         "",            "",                -32,        32, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     584,    0, "",         "",            "",                 56,        24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     592,    0, "",         "",            "",                 -8,        24, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     593,    0, "",         "",            "",                 17,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     622,    1, "BROWNGRN", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     790,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     791,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     792,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     806,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     807,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     810,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     811,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     842,    0, "",         "",            "",                 -8,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     846,    0, "",         "",            "",                 64,        40, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     879,    1, "BROWN144", "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,     880,    1, "",         "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,    1155,    0, "",         "",            "",                 -8,      -120, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  13,    1157,    0, "",         "",            "",                  8,      -120, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  14,     191,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     237,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     331,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     429,    0, "BSTONE2",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     430,    0, "BSTONE2",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     531,    0, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     607,    1, "BSTONE2",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     608,    1, "BSTONE2",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     609,    1, "BSTONE2",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     626,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     786,    1, "TANROCK5", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     787,    1, "TANROCK5", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     788,    1, "TANROCK5", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     789,    1, "TANROCK5", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     791,    1, "TANROCK5", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,     792,    1, "TANROCK5", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1133,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1134,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1135,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1137,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1138,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1139,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1140,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1141,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1142,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1259,    1, "BSTONE2",  "",            "BSTONE2",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  14,    1305,    1, "BSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  15,      94,    1, "BRICK1",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  15,      95,    1, "BRICK1",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  15,     989,    1, "BRICK10",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  16,     162,    1, "BRICK6",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  16,     303,    0, "STUCCO1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  16,     304,    0, "STUCCO1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  16,     328,    1, "",         "",            "ROCK3",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  16,     515,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  16,     525,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },

    { doom2,            1,  17,     182,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  17,     316,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  17,     379,    1, "METAL2",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  17,     726,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },

    { doom2,            1,  18,       5,    0, "",         "SUPPORT3",    "",                  4,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,      17,    0, "",         "",            "",            DEFAULT,        64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,      18,    0, "",         "",            "",            DEFAULT,        64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,      91,    0, "",         "",            "",                -32,       -80, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     364,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,  18,     368,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,  18,     385,    0, "",         "",            "",            DEFAULT,       -16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     386,    0, "",         "",            "",            DEFAULT,       -80, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     451,    0, "",         "DOORSTOP",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     459,    0, "",         "DOORSTOP",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     483,    0, "",         "",            "",                  8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     574,    0, "GRAYVINE", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     648,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     649,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     650,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     651,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     652,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     653,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     654,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  18,     655,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  19,       1,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,       3,    0, "",         "",            "",            DEFAULT,         8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     286,    1, "",         "",            "STEP4",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     287,    1, "",         "",            "STEP4",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     288,    1, "",         "",            "STEP4",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     355,    1, "STONE2",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     455,    1, "",         "",            "METAL",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     521,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     529,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     558,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     559,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     560,    0, "",         "",            "",            DEFAULT,        -8, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     577,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     578,    1, "",         "BRNSMAL1",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     618,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,     736,    0, "SLADWALL", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,    1181,    1, "MARBLE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  19,    1229,    0, "MARBGRAY", "",            "",            DEFAULT,        16, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  20,      73,    1, "",         "",            "SP_HOT1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  20,      74,    1, "",         "",            "SP_HOT1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  20,      75,    1, "",         "",            "SP_HOT1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  20,      76,    1, "",         "",            "SP_HOT1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  20,     453,    1, "",         "",            "STONE7",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  22,     120,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   S1_Floor_RaiseToNextHighestFloor_ChangesTexture, DEFAULT },
    { doom2,            1,  22,     158,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     223,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     442,    1, "METAL",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     443,    1, "METAL",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     530,    0, "METAL2",   "",            "METAL2",      DEFAULT,   DEFAULT, ML_DRAWASWALL,             DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     539,    0, "METAL2",   "",            "METAL2",      DEFAULT,   DEFAULT, ML_DRAWASWALL,             DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     542,    0, "METAL2",   "",            "METAL2",      DEFAULT,   DEFAULT, ML_DRAWASWALL,             DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     543,    0, "METAL2",   "",            "METAL2",      DEFAULT,   DEFAULT, ML_DRAWASWALL,             DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     544,    0, "METAL2",   "",            "METAL2",      DEFAULT,   DEFAULT, ML_DRAWASWALL,             DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     545,    0, "METAL2",   "",            "METAL2",      DEFAULT,   DEFAULT, ML_DRAWASWALL,             DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     548,    0, "METAL2",   "",            "METAL2",      DEFAULT,   DEFAULT, ML_DRAWASWALL,             DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     607,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  22,     610,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },

    { doom2,            1,  24,     687,    1, "",         "",            "SILVER2",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  24,     688,    1, "",         "",            "SILVER2",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  24,    1038,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },

    { doom2,            1,  25,     348,    1, "",         "MIDSPACE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  25,     349,    1, "",         "MIDSPACE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  25,     436,    1, "BFALL1",   "BFALL1",      "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  25,     613,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { doom2,            1,  25,     614,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },

    { doom2,            1,  26,      14,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  26,     761,    1, "METAL2",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  27,     342,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_BLOCKING,               DEFAULT,                                         DEFAULT },
    { doom2,            1,  27,     580,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   D1_Door_OpenStay,                                DEFAULT },
    { doom2,            1,  27,     581,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   D1_Door_OpenStay,                                DEFAULT },
    { doom2,            1,  27,     582,    1, "ZIMMER3",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  27,     727,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   SR_Floor_LowerTo8AboveHighestFloor,              DEFAULT },
    { doom2,            1,  27,     810,    1, "",         "",            "WOODVERT",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  27,     814,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DR_Door_Red_OpenWaitClose,                       DEFAULT },

    { doom2,            1,  28,      38,    1, "",         "",            "ZIMMER8",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,      39,    1, "",         "",            "ZIMMER8",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     103,    0, "ASHWALL6", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     104,    0, "ASHWALL6", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     105,    0, "ASHWALL6", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     106,    0, "ASHWALL6", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     107,    0, "ASHWALL6", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     161,    1, "",         "",            "ZIMMER8",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     170,    1, "",         "",            "BFALL4",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     213,    1, "",         "",            "ZIMMER8",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     214,    1, "",         "",            "ZIMMER8",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     215,    1, "",         "",            "ZIMMER8",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     221,    0, "",         "",            "BFALL4",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     256,    1, "",         "",            "ZIMMER8",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     388,    1, "",         "",            "FIREBLU2",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     391,    0, "BIGDOOR5", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     531,    1, "WOOD8",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     547,    1, "WOOD8",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     548,    1, "WOOD8",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     584,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     585,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     586,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     587,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     588,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     589,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     590,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     591,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     592,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     593,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     594,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     595,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor,                      5 },
    { doom2,            1,  28,     650,    1, "",         "MIDBARS1",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     651,    1, "",         "MIDBARS1",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  28,     652,    1, "",         "MIDBARS1",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  29,     405,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     406,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     407,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     408,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     516,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     517,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     518,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     519,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     524,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     525,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     526,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     527,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,     603,    1, "WOOD5",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,    1138,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,    1139,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,    1140,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,    1141,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,    1146,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,    1147,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,    1148,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  29,    1149,    1, "",         "",            "SUPPORT3",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  30,      55,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },

    { doom2,            1,  31,      32,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,      34,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,      41,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,      43,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,      57,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     137,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     163,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     210,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     218,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     226,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     234,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     243,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     251,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     259,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     266,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     274,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     282,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     316,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     330,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     338,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     364,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     409,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     431,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     452,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     459,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     569,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     594,    0, "ZDOORB1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     666,    0, "",         "",            "",                 25,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     667,    0, "",         "BRICK1",      "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     668,    0, "",         "",            "",                 25,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     669,    0, "",         "BRICK1",      "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     670,    0, "",         "",            "",                 25,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     671,    0, "",         "BRICK1",      "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     672,    0, "",         "",            "",                 25,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  31,     673,    0, "",         "BRICK1",      "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  32,      30,    0, "",         "",            "",            DEFAULT,         0, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { doom2,            1,  32,      31,    0, "",         "",            "",            DEFAULT,         0, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { doom2,            1,  33,     400,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                              41 },
    { doom2,            1,  33,     401,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                              41 },
    { doom2,            1,  33,     559,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                              41 },
    { doom2,            1,  33,     560,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                              41 },

   // mission,    episode, map, linedef, side, toptexture, middletexture, bottomtexture,  offset, rowoffset, flags,                     special,                                             tag

    { pack_nerve,       1,   1,    3434,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   D1_Door_OpenStay,                                DEFAULT },
    { pack_nerve,       1,   1,    3436,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   D1_Door_OpenStay,                                DEFAULT },

    { pack_nerve,       1,   2,     431,    1, "",         "BRNSMALR",    "",                 11,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,     433,    1, "",         "BRNSMALC",    "",                 -5,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,     427,    1, "",         "BRNSMALL",    "",                 11,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,     633,    1, "",         "BRNSMALR",    "",                 11,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,     411,    1, "",         "BRNSMALC",    "",                 -5,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,     409,    1, "",         "BRNSMALL",    "",                 11,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,     638,    1, "",         "BRNSMALR",    "",                 11,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,     639,    1, "",         "BRNSMALC",    "",                 -5,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,     637,    1, "",         "BRNSMALL",    "",                 11,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1070,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1071,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1072,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1073,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1173,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1175,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1204,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1205,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1206,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1208,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1209,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1210,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1221,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1222,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1223,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1228,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1229,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1230,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1232,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1233,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1234,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1245,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1246,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1247,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1248,    0, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1271,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   2,    1273,    1, "",         "",            "BROWN96",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_nerve,       1,   3,    1406,    1, "",         "",            "TANROCK5",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   3,    1429,    0, "",         "",            "TANROCK5",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   3,    1434,    0, "",         "",            "TANROCK5",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_nerve,       1,   4,    2234,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   4,    2515,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    2516,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    2517,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    2524,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    2532,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    2533,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    2534,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    2904,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    3765,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   4,    3768,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   4,    3933,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    4067,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    4069,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   4,    4456,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   4,    4457,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   4,    4458,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   4,    4461,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   4,    4462,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   4,    4463,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },

    { pack_nerve,       1,   5,    1361,    0, "",         "MIDGRATE",    "",                 30,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   5,    2243,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_nerve,       1,   7,     739,    1, "",         "MIDGRATE",    "",               -150,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1146,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { pack_nerve,       1,   7,    1374,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1375,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1376,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1377,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1382,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1383,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1384,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1540,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1541,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    1542,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    2508,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                               0 },
    { pack_nerve,       1,   7,    2542,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    2547,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    2550,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_nerve,       1,   7,    2552,    1, "",         "MIDGRATE",    "",            DEFAULT,      -256, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_nerve,       1,   9,    1327,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   9,    1337,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_nerve,       1,   9,    1339,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },

   // mission,    episode, map, linedef, side, toptexture, middletexture, bottomtexture,  offset, rowoffset, flags,                     special,                                             tag

    { pack_plut,        1,   1,    1110,    0, "",         "",            "",                  0,         0, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,   4,     303,    1, "",         "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,   4,     308,    1, "",         "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,   4,     762,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,   4,     763,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,   4,     975,    0, "",         "",            "",                 87,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,   6,    1337,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,   6,    1343,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,   8,     187,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },
    { pack_plut,        1,   8,     236,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,   8,     239,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,   8,     247,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,   8,     249,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  10,     254,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  10,     548,    0, "",         "",            "METAL",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  10,    1010,    0, "GSTONE1",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  12,     230,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, ML_BLOCKING,               DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  13,     107,    1, "A-BROWN1", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  13,     119,    1, "A-BROWN1", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  13,    1060,    0, "A-BROWN1", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  14,    1099,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  14,    1103,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  14,    1109,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  14,    1113,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  15,     407,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  15,     874,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  16,     667,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  17,     253,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  17,     265,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  17,     379,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  18,     986,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  19,     361,    1, "",         "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  19,     366,    1, "",         "MIDBRONZ",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  20,     267,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     276,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     278,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     297,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     315,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     331,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     333,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     511,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     517,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     876,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     882,    0, "",         "",            "",            DEFAULT,        72, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,     904,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,    1110,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  20,    1115,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  22,      58,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,      61,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,     375,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,     393,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1026,    0, "",         "",            "",                 45,       -88, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1028,    0, "",         "",            "",                 64,       -88, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1033,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1034,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1035,    1, "",         "A-RAIL1",     "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1085,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1086,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1087,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1088,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1089,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1090,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1091,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1122,    0, "METAL",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1123,    1, "",         "",            "METAL",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1135,    0, "METAL",    "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1136,    1, "",         "",            "METAL",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1680,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1681,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1682,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1683,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1684,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1685,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  22,    1686,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  23,    1100,    0, "",         "",            "",            DEFAULT,        16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  23,    1353,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  23,    1463,    1, "",         "BRNSMALR",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  23,    1468,    1, "",         "BRNSMALC",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  23,    1469,    1, "",         "BRNSMALL",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  25,    1073,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1074,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1075,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1076,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1077,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1078,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1079,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1152,    0, "A-BROCK2", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1153,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1154,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1155,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1156,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1157,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1158,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  25,    1159,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTDRAW,               DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  26,     322,    0, "A-MUD",    "A-MUD",       "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  26,     323,    0, "A-MUD",    "A-MUD",       "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  28,     179,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,     195,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,     199,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,     204,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,     675,    0, "",         "",            "BRICK10",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,     676,    0, "",         "",            "BRICK10",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,     834,    0, "",         "",            "WOOD8",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,     835,    0, "",         "",            "WOOD8",       DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    1232,    0, "",         "",            "",            DEFAULT,        -1, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    1233,    0, "",         "",            "",            DEFAULT,        -1, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    1234,    0, "",         "",            "",            DEFAULT,        -1, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    1235,    0, "",         "",            "",            DEFAULT,        -1, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    2073,    0, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    2352,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    2360,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    2460,    0, "BIGDOOR7", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    2496,    0, "BRICK10",  "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  28,    2496,    1, "",         "",            "METAL2",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  29,    1144,    0, "",         "",            "",                -37,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  29,    1147,    0, "",         "",            "",                 19,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  29,    1150,    0, "",         "",            "",                 10,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  29,    2842,    0, "A-BROCK2", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  29,    2936,    0, "",         "",            "",                 22,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  29,    2938,    0, "",         "",            "",                 26,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  30,     730,    0, "ROCKRED1", "",            "ROCKRED1",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  31,     682,    1, "",         "MIDBARS1",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  31,     929,    0, "",         "",            "",            DEFAULT,        54, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_plut,        1,  32,     569,    0, "A-MOSROK", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  32,     570,    0, "A-MOSROK", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  32,     571,    0, "A-MOSROK", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  32,     572,    0, "A-MOSROK", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_plut,        1,  32,     805,    0, "A-BRICK3", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

   // mission,    episode, map, linedef, side, toptexture, middletexture, bottomtexture,  offset, rowoffset, flags,                     special,                                             tag

    { pack_tnt,         1,   1,      47,    0, "",         "",            "",                  8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,   3,     880,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,     885,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,     889,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,     890,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1108,    0, "",         "",            "",                  8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1110,    0, "",         "",            "",                  8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1111,    0, "",         "",            "",                 24,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1113,    0, "",         "",            "",                 24,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1120,    0, "",         "",            "",                 24,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1121,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1122,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1124,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1132,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1134,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1135,    0, "",         "",            "",                 -8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1140,    0, "",         "",            "",                -24,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1144,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1145,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1153,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1211,    0, "",         "",            "",                 48,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1221,    0, "",         "",            "",                112,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1249,    0, "",         "",            "",                 45,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1251,    0, "",         "",            "",                -45,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1291,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1293,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1298,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1299,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1300,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1301,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1302,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1304,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1306,    0, "",         "",            "",                 11,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1310,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1315,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1316,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1318,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1319,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1320,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1321,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1324,    0, "",         "",            "",                -11,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1327,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1331,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1332,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1333,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1335,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1336,    0, "",         "",            "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1337,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1338,    0, "",         "",            "",                 24,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1339,    0, "",         "",            "",                 -8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1340,    0, "",         "",            "",                  8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1341,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1346,    0, "",         "",            "",                  8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1348,    0, "",         "",            "",                -16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1350,    0, "",         "",            "",                 24,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1354,    0, "",         "",            "",                -16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1356,    0, "",         "",            "",                  8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1358,    0, "",         "",            "",                 -8,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1362,    0, "",         "",            "",                -24,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1364,    0, "",         "",            "",                 16,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1366,    0, "",         "",            "",                  3,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,   3,    1367,    0, "",         "",            "",                 11,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,   7,     999,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor_Fast,                16 },
    { pack_tnt,         1,   7,    1000,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor_Fast,                16 },
    { pack_tnt,         1,   7,    1001,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor_Fast,                16 },
    { pack_tnt,         1,   7,    1002,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor_Fast,                16 },
    { pack_tnt,         1,   7,    1003,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor_Fast,                16 },
    { pack_tnt,         1,   7,    1004,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor_Fast,                16 },
    { pack_tnt,         1,   7,    1005,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor_Fast,                16 },
    { pack_tnt,         1,   7,    1006,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor_Fast,                16 },
    { pack_tnt,         1,   7,    1007,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   W1_Floor_RaiseToNextHighestFloor_Fast,                16 },

    { pack_tnt,         1,   8,     480,    1, "",         "",            "METAL2",      DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,  11,    1087,    0, "",         "",            "GRAY4",       DEFAULT,         2, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,  18,      52,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  18,      57,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  18,      63,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  18,      69,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  18,      76,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  18,      77,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  18,      85,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  18,      90,    1, "",         "MIDBARS3",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  18,     318,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   0,                                                     0 },

    { pack_tnt,         1,  19,     605,    1, "",         "SMGLASS1",    "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  19,     607,    1, "",         "SMGLASS1",    "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  19,     841,    1, "",         "SMGLASS1",    "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  19,     845,    1, "",         "SMGLASS1",    "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  19,    1369,    1, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  19,    1932,    1, "",         "SMGLASS1",    "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  19,    1937,    1, "",         "SMGLASS1",    "",            DEFAULT,       -64, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,  21,     357,    1, "",         "DOWINDOW",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  21,    1138,    0, "PANEL4",   "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,  23,    1777,    0, "",         "MIDBARS3",    "",            DEFAULT,        16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  23,    1781,    0, "",         "MIDBARS3",    "",            DEFAULT,        16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  23,    1785,    0, "",         "MIDBARS3",    "",            DEFAULT,        16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  23,    1790,    0, "",         "MIDBARS3",    "",            DEFAULT,        16, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  23,    1843,    0, "",         "MIDBARS3",    "",            DEFAULT,        16, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,  25,    1287,    0, "",         "MIDGRATE",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,  26,     813,    1, "",         "TYIRONLG",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  26,     814,    1, "",         "TYIRONLG",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  26,     815,    1, "",         "TYIRONLG",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  26,    1297,    1, "",         "TYIRONLG",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  26,    1298,    1, "",         "TYIRONLG",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  26,    1299,    1, "",         "TYIRONLG",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  26,    1300,    1, "",         "TYIRONLG",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  26,    1301,    1, "",         "TYIRONLG",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  26,    1302,    1, "",         "TYIRONLG",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,  27,    1231,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    1234,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    1237,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    1240,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    1243,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    1246,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    1249,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    1252,    1, "",         "BRNSMAL2",    "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    1604,    1, "ROCKRED1", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    2002,    1, "ROCKRED1", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    2007,    1, "ROCKRED1", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    2008,    1, "ROCKRED1", "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    2131,    1, "",         "",            "ROCKRED1",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    2140,    1, "",         "",            "ROCKRED1",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  27,    2141,    1, "",         "",            "ROCKRED1",    DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,  31,     138,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   S1_Floor_LowerToLowestFloor,                     DEFAULT },
    { pack_tnt,         1,  31,     279,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   S1_Floor_LowerToLowestFloor,                     DEFAULT },
    { pack_tnt,         1,  31,    1251,    0, "",         "",            "",            DEFAULT,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1252,    0, "",         "",            "",            DEFAULT,         4, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1403,    1, "",         "BRICK5",      "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1676,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1677,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1678,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1679,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1680,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1681,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1682,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    1683,    0, "",         "",            "",            DEFAULT,   DEFAULT, ML_DONTPEGBOTTOM,          DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  31,    2527,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   S1_Floor_LowerToLowestFloor,                     DEFAULT },
    { pack_tnt,         1,  31,    2528,    1, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   S1_Floor_LowerToLowestFloor,                     DEFAULT },
    { pack_tnt,         1,  31,    2643,    1, "",         "DRFRONT",     "",                 32,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },

    { pack_tnt,         1,  32,     622,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     627,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     628,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     629,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     630,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     631,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     632,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     633,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     634,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     635,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     636,    1, "",         "",            "GSTONE1",     DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT },
    { pack_tnt,         1,  32,     872,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   SR_Door_OpenStay_Fast,                           DEFAULT },

    { -1,               0,   0,       0,    0, "",         "",            "",            DEFAULT,   DEFAULT, DEFAULT,                   DEFAULT,                                         DEFAULT }
};

sectorfix_t sectorfix[] =
{
   // mission,    episode, map, sector, floorpic,  ceilingpic, floorheight, ceilingheight, special,                            oldtag,  newtag

    { doom,             1,   1,     14, "FLAT18",  "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { doom,             1,   4,     41, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 3,       0 },

    { doom,             1,   9,     46, "",        "",             DEFAULT,           160, DEFAULT,                           DEFAULT, DEFAULT },

    { doom,             2,   4,    173, "BLOOD3",  "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { doom,             2,   4,    177, "BLOOD3",  "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { doom,             2,   5,    127, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 1,     100 },

    { doom,             3,   5,    161, "",        "",                   0,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { doom,             3,   7,     20, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 2,       0 },
    { doom,             3,   7,     23, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 2,       0 },

    { doom,             4,   3,    124, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    125, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    127, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    128, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    129, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    130, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    131, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    132, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    133, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    134, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    136, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    137, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    138, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    147, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    148, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    149, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    150, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    151, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    152, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   3,    155, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },

    { doom,             4,   7,    263, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },
    { doom,             4,   7,    264, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },

    { doom,             5,   4,     67, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },

    { doom2,            1,   1,     29, "RROCK09", "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { doom2,            1,   3,    107, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 1,       0 },

    { doom2,            1,   4,     10, "SLIME15", "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { doom2,            1,   4,     19, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 5,       0 },
    { doom2,            1,   4,     20, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 5,       0 },
    { doom2,            1,   4,     23, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 5,       0 },
    { doom2,            1,   4,     28, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 5,       0 },
    { doom2,            1,   4,     33, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 5,       0 },
    { doom2,            1,   4,     34, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 5,       0 },
    { doom2,            1,   4,     39, "CRATOP1", "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { doom2,            1,   4,     40, "CRATOP1", "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { doom2,            1,   4,     46, "CRATOP1", "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { doom2,            1,   4,     72, "",        "",                  32,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { doom2,            1,   4,     76, "",        "",                  32,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { doom2,            1,   4,     83, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 5,       0 },
    { doom2,            1,   4,     85, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 5,       0 },

    { doom2,            1,   5,      4, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 9,       0 },
    { doom2,            1,   5,     52, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 9,       0 }, // v1.666
    { doom2,            1,   5,    143, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 9,       0 }, // v1.666
    { doom2,            1,   5,    153, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 9,       0 },

    { doom2,            1,  12,    134, "",        "FLOOR4_6",     DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { doom2,            1,  12,    149, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                17,       0 },

    { doom2,            1,  13,    151, "",        "CEIL5_1",      DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { doom2,            1,  14,    106, "",        "",                 176,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { doom2,            1,  15,    147, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },

    { doom2,            1,  19,     63, "",        "",                 176,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { doom2,            1,  21,     50, "",        "",             DEFAULT,           200, DEFAULT,                           DEFAULT, DEFAULT },
    { doom2,            1,  21,     54, "",        "",             DEFAULT,           200, DEFAULT,                           DEFAULT, DEFAULT },

    { doom2,            1,  27,     80, "",        "FLAT5_2",      DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { doom2,            1,  27,     93, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },

    { pack_nerve,       1,   4,    868, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },

    { pack_plut,        1,   4,    103, "RROCK03", "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { pack_plut,        1,   8,    130, "",        "",             DEFAULT,             0, DEFAULT,                           DEFAULT, DEFAULT },

    { pack_plut,        1,  10,     71, "",        "FLOOR7_1",     DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { pack_plut,        1,  16,     95, "",        "",             DEFAULT,       DEFAULT, DamageNegative10Or20PercentHealth, DEFAULT, DEFAULT },
    { pack_plut,        1,  16,     96, "",        "",             DEFAULT,       DEFAULT, DamageNegative10Or20PercentHealth, DEFAULT, DEFAULT },
    { pack_plut,        1,  16,     97, "",        "NUKAGE1",      DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { pack_plut,        1,  16,    104, "",        "NUKAGE1",      DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { pack_plut,        1,  24,     41, "",        "FLAT5_5",      DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { pack_plut,        1,  24,     42, "",        "FLAT5_5",      DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { pack_plut,        1,  26,    156, "",        "",             DEFAULT,       DEFAULT, Normal,                            DEFAULT, DEFAULT },

    { pack_plut,        1,  29,    178, "",        "",                 201,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { pack_plut,        1,  29,    224, "",        "",                 156,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { pack_tnt,         1,   3,    260, "",        "CEIL3_3",      DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },
    { pack_tnt,         1,   3,    329, "",        "CEIL3_3",      DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT },

    { pack_tnt,         1,  15,    330, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                                 0,      11 },

    { -1,               0,   0,      0, "",        "",             DEFAULT,       DEFAULT, DEFAULT,                           DEFAULT, DEFAULT }
};

thingfix_t thingfix[] =
{
   // mission,    episode, map, thing, type,                      oldx,    oldy,    newx,    newy,   angle, options

    { doom,             1,   6,    16, Demon,                      800,    -704,     800,    -688, DEFAULT, DEFAULT                            },
    { doom,             1,   6,   403, Spectre,                  -2016,    2096,   -2016,    2080, DEFAULT, DEFAULT                            },

    { doom,             1,   7,    15, Medikit,                   -304,   -2256,    -304,   -2264, DEFAULT, DEFAULT                            },
    { doom,             1,   7,    16, BoxOfShells,               -272,   -2256,    -272,   -2264, DEFAULT, DEFAULT                            },
    { doom,             1,   7,    17, BoxOfBullets,              -240,   -2256,    -240,   -2264, DEFAULT, DEFAULT                            },
    { doom,             1,   7,    18, Chaingun,                  -208,   -2256,    -208,   -2264, DEFAULT, DEFAULT                            },
    { doom,             1,   7,    19, BoxOfBullets,              -176,   -2256,    -176,   -2264, DEFAULT, DEFAULT                            },

    { doom,             2,   2,     2, Player1Start,               608,    4576,     608,    4574, DEFAULT, DEFAULT                            },
    { doom,             2,   2,     3, Player2Start,                96,    4576,      96,    4574, DEFAULT, DEFAULT                            },

    { doom,             2,   3,    37, Backpack,                   864,    -224,     864,    -216, DEFAULT, DEFAULT                            },

    { doom,             2,   5,    79, Chainsaw,                 -1056,     160,   -1052,     160, DEFAULT, DEFAULT                            },

    { doom,             2,   6,   290, Demon,                      992,    -128,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },
    { doom,             2,   6,   291, Demon,                     1056,    -128,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { doom,             2,   7,   195, HangingVictimTwitching,    3360,     320,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },
    { doom,             2,   7,   196, HangingVictimOneLegged,    3232,       0,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { doom,             3,   2,   186, HangingLeg,                 -80,    1216,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { doom,             3,   3,    19, Cell,                      -480,     864,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { doom,             4,   1,     0, Player1Start,               160,     352,     160,     350, DEFAULT, DEFAULT                            },
    { doom,             4,   1,     1, Player2Start,               288,     352,     288,     350, DEFAULT, DEFAULT                            },
    { doom,             4,   1,     2, Player3Start,               416,     224,     414,     224, DEFAULT, DEFAULT                            },
    { doom,             4,   1,     3, Player4Start,                32,     224,      34,     224, DEFAULT, DEFAULT                            },

    { doom,             4,   3,    69, Imp,                       -608,   -1696,    -640,   -1696, DEFAULT, DEFAULT                            },
    { doom,             4,   3,   232, Rocket,                    1296,    1008,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { doom,             4,   4,   106, Spectre,                    320,    -160,     328,    -128, DEFAULT, DEFAULT                            },
    { doom,             4,   4,   107, Spectre,                    -16,    -160,      -8,    -128, DEFAULT, DEFAULT                            },
    { doom,             4,   4,   108, Cacodemon,                  320,     -96,     328,     -88, DEFAULT, DEFAULT                            },
    { doom,             4,   4,   109, Cacodemon,                  -16,     -96,      -8,     -88, DEFAULT, DEFAULT                            },

    { doom2,            1,   2,    69, Barrel,                    2064,    2528,    2064,    2544, DEFAULT, DEFAULT                            },
    { doom2,            1,   2,    69, Barrel,                     464,     784,     464,     800, DEFAULT, DEFAULT                            },
    { doom2,            1,   2,    84, Barrel,                    2592,    2640,    2592,    2648, DEFAULT, DEFAULT                            },
    { doom2,            1,   2,    84, Barrel,                     992,     896,     992,     904, DEFAULT, DEFAULT                            },
    { doom2,            1,   2,    85, ShotgunGuy,                2560,    2640,    2560,    2656, DEFAULT, DEFAULT                            },
    { doom2,            1,   2,    85, ShotgunGuy,                 944,     896,     944,     912, DEFAULT, DEFAULT                            },

    { doom2,            1,   4,   136, ShortTechnoFloorLamp,      -368,     880,    -360,     880, DEFAULT, DEFAULT                            },
    { doom2,            1,   4,   137, ShortTechnoFloorLamp,      -368,    1072,    -360,    1080, DEFAULT, DEFAULT                            },

    { doom2,            1,   5,   108, LostSoul,                  2848,    -400,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { doom2,            1,  11,   165, Spectre,                    752,     304,     760,     304, DEFAULT, DEFAULT                            },
    { doom2,            1,  11,   236, CellPack,                  1952,     272,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { doom2,            1,  15,   301, HeavyWeaponDude,           1488,   -1984,    1488,   -1984, DEFAULT, (MTF_NORMAL | MTF_HARD)            },

    { doom2,            1,  17,   127, Spectre,                  -1888,   -2896,   -1896,   -2872, DEFAULT, DEFAULT                            },
    { doom2,            1,  17,   128, Spectre,                  -1984,   -2896,   -1976,   -2872, DEFAULT, DEFAULT                            },
    { doom2,            1,  17,   129, Spectre,                  -2064,   -2896,   -2056,   -2872, DEFAULT, DEFAULT                            },
    { doom2,            1,  17,   130, Spectre,                  -1936,   -2848,   -1936,   -2800, DEFAULT, DEFAULT                            },
    { doom2,            1,  17,   131, Spectre,                  -2016,   -2848,   -2016,   -2800, DEFAULT, DEFAULT                            },

    { doom2,            1,  19,   112, TeleportDestination,       -912,    -880,    -912,    -880, DEFAULT, (MTF_EASY | MTF_NORMAL | MTF_HARD) },

    { doom2,            1,  24,   238, Demon,                    -1200,    -352,   -1184,    -352, DEFAULT, DEFAULT                            },
    { doom2,            1,  24,   239, Demon,                    -1136,    -352,   -1120,    -352, DEFAULT, DEFAULT                            },

    { doom2,            1,  30,     1, MonsterSpawner,            2880,    1424,    2880,    1424,     270, DEFAULT                            },

    { doom2,            1,  31,    60, Demon,                     1376,     800,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },
    { doom2,            1,  31,    80, BurningBarrel,             1664,     448,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },
    { doom2,            1,  31,   265, WolfensteinSS,            -4576,    1952,   -4576,    1952, DEFAULT, (MTF_NORMAL | MTF_HARD)            },

    { doom2,            1,  32,    67, PlayerDeathmatchStart,     1216,    4640,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { pack_nerve,       1,   9,   595, DeadPlayer,               -1280,    3904,   -1280,    3880, DEFAULT, DEFAULT                            },

    { pack_plut,        1,   9,   304, ShortGreenFirestick,      -5216,   -1568,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { pack_plut,        1,  12,   225, Nothing,                   1600,   -3104,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },
    { pack_plut,        1,  12,   226, Nothing,                    992,   -3360,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { pack_plut,        1,  30,   206, MegaSphere,                -480,    1920,    -480,    1920, DEFAULT, MTF_NOTSINGLE                      },
    { pack_plut,        1,  30,   250, Berserk,                  -2368,    3424,   -2368,    3424, DEFAULT, MTF_NOTSINGLE                      },
    { pack_plut,        1,  30,   251, Berserk,                  -2272,    2368,   -2272,    2368, DEFAULT, MTF_NOTSINGLE                      },
    { pack_plut,        1,  30,   252, Berserk,                  -1632,    2464,   -1632,    2464, DEFAULT, MTF_NOTSINGLE                      },
    { pack_plut,        1,  30,   253, Berserk,                   -288,    2400,    -288,    2400, DEFAULT, MTF_NOTSINGLE                      },
    { pack_plut,        1,  30,   254, Berserk,                  -1248,    3104,   -1248,    3104, DEFAULT, MTF_NOTSINGLE                      },

    { pack_tnt,         1,   3,     7, TeleportDestination,       -416,     416,    -416,     416,     135, DEFAULT                            },
    { pack_tnt,         1,   3,    34, TeleportDestination,        960,    1472,     960,    1472,     135, DEFAULT                            },

    { pack_tnt,         1,  20,   511, CellPack,                  2910,   -1595,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { pack_tnt,         1,  24,   158, BurningBarrel,             -912,    1440,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { pack_tnt,         1,  25,   362, BoxOfRockets,              1656,    -512,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { pack_tnt,         1,  29,   405, Mancubus,                 -5536,     992,  REMOVE,  REMOVE, DEFAULT, DEFAULT                            },

    { pack_tnt,         1,  31,   470, YellowKeycard,            -2727,   -1976,   -2727,   -1976, DEFAULT, (MTF_EASY | MTF_NORMAL | MTF_HARD) },

    { -1,               0,   0,     0, 0,                      DEFAULT, DEFAULT, DEFAULT, DEFAULT, DEFAULT, DEFAULT                            }
};
