/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_OUTPUT_MANAGER_V1_CLIENT_PROTOCOL_H
#define TREELAND_OUTPUT_MANAGER_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_output_manager_v1 The treeland_output_manager_v1 protocol
 * @section page_ifaces_treeland_output_manager_v1 Interfaces
 * - @subpage page_iface_treeland_output_manager_v1 - expose which is the primary display
 * @section page_copyright_treeland_output_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_output_manager_v1;

#ifndef TREELAND_OUTPUT_MANAGER_V1_INTERFACE
#define TREELAND_OUTPUT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_output_manager_v1 treeland_output_manager_v1
 * @section page_iface_treeland_output_manager_v1_desc Description
 *
 * Protocol for telling which is the primary display among the selection of enabled
 * outputs.
 * @section page_iface_treeland_output_manager_v1_api API
 * See @ref iface_treeland_output_manager_v1.
 */
/**
 * @defgroup iface_treeland_output_manager_v1 The treeland_output_manager_v1 interface
 *
 * Protocol for telling which is the primary display among the selection of enabled
 * outputs.
 */
extern const struct wl_interface treeland_output_manager_v1_interface;
#endif

/**
 * @ingroup iface_treeland_output_manager_v1
 * @struct treeland_output_manager_v1_listener
 */
struct treeland_output_manager_v1_listener {
	/**
	 * Provide the current primary output's name
	 *
	 * Specifies which output is the primary one identified by their
	 * name.
	 * @param output_name the name of the output
	 */
	void (*primary_output)(void *data,
			       struct treeland_output_manager_v1 *treeland_output_manager_v1,
			       const char *output_name);
};

/**
 * @ingroup iface_treeland_output_manager_v1
 */
static inline int
treeland_output_manager_v1_add_listener(struct treeland_output_manager_v1 *treeland_output_manager_v1,
					const struct treeland_output_manager_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_output_manager_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_OUTPUT_MANAGER_V1_SET_PRIMARY_OUTPUT 0
#define TREELAND_OUTPUT_MANAGER_V1_DESTROY 1

/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_PRIMARY_OUTPUT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_SET_PRIMARY_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_output_manager_v1 */
static inline void
treeland_output_manager_v1_set_user_data(struct treeland_output_manager_v1 *treeland_output_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_output_manager_v1, user_data);
}

/** @ingroup iface_treeland_output_manager_v1 */
static inline void *
treeland_output_manager_v1_get_user_data(struct treeland_output_manager_v1 *treeland_output_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_output_manager_v1);
}

static inline uint32_t
treeland_output_manager_v1_get_version(struct treeland_output_manager_v1 *treeland_output_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_output_manager_v1);
}

/**
 * @ingroup iface_treeland_output_manager_v1
 */
static inline void
treeland_output_manager_v1_set_primary_output(struct treeland_output_manager_v1 *treeland_output_manager_v1, const char *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_output_manager_v1,
			 TREELAND_OUTPUT_MANAGER_V1_SET_PRIMARY_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_output_manager_v1), 0, output);
}

/**
 * @ingroup iface_treeland_output_manager_v1
 */
static inline void
treeland_output_manager_v1_destroy(struct treeland_output_manager_v1 *treeland_output_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_output_manager_v1,
			 TREELAND_OUTPUT_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_output_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
