// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/validate/validate.proto

//go:build !protoopaque

package validate

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies how `FieldRules.ignore` behaves, depending on the field's value, and
// whether the field tracks presence.
type Ignore int32

const (
	// Ignore rules if the field tracks presence and is unset. This is the default
	// behavior.
	//
	// In proto3, only message fields, members of a Protobuf `oneof`, and fields
	// with the `optional` label track presence. Consequently, the following fields
	// are always validated, whether a value is set or not:
	//
	// ```proto
	// syntax="proto3";
	//
	//	message RulesApply {
	//	  string email = 1 [
	//	    (buf.validate.field).string.email = true
	//	  ];
	//	  int32 age = 2 [
	//	    (buf.validate.field).int32.gt = 0
	//	  ];
	//	  repeated string labels = 3 [
	//	    (buf.validate.field).repeated.min_items = 1
	//	  ];
	//	}
	//
	// ```
	//
	// In contrast, the following fields track presence, and are only validated if
	// a value is set:
	//
	// ```proto
	// syntax="proto3";
	//
	//	message RulesApplyIfSet {
	//	  optional string email = 1 [
	//	    (buf.validate.field).string.email = true
	//	  ];
	//	  oneof ref {
	//	    string reference = 2 [
	//	      (buf.validate.field).string.uuid = true
	//	    ];
	//	    string name = 3 [
	//	      (buf.validate.field).string.min_len = 4
	//	    ];
	//	  }
	//	  SomeMessage msg = 4 [
	//	    (buf.validate.field).cel = {/* ... */}
	//	  ];
	//	}
	//
	// ```
	//
	// To ensure that such a field is set, add the `required` rule.
	//
	// To learn which fields track presence, see the
	// [Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).
	Ignore_IGNORE_UNSPECIFIED Ignore = 0
	// Ignore rules if the field is unset, or set to the zero value.
	//
	// The zero value depends on the field type:
	// - For strings, the zero value is the empty string.
	// - For bytes, the zero value is empty bytes.
	// - For bool, the zero value is false.
	// - For numeric types, the zero value is zero.
	// - For enums, the zero value is the first defined enum value.
	// - For repeated fields, the zero is an empty list.
	// - For map fields, the zero is an empty map.
	// - For message fields, absence of the message (typically a null-value) is considered zero value.
	//
	// For fields that track presence (e.g. adding the `optional` label in proto3),
	// this a no-op and behavior is the same as the default `IGNORE_UNSPECIFIED`.
	Ignore_IGNORE_IF_ZERO_VALUE Ignore = 1
	// Always ignore rules, including the `required` rule.
	//
	// This is useful for ignoring the rules of a referenced message, or to
	// temporarily ignore rules during development.
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field's rules will always be ignored, including any validations
	//	  // on value's fields.
	//	  MyOtherMessage value = 1 [
	//	    (buf.validate.field).ignore = IGNORE_ALWAYS];
	//	}
	//
	// ```
	Ignore_IGNORE_ALWAYS Ignore = 3
)

// Enum value maps for Ignore.
var (
	Ignore_name = map[int32]string{
		0: "IGNORE_UNSPECIFIED",
		1: "IGNORE_IF_ZERO_VALUE",
		3: "IGNORE_ALWAYS",
	}
	Ignore_value = map[string]int32{
		"IGNORE_UNSPECIFIED":   0,
		"IGNORE_IF_ZERO_VALUE": 1,
		"IGNORE_ALWAYS":        3,
	}
)

func (x Ignore) Enum() *Ignore {
	p := new(Ignore)
	*p = x
	return p
}

func (x Ignore) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Ignore) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_validate_validate_proto_enumTypes[0].Descriptor()
}

func (Ignore) Type() protoreflect.EnumType {
	return &file_buf_validate_validate_proto_enumTypes[0]
}

func (x Ignore) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// KnownRegex contains some well-known patterns.
type KnownRegex int32

const (
	KnownRegex_KNOWN_REGEX_UNSPECIFIED KnownRegex = 0
	// HTTP header name as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2).
	KnownRegex_KNOWN_REGEX_HTTP_HEADER_NAME KnownRegex = 1
	// HTTP header value as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.4).
	KnownRegex_KNOWN_REGEX_HTTP_HEADER_VALUE KnownRegex = 2
)

// Enum value maps for KnownRegex.
var (
	KnownRegex_name = map[int32]string{
		0: "KNOWN_REGEX_UNSPECIFIED",
		1: "KNOWN_REGEX_HTTP_HEADER_NAME",
		2: "KNOWN_REGEX_HTTP_HEADER_VALUE",
	}
	KnownRegex_value = map[string]int32{
		"KNOWN_REGEX_UNSPECIFIED":       0,
		"KNOWN_REGEX_HTTP_HEADER_NAME":  1,
		"KNOWN_REGEX_HTTP_HEADER_VALUE": 2,
	}
)

func (x KnownRegex) Enum() *KnownRegex {
	p := new(KnownRegex)
	*p = x
	return p
}

func (x KnownRegex) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KnownRegex) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_validate_validate_proto_enumTypes[1].Descriptor()
}

func (KnownRegex) Type() protoreflect.EnumType {
	return &file_buf_validate_validate_proto_enumTypes[1]
}

func (x KnownRegex) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// `Rule` represents a validation rule written in the Common Expression
// Language (CEL) syntax. Each Rule includes a unique identifier, an
// optional error message, and the CEL expression to evaluate. For more
// information, [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
//
// ```proto
//
//	message Foo {
//	  option (buf.validate.message).cel = {
//	    id: "foo.bar"
//	    message: "bar must be greater than 0"
//	    expression: "this.bar > 0"
//	  };
//	  int32 bar = 1;
//	}
//
// ```
type Rule struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `id` is a string that serves as a machine-readable name for this Rule.
	// It should be unique within its scope, which could be either a message or a field.
	Id *string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// `message` is an optional field that provides a human-readable error message
	// for this Rule when the CEL expression evaluates to false. If a
	// non-empty message is provided, any strings resulting from the CEL
	// expression evaluation are ignored.
	Message *string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
	// `expression` is the actual CEL expression that will be evaluated for
	// validation. This string must resolve to either a boolean or a string
	// value. If the expression evaluates to false or a non-empty string, the
	// validation is considered failed, and the message is rejected.
	Expression    *string `protobuf:"bytes,3,opt,name=expression" json:"expression,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Rule) Reset() {
	*x = Rule{}
	mi := &file_buf_validate_validate_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rule) ProtoMessage() {}

func (x *Rule) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Rule) GetId() string {
	if x != nil && x.Id != nil {
		return *x.Id
	}
	return ""
}

func (x *Rule) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

func (x *Rule) GetExpression() string {
	if x != nil && x.Expression != nil {
		return *x.Expression
	}
	return ""
}

func (x *Rule) SetId(v string) {
	x.Id = &v
}

func (x *Rule) SetMessage(v string) {
	x.Message = &v
}

func (x *Rule) SetExpression(v string) {
	x.Expression = &v
}

func (x *Rule) HasId() bool {
	if x == nil {
		return false
	}
	return x.Id != nil
}

func (x *Rule) HasMessage() bool {
	if x == nil {
		return false
	}
	return x.Message != nil
}

func (x *Rule) HasExpression() bool {
	if x == nil {
		return false
	}
	return x.Expression != nil
}

func (x *Rule) ClearId() {
	x.Id = nil
}

func (x *Rule) ClearMessage() {
	x.Message = nil
}

func (x *Rule) ClearExpression() {
	x.Expression = nil
}

type Rule_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `id` is a string that serves as a machine-readable name for this Rule.
	// It should be unique within its scope, which could be either a message or a field.
	Id *string
	// `message` is an optional field that provides a human-readable error message
	// for this Rule when the CEL expression evaluates to false. If a
	// non-empty message is provided, any strings resulting from the CEL
	// expression evaluation are ignored.
	Message *string
	// `expression` is the actual CEL expression that will be evaluated for
	// validation. This string must resolve to either a boolean or a string
	// value. If the expression evaluates to false or a non-empty string, the
	// validation is considered failed, and the message is rejected.
	Expression *string
}

func (b0 Rule_builder) Build() *Rule {
	m0 := &Rule{}
	b, x := &b0, m0
	_, _ = b, x
	x.Id = b.Id
	x.Message = b.Message
	x.Expression = b.Expression
	return m0
}

// MessageRules represents validation rules that are applied to the entire message.
// It includes disabling options and a list of Rule messages representing Common Expression Language (CEL) validation rules.
type MessageRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `cel` is a repeated field of type Rule. Each Rule specifies a validation rule to be applied to this message.
	// These rules are written in Common Expression Language (CEL) syntax. For more information,
	// [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `foo` must be greater than 42.
	//	  option (buf.validate.message).cel = {
	//	    id: "my_message.value",
	//	    message: "value must be greater than 42",
	//	    expression: "this.foo > 42",
	//	  };
	//	  optional int32 foo = 1;
	//	}
	//
	// ```
	Cel []*Rule `protobuf:"bytes,3,rep,name=cel" json:"cel,omitempty"`
	// `oneof` is a repeated field of type MessageOneofRule that specifies a list of fields
	// of which at most one can be present. If `required` is also specified, then exactly one
	// of the specified fields _must_ be present.
	//
	// This will enforce oneof-like constraints with a few features not provided by
	// actual Protobuf oneof declarations:
	//  1. Repeated and map fields are allowed in this validation. In a Protobuf oneof,
	//     only scalar fields are allowed.
	//  2. Fields with implicit presence are allowed. In a Protobuf oneof, all member
	//     fields have explicit presence. This means that, for the purpose of determining
	//     how many fields are set, explicitly setting such a field to its zero value is
	//     effectively the same as not setting it at all.
	//  3. This will always generate validation errors for a message unmarshalled from
	//     serialized data that sets more than one field. With a Protobuf oneof, when
	//     multiple fields are present in the serialized form, earlier values are usually
	//     silently ignored when unmarshalling, with only the last field being set when
	//     unmarshalling completes.
	//
	// Note that adding a field to a `oneof` will also set the IGNORE_IF_ZERO_VALUE on the fields. This means
	// only the field that is set will be validated and the unset fields are not validated according to the field rules.
	// This behavior can be overridden by setting `ignore` against a field.
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // Only one of `field1` or `field2` _can_ be present in this message.
	//	  option (buf.validate.message).oneof = { fields: ["field1", "field2"] };
	//	  // Exactly one of `field3` or `field4` _must_ be present in this message.
	//	  option (buf.validate.message).oneof = { fields: ["field3", "field4"], required: true };
	//	  string field1 = 1;
	//	  bytes field2 = 2;
	//	  bool field3 = 3;
	//	  int32 field4 = 4;
	//	}
	//
	// ```
	Oneof         []*MessageOneofRule `protobuf:"bytes,4,rep,name=oneof" json:"oneof,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MessageRules) Reset() {
	*x = MessageRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageRules) ProtoMessage() {}

func (x *MessageRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MessageRules) GetCel() []*Rule {
	if x != nil {
		return x.Cel
	}
	return nil
}

func (x *MessageRules) GetOneof() []*MessageOneofRule {
	if x != nil {
		return x.Oneof
	}
	return nil
}

func (x *MessageRules) SetCel(v []*Rule) {
	x.Cel = v
}

func (x *MessageRules) SetOneof(v []*MessageOneofRule) {
	x.Oneof = v
}

type MessageRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `cel` is a repeated field of type Rule. Each Rule specifies a validation rule to be applied to this message.
	// These rules are written in Common Expression Language (CEL) syntax. For more information,
	// [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `foo` must be greater than 42.
	//	  option (buf.validate.message).cel = {
	//	    id: "my_message.value",
	//	    message: "value must be greater than 42",
	//	    expression: "this.foo > 42",
	//	  };
	//	  optional int32 foo = 1;
	//	}
	//
	// ```
	Cel []*Rule
	// `oneof` is a repeated field of type MessageOneofRule that specifies a list of fields
	// of which at most one can be present. If `required` is also specified, then exactly one
	// of the specified fields _must_ be present.
	//
	// This will enforce oneof-like constraints with a few features not provided by
	// actual Protobuf oneof declarations:
	//  1. Repeated and map fields are allowed in this validation. In a Protobuf oneof,
	//     only scalar fields are allowed.
	//  2. Fields with implicit presence are allowed. In a Protobuf oneof, all member
	//     fields have explicit presence. This means that, for the purpose of determining
	//     how many fields are set, explicitly setting such a field to its zero value is
	//     effectively the same as not setting it at all.
	//  3. This will always generate validation errors for a message unmarshalled from
	//     serialized data that sets more than one field. With a Protobuf oneof, when
	//     multiple fields are present in the serialized form, earlier values are usually
	//     silently ignored when unmarshalling, with only the last field being set when
	//     unmarshalling completes.
	//
	// Note that adding a field to a `oneof` will also set the IGNORE_IF_ZERO_VALUE on the fields. This means
	// only the field that is set will be validated and the unset fields are not validated according to the field rules.
	// This behavior can be overridden by setting `ignore` against a field.
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // Only one of `field1` or `field2` _can_ be present in this message.
	//	  option (buf.validate.message).oneof = { fields: ["field1", "field2"] };
	//	  // Exactly one of `field3` or `field4` _must_ be present in this message.
	//	  option (buf.validate.message).oneof = { fields: ["field3", "field4"], required: true };
	//	  string field1 = 1;
	//	  bytes field2 = 2;
	//	  bool field3 = 3;
	//	  int32 field4 = 4;
	//	}
	//
	// ```
	Oneof []*MessageOneofRule
}

func (b0 MessageRules_builder) Build() *MessageRules {
	m0 := &MessageRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Cel = b.Cel
	x.Oneof = b.Oneof
	return m0
}

type MessageOneofRule struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// A list of field names to include in the oneof. All field names must be
	// defined in the message. At least one field must be specified, and
	// duplicates are not permitted.
	Fields []string `protobuf:"bytes,1,rep,name=fields" json:"fields,omitempty"`
	// If true, one of the fields specified _must_ be set.
	Required      *bool `protobuf:"varint,2,opt,name=required" json:"required,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MessageOneofRule) Reset() {
	*x = MessageOneofRule{}
	mi := &file_buf_validate_validate_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageOneofRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageOneofRule) ProtoMessage() {}

func (x *MessageOneofRule) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MessageOneofRule) GetFields() []string {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *MessageOneofRule) GetRequired() bool {
	if x != nil && x.Required != nil {
		return *x.Required
	}
	return false
}

func (x *MessageOneofRule) SetFields(v []string) {
	x.Fields = v
}

func (x *MessageOneofRule) SetRequired(v bool) {
	x.Required = &v
}

func (x *MessageOneofRule) HasRequired() bool {
	if x == nil {
		return false
	}
	return x.Required != nil
}

func (x *MessageOneofRule) ClearRequired() {
	x.Required = nil
}

type MessageOneofRule_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// A list of field names to include in the oneof. All field names must be
	// defined in the message. At least one field must be specified, and
	// duplicates are not permitted.
	Fields []string
	// If true, one of the fields specified _must_ be set.
	Required *bool
}

func (b0 MessageOneofRule_builder) Build() *MessageOneofRule {
	m0 := &MessageOneofRule{}
	b, x := &b0, m0
	_, _ = b, x
	x.Fields = b.Fields
	x.Required = b.Required
	return m0
}

// The `OneofRules` message type enables you to manage rules for
// oneof fields in your protobuf messages.
type OneofRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// If `required` is true, exactly one field of the oneof must be set. A
	// validation error is returned if no fields in the oneof are set. Further rules
	// should be placed on the fields themselves to ensure they are valid values,
	// such as `min_len` or `gt`.
	//
	// ```proto
	//
	//	message MyMessage {
	//	  oneof value {
	//	    // Either `a` or `b` must be set. If `a` is set, it must also be
	//	    // non-empty; whereas if `b` is set, it can still be an empty string.
	//	    option (buf.validate.oneof).required = true;
	//	    string a = 1 [(buf.validate.field).string.min_len = 1];
	//	    string b = 2;
	//	  }
	//	}
	//
	// ```
	Required      *bool `protobuf:"varint,1,opt,name=required" json:"required,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OneofRules) Reset() {
	*x = OneofRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OneofRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OneofRules) ProtoMessage() {}

func (x *OneofRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *OneofRules) GetRequired() bool {
	if x != nil && x.Required != nil {
		return *x.Required
	}
	return false
}

func (x *OneofRules) SetRequired(v bool) {
	x.Required = &v
}

func (x *OneofRules) HasRequired() bool {
	if x == nil {
		return false
	}
	return x.Required != nil
}

func (x *OneofRules) ClearRequired() {
	x.Required = nil
}

type OneofRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// If `required` is true, exactly one field of the oneof must be set. A
	// validation error is returned if no fields in the oneof are set. Further rules
	// should be placed on the fields themselves to ensure they are valid values,
	// such as `min_len` or `gt`.
	//
	// ```proto
	//
	//	message MyMessage {
	//	  oneof value {
	//	    // Either `a` or `b` must be set. If `a` is set, it must also be
	//	    // non-empty; whereas if `b` is set, it can still be an empty string.
	//	    option (buf.validate.oneof).required = true;
	//	    string a = 1 [(buf.validate.field).string.min_len = 1];
	//	    string b = 2;
	//	  }
	//	}
	//
	// ```
	Required *bool
}

func (b0 OneofRules_builder) Build() *OneofRules {
	m0 := &OneofRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Required = b.Required
	return m0
}

// FieldRules encapsulates the rules for each type of field. Depending on
// the field, the correct set should be used to ensure proper validations.
type FieldRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `cel` is a repeated field used to represent a textual expression
	// in the Common Expression Language (CEL) syntax. For more information,
	// [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `value` must be greater than 42.
	//	  optional int32 value = 1 [(buf.validate.field).cel = {
	//	    id: "my_message.value",
	//	    message: "value must be greater than 42",
	//	    expression: "this > 42",
	//	  }];
	//	}
	//
	// ```
	Cel []*Rule `protobuf:"bytes,23,rep,name=cel" json:"cel,omitempty"`
	// If `required` is true, the field must be set. A validation error is returned
	// if the field is not set.
	//
	// ```proto
	// syntax="proto3";
	//
	//	message FieldsWithPresence {
	//	  // Requires any string to be set, including the empty string.
	//	  optional string link = 1 [
	//	    (buf.validate.field).required = true
	//	  ];
	//	  // Requires true or false to be set.
	//	  optional bool disabled = 2 [
	//	    (buf.validate.field).required = true
	//	  ];
	//	  // Requires a message to be set, including the empty message.
	//	  SomeMessage msg = 4 [
	//	    (buf.validate.field).required = true
	//	  ];
	//	}
	//
	// ```
	//
	// All fields in the example above track presence. By default, Protovalidate
	// ignores rules on those fields if no value is set. `required` ensures that
	// the fields are set and valid.
	//
	// Fields that don't track presence are always validated by Protovalidate,
	// whether they are set or not. It is not necessary to add `required`:
	//
	// ```proto
	// syntax="proto3";
	//
	//	message FieldsWithoutPresence {
	//	  // `string.email` always applies, even to an empty string.
	//	  string link = 1 [
	//	    (buf.validate.field).string.email = true
	//	  ];
	//	  // `repeated.min_items` always applies, even to an empty list.
	//	  repeated string labels = 4 [
	//	    (buf.validate.field).repeated.min_items = 1
	//	  ];
	//	}
	//
	// ```
	//
	// To learn which fields track presence, see the
	// [Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).
	//
	// Note: While field rules can be applied to repeated items, map keys, and map
	// values, the elements are always considered to be set. Consequently,
	// specifying `repeated.items.required` is redundant.
	Required *bool `protobuf:"varint,25,opt,name=required" json:"required,omitempty"`
	// Ignore validation rules on the field if its value matches the specified
	// criteria. See the `Ignore` enum for details.
	//
	// ```proto
	//
	//	message UpdateRequest {
	//	  // The uri rule only applies if the field is not an empty string.
	//	  string url = 1 [
	//	    (buf.validate.field).ignore = IGNORE_IF_ZERO_VALUE,
	//	    (buf.validate.field).string.uri = true
	//	  ];
	//	}
	//
	// ```
	Ignore *Ignore `protobuf:"varint,27,opt,name=ignore,enum=buf.validate.Ignore" json:"ignore,omitempty"`
	// Types that are valid to be assigned to Type:
	//
	//	*FieldRules_Float
	//	*FieldRules_Double
	//	*FieldRules_Int32
	//	*FieldRules_Int64
	//	*FieldRules_Uint32
	//	*FieldRules_Uint64
	//	*FieldRules_Sint32
	//	*FieldRules_Sint64
	//	*FieldRules_Fixed32
	//	*FieldRules_Fixed64
	//	*FieldRules_Sfixed32
	//	*FieldRules_Sfixed64
	//	*FieldRules_Bool
	//	*FieldRules_String_
	//	*FieldRules_Bytes
	//	*FieldRules_Enum
	//	*FieldRules_Repeated
	//	*FieldRules_Map
	//	*FieldRules_Any
	//	*FieldRules_Duration
	//	*FieldRules_Timestamp
	Type          isFieldRules_Type `protobuf_oneof:"type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FieldRules) Reset() {
	*x = FieldRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldRules) ProtoMessage() {}

func (x *FieldRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FieldRules) GetCel() []*Rule {
	if x != nil {
		return x.Cel
	}
	return nil
}

func (x *FieldRules) GetRequired() bool {
	if x != nil && x.Required != nil {
		return *x.Required
	}
	return false
}

func (x *FieldRules) GetIgnore() Ignore {
	if x != nil && x.Ignore != nil {
		return *x.Ignore
	}
	return Ignore_IGNORE_UNSPECIFIED
}

func (x *FieldRules) GetType() isFieldRules_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *FieldRules) GetFloat() *FloatRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Float); ok {
			return x.Float
		}
	}
	return nil
}

func (x *FieldRules) GetDouble() *DoubleRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Double); ok {
			return x.Double
		}
	}
	return nil
}

func (x *FieldRules) GetInt32() *Int32Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Int32); ok {
			return x.Int32
		}
	}
	return nil
}

func (x *FieldRules) GetInt64() *Int64Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Int64); ok {
			return x.Int64
		}
	}
	return nil
}

func (x *FieldRules) GetUint32() *UInt32Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Uint32); ok {
			return x.Uint32
		}
	}
	return nil
}

func (x *FieldRules) GetUint64() *UInt64Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Uint64); ok {
			return x.Uint64
		}
	}
	return nil
}

func (x *FieldRules) GetSint32() *SInt32Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Sint32); ok {
			return x.Sint32
		}
	}
	return nil
}

func (x *FieldRules) GetSint64() *SInt64Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Sint64); ok {
			return x.Sint64
		}
	}
	return nil
}

func (x *FieldRules) GetFixed32() *Fixed32Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Fixed32); ok {
			return x.Fixed32
		}
	}
	return nil
}

func (x *FieldRules) GetFixed64() *Fixed64Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Fixed64); ok {
			return x.Fixed64
		}
	}
	return nil
}

func (x *FieldRules) GetSfixed32() *SFixed32Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Sfixed32); ok {
			return x.Sfixed32
		}
	}
	return nil
}

func (x *FieldRules) GetSfixed64() *SFixed64Rules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Sfixed64); ok {
			return x.Sfixed64
		}
	}
	return nil
}

func (x *FieldRules) GetBool() *BoolRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Bool); ok {
			return x.Bool
		}
	}
	return nil
}

func (x *FieldRules) GetString() *StringRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_String_); ok {
			return x.String_
		}
	}
	return nil
}

// Deprecated: Use GetString instead.
func (x *FieldRules) GetString_() *StringRules {
	return x.GetString()
}

func (x *FieldRules) GetBytes() *BytesRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Bytes); ok {
			return x.Bytes
		}
	}
	return nil
}

func (x *FieldRules) GetEnum() *EnumRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Enum); ok {
			return x.Enum
		}
	}
	return nil
}

func (x *FieldRules) GetRepeated() *RepeatedRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Repeated); ok {
			return x.Repeated
		}
	}
	return nil
}

func (x *FieldRules) GetMap() *MapRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Map); ok {
			return x.Map
		}
	}
	return nil
}

func (x *FieldRules) GetAny() *AnyRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Any); ok {
			return x.Any
		}
	}
	return nil
}

func (x *FieldRules) GetDuration() *DurationRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Duration); ok {
			return x.Duration
		}
	}
	return nil
}

func (x *FieldRules) GetTimestamp() *TimestampRules {
	if x != nil {
		if x, ok := x.Type.(*FieldRules_Timestamp); ok {
			return x.Timestamp
		}
	}
	return nil
}

func (x *FieldRules) SetCel(v []*Rule) {
	x.Cel = v
}

func (x *FieldRules) SetRequired(v bool) {
	x.Required = &v
}

func (x *FieldRules) SetIgnore(v Ignore) {
	x.Ignore = &v
}

func (x *FieldRules) SetFloat(v *FloatRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Float{v}
}

func (x *FieldRules) SetDouble(v *DoubleRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Double{v}
}

func (x *FieldRules) SetInt32(v *Int32Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Int32{v}
}

func (x *FieldRules) SetInt64(v *Int64Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Int64{v}
}

func (x *FieldRules) SetUint32(v *UInt32Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Uint32{v}
}

func (x *FieldRules) SetUint64(v *UInt64Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Uint64{v}
}

func (x *FieldRules) SetSint32(v *SInt32Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Sint32{v}
}

func (x *FieldRules) SetSint64(v *SInt64Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Sint64{v}
}

func (x *FieldRules) SetFixed32(v *Fixed32Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Fixed32{v}
}

func (x *FieldRules) SetFixed64(v *Fixed64Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Fixed64{v}
}

func (x *FieldRules) SetSfixed32(v *SFixed32Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Sfixed32{v}
}

func (x *FieldRules) SetSfixed64(v *SFixed64Rules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Sfixed64{v}
}

func (x *FieldRules) SetBool(v *BoolRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Bool{v}
}

func (x *FieldRules) SetString(v *StringRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_String_{v}
}

func (x *FieldRules) SetBytes(v *BytesRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Bytes{v}
}

func (x *FieldRules) SetEnum(v *EnumRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Enum{v}
}

func (x *FieldRules) SetRepeated(v *RepeatedRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Repeated{v}
}

func (x *FieldRules) SetMap(v *MapRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Map{v}
}

func (x *FieldRules) SetAny(v *AnyRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Any{v}
}

func (x *FieldRules) SetDuration(v *DurationRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Duration{v}
}

func (x *FieldRules) SetTimestamp(v *TimestampRules) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &FieldRules_Timestamp{v}
}

func (x *FieldRules) HasRequired() bool {
	if x == nil {
		return false
	}
	return x.Required != nil
}

func (x *FieldRules) HasIgnore() bool {
	if x == nil {
		return false
	}
	return x.Ignore != nil
}

func (x *FieldRules) HasType() bool {
	if x == nil {
		return false
	}
	return x.Type != nil
}

func (x *FieldRules) HasFloat() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Float)
	return ok
}

func (x *FieldRules) HasDouble() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Double)
	return ok
}

func (x *FieldRules) HasInt32() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Int32)
	return ok
}

func (x *FieldRules) HasInt64() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Int64)
	return ok
}

func (x *FieldRules) HasUint32() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Uint32)
	return ok
}

func (x *FieldRules) HasUint64() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Uint64)
	return ok
}

func (x *FieldRules) HasSint32() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Sint32)
	return ok
}

func (x *FieldRules) HasSint64() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Sint64)
	return ok
}

func (x *FieldRules) HasFixed32() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Fixed32)
	return ok
}

func (x *FieldRules) HasFixed64() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Fixed64)
	return ok
}

func (x *FieldRules) HasSfixed32() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Sfixed32)
	return ok
}

func (x *FieldRules) HasSfixed64() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Sfixed64)
	return ok
}

func (x *FieldRules) HasBool() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Bool)
	return ok
}

func (x *FieldRules) HasString() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_String_)
	return ok
}

func (x *FieldRules) HasBytes() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Bytes)
	return ok
}

func (x *FieldRules) HasEnum() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Enum)
	return ok
}

func (x *FieldRules) HasRepeated() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Repeated)
	return ok
}

func (x *FieldRules) HasMap() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Map)
	return ok
}

func (x *FieldRules) HasAny() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Any)
	return ok
}

func (x *FieldRules) HasDuration() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Duration)
	return ok
}

func (x *FieldRules) HasTimestamp() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*FieldRules_Timestamp)
	return ok
}

func (x *FieldRules) ClearRequired() {
	x.Required = nil
}

func (x *FieldRules) ClearIgnore() {
	x.Ignore = nil
}

func (x *FieldRules) ClearType() {
	x.Type = nil
}

func (x *FieldRules) ClearFloat() {
	if _, ok := x.Type.(*FieldRules_Float); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearDouble() {
	if _, ok := x.Type.(*FieldRules_Double); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearInt32() {
	if _, ok := x.Type.(*FieldRules_Int32); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearInt64() {
	if _, ok := x.Type.(*FieldRules_Int64); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearUint32() {
	if _, ok := x.Type.(*FieldRules_Uint32); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearUint64() {
	if _, ok := x.Type.(*FieldRules_Uint64); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearSint32() {
	if _, ok := x.Type.(*FieldRules_Sint32); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearSint64() {
	if _, ok := x.Type.(*FieldRules_Sint64); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearFixed32() {
	if _, ok := x.Type.(*FieldRules_Fixed32); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearFixed64() {
	if _, ok := x.Type.(*FieldRules_Fixed64); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearSfixed32() {
	if _, ok := x.Type.(*FieldRules_Sfixed32); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearSfixed64() {
	if _, ok := x.Type.(*FieldRules_Sfixed64); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearBool() {
	if _, ok := x.Type.(*FieldRules_Bool); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearString() {
	if _, ok := x.Type.(*FieldRules_String_); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearBytes() {
	if _, ok := x.Type.(*FieldRules_Bytes); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearEnum() {
	if _, ok := x.Type.(*FieldRules_Enum); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearRepeated() {
	if _, ok := x.Type.(*FieldRules_Repeated); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearMap() {
	if _, ok := x.Type.(*FieldRules_Map); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearAny() {
	if _, ok := x.Type.(*FieldRules_Any); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearDuration() {
	if _, ok := x.Type.(*FieldRules_Duration); ok {
		x.Type = nil
	}
}

func (x *FieldRules) ClearTimestamp() {
	if _, ok := x.Type.(*FieldRules_Timestamp); ok {
		x.Type = nil
	}
}

const FieldRules_Type_not_set_case case_FieldRules_Type = 0
const FieldRules_Float_case case_FieldRules_Type = 1
const FieldRules_Double_case case_FieldRules_Type = 2
const FieldRules_Int32_case case_FieldRules_Type = 3
const FieldRules_Int64_case case_FieldRules_Type = 4
const FieldRules_Uint32_case case_FieldRules_Type = 5
const FieldRules_Uint64_case case_FieldRules_Type = 6
const FieldRules_Sint32_case case_FieldRules_Type = 7
const FieldRules_Sint64_case case_FieldRules_Type = 8
const FieldRules_Fixed32_case case_FieldRules_Type = 9
const FieldRules_Fixed64_case case_FieldRules_Type = 10
const FieldRules_Sfixed32_case case_FieldRules_Type = 11
const FieldRules_Sfixed64_case case_FieldRules_Type = 12
const FieldRules_Bool_case case_FieldRules_Type = 13
const FieldRules_String__case case_FieldRules_Type = 14
const FieldRules_Bytes_case case_FieldRules_Type = 15
const FieldRules_Enum_case case_FieldRules_Type = 16
const FieldRules_Repeated_case case_FieldRules_Type = 18
const FieldRules_Map_case case_FieldRules_Type = 19
const FieldRules_Any_case case_FieldRules_Type = 20
const FieldRules_Duration_case case_FieldRules_Type = 21
const FieldRules_Timestamp_case case_FieldRules_Type = 22

func (x *FieldRules) WhichType() case_FieldRules_Type {
	if x == nil {
		return FieldRules_Type_not_set_case
	}
	switch x.Type.(type) {
	case *FieldRules_Float:
		return FieldRules_Float_case
	case *FieldRules_Double:
		return FieldRules_Double_case
	case *FieldRules_Int32:
		return FieldRules_Int32_case
	case *FieldRules_Int64:
		return FieldRules_Int64_case
	case *FieldRules_Uint32:
		return FieldRules_Uint32_case
	case *FieldRules_Uint64:
		return FieldRules_Uint64_case
	case *FieldRules_Sint32:
		return FieldRules_Sint32_case
	case *FieldRules_Sint64:
		return FieldRules_Sint64_case
	case *FieldRules_Fixed32:
		return FieldRules_Fixed32_case
	case *FieldRules_Fixed64:
		return FieldRules_Fixed64_case
	case *FieldRules_Sfixed32:
		return FieldRules_Sfixed32_case
	case *FieldRules_Sfixed64:
		return FieldRules_Sfixed64_case
	case *FieldRules_Bool:
		return FieldRules_Bool_case
	case *FieldRules_String_:
		return FieldRules_String__case
	case *FieldRules_Bytes:
		return FieldRules_Bytes_case
	case *FieldRules_Enum:
		return FieldRules_Enum_case
	case *FieldRules_Repeated:
		return FieldRules_Repeated_case
	case *FieldRules_Map:
		return FieldRules_Map_case
	case *FieldRules_Any:
		return FieldRules_Any_case
	case *FieldRules_Duration:
		return FieldRules_Duration_case
	case *FieldRules_Timestamp:
		return FieldRules_Timestamp_case
	default:
		return FieldRules_Type_not_set_case
	}
}

type FieldRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `cel` is a repeated field used to represent a textual expression
	// in the Common Expression Language (CEL) syntax. For more information,
	// [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `value` must be greater than 42.
	//	  optional int32 value = 1 [(buf.validate.field).cel = {
	//	    id: "my_message.value",
	//	    message: "value must be greater than 42",
	//	    expression: "this > 42",
	//	  }];
	//	}
	//
	// ```
	Cel []*Rule
	// If `required` is true, the field must be set. A validation error is returned
	// if the field is not set.
	//
	// ```proto
	// syntax="proto3";
	//
	//	message FieldsWithPresence {
	//	  // Requires any string to be set, including the empty string.
	//	  optional string link = 1 [
	//	    (buf.validate.field).required = true
	//	  ];
	//	  // Requires true or false to be set.
	//	  optional bool disabled = 2 [
	//	    (buf.validate.field).required = true
	//	  ];
	//	  // Requires a message to be set, including the empty message.
	//	  SomeMessage msg = 4 [
	//	    (buf.validate.field).required = true
	//	  ];
	//	}
	//
	// ```
	//
	// All fields in the example above track presence. By default, Protovalidate
	// ignores rules on those fields if no value is set. `required` ensures that
	// the fields are set and valid.
	//
	// Fields that don't track presence are always validated by Protovalidate,
	// whether they are set or not. It is not necessary to add `required`:
	//
	// ```proto
	// syntax="proto3";
	//
	//	message FieldsWithoutPresence {
	//	  // `string.email` always applies, even to an empty string.
	//	  string link = 1 [
	//	    (buf.validate.field).string.email = true
	//	  ];
	//	  // `repeated.min_items` always applies, even to an empty list.
	//	  repeated string labels = 4 [
	//	    (buf.validate.field).repeated.min_items = 1
	//	  ];
	//	}
	//
	// ```
	//
	// To learn which fields track presence, see the
	// [Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).
	//
	// Note: While field rules can be applied to repeated items, map keys, and map
	// values, the elements are always considered to be set. Consequently,
	// specifying `repeated.items.required` is redundant.
	Required *bool
	// Ignore validation rules on the field if its value matches the specified
	// criteria. See the `Ignore` enum for details.
	//
	// ```proto
	//
	//	message UpdateRequest {
	//	  // The uri rule only applies if the field is not an empty string.
	//	  string url = 1 [
	//	    (buf.validate.field).ignore = IGNORE_IF_ZERO_VALUE,
	//	    (buf.validate.field).string.uri = true
	//	  ];
	//	}
	//
	// ```
	Ignore *Ignore
	// Fields of oneof Type:
	// Scalar Field Types
	Float    *FloatRules
	Double   *DoubleRules
	Int32    *Int32Rules
	Int64    *Int64Rules
	Uint32   *UInt32Rules
	Uint64   *UInt64Rules
	Sint32   *SInt32Rules
	Sint64   *SInt64Rules
	Fixed32  *Fixed32Rules
	Fixed64  *Fixed64Rules
	Sfixed32 *SFixed32Rules
	Sfixed64 *SFixed64Rules
	Bool     *BoolRules
	String   *StringRules
	Bytes    *BytesRules
	// Complex Field Types
	Enum     *EnumRules
	Repeated *RepeatedRules
	Map      *MapRules
	// Well-Known Field Types
	Any       *AnyRules
	Duration  *DurationRules
	Timestamp *TimestampRules
	// -- end of Type
}

func (b0 FieldRules_builder) Build() *FieldRules {
	m0 := &FieldRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Cel = b.Cel
	x.Required = b.Required
	x.Ignore = b.Ignore
	if b.Float != nil {
		x.Type = &FieldRules_Float{b.Float}
	}
	if b.Double != nil {
		x.Type = &FieldRules_Double{b.Double}
	}
	if b.Int32 != nil {
		x.Type = &FieldRules_Int32{b.Int32}
	}
	if b.Int64 != nil {
		x.Type = &FieldRules_Int64{b.Int64}
	}
	if b.Uint32 != nil {
		x.Type = &FieldRules_Uint32{b.Uint32}
	}
	if b.Uint64 != nil {
		x.Type = &FieldRules_Uint64{b.Uint64}
	}
	if b.Sint32 != nil {
		x.Type = &FieldRules_Sint32{b.Sint32}
	}
	if b.Sint64 != nil {
		x.Type = &FieldRules_Sint64{b.Sint64}
	}
	if b.Fixed32 != nil {
		x.Type = &FieldRules_Fixed32{b.Fixed32}
	}
	if b.Fixed64 != nil {
		x.Type = &FieldRules_Fixed64{b.Fixed64}
	}
	if b.Sfixed32 != nil {
		x.Type = &FieldRules_Sfixed32{b.Sfixed32}
	}
	if b.Sfixed64 != nil {
		x.Type = &FieldRules_Sfixed64{b.Sfixed64}
	}
	if b.Bool != nil {
		x.Type = &FieldRules_Bool{b.Bool}
	}
	if b.String != nil {
		x.Type = &FieldRules_String_{b.String}
	}
	if b.Bytes != nil {
		x.Type = &FieldRules_Bytes{b.Bytes}
	}
	if b.Enum != nil {
		x.Type = &FieldRules_Enum{b.Enum}
	}
	if b.Repeated != nil {
		x.Type = &FieldRules_Repeated{b.Repeated}
	}
	if b.Map != nil {
		x.Type = &FieldRules_Map{b.Map}
	}
	if b.Any != nil {
		x.Type = &FieldRules_Any{b.Any}
	}
	if b.Duration != nil {
		x.Type = &FieldRules_Duration{b.Duration}
	}
	if b.Timestamp != nil {
		x.Type = &FieldRules_Timestamp{b.Timestamp}
	}
	return m0
}

type case_FieldRules_Type protoreflect.FieldNumber

func (x case_FieldRules_Type) String() string {
	md := file_buf_validate_validate_proto_msgTypes[4].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isFieldRules_Type interface {
	isFieldRules_Type()
}

type FieldRules_Float struct {
	// Scalar Field Types
	Float *FloatRules `protobuf:"bytes,1,opt,name=float,oneof"`
}

type FieldRules_Double struct {
	Double *DoubleRules `protobuf:"bytes,2,opt,name=double,oneof"`
}

type FieldRules_Int32 struct {
	Int32 *Int32Rules `protobuf:"bytes,3,opt,name=int32,oneof"`
}

type FieldRules_Int64 struct {
	Int64 *Int64Rules `protobuf:"bytes,4,opt,name=int64,oneof"`
}

type FieldRules_Uint32 struct {
	Uint32 *UInt32Rules `protobuf:"bytes,5,opt,name=uint32,oneof"`
}

type FieldRules_Uint64 struct {
	Uint64 *UInt64Rules `protobuf:"bytes,6,opt,name=uint64,oneof"`
}

type FieldRules_Sint32 struct {
	Sint32 *SInt32Rules `protobuf:"bytes,7,opt,name=sint32,oneof"`
}

type FieldRules_Sint64 struct {
	Sint64 *SInt64Rules `protobuf:"bytes,8,opt,name=sint64,oneof"`
}

type FieldRules_Fixed32 struct {
	Fixed32 *Fixed32Rules `protobuf:"bytes,9,opt,name=fixed32,oneof"`
}

type FieldRules_Fixed64 struct {
	Fixed64 *Fixed64Rules `protobuf:"bytes,10,opt,name=fixed64,oneof"`
}

type FieldRules_Sfixed32 struct {
	Sfixed32 *SFixed32Rules `protobuf:"bytes,11,opt,name=sfixed32,oneof"`
}

type FieldRules_Sfixed64 struct {
	Sfixed64 *SFixed64Rules `protobuf:"bytes,12,opt,name=sfixed64,oneof"`
}

type FieldRules_Bool struct {
	Bool *BoolRules `protobuf:"bytes,13,opt,name=bool,oneof"`
}

type FieldRules_String_ struct {
	String_ *StringRules `protobuf:"bytes,14,opt,name=string,oneof"`
}

type FieldRules_Bytes struct {
	Bytes *BytesRules `protobuf:"bytes,15,opt,name=bytes,oneof"`
}

type FieldRules_Enum struct {
	// Complex Field Types
	Enum *EnumRules `protobuf:"bytes,16,opt,name=enum,oneof"`
}

type FieldRules_Repeated struct {
	Repeated *RepeatedRules `protobuf:"bytes,18,opt,name=repeated,oneof"`
}

type FieldRules_Map struct {
	Map *MapRules `protobuf:"bytes,19,opt,name=map,oneof"`
}

type FieldRules_Any struct {
	// Well-Known Field Types
	Any *AnyRules `protobuf:"bytes,20,opt,name=any,oneof"`
}

type FieldRules_Duration struct {
	Duration *DurationRules `protobuf:"bytes,21,opt,name=duration,oneof"`
}

type FieldRules_Timestamp struct {
	Timestamp *TimestampRules `protobuf:"bytes,22,opt,name=timestamp,oneof"`
}

func (*FieldRules_Float) isFieldRules_Type() {}

func (*FieldRules_Double) isFieldRules_Type() {}

func (*FieldRules_Int32) isFieldRules_Type() {}

func (*FieldRules_Int64) isFieldRules_Type() {}

func (*FieldRules_Uint32) isFieldRules_Type() {}

func (*FieldRules_Uint64) isFieldRules_Type() {}

func (*FieldRules_Sint32) isFieldRules_Type() {}

func (*FieldRules_Sint64) isFieldRules_Type() {}

func (*FieldRules_Fixed32) isFieldRules_Type() {}

func (*FieldRules_Fixed64) isFieldRules_Type() {}

func (*FieldRules_Sfixed32) isFieldRules_Type() {}

func (*FieldRules_Sfixed64) isFieldRules_Type() {}

func (*FieldRules_Bool) isFieldRules_Type() {}

func (*FieldRules_String_) isFieldRules_Type() {}

func (*FieldRules_Bytes) isFieldRules_Type() {}

func (*FieldRules_Enum) isFieldRules_Type() {}

func (*FieldRules_Repeated) isFieldRules_Type() {}

func (*FieldRules_Map) isFieldRules_Type() {}

func (*FieldRules_Any) isFieldRules_Type() {}

func (*FieldRules_Duration) isFieldRules_Type() {}

func (*FieldRules_Timestamp) isFieldRules_Type() {}

// PredefinedRules are custom rules that can be re-used with
// multiple fields.
type PredefinedRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `cel` is a repeated field used to represent a textual expression
	// in the Common Expression Language (CEL) syntax. For more information,
	// [see our documentation](https://buf.build/docs/protovalidate/schemas/predefined-rules/).
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `value` must be greater than 42.
	//	  optional int32 value = 1 [(buf.validate.predefined).cel = {
	//	    id: "my_message.value",
	//	    message: "value must be greater than 42",
	//	    expression: "this > 42",
	//	  }];
	//	}
	//
	// ```
	Cel           []*Rule `protobuf:"bytes,1,rep,name=cel" json:"cel,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PredefinedRules) Reset() {
	*x = PredefinedRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredefinedRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredefinedRules) ProtoMessage() {}

func (x *PredefinedRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *PredefinedRules) GetCel() []*Rule {
	if x != nil {
		return x.Cel
	}
	return nil
}

func (x *PredefinedRules) SetCel(v []*Rule) {
	x.Cel = v
}

type PredefinedRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `cel` is a repeated field used to represent a textual expression
	// in the Common Expression Language (CEL) syntax. For more information,
	// [see our documentation](https://buf.build/docs/protovalidate/schemas/predefined-rules/).
	//
	// ```proto
	//
	//	message MyMessage {
	//	  // The field `value` must be greater than 42.
	//	  optional int32 value = 1 [(buf.validate.predefined).cel = {
	//	    id: "my_message.value",
	//	    message: "value must be greater than 42",
	//	    expression: "this > 42",
	//	  }];
	//	}
	//
	// ```
	Cel []*Rule
}

func (b0 PredefinedRules_builder) Build() *PredefinedRules {
	m0 := &PredefinedRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Cel = b.Cel
	return m0
}

// FloatRules describes the rules applied to `float` values. These
// rules may also be applied to the `google.protobuf.FloatValue` Well-Known-Type.
type FloatRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must equal 42.0
	//	  float value = 1 [(buf.validate.field).float.const = 42.0];
	//	}
	//
	// ```
	Const *float32 `protobuf:"fixed32,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*FloatRules_Lt
	//	*FloatRules_Lte
	LessThan isFloatRules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*FloatRules_Gt
	//	*FloatRules_Gte
	GreaterThan isFloatRules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be in list [1.0, 2.0, 3.0]
	//	  float value = 1 [(buf.validate.field).float = { in: [1.0, 2.0, 3.0] }];
	//	}
	//
	// ```
	In []float32 `protobuf:"fixed32,6,rep,name=in" json:"in,omitempty"`
	// `in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must not be in list [1.0, 2.0, 3.0]
	//	  float value = 1 [(buf.validate.field).float = { not_in: [1.0, 2.0, 3.0] }];
	//	}
	//
	// ```
	NotIn []float32 `protobuf:"fixed32,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `finite` requires the field value to be finite. If the field value is
	// infinite or NaN, an error message is generated.
	Finite *bool `protobuf:"varint,8,opt,name=finite" json:"finite,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  float value = 1 [
	//	    (buf.validate.field).float.example = 1.0,
	//	    (buf.validate.field).float.example = inf
	//	  ];
	//	}
	//
	// ```
	Example         []float32 `protobuf:"fixed32,9,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *FloatRules) Reset() {
	*x = FloatRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FloatRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FloatRules) ProtoMessage() {}

func (x *FloatRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FloatRules) GetConst() float32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *FloatRules) GetLessThan() isFloatRules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *FloatRules) GetLt() float32 {
	if x != nil {
		if x, ok := x.LessThan.(*FloatRules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *FloatRules) GetLte() float32 {
	if x != nil {
		if x, ok := x.LessThan.(*FloatRules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *FloatRules) GetGreaterThan() isFloatRules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *FloatRules) GetGt() float32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*FloatRules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *FloatRules) GetGte() float32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*FloatRules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *FloatRules) GetIn() []float32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *FloatRules) GetNotIn() []float32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *FloatRules) GetFinite() bool {
	if x != nil && x.Finite != nil {
		return *x.Finite
	}
	return false
}

func (x *FloatRules) GetExample() []float32 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *FloatRules) SetConst(v float32) {
	x.Const = &v
}

func (x *FloatRules) SetLt(v float32) {
	x.LessThan = &FloatRules_Lt{v}
}

func (x *FloatRules) SetLte(v float32) {
	x.LessThan = &FloatRules_Lte{v}
}

func (x *FloatRules) SetGt(v float32) {
	x.GreaterThan = &FloatRules_Gt{v}
}

func (x *FloatRules) SetGte(v float32) {
	x.GreaterThan = &FloatRules_Gte{v}
}

func (x *FloatRules) SetIn(v []float32) {
	x.In = v
}

func (x *FloatRules) SetNotIn(v []float32) {
	x.NotIn = v
}

func (x *FloatRules) SetFinite(v bool) {
	x.Finite = &v
}

func (x *FloatRules) SetExample(v []float32) {
	x.Example = v
}

func (x *FloatRules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *FloatRules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *FloatRules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*FloatRules_Lt)
	return ok
}

func (x *FloatRules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*FloatRules_Lte)
	return ok
}

func (x *FloatRules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *FloatRules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*FloatRules_Gt)
	return ok
}

func (x *FloatRules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*FloatRules_Gte)
	return ok
}

func (x *FloatRules) HasFinite() bool {
	if x == nil {
		return false
	}
	return x.Finite != nil
}

func (x *FloatRules) ClearConst() {
	x.Const = nil
}

func (x *FloatRules) ClearLessThan() {
	x.LessThan = nil
}

func (x *FloatRules) ClearLt() {
	if _, ok := x.LessThan.(*FloatRules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *FloatRules) ClearLte() {
	if _, ok := x.LessThan.(*FloatRules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *FloatRules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *FloatRules) ClearGt() {
	if _, ok := x.GreaterThan.(*FloatRules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *FloatRules) ClearGte() {
	if _, ok := x.GreaterThan.(*FloatRules_Gte); ok {
		x.GreaterThan = nil
	}
}

func (x *FloatRules) ClearFinite() {
	x.Finite = nil
}

const FloatRules_LessThan_not_set_case case_FloatRules_LessThan = 0
const FloatRules_Lt_case case_FloatRules_LessThan = 2
const FloatRules_Lte_case case_FloatRules_LessThan = 3

func (x *FloatRules) WhichLessThan() case_FloatRules_LessThan {
	if x == nil {
		return FloatRules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *FloatRules_Lt:
		return FloatRules_Lt_case
	case *FloatRules_Lte:
		return FloatRules_Lte_case
	default:
		return FloatRules_LessThan_not_set_case
	}
}

const FloatRules_GreaterThan_not_set_case case_FloatRules_GreaterThan = 0
const FloatRules_Gt_case case_FloatRules_GreaterThan = 4
const FloatRules_Gte_case case_FloatRules_GreaterThan = 5

func (x *FloatRules) WhichGreaterThan() case_FloatRules_GreaterThan {
	if x == nil {
		return FloatRules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *FloatRules_Gt:
		return FloatRules_Gt_case
	case *FloatRules_Gte:
		return FloatRules_Gte_case
	default:
		return FloatRules_GreaterThan_not_set_case
	}
}

type FloatRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must equal 42.0
	//	  float value = 1 [(buf.validate.field).float.const = 42.0];
	//	}
	//
	// ```
	Const *float32
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be less than 10.0
	//	  float value = 1 [(buf.validate.field).float.lt = 10.0];
	//	}
	//
	// ```
	Lt *float32
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be less than or equal to 10.0
	//	  float value = 1 [(buf.validate.field).float.lte = 10.0];
	//	}
	//
	// ```
	Lte *float32
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be greater than 5.0 [float.gt]
	//	  float value = 1 [(buf.validate.field).float.gt = 5.0];
	//
	//	  // value must be greater than 5 and less than 10.0 [float.gt_lt]
	//	  float other_value = 2 [(buf.validate.field).float = { gt: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than 10 or less than 5.0 [float.gt_lt_exclusive]
	//	  float another_value = 3 [(buf.validate.field).float = { gt: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gt *float32
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be greater than or equal to 5.0 [float.gte]
	//	  float value = 1 [(buf.validate.field).float.gte = 5.0];
	//
	//	  // value must be greater than or equal to 5.0 and less than 10.0 [float.gte_lt]
	//	  float other_value = 2 [(buf.validate.field).float = { gte: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than or equal to 10.0 or less than 5.0 [float.gte_lt_exclusive]
	//	  float another_value = 3 [(buf.validate.field).float = { gte: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gte *float32
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be in list [1.0, 2.0, 3.0]
	//	  float value = 1 [(buf.validate.field).float = { in: [1.0, 2.0, 3.0] }];
	//	}
	//
	// ```
	In []float32
	// `in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must not be in list [1.0, 2.0, 3.0]
	//	  float value = 1 [(buf.validate.field).float = { not_in: [1.0, 2.0, 3.0] }];
	//	}
	//
	// ```
	NotIn []float32
	// `finite` requires the field value to be finite. If the field value is
	// infinite or NaN, an error message is generated.
	Finite *bool
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  float value = 1 [
	//	    (buf.validate.field).float.example = 1.0,
	//	    (buf.validate.field).float.example = inf
	//	  ];
	//	}
	//
	// ```
	Example []float32
}

func (b0 FloatRules_builder) Build() *FloatRules {
	m0 := &FloatRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &FloatRules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &FloatRules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &FloatRules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &FloatRules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Finite = b.Finite
	x.Example = b.Example
	return m0
}

type case_FloatRules_LessThan protoreflect.FieldNumber

func (x case_FloatRules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[6].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_FloatRules_GreaterThan protoreflect.FieldNumber

func (x case_FloatRules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[6].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isFloatRules_LessThan interface {
	isFloatRules_LessThan()
}

type FloatRules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be less than 10.0
	//	  float value = 1 [(buf.validate.field).float.lt = 10.0];
	//	}
	//
	// ```
	Lt float32 `protobuf:"fixed32,2,opt,name=lt,oneof"`
}

type FloatRules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be less than or equal to 10.0
	//	  float value = 1 [(buf.validate.field).float.lte = 10.0];
	//	}
	//
	// ```
	Lte float32 `protobuf:"fixed32,3,opt,name=lte,oneof"`
}

func (*FloatRules_Lt) isFloatRules_LessThan() {}

func (*FloatRules_Lte) isFloatRules_LessThan() {}

type isFloatRules_GreaterThan interface {
	isFloatRules_GreaterThan()
}

type FloatRules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be greater than 5.0 [float.gt]
	//	  float value = 1 [(buf.validate.field).float.gt = 5.0];
	//
	//	  // value must be greater than 5 and less than 10.0 [float.gt_lt]
	//	  float other_value = 2 [(buf.validate.field).float = { gt: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than 10 or less than 5.0 [float.gt_lt_exclusive]
	//	  float another_value = 3 [(buf.validate.field).float = { gt: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gt float32 `protobuf:"fixed32,4,opt,name=gt,oneof"`
}

type FloatRules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFloat {
	//	  // value must be greater than or equal to 5.0 [float.gte]
	//	  float value = 1 [(buf.validate.field).float.gte = 5.0];
	//
	//	  // value must be greater than or equal to 5.0 and less than 10.0 [float.gte_lt]
	//	  float other_value = 2 [(buf.validate.field).float = { gte: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than or equal to 10.0 or less than 5.0 [float.gte_lt_exclusive]
	//	  float another_value = 3 [(buf.validate.field).float = { gte: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gte float32 `protobuf:"fixed32,5,opt,name=gte,oneof"`
}

func (*FloatRules_Gt) isFloatRules_GreaterThan() {}

func (*FloatRules_Gte) isFloatRules_GreaterThan() {}

// DoubleRules describes the rules applied to `double` values. These
// rules may also be applied to the `google.protobuf.DoubleValue` Well-Known-Type.
type DoubleRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must equal 42.0
	//	  double value = 1 [(buf.validate.field).double.const = 42.0];
	//	}
	//
	// ```
	Const *float64 `protobuf:"fixed64,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*DoubleRules_Lt
	//	*DoubleRules_Lte
	LessThan isDoubleRules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*DoubleRules_Gt
	//	*DoubleRules_Gte
	GreaterThan isDoubleRules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be in list [1.0, 2.0, 3.0]
	//	  double value = 1 [(buf.validate.field).double = { in: [1.0, 2.0, 3.0] }];
	//	}
	//
	// ```
	In []float64 `protobuf:"fixed64,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must not be in list [1.0, 2.0, 3.0]
	//	  double value = 1 [(buf.validate.field).double = { not_in: [1.0, 2.0, 3.0] }];
	//	}
	//
	// ```
	NotIn []float64 `protobuf:"fixed64,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `finite` requires the field value to be finite. If the field value is
	// infinite or NaN, an error message is generated.
	Finite *bool `protobuf:"varint,8,opt,name=finite" json:"finite,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  double value = 1 [
	//	    (buf.validate.field).double.example = 1.0,
	//	    (buf.validate.field).double.example = inf
	//	  ];
	//	}
	//
	// ```
	Example         []float64 `protobuf:"fixed64,9,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *DoubleRules) Reset() {
	*x = DoubleRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DoubleRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleRules) ProtoMessage() {}

func (x *DoubleRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DoubleRules) GetConst() float64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *DoubleRules) GetLessThan() isDoubleRules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *DoubleRules) GetLt() float64 {
	if x != nil {
		if x, ok := x.LessThan.(*DoubleRules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *DoubleRules) GetLte() float64 {
	if x != nil {
		if x, ok := x.LessThan.(*DoubleRules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *DoubleRules) GetGreaterThan() isDoubleRules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *DoubleRules) GetGt() float64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*DoubleRules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *DoubleRules) GetGte() float64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*DoubleRules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *DoubleRules) GetIn() []float64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *DoubleRules) GetNotIn() []float64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *DoubleRules) GetFinite() bool {
	if x != nil && x.Finite != nil {
		return *x.Finite
	}
	return false
}

func (x *DoubleRules) GetExample() []float64 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *DoubleRules) SetConst(v float64) {
	x.Const = &v
}

func (x *DoubleRules) SetLt(v float64) {
	x.LessThan = &DoubleRules_Lt{v}
}

func (x *DoubleRules) SetLte(v float64) {
	x.LessThan = &DoubleRules_Lte{v}
}

func (x *DoubleRules) SetGt(v float64) {
	x.GreaterThan = &DoubleRules_Gt{v}
}

func (x *DoubleRules) SetGte(v float64) {
	x.GreaterThan = &DoubleRules_Gte{v}
}

func (x *DoubleRules) SetIn(v []float64) {
	x.In = v
}

func (x *DoubleRules) SetNotIn(v []float64) {
	x.NotIn = v
}

func (x *DoubleRules) SetFinite(v bool) {
	x.Finite = &v
}

func (x *DoubleRules) SetExample(v []float64) {
	x.Example = v
}

func (x *DoubleRules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *DoubleRules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *DoubleRules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*DoubleRules_Lt)
	return ok
}

func (x *DoubleRules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*DoubleRules_Lte)
	return ok
}

func (x *DoubleRules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *DoubleRules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*DoubleRules_Gt)
	return ok
}

func (x *DoubleRules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*DoubleRules_Gte)
	return ok
}

func (x *DoubleRules) HasFinite() bool {
	if x == nil {
		return false
	}
	return x.Finite != nil
}

func (x *DoubleRules) ClearConst() {
	x.Const = nil
}

func (x *DoubleRules) ClearLessThan() {
	x.LessThan = nil
}

func (x *DoubleRules) ClearLt() {
	if _, ok := x.LessThan.(*DoubleRules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *DoubleRules) ClearLte() {
	if _, ok := x.LessThan.(*DoubleRules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *DoubleRules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *DoubleRules) ClearGt() {
	if _, ok := x.GreaterThan.(*DoubleRules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *DoubleRules) ClearGte() {
	if _, ok := x.GreaterThan.(*DoubleRules_Gte); ok {
		x.GreaterThan = nil
	}
}

func (x *DoubleRules) ClearFinite() {
	x.Finite = nil
}

const DoubleRules_LessThan_not_set_case case_DoubleRules_LessThan = 0
const DoubleRules_Lt_case case_DoubleRules_LessThan = 2
const DoubleRules_Lte_case case_DoubleRules_LessThan = 3

func (x *DoubleRules) WhichLessThan() case_DoubleRules_LessThan {
	if x == nil {
		return DoubleRules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *DoubleRules_Lt:
		return DoubleRules_Lt_case
	case *DoubleRules_Lte:
		return DoubleRules_Lte_case
	default:
		return DoubleRules_LessThan_not_set_case
	}
}

const DoubleRules_GreaterThan_not_set_case case_DoubleRules_GreaterThan = 0
const DoubleRules_Gt_case case_DoubleRules_GreaterThan = 4
const DoubleRules_Gte_case case_DoubleRules_GreaterThan = 5

func (x *DoubleRules) WhichGreaterThan() case_DoubleRules_GreaterThan {
	if x == nil {
		return DoubleRules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *DoubleRules_Gt:
		return DoubleRules_Gt_case
	case *DoubleRules_Gte:
		return DoubleRules_Gte_case
	default:
		return DoubleRules_GreaterThan_not_set_case
	}
}

type DoubleRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must equal 42.0
	//	  double value = 1 [(buf.validate.field).double.const = 42.0];
	//	}
	//
	// ```
	Const *float64
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be less than 10.0
	//	  double value = 1 [(buf.validate.field).double.lt = 10.0];
	//	}
	//
	// ```
	Lt *float64
	// `lte` requires the field value to be less than or equal to the specified value
	// (field <= value). If the field value is greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be less than or equal to 10.0
	//	  double value = 1 [(buf.validate.field).double.lte = 10.0];
	//	}
	//
	// ```
	Lte *float64
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or `lte`,
	// the range is reversed, and the field value must be outside the specified
	// range. If the field value doesn't meet the required conditions, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be greater than 5.0 [double.gt]
	//	  double value = 1 [(buf.validate.field).double.gt = 5.0];
	//
	//	  // value must be greater than 5 and less than 10.0 [double.gt_lt]
	//	  double other_value = 2 [(buf.validate.field).double = { gt: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than 10 or less than 5.0 [double.gt_lt_exclusive]
	//	  double another_value = 3 [(buf.validate.field).double = { gt: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gt *float64
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be greater than or equal to 5.0 [double.gte]
	//	  double value = 1 [(buf.validate.field).double.gte = 5.0];
	//
	//	  // value must be greater than or equal to 5.0 and less than 10.0 [double.gte_lt]
	//	  double other_value = 2 [(buf.validate.field).double = { gte: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than or equal to 10.0 or less than 5.0 [double.gte_lt_exclusive]
	//	  double another_value = 3 [(buf.validate.field).double = { gte: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gte *float64
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be in list [1.0, 2.0, 3.0]
	//	  double value = 1 [(buf.validate.field).double = { in: [1.0, 2.0, 3.0] }];
	//	}
	//
	// ```
	In []float64
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must not be in list [1.0, 2.0, 3.0]
	//	  double value = 1 [(buf.validate.field).double = { not_in: [1.0, 2.0, 3.0] }];
	//	}
	//
	// ```
	NotIn []float64
	// `finite` requires the field value to be finite. If the field value is
	// infinite or NaN, an error message is generated.
	Finite *bool
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  double value = 1 [
	//	    (buf.validate.field).double.example = 1.0,
	//	    (buf.validate.field).double.example = inf
	//	  ];
	//	}
	//
	// ```
	Example []float64
}

func (b0 DoubleRules_builder) Build() *DoubleRules {
	m0 := &DoubleRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &DoubleRules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &DoubleRules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &DoubleRules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &DoubleRules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Finite = b.Finite
	x.Example = b.Example
	return m0
}

type case_DoubleRules_LessThan protoreflect.FieldNumber

func (x case_DoubleRules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[7].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_DoubleRules_GreaterThan protoreflect.FieldNumber

func (x case_DoubleRules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[7].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isDoubleRules_LessThan interface {
	isDoubleRules_LessThan()
}

type DoubleRules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be less than 10.0
	//	  double value = 1 [(buf.validate.field).double.lt = 10.0];
	//	}
	//
	// ```
	Lt float64 `protobuf:"fixed64,2,opt,name=lt,oneof"`
}

type DoubleRules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified value
	// (field <= value). If the field value is greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be less than or equal to 10.0
	//	  double value = 1 [(buf.validate.field).double.lte = 10.0];
	//	}
	//
	// ```
	Lte float64 `protobuf:"fixed64,3,opt,name=lte,oneof"`
}

func (*DoubleRules_Lt) isDoubleRules_LessThan() {}

func (*DoubleRules_Lte) isDoubleRules_LessThan() {}

type isDoubleRules_GreaterThan interface {
	isDoubleRules_GreaterThan()
}

type DoubleRules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or `lte`,
	// the range is reversed, and the field value must be outside the specified
	// range. If the field value doesn't meet the required conditions, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be greater than 5.0 [double.gt]
	//	  double value = 1 [(buf.validate.field).double.gt = 5.0];
	//
	//	  // value must be greater than 5 and less than 10.0 [double.gt_lt]
	//	  double other_value = 2 [(buf.validate.field).double = { gt: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than 10 or less than 5.0 [double.gt_lt_exclusive]
	//	  double another_value = 3 [(buf.validate.field).double = { gt: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gt float64 `protobuf:"fixed64,4,opt,name=gt,oneof"`
}

type DoubleRules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyDouble {
	//	  // value must be greater than or equal to 5.0 [double.gte]
	//	  double value = 1 [(buf.validate.field).double.gte = 5.0];
	//
	//	  // value must be greater than or equal to 5.0 and less than 10.0 [double.gte_lt]
	//	  double other_value = 2 [(buf.validate.field).double = { gte: 5.0, lt: 10.0 }];
	//
	//	  // value must be greater than or equal to 10.0 or less than 5.0 [double.gte_lt_exclusive]
	//	  double another_value = 3 [(buf.validate.field).double = { gte: 10.0, lt: 5.0 }];
	//	}
	//
	// ```
	Gte float64 `protobuf:"fixed64,5,opt,name=gte,oneof"`
}

func (*DoubleRules_Gt) isDoubleRules_GreaterThan() {}

func (*DoubleRules_Gte) isDoubleRules_GreaterThan() {}

// Int32Rules describes the rules applied to `int32` values. These
// rules may also be applied to the `google.protobuf.Int32Value` Well-Known-Type.
type Int32Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must equal 42
	//	  int32 value = 1 [(buf.validate.field).int32.const = 42];
	//	}
	//
	// ```
	Const *int32 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*Int32Rules_Lt
	//	*Int32Rules_Lte
	LessThan isInt32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*Int32Rules_Gt
	//	*Int32Rules_Gte
	GreaterThan isInt32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be in list [1, 2, 3]
	//	  int32 value = 1 [(buf.validate.field).int32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int32 `protobuf:"varint,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must not be in list [1, 2, 3]
	//	  int32 value = 1 [(buf.validate.field).int32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int32 `protobuf:"varint,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  int32 value = 1 [
	//	    (buf.validate.field).int32.example = 1,
	//	    (buf.validate.field).int32.example = -10
	//	  ];
	//	}
	//
	// ```
	Example         []int32 `protobuf:"varint,8,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Int32Rules) Reset() {
	*x = Int32Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Int32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Int32Rules) ProtoMessage() {}

func (x *Int32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Int32Rules) GetConst() int32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *Int32Rules) GetLessThan() isInt32Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *Int32Rules) GetLt() int32 {
	if x != nil {
		if x, ok := x.LessThan.(*Int32Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *Int32Rules) GetLte() int32 {
	if x != nil {
		if x, ok := x.LessThan.(*Int32Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *Int32Rules) GetGreaterThan() isInt32Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *Int32Rules) GetGt() int32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*Int32Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *Int32Rules) GetGte() int32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*Int32Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *Int32Rules) GetIn() []int32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *Int32Rules) GetNotIn() []int32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *Int32Rules) GetExample() []int32 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *Int32Rules) SetConst(v int32) {
	x.Const = &v
}

func (x *Int32Rules) SetLt(v int32) {
	x.LessThan = &Int32Rules_Lt{v}
}

func (x *Int32Rules) SetLte(v int32) {
	x.LessThan = &Int32Rules_Lte{v}
}

func (x *Int32Rules) SetGt(v int32) {
	x.GreaterThan = &Int32Rules_Gt{v}
}

func (x *Int32Rules) SetGte(v int32) {
	x.GreaterThan = &Int32Rules_Gte{v}
}

func (x *Int32Rules) SetIn(v []int32) {
	x.In = v
}

func (x *Int32Rules) SetNotIn(v []int32) {
	x.NotIn = v
}

func (x *Int32Rules) SetExample(v []int32) {
	x.Example = v
}

func (x *Int32Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *Int32Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *Int32Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*Int32Rules_Lt)
	return ok
}

func (x *Int32Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*Int32Rules_Lte)
	return ok
}

func (x *Int32Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *Int32Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*Int32Rules_Gt)
	return ok
}

func (x *Int32Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*Int32Rules_Gte)
	return ok
}

func (x *Int32Rules) ClearConst() {
	x.Const = nil
}

func (x *Int32Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *Int32Rules) ClearLt() {
	if _, ok := x.LessThan.(*Int32Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *Int32Rules) ClearLte() {
	if _, ok := x.LessThan.(*Int32Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *Int32Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *Int32Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*Int32Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *Int32Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*Int32Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const Int32Rules_LessThan_not_set_case case_Int32Rules_LessThan = 0
const Int32Rules_Lt_case case_Int32Rules_LessThan = 2
const Int32Rules_Lte_case case_Int32Rules_LessThan = 3

func (x *Int32Rules) WhichLessThan() case_Int32Rules_LessThan {
	if x == nil {
		return Int32Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *Int32Rules_Lt:
		return Int32Rules_Lt_case
	case *Int32Rules_Lte:
		return Int32Rules_Lte_case
	default:
		return Int32Rules_LessThan_not_set_case
	}
}

const Int32Rules_GreaterThan_not_set_case case_Int32Rules_GreaterThan = 0
const Int32Rules_Gt_case case_Int32Rules_GreaterThan = 4
const Int32Rules_Gte_case case_Int32Rules_GreaterThan = 5

func (x *Int32Rules) WhichGreaterThan() case_Int32Rules_GreaterThan {
	if x == nil {
		return Int32Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *Int32Rules_Gt:
		return Int32Rules_Gt_case
	case *Int32Rules_Gte:
		return Int32Rules_Gte_case
	default:
		return Int32Rules_GreaterThan_not_set_case
	}
}

type Int32Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must equal 42
	//	  int32 value = 1 [(buf.validate.field).int32.const = 42];
	//	}
	//
	// ```
	Const *int32
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field
	// < value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be less than 10
	//	  int32 value = 1 [(buf.validate.field).int32.lt = 10];
	//	}
	//
	// ```
	Lt *int32
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be less than or equal to 10
	//	  int32 value = 1 [(buf.validate.field).int32.lte = 10];
	//	}
	//
	// ```
	Lte *int32
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be greater than 5 [int32.gt]
	//	  int32 value = 1 [(buf.validate.field).int32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [int32.gt_lt]
	//	  int32 other_value = 2 [(buf.validate.field).int32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [int32.gt_lt_exclusive]
	//	  int32 another_value = 3 [(buf.validate.field).int32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *int32
	// `gte` requires the field value to be greater than or equal to the specified value
	// (exclusive). If the value of `gte` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be greater than or equal to 5 [int32.gte]
	//	  int32 value = 1 [(buf.validate.field).int32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [int32.gte_lt]
	//	  int32 other_value = 2 [(buf.validate.field).int32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [int32.gte_lt_exclusive]
	//	  int32 another_value = 3 [(buf.validate.field).int32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *int32
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be in list [1, 2, 3]
	//	  int32 value = 1 [(buf.validate.field).int32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int32
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must not be in list [1, 2, 3]
	//	  int32 value = 1 [(buf.validate.field).int32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int32
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  int32 value = 1 [
	//	    (buf.validate.field).int32.example = 1,
	//	    (buf.validate.field).int32.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []int32
}

func (b0 Int32Rules_builder) Build() *Int32Rules {
	m0 := &Int32Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &Int32Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &Int32Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &Int32Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &Int32Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_Int32Rules_LessThan protoreflect.FieldNumber

func (x case_Int32Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[8].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_Int32Rules_GreaterThan protoreflect.FieldNumber

func (x case_Int32Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[8].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isInt32Rules_LessThan interface {
	isInt32Rules_LessThan()
}

type Int32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field
	// < value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be less than 10
	//	  int32 value = 1 [(buf.validate.field).int32.lt = 10];
	//	}
	//
	// ```
	Lt int32 `protobuf:"varint,2,opt,name=lt,oneof"`
}

type Int32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be less than or equal to 10
	//	  int32 value = 1 [(buf.validate.field).int32.lte = 10];
	//	}
	//
	// ```
	Lte int32 `protobuf:"varint,3,opt,name=lte,oneof"`
}

func (*Int32Rules_Lt) isInt32Rules_LessThan() {}

func (*Int32Rules_Lte) isInt32Rules_LessThan() {}

type isInt32Rules_GreaterThan interface {
	isInt32Rules_GreaterThan()
}

type Int32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be greater than 5 [int32.gt]
	//	  int32 value = 1 [(buf.validate.field).int32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [int32.gt_lt]
	//	  int32 other_value = 2 [(buf.validate.field).int32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [int32.gt_lt_exclusive]
	//	  int32 another_value = 3 [(buf.validate.field).int32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int32 `protobuf:"varint,4,opt,name=gt,oneof"`
}

type Int32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified value
	// (exclusive). If the value of `gte` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt32 {
	//	  // value must be greater than or equal to 5 [int32.gte]
	//	  int32 value = 1 [(buf.validate.field).int32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [int32.gte_lt]
	//	  int32 other_value = 2 [(buf.validate.field).int32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [int32.gte_lt_exclusive]
	//	  int32 another_value = 3 [(buf.validate.field).int32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int32 `protobuf:"varint,5,opt,name=gte,oneof"`
}

func (*Int32Rules_Gt) isInt32Rules_GreaterThan() {}

func (*Int32Rules_Gte) isInt32Rules_GreaterThan() {}

// Int64Rules describes the rules applied to `int64` values. These
// rules may also be applied to the `google.protobuf.Int64Value` Well-Known-Type.
type Int64Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must equal 42
	//	  int64 value = 1 [(buf.validate.field).int64.const = 42];
	//	}
	//
	// ```
	Const *int64 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*Int64Rules_Lt
	//	*Int64Rules_Lte
	LessThan isInt64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*Int64Rules_Gt
	//	*Int64Rules_Gte
	GreaterThan isInt64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be in list [1, 2, 3]
	//	  int64 value = 1 [(buf.validate.field).int64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int64 `protobuf:"varint,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must not be in list [1, 2, 3]
	//	  int64 value = 1 [(buf.validate.field).int64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int64 `protobuf:"varint,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  int64 value = 1 [
	//	    (buf.validate.field).int64.example = 1,
	//	    (buf.validate.field).int64.example = -10
	//	  ];
	//	}
	//
	// ```
	Example         []int64 `protobuf:"varint,9,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Int64Rules) Reset() {
	*x = Int64Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Int64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Int64Rules) ProtoMessage() {}

func (x *Int64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Int64Rules) GetConst() int64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *Int64Rules) GetLessThan() isInt64Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *Int64Rules) GetLt() int64 {
	if x != nil {
		if x, ok := x.LessThan.(*Int64Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *Int64Rules) GetLte() int64 {
	if x != nil {
		if x, ok := x.LessThan.(*Int64Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *Int64Rules) GetGreaterThan() isInt64Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *Int64Rules) GetGt() int64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*Int64Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *Int64Rules) GetGte() int64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*Int64Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *Int64Rules) GetIn() []int64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *Int64Rules) GetNotIn() []int64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *Int64Rules) GetExample() []int64 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *Int64Rules) SetConst(v int64) {
	x.Const = &v
}

func (x *Int64Rules) SetLt(v int64) {
	x.LessThan = &Int64Rules_Lt{v}
}

func (x *Int64Rules) SetLte(v int64) {
	x.LessThan = &Int64Rules_Lte{v}
}

func (x *Int64Rules) SetGt(v int64) {
	x.GreaterThan = &Int64Rules_Gt{v}
}

func (x *Int64Rules) SetGte(v int64) {
	x.GreaterThan = &Int64Rules_Gte{v}
}

func (x *Int64Rules) SetIn(v []int64) {
	x.In = v
}

func (x *Int64Rules) SetNotIn(v []int64) {
	x.NotIn = v
}

func (x *Int64Rules) SetExample(v []int64) {
	x.Example = v
}

func (x *Int64Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *Int64Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *Int64Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*Int64Rules_Lt)
	return ok
}

func (x *Int64Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*Int64Rules_Lte)
	return ok
}

func (x *Int64Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *Int64Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*Int64Rules_Gt)
	return ok
}

func (x *Int64Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*Int64Rules_Gte)
	return ok
}

func (x *Int64Rules) ClearConst() {
	x.Const = nil
}

func (x *Int64Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *Int64Rules) ClearLt() {
	if _, ok := x.LessThan.(*Int64Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *Int64Rules) ClearLte() {
	if _, ok := x.LessThan.(*Int64Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *Int64Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *Int64Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*Int64Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *Int64Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*Int64Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const Int64Rules_LessThan_not_set_case case_Int64Rules_LessThan = 0
const Int64Rules_Lt_case case_Int64Rules_LessThan = 2
const Int64Rules_Lte_case case_Int64Rules_LessThan = 3

func (x *Int64Rules) WhichLessThan() case_Int64Rules_LessThan {
	if x == nil {
		return Int64Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *Int64Rules_Lt:
		return Int64Rules_Lt_case
	case *Int64Rules_Lte:
		return Int64Rules_Lte_case
	default:
		return Int64Rules_LessThan_not_set_case
	}
}

const Int64Rules_GreaterThan_not_set_case case_Int64Rules_GreaterThan = 0
const Int64Rules_Gt_case case_Int64Rules_GreaterThan = 4
const Int64Rules_Gte_case case_Int64Rules_GreaterThan = 5

func (x *Int64Rules) WhichGreaterThan() case_Int64Rules_GreaterThan {
	if x == nil {
		return Int64Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *Int64Rules_Gt:
		return Int64Rules_Gt_case
	case *Int64Rules_Gte:
		return Int64Rules_Gte_case
	default:
		return Int64Rules_GreaterThan_not_set_case
	}
}

type Int64Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must equal 42
	//	  int64 value = 1 [(buf.validate.field).int64.const = 42];
	//	}
	//
	// ```
	Const *int64
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be less than 10
	//	  int64 value = 1 [(buf.validate.field).int64.lt = 10];
	//	}
	//
	// ```
	Lt *int64
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be less than or equal to 10
	//	  int64 value = 1 [(buf.validate.field).int64.lte = 10];
	//	}
	//
	// ```
	Lte *int64
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be greater than 5 [int64.gt]
	//	  int64 value = 1 [(buf.validate.field).int64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [int64.gt_lt]
	//	  int64 other_value = 2 [(buf.validate.field).int64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [int64.gt_lt_exclusive]
	//	  int64 another_value = 3 [(buf.validate.field).int64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *int64
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be greater than or equal to 5 [int64.gte]
	//	  int64 value = 1 [(buf.validate.field).int64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [int64.gte_lt]
	//	  int64 other_value = 2 [(buf.validate.field).int64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [int64.gte_lt_exclusive]
	//	  int64 another_value = 3 [(buf.validate.field).int64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *int64
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be in list [1, 2, 3]
	//	  int64 value = 1 [(buf.validate.field).int64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int64
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must not be in list [1, 2, 3]
	//	  int64 value = 1 [(buf.validate.field).int64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int64
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  int64 value = 1 [
	//	    (buf.validate.field).int64.example = 1,
	//	    (buf.validate.field).int64.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []int64
}

func (b0 Int64Rules_builder) Build() *Int64Rules {
	m0 := &Int64Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &Int64Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &Int64Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &Int64Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &Int64Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_Int64Rules_LessThan protoreflect.FieldNumber

func (x case_Int64Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[9].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_Int64Rules_GreaterThan protoreflect.FieldNumber

func (x case_Int64Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[9].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isInt64Rules_LessThan interface {
	isInt64Rules_LessThan()
}

type Int64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be less than 10
	//	  int64 value = 1 [(buf.validate.field).int64.lt = 10];
	//	}
	//
	// ```
	Lt int64 `protobuf:"varint,2,opt,name=lt,oneof"`
}

type Int64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be less than or equal to 10
	//	  int64 value = 1 [(buf.validate.field).int64.lte = 10];
	//	}
	//
	// ```
	Lte int64 `protobuf:"varint,3,opt,name=lte,oneof"`
}

func (*Int64Rules_Lt) isInt64Rules_LessThan() {}

func (*Int64Rules_Lte) isInt64Rules_LessThan() {}

type isInt64Rules_GreaterThan interface {
	isInt64Rules_GreaterThan()
}

type Int64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be greater than 5 [int64.gt]
	//	  int64 value = 1 [(buf.validate.field).int64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [int64.gt_lt]
	//	  int64 other_value = 2 [(buf.validate.field).int64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [int64.gt_lt_exclusive]
	//	  int64 another_value = 3 [(buf.validate.field).int64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int64 `protobuf:"varint,4,opt,name=gt,oneof"`
}

type Int64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyInt64 {
	//	  // value must be greater than or equal to 5 [int64.gte]
	//	  int64 value = 1 [(buf.validate.field).int64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [int64.gte_lt]
	//	  int64 other_value = 2 [(buf.validate.field).int64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [int64.gte_lt_exclusive]
	//	  int64 another_value = 3 [(buf.validate.field).int64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int64 `protobuf:"varint,5,opt,name=gte,oneof"`
}

func (*Int64Rules_Gt) isInt64Rules_GreaterThan() {}

func (*Int64Rules_Gte) isInt64Rules_GreaterThan() {}

// UInt32Rules describes the rules applied to `uint32` values. These
// rules may also be applied to the `google.protobuf.UInt32Value` Well-Known-Type.
type UInt32Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must equal 42
	//	  uint32 value = 1 [(buf.validate.field).uint32.const = 42];
	//	}
	//
	// ```
	Const *uint32 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*UInt32Rules_Lt
	//	*UInt32Rules_Lte
	LessThan isUInt32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*UInt32Rules_Gt
	//	*UInt32Rules_Gte
	GreaterThan isUInt32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be in list [1, 2, 3]
	//	  uint32 value = 1 [(buf.validate.field).uint32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []uint32 `protobuf:"varint,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must not be in list [1, 2, 3]
	//	  uint32 value = 1 [(buf.validate.field).uint32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []uint32 `protobuf:"varint,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  uint32 value = 1 [
	//	    (buf.validate.field).uint32.example = 1,
	//	    (buf.validate.field).uint32.example = 10
	//	  ];
	//	}
	//
	// ```
	Example         []uint32 `protobuf:"varint,8,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *UInt32Rules) Reset() {
	*x = UInt32Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UInt32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UInt32Rules) ProtoMessage() {}

func (x *UInt32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UInt32Rules) GetConst() uint32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *UInt32Rules) GetLessThan() isUInt32Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *UInt32Rules) GetLt() uint32 {
	if x != nil {
		if x, ok := x.LessThan.(*UInt32Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *UInt32Rules) GetLte() uint32 {
	if x != nil {
		if x, ok := x.LessThan.(*UInt32Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *UInt32Rules) GetGreaterThan() isUInt32Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *UInt32Rules) GetGt() uint32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*UInt32Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *UInt32Rules) GetGte() uint32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*UInt32Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *UInt32Rules) GetIn() []uint32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *UInt32Rules) GetNotIn() []uint32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *UInt32Rules) GetExample() []uint32 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *UInt32Rules) SetConst(v uint32) {
	x.Const = &v
}

func (x *UInt32Rules) SetLt(v uint32) {
	x.LessThan = &UInt32Rules_Lt{v}
}

func (x *UInt32Rules) SetLte(v uint32) {
	x.LessThan = &UInt32Rules_Lte{v}
}

func (x *UInt32Rules) SetGt(v uint32) {
	x.GreaterThan = &UInt32Rules_Gt{v}
}

func (x *UInt32Rules) SetGte(v uint32) {
	x.GreaterThan = &UInt32Rules_Gte{v}
}

func (x *UInt32Rules) SetIn(v []uint32) {
	x.In = v
}

func (x *UInt32Rules) SetNotIn(v []uint32) {
	x.NotIn = v
}

func (x *UInt32Rules) SetExample(v []uint32) {
	x.Example = v
}

func (x *UInt32Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *UInt32Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *UInt32Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*UInt32Rules_Lt)
	return ok
}

func (x *UInt32Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*UInt32Rules_Lte)
	return ok
}

func (x *UInt32Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *UInt32Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*UInt32Rules_Gt)
	return ok
}

func (x *UInt32Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*UInt32Rules_Gte)
	return ok
}

func (x *UInt32Rules) ClearConst() {
	x.Const = nil
}

func (x *UInt32Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *UInt32Rules) ClearLt() {
	if _, ok := x.LessThan.(*UInt32Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *UInt32Rules) ClearLte() {
	if _, ok := x.LessThan.(*UInt32Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *UInt32Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *UInt32Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*UInt32Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *UInt32Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*UInt32Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const UInt32Rules_LessThan_not_set_case case_UInt32Rules_LessThan = 0
const UInt32Rules_Lt_case case_UInt32Rules_LessThan = 2
const UInt32Rules_Lte_case case_UInt32Rules_LessThan = 3

func (x *UInt32Rules) WhichLessThan() case_UInt32Rules_LessThan {
	if x == nil {
		return UInt32Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *UInt32Rules_Lt:
		return UInt32Rules_Lt_case
	case *UInt32Rules_Lte:
		return UInt32Rules_Lte_case
	default:
		return UInt32Rules_LessThan_not_set_case
	}
}

const UInt32Rules_GreaterThan_not_set_case case_UInt32Rules_GreaterThan = 0
const UInt32Rules_Gt_case case_UInt32Rules_GreaterThan = 4
const UInt32Rules_Gte_case case_UInt32Rules_GreaterThan = 5

func (x *UInt32Rules) WhichGreaterThan() case_UInt32Rules_GreaterThan {
	if x == nil {
		return UInt32Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *UInt32Rules_Gt:
		return UInt32Rules_Gt_case
	case *UInt32Rules_Gte:
		return UInt32Rules_Gte_case
	default:
		return UInt32Rules_GreaterThan_not_set_case
	}
}

type UInt32Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must equal 42
	//	  uint32 value = 1 [(buf.validate.field).uint32.const = 42];
	//	}
	//
	// ```
	Const *uint32
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be less than 10
	//	  uint32 value = 1 [(buf.validate.field).uint32.lt = 10];
	//	}
	//
	// ```
	Lt *uint32
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be less than or equal to 10
	//	  uint32 value = 1 [(buf.validate.field).uint32.lte = 10];
	//	}
	//
	// ```
	Lte *uint32
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be greater than 5 [uint32.gt]
	//	  uint32 value = 1 [(buf.validate.field).uint32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [uint32.gt_lt]
	//	  uint32 other_value = 2 [(buf.validate.field).uint32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [uint32.gt_lt_exclusive]
	//	  uint32 another_value = 3 [(buf.validate.field).uint32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *uint32
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be greater than or equal to 5 [uint32.gte]
	//	  uint32 value = 1 [(buf.validate.field).uint32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [uint32.gte_lt]
	//	  uint32 other_value = 2 [(buf.validate.field).uint32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [uint32.gte_lt_exclusive]
	//	  uint32 another_value = 3 [(buf.validate.field).uint32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *uint32
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be in list [1, 2, 3]
	//	  uint32 value = 1 [(buf.validate.field).uint32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []uint32
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must not be in list [1, 2, 3]
	//	  uint32 value = 1 [(buf.validate.field).uint32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []uint32
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  uint32 value = 1 [
	//	    (buf.validate.field).uint32.example = 1,
	//	    (buf.validate.field).uint32.example = 10
	//	  ];
	//	}
	//
	// ```
	Example []uint32
}

func (b0 UInt32Rules_builder) Build() *UInt32Rules {
	m0 := &UInt32Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &UInt32Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &UInt32Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &UInt32Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &UInt32Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_UInt32Rules_LessThan protoreflect.FieldNumber

func (x case_UInt32Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[10].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_UInt32Rules_GreaterThan protoreflect.FieldNumber

func (x case_UInt32Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[10].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isUInt32Rules_LessThan interface {
	isUInt32Rules_LessThan()
}

type UInt32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be less than 10
	//	  uint32 value = 1 [(buf.validate.field).uint32.lt = 10];
	//	}
	//
	// ```
	Lt uint32 `protobuf:"varint,2,opt,name=lt,oneof"`
}

type UInt32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be less than or equal to 10
	//	  uint32 value = 1 [(buf.validate.field).uint32.lte = 10];
	//	}
	//
	// ```
	Lte uint32 `protobuf:"varint,3,opt,name=lte,oneof"`
}

func (*UInt32Rules_Lt) isUInt32Rules_LessThan() {}

func (*UInt32Rules_Lte) isUInt32Rules_LessThan() {}

type isUInt32Rules_GreaterThan interface {
	isUInt32Rules_GreaterThan()
}

type UInt32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be greater than 5 [uint32.gt]
	//	  uint32 value = 1 [(buf.validate.field).uint32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [uint32.gt_lt]
	//	  uint32 other_value = 2 [(buf.validate.field).uint32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [uint32.gt_lt_exclusive]
	//	  uint32 another_value = 3 [(buf.validate.field).uint32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt uint32 `protobuf:"varint,4,opt,name=gt,oneof"`
}

type UInt32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt32 {
	//	  // value must be greater than or equal to 5 [uint32.gte]
	//	  uint32 value = 1 [(buf.validate.field).uint32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [uint32.gte_lt]
	//	  uint32 other_value = 2 [(buf.validate.field).uint32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [uint32.gte_lt_exclusive]
	//	  uint32 another_value = 3 [(buf.validate.field).uint32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte uint32 `protobuf:"varint,5,opt,name=gte,oneof"`
}

func (*UInt32Rules_Gt) isUInt32Rules_GreaterThan() {}

func (*UInt32Rules_Gte) isUInt32Rules_GreaterThan() {}

// UInt64Rules describes the rules applied to `uint64` values. These
// rules may also be applied to the `google.protobuf.UInt64Value` Well-Known-Type.
type UInt64Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must equal 42
	//	  uint64 value = 1 [(buf.validate.field).uint64.const = 42];
	//	}
	//
	// ```
	Const *uint64 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*UInt64Rules_Lt
	//	*UInt64Rules_Lte
	LessThan isUInt64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*UInt64Rules_Gt
	//	*UInt64Rules_Gte
	GreaterThan isUInt64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be in list [1, 2, 3]
	//	  uint64 value = 1 [(buf.validate.field).uint64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []uint64 `protobuf:"varint,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must not be in list [1, 2, 3]
	//	  uint64 value = 1 [(buf.validate.field).uint64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []uint64 `protobuf:"varint,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  uint64 value = 1 [
	//	    (buf.validate.field).uint64.example = 1,
	//	    (buf.validate.field).uint64.example = -10
	//	  ];
	//	}
	//
	// ```
	Example         []uint64 `protobuf:"varint,8,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *UInt64Rules) Reset() {
	*x = UInt64Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UInt64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UInt64Rules) ProtoMessage() {}

func (x *UInt64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UInt64Rules) GetConst() uint64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *UInt64Rules) GetLessThan() isUInt64Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *UInt64Rules) GetLt() uint64 {
	if x != nil {
		if x, ok := x.LessThan.(*UInt64Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *UInt64Rules) GetLte() uint64 {
	if x != nil {
		if x, ok := x.LessThan.(*UInt64Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *UInt64Rules) GetGreaterThan() isUInt64Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *UInt64Rules) GetGt() uint64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*UInt64Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *UInt64Rules) GetGte() uint64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*UInt64Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *UInt64Rules) GetIn() []uint64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *UInt64Rules) GetNotIn() []uint64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *UInt64Rules) GetExample() []uint64 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *UInt64Rules) SetConst(v uint64) {
	x.Const = &v
}

func (x *UInt64Rules) SetLt(v uint64) {
	x.LessThan = &UInt64Rules_Lt{v}
}

func (x *UInt64Rules) SetLte(v uint64) {
	x.LessThan = &UInt64Rules_Lte{v}
}

func (x *UInt64Rules) SetGt(v uint64) {
	x.GreaterThan = &UInt64Rules_Gt{v}
}

func (x *UInt64Rules) SetGte(v uint64) {
	x.GreaterThan = &UInt64Rules_Gte{v}
}

func (x *UInt64Rules) SetIn(v []uint64) {
	x.In = v
}

func (x *UInt64Rules) SetNotIn(v []uint64) {
	x.NotIn = v
}

func (x *UInt64Rules) SetExample(v []uint64) {
	x.Example = v
}

func (x *UInt64Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *UInt64Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *UInt64Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*UInt64Rules_Lt)
	return ok
}

func (x *UInt64Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*UInt64Rules_Lte)
	return ok
}

func (x *UInt64Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *UInt64Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*UInt64Rules_Gt)
	return ok
}

func (x *UInt64Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*UInt64Rules_Gte)
	return ok
}

func (x *UInt64Rules) ClearConst() {
	x.Const = nil
}

func (x *UInt64Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *UInt64Rules) ClearLt() {
	if _, ok := x.LessThan.(*UInt64Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *UInt64Rules) ClearLte() {
	if _, ok := x.LessThan.(*UInt64Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *UInt64Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *UInt64Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*UInt64Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *UInt64Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*UInt64Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const UInt64Rules_LessThan_not_set_case case_UInt64Rules_LessThan = 0
const UInt64Rules_Lt_case case_UInt64Rules_LessThan = 2
const UInt64Rules_Lte_case case_UInt64Rules_LessThan = 3

func (x *UInt64Rules) WhichLessThan() case_UInt64Rules_LessThan {
	if x == nil {
		return UInt64Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *UInt64Rules_Lt:
		return UInt64Rules_Lt_case
	case *UInt64Rules_Lte:
		return UInt64Rules_Lte_case
	default:
		return UInt64Rules_LessThan_not_set_case
	}
}

const UInt64Rules_GreaterThan_not_set_case case_UInt64Rules_GreaterThan = 0
const UInt64Rules_Gt_case case_UInt64Rules_GreaterThan = 4
const UInt64Rules_Gte_case case_UInt64Rules_GreaterThan = 5

func (x *UInt64Rules) WhichGreaterThan() case_UInt64Rules_GreaterThan {
	if x == nil {
		return UInt64Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *UInt64Rules_Gt:
		return UInt64Rules_Gt_case
	case *UInt64Rules_Gte:
		return UInt64Rules_Gte_case
	default:
		return UInt64Rules_GreaterThan_not_set_case
	}
}

type UInt64Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must equal 42
	//	  uint64 value = 1 [(buf.validate.field).uint64.const = 42];
	//	}
	//
	// ```
	Const *uint64
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be less than 10
	//	  uint64 value = 1 [(buf.validate.field).uint64.lt = 10];
	//	}
	//
	// ```
	Lt *uint64
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be less than or equal to 10
	//	  uint64 value = 1 [(buf.validate.field).uint64.lte = 10];
	//	}
	//
	// ```
	Lte *uint64
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be greater than 5 [uint64.gt]
	//	  uint64 value = 1 [(buf.validate.field).uint64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [uint64.gt_lt]
	//	  uint64 other_value = 2 [(buf.validate.field).uint64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [uint64.gt_lt_exclusive]
	//	  uint64 another_value = 3 [(buf.validate.field).uint64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *uint64
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be greater than or equal to 5 [uint64.gte]
	//	  uint64 value = 1 [(buf.validate.field).uint64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [uint64.gte_lt]
	//	  uint64 other_value = 2 [(buf.validate.field).uint64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [uint64.gte_lt_exclusive]
	//	  uint64 another_value = 3 [(buf.validate.field).uint64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *uint64
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be in list [1, 2, 3]
	//	  uint64 value = 1 [(buf.validate.field).uint64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []uint64
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must not be in list [1, 2, 3]
	//	  uint64 value = 1 [(buf.validate.field).uint64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []uint64
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  uint64 value = 1 [
	//	    (buf.validate.field).uint64.example = 1,
	//	    (buf.validate.field).uint64.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []uint64
}

func (b0 UInt64Rules_builder) Build() *UInt64Rules {
	m0 := &UInt64Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &UInt64Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &UInt64Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &UInt64Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &UInt64Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_UInt64Rules_LessThan protoreflect.FieldNumber

func (x case_UInt64Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[11].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_UInt64Rules_GreaterThan protoreflect.FieldNumber

func (x case_UInt64Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[11].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isUInt64Rules_LessThan interface {
	isUInt64Rules_LessThan()
}

type UInt64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be less than 10
	//	  uint64 value = 1 [(buf.validate.field).uint64.lt = 10];
	//	}
	//
	// ```
	Lt uint64 `protobuf:"varint,2,opt,name=lt,oneof"`
}

type UInt64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be less than or equal to 10
	//	  uint64 value = 1 [(buf.validate.field).uint64.lte = 10];
	//	}
	//
	// ```
	Lte uint64 `protobuf:"varint,3,opt,name=lte,oneof"`
}

func (*UInt64Rules_Lt) isUInt64Rules_LessThan() {}

func (*UInt64Rules_Lte) isUInt64Rules_LessThan() {}

type isUInt64Rules_GreaterThan interface {
	isUInt64Rules_GreaterThan()
}

type UInt64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be greater than 5 [uint64.gt]
	//	  uint64 value = 1 [(buf.validate.field).uint64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [uint64.gt_lt]
	//	  uint64 other_value = 2 [(buf.validate.field).uint64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [uint64.gt_lt_exclusive]
	//	  uint64 another_value = 3 [(buf.validate.field).uint64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt uint64 `protobuf:"varint,4,opt,name=gt,oneof"`
}

type UInt64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyUInt64 {
	//	  // value must be greater than or equal to 5 [uint64.gte]
	//	  uint64 value = 1 [(buf.validate.field).uint64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [uint64.gte_lt]
	//	  uint64 other_value = 2 [(buf.validate.field).uint64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [uint64.gte_lt_exclusive]
	//	  uint64 another_value = 3 [(buf.validate.field).uint64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte uint64 `protobuf:"varint,5,opt,name=gte,oneof"`
}

func (*UInt64Rules_Gt) isUInt64Rules_GreaterThan() {}

func (*UInt64Rules_Gte) isUInt64Rules_GreaterThan() {}

// SInt32Rules describes the rules applied to `sint32` values.
type SInt32Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must equal 42
	//	  sint32 value = 1 [(buf.validate.field).sint32.const = 42];
	//	}
	//
	// ```
	Const *int32 `protobuf:"zigzag32,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*SInt32Rules_Lt
	//	*SInt32Rules_Lte
	LessThan isSInt32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*SInt32Rules_Gt
	//	*SInt32Rules_Gte
	GreaterThan isSInt32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be in list [1, 2, 3]
	//	  sint32 value = 1 [(buf.validate.field).sint32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int32 `protobuf:"zigzag32,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must not be in list [1, 2, 3]
	//	  sint32 value = 1 [(buf.validate.field).sint32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int32 `protobuf:"zigzag32,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  sint32 value = 1 [
	//	    (buf.validate.field).sint32.example = 1,
	//	    (buf.validate.field).sint32.example = -10
	//	  ];
	//	}
	//
	// ```
	Example         []int32 `protobuf:"zigzag32,8,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SInt32Rules) Reset() {
	*x = SInt32Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SInt32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SInt32Rules) ProtoMessage() {}

func (x *SInt32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SInt32Rules) GetConst() int32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *SInt32Rules) GetLessThan() isSInt32Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *SInt32Rules) GetLt() int32 {
	if x != nil {
		if x, ok := x.LessThan.(*SInt32Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *SInt32Rules) GetLte() int32 {
	if x != nil {
		if x, ok := x.LessThan.(*SInt32Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *SInt32Rules) GetGreaterThan() isSInt32Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *SInt32Rules) GetGt() int32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*SInt32Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *SInt32Rules) GetGte() int32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*SInt32Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *SInt32Rules) GetIn() []int32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *SInt32Rules) GetNotIn() []int32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *SInt32Rules) GetExample() []int32 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *SInt32Rules) SetConst(v int32) {
	x.Const = &v
}

func (x *SInt32Rules) SetLt(v int32) {
	x.LessThan = &SInt32Rules_Lt{v}
}

func (x *SInt32Rules) SetLte(v int32) {
	x.LessThan = &SInt32Rules_Lte{v}
}

func (x *SInt32Rules) SetGt(v int32) {
	x.GreaterThan = &SInt32Rules_Gt{v}
}

func (x *SInt32Rules) SetGte(v int32) {
	x.GreaterThan = &SInt32Rules_Gte{v}
}

func (x *SInt32Rules) SetIn(v []int32) {
	x.In = v
}

func (x *SInt32Rules) SetNotIn(v []int32) {
	x.NotIn = v
}

func (x *SInt32Rules) SetExample(v []int32) {
	x.Example = v
}

func (x *SInt32Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *SInt32Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *SInt32Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*SInt32Rules_Lt)
	return ok
}

func (x *SInt32Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*SInt32Rules_Lte)
	return ok
}

func (x *SInt32Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *SInt32Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*SInt32Rules_Gt)
	return ok
}

func (x *SInt32Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*SInt32Rules_Gte)
	return ok
}

func (x *SInt32Rules) ClearConst() {
	x.Const = nil
}

func (x *SInt32Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *SInt32Rules) ClearLt() {
	if _, ok := x.LessThan.(*SInt32Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *SInt32Rules) ClearLte() {
	if _, ok := x.LessThan.(*SInt32Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *SInt32Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *SInt32Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*SInt32Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *SInt32Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*SInt32Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const SInt32Rules_LessThan_not_set_case case_SInt32Rules_LessThan = 0
const SInt32Rules_Lt_case case_SInt32Rules_LessThan = 2
const SInt32Rules_Lte_case case_SInt32Rules_LessThan = 3

func (x *SInt32Rules) WhichLessThan() case_SInt32Rules_LessThan {
	if x == nil {
		return SInt32Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *SInt32Rules_Lt:
		return SInt32Rules_Lt_case
	case *SInt32Rules_Lte:
		return SInt32Rules_Lte_case
	default:
		return SInt32Rules_LessThan_not_set_case
	}
}

const SInt32Rules_GreaterThan_not_set_case case_SInt32Rules_GreaterThan = 0
const SInt32Rules_Gt_case case_SInt32Rules_GreaterThan = 4
const SInt32Rules_Gte_case case_SInt32Rules_GreaterThan = 5

func (x *SInt32Rules) WhichGreaterThan() case_SInt32Rules_GreaterThan {
	if x == nil {
		return SInt32Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *SInt32Rules_Gt:
		return SInt32Rules_Gt_case
	case *SInt32Rules_Gte:
		return SInt32Rules_Gte_case
	default:
		return SInt32Rules_GreaterThan_not_set_case
	}
}

type SInt32Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must equal 42
	//	  sint32 value = 1 [(buf.validate.field).sint32.const = 42];
	//	}
	//
	// ```
	Const *int32
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field
	// < value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be less than 10
	//	  sint32 value = 1 [(buf.validate.field).sint32.lt = 10];
	//	}
	//
	// ```
	Lt *int32
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be less than or equal to 10
	//	  sint32 value = 1 [(buf.validate.field).sint32.lte = 10];
	//	}
	//
	// ```
	Lte *int32
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be greater than 5 [sint32.gt]
	//	  sint32 value = 1 [(buf.validate.field).sint32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sint32.gt_lt]
	//	  sint32 other_value = 2 [(buf.validate.field).sint32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sint32.gt_lt_exclusive]
	//	  sint32 another_value = 3 [(buf.validate.field).sint32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *int32
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	 // value must be greater than or equal to 5 [sint32.gte]
	//	 sint32 value = 1 [(buf.validate.field).sint32.gte = 5];
	//
	//	 // value must be greater than or equal to 5 and less than 10 [sint32.gte_lt]
	//	 sint32 other_value = 2 [(buf.validate.field).sint32 = { gte: 5, lt: 10 }];
	//
	//	 // value must be greater than or equal to 10 or less than 5 [sint32.gte_lt_exclusive]
	//	 sint32 another_value = 3 [(buf.validate.field).sint32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *int32
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be in list [1, 2, 3]
	//	  sint32 value = 1 [(buf.validate.field).sint32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int32
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must not be in list [1, 2, 3]
	//	  sint32 value = 1 [(buf.validate.field).sint32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int32
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  sint32 value = 1 [
	//	    (buf.validate.field).sint32.example = 1,
	//	    (buf.validate.field).sint32.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []int32
}

func (b0 SInt32Rules_builder) Build() *SInt32Rules {
	m0 := &SInt32Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &SInt32Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &SInt32Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &SInt32Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &SInt32Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_SInt32Rules_LessThan protoreflect.FieldNumber

func (x case_SInt32Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[12].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_SInt32Rules_GreaterThan protoreflect.FieldNumber

func (x case_SInt32Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[12].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isSInt32Rules_LessThan interface {
	isSInt32Rules_LessThan()
}

type SInt32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field
	// < value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be less than 10
	//	  sint32 value = 1 [(buf.validate.field).sint32.lt = 10];
	//	}
	//
	// ```
	Lt int32 `protobuf:"zigzag32,2,opt,name=lt,oneof"`
}

type SInt32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be less than or equal to 10
	//	  sint32 value = 1 [(buf.validate.field).sint32.lte = 10];
	//	}
	//
	// ```
	Lte int32 `protobuf:"zigzag32,3,opt,name=lte,oneof"`
}

func (*SInt32Rules_Lt) isSInt32Rules_LessThan() {}

func (*SInt32Rules_Lte) isSInt32Rules_LessThan() {}

type isSInt32Rules_GreaterThan interface {
	isSInt32Rules_GreaterThan()
}

type SInt32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	  // value must be greater than 5 [sint32.gt]
	//	  sint32 value = 1 [(buf.validate.field).sint32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sint32.gt_lt]
	//	  sint32 other_value = 2 [(buf.validate.field).sint32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sint32.gt_lt_exclusive]
	//	  sint32 another_value = 3 [(buf.validate.field).sint32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int32 `protobuf:"zigzag32,4,opt,name=gt,oneof"`
}

type SInt32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt32 {
	//	 // value must be greater than or equal to 5 [sint32.gte]
	//	 sint32 value = 1 [(buf.validate.field).sint32.gte = 5];
	//
	//	 // value must be greater than or equal to 5 and less than 10 [sint32.gte_lt]
	//	 sint32 other_value = 2 [(buf.validate.field).sint32 = { gte: 5, lt: 10 }];
	//
	//	 // value must be greater than or equal to 10 or less than 5 [sint32.gte_lt_exclusive]
	//	 sint32 another_value = 3 [(buf.validate.field).sint32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int32 `protobuf:"zigzag32,5,opt,name=gte,oneof"`
}

func (*SInt32Rules_Gt) isSInt32Rules_GreaterThan() {}

func (*SInt32Rules_Gte) isSInt32Rules_GreaterThan() {}

// SInt64Rules describes the rules applied to `sint64` values.
type SInt64Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must equal 42
	//	  sint64 value = 1 [(buf.validate.field).sint64.const = 42];
	//	}
	//
	// ```
	Const *int64 `protobuf:"zigzag64,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*SInt64Rules_Lt
	//	*SInt64Rules_Lte
	LessThan isSInt64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*SInt64Rules_Gt
	//	*SInt64Rules_Gte
	GreaterThan isSInt64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be in list [1, 2, 3]
	//	  sint64 value = 1 [(buf.validate.field).sint64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int64 `protobuf:"zigzag64,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must not be in list [1, 2, 3]
	//	  sint64 value = 1 [(buf.validate.field).sint64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int64 `protobuf:"zigzag64,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  sint64 value = 1 [
	//	    (buf.validate.field).sint64.example = 1,
	//	    (buf.validate.field).sint64.example = -10
	//	  ];
	//	}
	//
	// ```
	Example         []int64 `protobuf:"zigzag64,8,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SInt64Rules) Reset() {
	*x = SInt64Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SInt64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SInt64Rules) ProtoMessage() {}

func (x *SInt64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SInt64Rules) GetConst() int64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *SInt64Rules) GetLessThan() isSInt64Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *SInt64Rules) GetLt() int64 {
	if x != nil {
		if x, ok := x.LessThan.(*SInt64Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *SInt64Rules) GetLte() int64 {
	if x != nil {
		if x, ok := x.LessThan.(*SInt64Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *SInt64Rules) GetGreaterThan() isSInt64Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *SInt64Rules) GetGt() int64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*SInt64Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *SInt64Rules) GetGte() int64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*SInt64Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *SInt64Rules) GetIn() []int64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *SInt64Rules) GetNotIn() []int64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *SInt64Rules) GetExample() []int64 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *SInt64Rules) SetConst(v int64) {
	x.Const = &v
}

func (x *SInt64Rules) SetLt(v int64) {
	x.LessThan = &SInt64Rules_Lt{v}
}

func (x *SInt64Rules) SetLte(v int64) {
	x.LessThan = &SInt64Rules_Lte{v}
}

func (x *SInt64Rules) SetGt(v int64) {
	x.GreaterThan = &SInt64Rules_Gt{v}
}

func (x *SInt64Rules) SetGte(v int64) {
	x.GreaterThan = &SInt64Rules_Gte{v}
}

func (x *SInt64Rules) SetIn(v []int64) {
	x.In = v
}

func (x *SInt64Rules) SetNotIn(v []int64) {
	x.NotIn = v
}

func (x *SInt64Rules) SetExample(v []int64) {
	x.Example = v
}

func (x *SInt64Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *SInt64Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *SInt64Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*SInt64Rules_Lt)
	return ok
}

func (x *SInt64Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*SInt64Rules_Lte)
	return ok
}

func (x *SInt64Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *SInt64Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*SInt64Rules_Gt)
	return ok
}

func (x *SInt64Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*SInt64Rules_Gte)
	return ok
}

func (x *SInt64Rules) ClearConst() {
	x.Const = nil
}

func (x *SInt64Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *SInt64Rules) ClearLt() {
	if _, ok := x.LessThan.(*SInt64Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *SInt64Rules) ClearLte() {
	if _, ok := x.LessThan.(*SInt64Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *SInt64Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *SInt64Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*SInt64Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *SInt64Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*SInt64Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const SInt64Rules_LessThan_not_set_case case_SInt64Rules_LessThan = 0
const SInt64Rules_Lt_case case_SInt64Rules_LessThan = 2
const SInt64Rules_Lte_case case_SInt64Rules_LessThan = 3

func (x *SInt64Rules) WhichLessThan() case_SInt64Rules_LessThan {
	if x == nil {
		return SInt64Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *SInt64Rules_Lt:
		return SInt64Rules_Lt_case
	case *SInt64Rules_Lte:
		return SInt64Rules_Lte_case
	default:
		return SInt64Rules_LessThan_not_set_case
	}
}

const SInt64Rules_GreaterThan_not_set_case case_SInt64Rules_GreaterThan = 0
const SInt64Rules_Gt_case case_SInt64Rules_GreaterThan = 4
const SInt64Rules_Gte_case case_SInt64Rules_GreaterThan = 5

func (x *SInt64Rules) WhichGreaterThan() case_SInt64Rules_GreaterThan {
	if x == nil {
		return SInt64Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *SInt64Rules_Gt:
		return SInt64Rules_Gt_case
	case *SInt64Rules_Gte:
		return SInt64Rules_Gte_case
	default:
		return SInt64Rules_GreaterThan_not_set_case
	}
}

type SInt64Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must equal 42
	//	  sint64 value = 1 [(buf.validate.field).sint64.const = 42];
	//	}
	//
	// ```
	Const *int64
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field
	// < value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be less than 10
	//	  sint64 value = 1 [(buf.validate.field).sint64.lt = 10];
	//	}
	//
	// ```
	Lt *int64
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be less than or equal to 10
	//	  sint64 value = 1 [(buf.validate.field).sint64.lte = 10];
	//	}
	//
	// ```
	Lte *int64
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be greater than 5 [sint64.gt]
	//	  sint64 value = 1 [(buf.validate.field).sint64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sint64.gt_lt]
	//	  sint64 other_value = 2 [(buf.validate.field).sint64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sint64.gt_lt_exclusive]
	//	  sint64 another_value = 3 [(buf.validate.field).sint64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *int64
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be greater than or equal to 5 [sint64.gte]
	//	  sint64 value = 1 [(buf.validate.field).sint64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [sint64.gte_lt]
	//	  sint64 other_value = 2 [(buf.validate.field).sint64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [sint64.gte_lt_exclusive]
	//	  sint64 another_value = 3 [(buf.validate.field).sint64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *int64
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be in list [1, 2, 3]
	//	  sint64 value = 1 [(buf.validate.field).sint64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int64
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must not be in list [1, 2, 3]
	//	  sint64 value = 1 [(buf.validate.field).sint64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int64
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  sint64 value = 1 [
	//	    (buf.validate.field).sint64.example = 1,
	//	    (buf.validate.field).sint64.example = -10
	//	  ];
	//	}
	//
	// ```
	Example []int64
}

func (b0 SInt64Rules_builder) Build() *SInt64Rules {
	m0 := &SInt64Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &SInt64Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &SInt64Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &SInt64Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &SInt64Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_SInt64Rules_LessThan protoreflect.FieldNumber

func (x case_SInt64Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[13].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_SInt64Rules_GreaterThan protoreflect.FieldNumber

func (x case_SInt64Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[13].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isSInt64Rules_LessThan interface {
	isSInt64Rules_LessThan()
}

type SInt64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field
	// < value). If the field value is equal to or greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be less than 10
	//	  sint64 value = 1 [(buf.validate.field).sint64.lt = 10];
	//	}
	//
	// ```
	Lt int64 `protobuf:"zigzag64,2,opt,name=lt,oneof"`
}

type SInt64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be less than or equal to 10
	//	  sint64 value = 1 [(buf.validate.field).sint64.lte = 10];
	//	}
	//
	// ```
	Lte int64 `protobuf:"zigzag64,3,opt,name=lte,oneof"`
}

func (*SInt64Rules_Lt) isSInt64Rules_LessThan() {}

func (*SInt64Rules_Lte) isSInt64Rules_LessThan() {}

type isSInt64Rules_GreaterThan interface {
	isSInt64Rules_GreaterThan()
}

type SInt64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be greater than 5 [sint64.gt]
	//	  sint64 value = 1 [(buf.validate.field).sint64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sint64.gt_lt]
	//	  sint64 other_value = 2 [(buf.validate.field).sint64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sint64.gt_lt_exclusive]
	//	  sint64 another_value = 3 [(buf.validate.field).sint64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int64 `protobuf:"zigzag64,4,opt,name=gt,oneof"`
}

type SInt64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySInt64 {
	//	  // value must be greater than or equal to 5 [sint64.gte]
	//	  sint64 value = 1 [(buf.validate.field).sint64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [sint64.gte_lt]
	//	  sint64 other_value = 2 [(buf.validate.field).sint64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [sint64.gte_lt_exclusive]
	//	  sint64 another_value = 3 [(buf.validate.field).sint64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int64 `protobuf:"zigzag64,5,opt,name=gte,oneof"`
}

func (*SInt64Rules_Gt) isSInt64Rules_GreaterThan() {}

func (*SInt64Rules_Gte) isSInt64Rules_GreaterThan() {}

// Fixed32Rules describes the rules applied to `fixed32` values.
type Fixed32Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must equal 42
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.const = 42];
	//	}
	//
	// ```
	Const *uint32 `protobuf:"fixed32,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*Fixed32Rules_Lt
	//	*Fixed32Rules_Lte
	LessThan isFixed32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*Fixed32Rules_Gt
	//	*Fixed32Rules_Gte
	GreaterThan isFixed32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be in list [1, 2, 3]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []uint32 `protobuf:"fixed32,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must not be in list [1, 2, 3]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []uint32 `protobuf:"fixed32,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  fixed32 value = 1 [
	//	    (buf.validate.field).fixed32.example = 1,
	//	    (buf.validate.field).fixed32.example = 2
	//	  ];
	//	}
	//
	// ```
	Example         []uint32 `protobuf:"fixed32,8,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Fixed32Rules) Reset() {
	*x = Fixed32Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Fixed32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fixed32Rules) ProtoMessage() {}

func (x *Fixed32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Fixed32Rules) GetConst() uint32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *Fixed32Rules) GetLessThan() isFixed32Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *Fixed32Rules) GetLt() uint32 {
	if x != nil {
		if x, ok := x.LessThan.(*Fixed32Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *Fixed32Rules) GetLte() uint32 {
	if x != nil {
		if x, ok := x.LessThan.(*Fixed32Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *Fixed32Rules) GetGreaterThan() isFixed32Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *Fixed32Rules) GetGt() uint32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*Fixed32Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *Fixed32Rules) GetGte() uint32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*Fixed32Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *Fixed32Rules) GetIn() []uint32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *Fixed32Rules) GetNotIn() []uint32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *Fixed32Rules) GetExample() []uint32 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *Fixed32Rules) SetConst(v uint32) {
	x.Const = &v
}

func (x *Fixed32Rules) SetLt(v uint32) {
	x.LessThan = &Fixed32Rules_Lt{v}
}

func (x *Fixed32Rules) SetLte(v uint32) {
	x.LessThan = &Fixed32Rules_Lte{v}
}

func (x *Fixed32Rules) SetGt(v uint32) {
	x.GreaterThan = &Fixed32Rules_Gt{v}
}

func (x *Fixed32Rules) SetGte(v uint32) {
	x.GreaterThan = &Fixed32Rules_Gte{v}
}

func (x *Fixed32Rules) SetIn(v []uint32) {
	x.In = v
}

func (x *Fixed32Rules) SetNotIn(v []uint32) {
	x.NotIn = v
}

func (x *Fixed32Rules) SetExample(v []uint32) {
	x.Example = v
}

func (x *Fixed32Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *Fixed32Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *Fixed32Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*Fixed32Rules_Lt)
	return ok
}

func (x *Fixed32Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*Fixed32Rules_Lte)
	return ok
}

func (x *Fixed32Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *Fixed32Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*Fixed32Rules_Gt)
	return ok
}

func (x *Fixed32Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*Fixed32Rules_Gte)
	return ok
}

func (x *Fixed32Rules) ClearConst() {
	x.Const = nil
}

func (x *Fixed32Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *Fixed32Rules) ClearLt() {
	if _, ok := x.LessThan.(*Fixed32Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *Fixed32Rules) ClearLte() {
	if _, ok := x.LessThan.(*Fixed32Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *Fixed32Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *Fixed32Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*Fixed32Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *Fixed32Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*Fixed32Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const Fixed32Rules_LessThan_not_set_case case_Fixed32Rules_LessThan = 0
const Fixed32Rules_Lt_case case_Fixed32Rules_LessThan = 2
const Fixed32Rules_Lte_case case_Fixed32Rules_LessThan = 3

func (x *Fixed32Rules) WhichLessThan() case_Fixed32Rules_LessThan {
	if x == nil {
		return Fixed32Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *Fixed32Rules_Lt:
		return Fixed32Rules_Lt_case
	case *Fixed32Rules_Lte:
		return Fixed32Rules_Lte_case
	default:
		return Fixed32Rules_LessThan_not_set_case
	}
}

const Fixed32Rules_GreaterThan_not_set_case case_Fixed32Rules_GreaterThan = 0
const Fixed32Rules_Gt_case case_Fixed32Rules_GreaterThan = 4
const Fixed32Rules_Gte_case case_Fixed32Rules_GreaterThan = 5

func (x *Fixed32Rules) WhichGreaterThan() case_Fixed32Rules_GreaterThan {
	if x == nil {
		return Fixed32Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *Fixed32Rules_Gt:
		return Fixed32Rules_Gt_case
	case *Fixed32Rules_Gte:
		return Fixed32Rules_Gte_case
	default:
		return Fixed32Rules_GreaterThan_not_set_case
	}
}

type Fixed32Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must equal 42
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.const = 42];
	//	}
	//
	// ```
	Const *uint32
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be less than 10
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.lt = 10];
	//	}
	//
	// ```
	Lt *uint32
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be less than or equal to 10
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.lte = 10];
	//	}
	//
	// ```
	Lte *uint32
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be greater than 5 [fixed32.gt]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [fixed32.gt_lt]
	//	  fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [fixed32.gt_lt_exclusive]
	//	  fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *uint32
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be greater than or equal to 5 [fixed32.gte]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [fixed32.gte_lt]
	//	  fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [fixed32.gte_lt_exclusive]
	//	  fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *uint32
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message
	// is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be in list [1, 2, 3]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []uint32
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must not be in list [1, 2, 3]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []uint32
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  fixed32 value = 1 [
	//	    (buf.validate.field).fixed32.example = 1,
	//	    (buf.validate.field).fixed32.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []uint32
}

func (b0 Fixed32Rules_builder) Build() *Fixed32Rules {
	m0 := &Fixed32Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &Fixed32Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &Fixed32Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &Fixed32Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &Fixed32Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_Fixed32Rules_LessThan protoreflect.FieldNumber

func (x case_Fixed32Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[14].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_Fixed32Rules_GreaterThan protoreflect.FieldNumber

func (x case_Fixed32Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[14].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isFixed32Rules_LessThan interface {
	isFixed32Rules_LessThan()
}

type Fixed32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be less than 10
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.lt = 10];
	//	}
	//
	// ```
	Lt uint32 `protobuf:"fixed32,2,opt,name=lt,oneof"`
}

type Fixed32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be less than or equal to 10
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.lte = 10];
	//	}
	//
	// ```
	Lte uint32 `protobuf:"fixed32,3,opt,name=lte,oneof"`
}

func (*Fixed32Rules_Lt) isFixed32Rules_LessThan() {}

func (*Fixed32Rules_Lte) isFixed32Rules_LessThan() {}

type isFixed32Rules_GreaterThan interface {
	isFixed32Rules_GreaterThan()
}

type Fixed32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be greater than 5 [fixed32.gt]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [fixed32.gt_lt]
	//	  fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [fixed32.gt_lt_exclusive]
	//	  fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt uint32 `protobuf:"fixed32,4,opt,name=gt,oneof"`
}

type Fixed32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed32 {
	//	  // value must be greater than or equal to 5 [fixed32.gte]
	//	  fixed32 value = 1 [(buf.validate.field).fixed32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [fixed32.gte_lt]
	//	  fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [fixed32.gte_lt_exclusive]
	//	  fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte uint32 `protobuf:"fixed32,5,opt,name=gte,oneof"`
}

func (*Fixed32Rules_Gt) isFixed32Rules_GreaterThan() {}

func (*Fixed32Rules_Gte) isFixed32Rules_GreaterThan() {}

// Fixed64Rules describes the rules applied to `fixed64` values.
type Fixed64Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must equal 42
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.const = 42];
	//	}
	//
	// ```
	Const *uint64 `protobuf:"fixed64,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*Fixed64Rules_Lt
	//	*Fixed64Rules_Lte
	LessThan isFixed64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*Fixed64Rules_Gt
	//	*Fixed64Rules_Gte
	GreaterThan isFixed64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be in list [1, 2, 3]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []uint64 `protobuf:"fixed64,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must not be in list [1, 2, 3]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []uint64 `protobuf:"fixed64,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  fixed64 value = 1 [
	//	    (buf.validate.field).fixed64.example = 1,
	//	    (buf.validate.field).fixed64.example = 2
	//	  ];
	//	}
	//
	// ```
	Example         []uint64 `protobuf:"fixed64,8,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Fixed64Rules) Reset() {
	*x = Fixed64Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Fixed64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fixed64Rules) ProtoMessage() {}

func (x *Fixed64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Fixed64Rules) GetConst() uint64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *Fixed64Rules) GetLessThan() isFixed64Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *Fixed64Rules) GetLt() uint64 {
	if x != nil {
		if x, ok := x.LessThan.(*Fixed64Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *Fixed64Rules) GetLte() uint64 {
	if x != nil {
		if x, ok := x.LessThan.(*Fixed64Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *Fixed64Rules) GetGreaterThan() isFixed64Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *Fixed64Rules) GetGt() uint64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*Fixed64Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *Fixed64Rules) GetGte() uint64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*Fixed64Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *Fixed64Rules) GetIn() []uint64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *Fixed64Rules) GetNotIn() []uint64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *Fixed64Rules) GetExample() []uint64 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *Fixed64Rules) SetConst(v uint64) {
	x.Const = &v
}

func (x *Fixed64Rules) SetLt(v uint64) {
	x.LessThan = &Fixed64Rules_Lt{v}
}

func (x *Fixed64Rules) SetLte(v uint64) {
	x.LessThan = &Fixed64Rules_Lte{v}
}

func (x *Fixed64Rules) SetGt(v uint64) {
	x.GreaterThan = &Fixed64Rules_Gt{v}
}

func (x *Fixed64Rules) SetGte(v uint64) {
	x.GreaterThan = &Fixed64Rules_Gte{v}
}

func (x *Fixed64Rules) SetIn(v []uint64) {
	x.In = v
}

func (x *Fixed64Rules) SetNotIn(v []uint64) {
	x.NotIn = v
}

func (x *Fixed64Rules) SetExample(v []uint64) {
	x.Example = v
}

func (x *Fixed64Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *Fixed64Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *Fixed64Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*Fixed64Rules_Lt)
	return ok
}

func (x *Fixed64Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*Fixed64Rules_Lte)
	return ok
}

func (x *Fixed64Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *Fixed64Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*Fixed64Rules_Gt)
	return ok
}

func (x *Fixed64Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*Fixed64Rules_Gte)
	return ok
}

func (x *Fixed64Rules) ClearConst() {
	x.Const = nil
}

func (x *Fixed64Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *Fixed64Rules) ClearLt() {
	if _, ok := x.LessThan.(*Fixed64Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *Fixed64Rules) ClearLte() {
	if _, ok := x.LessThan.(*Fixed64Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *Fixed64Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *Fixed64Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*Fixed64Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *Fixed64Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*Fixed64Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const Fixed64Rules_LessThan_not_set_case case_Fixed64Rules_LessThan = 0
const Fixed64Rules_Lt_case case_Fixed64Rules_LessThan = 2
const Fixed64Rules_Lte_case case_Fixed64Rules_LessThan = 3

func (x *Fixed64Rules) WhichLessThan() case_Fixed64Rules_LessThan {
	if x == nil {
		return Fixed64Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *Fixed64Rules_Lt:
		return Fixed64Rules_Lt_case
	case *Fixed64Rules_Lte:
		return Fixed64Rules_Lte_case
	default:
		return Fixed64Rules_LessThan_not_set_case
	}
}

const Fixed64Rules_GreaterThan_not_set_case case_Fixed64Rules_GreaterThan = 0
const Fixed64Rules_Gt_case case_Fixed64Rules_GreaterThan = 4
const Fixed64Rules_Gte_case case_Fixed64Rules_GreaterThan = 5

func (x *Fixed64Rules) WhichGreaterThan() case_Fixed64Rules_GreaterThan {
	if x == nil {
		return Fixed64Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *Fixed64Rules_Gt:
		return Fixed64Rules_Gt_case
	case *Fixed64Rules_Gte:
		return Fixed64Rules_Gte_case
	default:
		return Fixed64Rules_GreaterThan_not_set_case
	}
}

type Fixed64Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must equal 42
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.const = 42];
	//	}
	//
	// ```
	Const *uint64
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be less than 10
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.lt = 10];
	//	}
	//
	// ```
	Lt *uint64
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be less than or equal to 10
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.lte = 10];
	//	}
	//
	// ```
	Lte *uint64
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be greater than 5 [fixed64.gt]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [fixed64.gt_lt]
	//	  fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [fixed64.gt_lt_exclusive]
	//	  fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *uint64
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be greater than or equal to 5 [fixed64.gte]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [fixed64.gte_lt]
	//	  fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [fixed64.gte_lt_exclusive]
	//	  fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *uint64
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be in list [1, 2, 3]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []uint64
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must not be in list [1, 2, 3]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []uint64
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  fixed64 value = 1 [
	//	    (buf.validate.field).fixed64.example = 1,
	//	    (buf.validate.field).fixed64.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []uint64
}

func (b0 Fixed64Rules_builder) Build() *Fixed64Rules {
	m0 := &Fixed64Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &Fixed64Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &Fixed64Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &Fixed64Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &Fixed64Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_Fixed64Rules_LessThan protoreflect.FieldNumber

func (x case_Fixed64Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[15].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_Fixed64Rules_GreaterThan protoreflect.FieldNumber

func (x case_Fixed64Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[15].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isFixed64Rules_LessThan interface {
	isFixed64Rules_LessThan()
}

type Fixed64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be less than 10
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.lt = 10];
	//	}
	//
	// ```
	Lt uint64 `protobuf:"fixed64,2,opt,name=lt,oneof"`
}

type Fixed64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be less than or equal to 10
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.lte = 10];
	//	}
	//
	// ```
	Lte uint64 `protobuf:"fixed64,3,opt,name=lte,oneof"`
}

func (*Fixed64Rules_Lt) isFixed64Rules_LessThan() {}

func (*Fixed64Rules_Lte) isFixed64Rules_LessThan() {}

type isFixed64Rules_GreaterThan interface {
	isFixed64Rules_GreaterThan()
}

type Fixed64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be greater than 5 [fixed64.gt]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [fixed64.gt_lt]
	//	  fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [fixed64.gt_lt_exclusive]
	//	  fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt uint64 `protobuf:"fixed64,4,opt,name=gt,oneof"`
}

type Fixed64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyFixed64 {
	//	  // value must be greater than or equal to 5 [fixed64.gte]
	//	  fixed64 value = 1 [(buf.validate.field).fixed64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [fixed64.gte_lt]
	//	  fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [fixed64.gte_lt_exclusive]
	//	  fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte uint64 `protobuf:"fixed64,5,opt,name=gte,oneof"`
}

func (*Fixed64Rules_Gt) isFixed64Rules_GreaterThan() {}

func (*Fixed64Rules_Gte) isFixed64Rules_GreaterThan() {}

// SFixed32Rules describes the rules applied to `fixed32` values.
type SFixed32Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must equal 42
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.const = 42];
	//	}
	//
	// ```
	Const *int32 `protobuf:"fixed32,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*SFixed32Rules_Lt
	//	*SFixed32Rules_Lte
	LessThan isSFixed32Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*SFixed32Rules_Gt
	//	*SFixed32Rules_Gte
	GreaterThan isSFixed32Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be in list [1, 2, 3]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int32 `protobuf:"fixed32,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must not be in list [1, 2, 3]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int32 `protobuf:"fixed32,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  sfixed32 value = 1 [
	//	    (buf.validate.field).sfixed32.example = 1,
	//	    (buf.validate.field).sfixed32.example = 2
	//	  ];
	//	}
	//
	// ```
	Example         []int32 `protobuf:"fixed32,8,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SFixed32Rules) Reset() {
	*x = SFixed32Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SFixed32Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SFixed32Rules) ProtoMessage() {}

func (x *SFixed32Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SFixed32Rules) GetConst() int32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *SFixed32Rules) GetLessThan() isSFixed32Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *SFixed32Rules) GetLt() int32 {
	if x != nil {
		if x, ok := x.LessThan.(*SFixed32Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *SFixed32Rules) GetLte() int32 {
	if x != nil {
		if x, ok := x.LessThan.(*SFixed32Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *SFixed32Rules) GetGreaterThan() isSFixed32Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *SFixed32Rules) GetGt() int32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*SFixed32Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *SFixed32Rules) GetGte() int32 {
	if x != nil {
		if x, ok := x.GreaterThan.(*SFixed32Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *SFixed32Rules) GetIn() []int32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *SFixed32Rules) GetNotIn() []int32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *SFixed32Rules) GetExample() []int32 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *SFixed32Rules) SetConst(v int32) {
	x.Const = &v
}

func (x *SFixed32Rules) SetLt(v int32) {
	x.LessThan = &SFixed32Rules_Lt{v}
}

func (x *SFixed32Rules) SetLte(v int32) {
	x.LessThan = &SFixed32Rules_Lte{v}
}

func (x *SFixed32Rules) SetGt(v int32) {
	x.GreaterThan = &SFixed32Rules_Gt{v}
}

func (x *SFixed32Rules) SetGte(v int32) {
	x.GreaterThan = &SFixed32Rules_Gte{v}
}

func (x *SFixed32Rules) SetIn(v []int32) {
	x.In = v
}

func (x *SFixed32Rules) SetNotIn(v []int32) {
	x.NotIn = v
}

func (x *SFixed32Rules) SetExample(v []int32) {
	x.Example = v
}

func (x *SFixed32Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *SFixed32Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *SFixed32Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*SFixed32Rules_Lt)
	return ok
}

func (x *SFixed32Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*SFixed32Rules_Lte)
	return ok
}

func (x *SFixed32Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *SFixed32Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*SFixed32Rules_Gt)
	return ok
}

func (x *SFixed32Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*SFixed32Rules_Gte)
	return ok
}

func (x *SFixed32Rules) ClearConst() {
	x.Const = nil
}

func (x *SFixed32Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *SFixed32Rules) ClearLt() {
	if _, ok := x.LessThan.(*SFixed32Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *SFixed32Rules) ClearLte() {
	if _, ok := x.LessThan.(*SFixed32Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *SFixed32Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *SFixed32Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*SFixed32Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *SFixed32Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*SFixed32Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const SFixed32Rules_LessThan_not_set_case case_SFixed32Rules_LessThan = 0
const SFixed32Rules_Lt_case case_SFixed32Rules_LessThan = 2
const SFixed32Rules_Lte_case case_SFixed32Rules_LessThan = 3

func (x *SFixed32Rules) WhichLessThan() case_SFixed32Rules_LessThan {
	if x == nil {
		return SFixed32Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *SFixed32Rules_Lt:
		return SFixed32Rules_Lt_case
	case *SFixed32Rules_Lte:
		return SFixed32Rules_Lte_case
	default:
		return SFixed32Rules_LessThan_not_set_case
	}
}

const SFixed32Rules_GreaterThan_not_set_case case_SFixed32Rules_GreaterThan = 0
const SFixed32Rules_Gt_case case_SFixed32Rules_GreaterThan = 4
const SFixed32Rules_Gte_case case_SFixed32Rules_GreaterThan = 5

func (x *SFixed32Rules) WhichGreaterThan() case_SFixed32Rules_GreaterThan {
	if x == nil {
		return SFixed32Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *SFixed32Rules_Gt:
		return SFixed32Rules_Gt_case
	case *SFixed32Rules_Gte:
		return SFixed32Rules_Gte_case
	default:
		return SFixed32Rules_GreaterThan_not_set_case
	}
}

type SFixed32Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must equal 42
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.const = 42];
	//	}
	//
	// ```
	Const *int32
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be less than 10
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.lt = 10];
	//	}
	//
	// ```
	Lt *int32
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be less than or equal to 10
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.lte = 10];
	//	}
	//
	// ```
	Lte *int32
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be greater than 5 [sfixed32.gt]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sfixed32.gt_lt]
	//	  sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sfixed32.gt_lt_exclusive]
	//	  sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *int32
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be greater than or equal to 5 [sfixed32.gte]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [sfixed32.gte_lt]
	//	  sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [sfixed32.gte_lt_exclusive]
	//	  sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *int32
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be in list [1, 2, 3]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int32
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must not be in list [1, 2, 3]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int32
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  sfixed32 value = 1 [
	//	    (buf.validate.field).sfixed32.example = 1,
	//	    (buf.validate.field).sfixed32.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []int32
}

func (b0 SFixed32Rules_builder) Build() *SFixed32Rules {
	m0 := &SFixed32Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &SFixed32Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &SFixed32Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &SFixed32Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &SFixed32Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_SFixed32Rules_LessThan protoreflect.FieldNumber

func (x case_SFixed32Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[16].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_SFixed32Rules_GreaterThan protoreflect.FieldNumber

func (x case_SFixed32Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[16].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isSFixed32Rules_LessThan interface {
	isSFixed32Rules_LessThan()
}

type SFixed32Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be less than 10
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.lt = 10];
	//	}
	//
	// ```
	Lt int32 `protobuf:"fixed32,2,opt,name=lt,oneof"`
}

type SFixed32Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be less than or equal to 10
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.lte = 10];
	//	}
	//
	// ```
	Lte int32 `protobuf:"fixed32,3,opt,name=lte,oneof"`
}

func (*SFixed32Rules_Lt) isSFixed32Rules_LessThan() {}

func (*SFixed32Rules_Lte) isSFixed32Rules_LessThan() {}

type isSFixed32Rules_GreaterThan interface {
	isSFixed32Rules_GreaterThan()
}

type SFixed32Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be greater than 5 [sfixed32.gt]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sfixed32.gt_lt]
	//	  sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sfixed32.gt_lt_exclusive]
	//	  sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int32 `protobuf:"fixed32,4,opt,name=gt,oneof"`
}

type SFixed32Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed32 {
	//	  // value must be greater than or equal to 5 [sfixed32.gte]
	//	  sfixed32 value = 1 [(buf.validate.field).sfixed32.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [sfixed32.gte_lt]
	//	  sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [sfixed32.gte_lt_exclusive]
	//	  sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int32 `protobuf:"fixed32,5,opt,name=gte,oneof"`
}

func (*SFixed32Rules_Gt) isSFixed32Rules_GreaterThan() {}

func (*SFixed32Rules_Gte) isSFixed32Rules_GreaterThan() {}

// SFixed64Rules describes the rules applied to `fixed64` values.
type SFixed64Rules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must equal 42
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.const = 42];
	//	}
	//
	// ```
	Const *int64 `protobuf:"fixed64,1,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*SFixed64Rules_Lt
	//	*SFixed64Rules_Lte
	LessThan isSFixed64Rules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*SFixed64Rules_Gt
	//	*SFixed64Rules_Gte
	GreaterThan isSFixed64Rules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be in list [1, 2, 3]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int64 `protobuf:"fixed64,6,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must not be in list [1, 2, 3]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int64 `protobuf:"fixed64,7,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  sfixed64 value = 1 [
	//	    (buf.validate.field).sfixed64.example = 1,
	//	    (buf.validate.field).sfixed64.example = 2
	//	  ];
	//	}
	//
	// ```
	Example         []int64 `protobuf:"fixed64,8,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SFixed64Rules) Reset() {
	*x = SFixed64Rules{}
	mi := &file_buf_validate_validate_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SFixed64Rules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SFixed64Rules) ProtoMessage() {}

func (x *SFixed64Rules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *SFixed64Rules) GetConst() int64 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *SFixed64Rules) GetLessThan() isSFixed64Rules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *SFixed64Rules) GetLt() int64 {
	if x != nil {
		if x, ok := x.LessThan.(*SFixed64Rules_Lt); ok {
			return x.Lt
		}
	}
	return 0
}

func (x *SFixed64Rules) GetLte() int64 {
	if x != nil {
		if x, ok := x.LessThan.(*SFixed64Rules_Lte); ok {
			return x.Lte
		}
	}
	return 0
}

func (x *SFixed64Rules) GetGreaterThan() isSFixed64Rules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *SFixed64Rules) GetGt() int64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*SFixed64Rules_Gt); ok {
			return x.Gt
		}
	}
	return 0
}

func (x *SFixed64Rules) GetGte() int64 {
	if x != nil {
		if x, ok := x.GreaterThan.(*SFixed64Rules_Gte); ok {
			return x.Gte
		}
	}
	return 0
}

func (x *SFixed64Rules) GetIn() []int64 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *SFixed64Rules) GetNotIn() []int64 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *SFixed64Rules) GetExample() []int64 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *SFixed64Rules) SetConst(v int64) {
	x.Const = &v
}

func (x *SFixed64Rules) SetLt(v int64) {
	x.LessThan = &SFixed64Rules_Lt{v}
}

func (x *SFixed64Rules) SetLte(v int64) {
	x.LessThan = &SFixed64Rules_Lte{v}
}

func (x *SFixed64Rules) SetGt(v int64) {
	x.GreaterThan = &SFixed64Rules_Gt{v}
}

func (x *SFixed64Rules) SetGte(v int64) {
	x.GreaterThan = &SFixed64Rules_Gte{v}
}

func (x *SFixed64Rules) SetIn(v []int64) {
	x.In = v
}

func (x *SFixed64Rules) SetNotIn(v []int64) {
	x.NotIn = v
}

func (x *SFixed64Rules) SetExample(v []int64) {
	x.Example = v
}

func (x *SFixed64Rules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *SFixed64Rules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *SFixed64Rules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*SFixed64Rules_Lt)
	return ok
}

func (x *SFixed64Rules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*SFixed64Rules_Lte)
	return ok
}

func (x *SFixed64Rules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *SFixed64Rules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*SFixed64Rules_Gt)
	return ok
}

func (x *SFixed64Rules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*SFixed64Rules_Gte)
	return ok
}

func (x *SFixed64Rules) ClearConst() {
	x.Const = nil
}

func (x *SFixed64Rules) ClearLessThan() {
	x.LessThan = nil
}

func (x *SFixed64Rules) ClearLt() {
	if _, ok := x.LessThan.(*SFixed64Rules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *SFixed64Rules) ClearLte() {
	if _, ok := x.LessThan.(*SFixed64Rules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *SFixed64Rules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *SFixed64Rules) ClearGt() {
	if _, ok := x.GreaterThan.(*SFixed64Rules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *SFixed64Rules) ClearGte() {
	if _, ok := x.GreaterThan.(*SFixed64Rules_Gte); ok {
		x.GreaterThan = nil
	}
}

const SFixed64Rules_LessThan_not_set_case case_SFixed64Rules_LessThan = 0
const SFixed64Rules_Lt_case case_SFixed64Rules_LessThan = 2
const SFixed64Rules_Lte_case case_SFixed64Rules_LessThan = 3

func (x *SFixed64Rules) WhichLessThan() case_SFixed64Rules_LessThan {
	if x == nil {
		return SFixed64Rules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *SFixed64Rules_Lt:
		return SFixed64Rules_Lt_case
	case *SFixed64Rules_Lte:
		return SFixed64Rules_Lte_case
	default:
		return SFixed64Rules_LessThan_not_set_case
	}
}

const SFixed64Rules_GreaterThan_not_set_case case_SFixed64Rules_GreaterThan = 0
const SFixed64Rules_Gt_case case_SFixed64Rules_GreaterThan = 4
const SFixed64Rules_Gte_case case_SFixed64Rules_GreaterThan = 5

func (x *SFixed64Rules) WhichGreaterThan() case_SFixed64Rules_GreaterThan {
	if x == nil {
		return SFixed64Rules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *SFixed64Rules_Gt:
		return SFixed64Rules_Gt_case
	case *SFixed64Rules_Gte:
		return SFixed64Rules_Gte_case
	default:
		return SFixed64Rules_GreaterThan_not_set_case
	}
}

type SFixed64Rules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must equal 42
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.const = 42];
	//	}
	//
	// ```
	Const *int64
	// Fields of oneof LessThan:
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be less than 10
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.lt = 10];
	//	}
	//
	// ```
	Lt *int64
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be less than or equal to 10
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.lte = 10];
	//	}
	//
	// ```
	Lte *int64
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be greater than 5 [sfixed64.gt]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sfixed64.gt_lt]
	//	  sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sfixed64.gt_lt_exclusive]
	//	  sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt *int64
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be greater than or equal to 5 [sfixed64.gte]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [sfixed64.gte_lt]
	//	  sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [sfixed64.gte_lt_exclusive]
	//	  sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte *int64
	// -- end of GreaterThan
	// `in` requires the field value to be equal to one of the specified values.
	// If the field value isn't one of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be in list [1, 2, 3]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64 = { in: [1, 2, 3] }];
	//	}
	//
	// ```
	In []int64
	// `not_in` requires the field value to not be equal to any of the specified
	// values. If the field value is one of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must not be in list [1, 2, 3]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64 = { not_in: [1, 2, 3] }];
	//	}
	//
	// ```
	NotIn []int64
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  sfixed64 value = 1 [
	//	    (buf.validate.field).sfixed64.example = 1,
	//	    (buf.validate.field).sfixed64.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []int64
}

func (b0 SFixed64Rules_builder) Build() *SFixed64Rules {
	m0 := &SFixed64Rules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &SFixed64Rules_Lt{*b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &SFixed64Rules_Lte{*b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &SFixed64Rules_Gt{*b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &SFixed64Rules_Gte{*b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_SFixed64Rules_LessThan protoreflect.FieldNumber

func (x case_SFixed64Rules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[17].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_SFixed64Rules_GreaterThan protoreflect.FieldNumber

func (x case_SFixed64Rules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[17].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isSFixed64Rules_LessThan interface {
	isSFixed64Rules_LessThan()
}

type SFixed64Rules_Lt struct {
	// `lt` requires the field value to be less than the specified value (field <
	// value). If the field value is equal to or greater than the specified value,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be less than 10
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.lt = 10];
	//	}
	//
	// ```
	Lt int64 `protobuf:"fixed64,2,opt,name=lt,oneof"`
}

type SFixed64Rules_Lte struct {
	// `lte` requires the field value to be less than or equal to the specified
	// value (field <= value). If the field value is greater than the specified
	// value, an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be less than or equal to 10
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.lte = 10];
	//	}
	//
	// ```
	Lte int64 `protobuf:"fixed64,3,opt,name=lte,oneof"`
}

func (*SFixed64Rules_Lt) isSFixed64Rules_LessThan() {}

func (*SFixed64Rules_Lte) isSFixed64Rules_LessThan() {}

type isSFixed64Rules_GreaterThan interface {
	isSFixed64Rules_GreaterThan()
}

type SFixed64Rules_Gt struct {
	// `gt` requires the field value to be greater than the specified value
	// (exclusive). If the value of `gt` is larger than a specified `lt` or
	// `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be greater than 5 [sfixed64.gt]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.gt = 5];
	//
	//	  // value must be greater than 5 and less than 10 [sfixed64.gt_lt]
	//	  sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gt: 5, lt: 10 }];
	//
	//	  // value must be greater than 10 or less than 5 [sfixed64.gt_lt_exclusive]
	//	  sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gt: 10, lt: 5 }];
	//	}
	//
	// ```
	Gt int64 `protobuf:"fixed64,4,opt,name=gt,oneof"`
}

type SFixed64Rules_Gte struct {
	// `gte` requires the field value to be greater than or equal to the specified
	// value (exclusive). If the value of `gte` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MySFixed64 {
	//	  // value must be greater than or equal to 5 [sfixed64.gte]
	//	  sfixed64 value = 1 [(buf.validate.field).sfixed64.gte = 5];
	//
	//	  // value must be greater than or equal to 5 and less than 10 [sfixed64.gte_lt]
	//	  sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gte: 5, lt: 10 }];
	//
	//	  // value must be greater than or equal to 10 or less than 5 [sfixed64.gte_lt_exclusive]
	//	  sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gte: 10, lt: 5 }];
	//	}
	//
	// ```
	Gte int64 `protobuf:"fixed64,5,opt,name=gte,oneof"`
}

func (*SFixed64Rules_Gt) isSFixed64Rules_GreaterThan() {}

func (*SFixed64Rules_Gte) isSFixed64Rules_GreaterThan() {}

// BoolRules describes the rules applied to `bool` values. These rules
// may also be applied to the `google.protobuf.BoolValue` Well-Known-Type.
type BoolRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified boolean value.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyBool {
	//	  // value must equal true
	//	  bool value = 1 [(buf.validate.field).bool.const = true];
	//	}
	//
	// ```
	Const *bool `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyBool {
	//	  bool value = 1 [
	//	    (buf.validate.field).bool.example = 1,
	//	    (buf.validate.field).bool.example = 2
	//	  ];
	//	}
	//
	// ```
	Example         []bool `protobuf:"varint,2,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *BoolRules) Reset() {
	*x = BoolRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BoolRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoolRules) ProtoMessage() {}

func (x *BoolRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *BoolRules) GetConst() bool {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return false
}

func (x *BoolRules) GetExample() []bool {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *BoolRules) SetConst(v bool) {
	x.Const = &v
}

func (x *BoolRules) SetExample(v []bool) {
	x.Example = v
}

func (x *BoolRules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *BoolRules) ClearConst() {
	x.Const = nil
}

type BoolRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified boolean value.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyBool {
	//	  // value must equal true
	//	  bool value = 1 [(buf.validate.field).bool.const = true];
	//	}
	//
	// ```
	Const *bool
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyBool {
	//	  bool value = 1 [
	//	    (buf.validate.field).bool.example = 1,
	//	    (buf.validate.field).bool.example = 2
	//	  ];
	//	}
	//
	// ```
	Example []bool
}

func (b0 BoolRules_builder) Build() *BoolRules {
	m0 := &BoolRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	x.Example = b.Example
	return m0
}

// StringRules describes the rules applied to `string` values These
// rules may also be applied to the `google.protobuf.StringValue` Well-Known-Type.
type StringRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must equal `hello`
	//	  string value = 1 [(buf.validate.field).string.const = "hello"];
	//	}
	//
	// ```
	Const *string `protobuf:"bytes,1,opt,name=const" json:"const,omitempty"`
	// `len` dictates that the field value must have the specified
	// number of characters (Unicode code points), which may differ from the number
	// of bytes in the string. If the field value does not meet the specified
	// length, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be 5 characters
	//	  string value = 1 [(buf.validate.field).string.len = 5];
	//	}
	//
	// ```
	Len *uint64 `protobuf:"varint,19,opt,name=len" json:"len,omitempty"`
	// `min_len` specifies that the field value must have at least the specified
	// number of characters (Unicode code points), which may differ from the number
	// of bytes in the string. If the field value contains fewer characters, an error
	// message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at least 3 characters
	//	  string value = 1 [(buf.validate.field).string.min_len = 3];
	//	}
	//
	// ```
	MinLen *uint64 `protobuf:"varint,2,opt,name=min_len,json=minLen" json:"min_len,omitempty"`
	// `max_len` specifies that the field value must have no more than the specified
	// number of characters (Unicode code points), which may differ from the
	// number of bytes in the string. If the field value contains more characters,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at most 10 characters
	//	  string value = 1 [(buf.validate.field).string.max_len = 10];
	//	}
	//
	// ```
	MaxLen *uint64 `protobuf:"varint,3,opt,name=max_len,json=maxLen" json:"max_len,omitempty"`
	// `len_bytes` dictates that the field value must have the specified number of
	// bytes. If the field value does not match the specified length in bytes,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be 6 bytes
	//	  string value = 1 [(buf.validate.field).string.len_bytes = 6];
	//	}
	//
	// ```
	LenBytes *uint64 `protobuf:"varint,20,opt,name=len_bytes,json=lenBytes" json:"len_bytes,omitempty"`
	// `min_bytes` specifies that the field value must have at least the specified
	// number of bytes. If the field value contains fewer bytes, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at least 4 bytes
	//	  string value = 1 [(buf.validate.field).string.min_bytes = 4];
	//	}
	//
	// ```
	MinBytes *uint64 `protobuf:"varint,4,opt,name=min_bytes,json=minBytes" json:"min_bytes,omitempty"`
	// `max_bytes` specifies that the field value must have no more than the
	// specified number of bytes. If the field value contains more bytes, an
	// error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at most 8 bytes
	//	  string value = 1 [(buf.validate.field).string.max_bytes = 8];
	//	}
	//
	// ```
	MaxBytes *uint64 `protobuf:"varint,5,opt,name=max_bytes,json=maxBytes" json:"max_bytes,omitempty"`
	// `pattern` specifies that the field value must match the specified
	// regular expression (RE2 syntax), with the expression provided without any
	// delimiters. If the field value doesn't match the regular expression, an
	// error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not match regex pattern `^[a-zA-Z]//$`
	//	  string value = 1 [(buf.validate.field).string.pattern = "^[a-zA-Z]//$"];
	//	}
	//
	// ```
	Pattern *string `protobuf:"bytes,6,opt,name=pattern" json:"pattern,omitempty"`
	// `prefix` specifies that the field value must have the
	// specified substring at the beginning of the string. If the field value
	// doesn't start with the specified prefix, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not have prefix `pre`
	//	  string value = 1 [(buf.validate.field).string.prefix = "pre"];
	//	}
	//
	// ```
	Prefix *string `protobuf:"bytes,7,opt,name=prefix" json:"prefix,omitempty"`
	// `suffix` specifies that the field value must have the
	// specified substring at the end of the string. If the field value doesn't
	// end with the specified suffix, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not have suffix `post`
	//	  string value = 1 [(buf.validate.field).string.suffix = "post"];
	//	}
	//
	// ```
	Suffix *string `protobuf:"bytes,8,opt,name=suffix" json:"suffix,omitempty"`
	// `contains` specifies that the field value must have the
	// specified substring anywhere in the string. If the field value doesn't
	// contain the specified substring, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not contain substring `inside`.
	//	  string value = 1 [(buf.validate.field).string.contains = "inside"];
	//	}
	//
	// ```
	Contains *string `protobuf:"bytes,9,opt,name=contains" json:"contains,omitempty"`
	// `not_contains` specifies that the field value must not have the
	// specified substring anywhere in the string. If the field value contains
	// the specified substring, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value contains substring `inside`.
	//	  string value = 1 [(buf.validate.field).string.not_contains = "inside"];
	//	}
	//
	// ```
	NotContains *string `protobuf:"bytes,23,opt,name=not_contains,json=notContains" json:"not_contains,omitempty"`
	// `in` specifies that the field value must be equal to one of the specified
	// values. If the field value isn't one of the specified values, an error
	// message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be in list ["apple", "banana"]
	//	  string value = 1 [(buf.validate.field).string.in = "apple", (buf.validate.field).string.in = "banana"];
	//	}
	//
	// ```
	In []string `protobuf:"bytes,10,rep,name=in" json:"in,omitempty"`
	// `not_in` specifies that the field value cannot be equal to any
	// of the specified values. If the field value is one of the specified values,
	// an error message will be generated.
	// ```proto
	//
	//	message MyString {
	//	  // value must not be in list ["orange", "grape"]
	//	  string value = 1 [(buf.validate.field).string.not_in = "orange", (buf.validate.field).string.not_in = "grape"];
	//	}
	//
	// ```
	NotIn []string `protobuf:"bytes,11,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `WellKnown` rules provide advanced rules against common string
	// patterns.
	//
	// Types that are valid to be assigned to WellKnown:
	//
	//	*StringRules_Email
	//	*StringRules_Hostname
	//	*StringRules_Ip
	//	*StringRules_Ipv4
	//	*StringRules_Ipv6
	//	*StringRules_Uri
	//	*StringRules_UriRef
	//	*StringRules_Address
	//	*StringRules_Uuid
	//	*StringRules_Tuuid
	//	*StringRules_IpWithPrefixlen
	//	*StringRules_Ipv4WithPrefixlen
	//	*StringRules_Ipv6WithPrefixlen
	//	*StringRules_IpPrefix
	//	*StringRules_Ipv4Prefix
	//	*StringRules_Ipv6Prefix
	//	*StringRules_HostAndPort
	//	*StringRules_WellKnownRegex
	WellKnown isStringRules_WellKnown `protobuf_oneof:"well_known"`
	// This applies to regexes `HTTP_HEADER_NAME` and `HTTP_HEADER_VALUE` to
	// enable strict header validation. By default, this is true, and HTTP header
	// validations are [RFC-compliant](https://datatracker.ietf.org/doc/html/rfc7230#section-3). Setting to false will enable looser
	// validations that only disallow `\r\n\0` characters, which can be used to
	// bypass header matching rules.
	//
	// ```proto
	//
	//	message MyString {
	//	  // The field `value` must have be a valid HTTP headers, but not enforced with strict rules.
	//	  string value = 1 [(buf.validate.field).string.strict = false];
	//	}
	//
	// ```
	Strict *bool `protobuf:"varint,25,opt,name=strict" json:"strict,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyString {
	//	  string value = 1 [
	//	    (buf.validate.field).string.example = "hello",
	//	    (buf.validate.field).string.example = "world"
	//	  ];
	//	}
	//
	// ```
	Example         []string `protobuf:"bytes,34,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *StringRules) Reset() {
	*x = StringRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StringRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StringRules) ProtoMessage() {}

func (x *StringRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *StringRules) GetConst() string {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return ""
}

func (x *StringRules) GetLen() uint64 {
	if x != nil && x.Len != nil {
		return *x.Len
	}
	return 0
}

func (x *StringRules) GetMinLen() uint64 {
	if x != nil && x.MinLen != nil {
		return *x.MinLen
	}
	return 0
}

func (x *StringRules) GetMaxLen() uint64 {
	if x != nil && x.MaxLen != nil {
		return *x.MaxLen
	}
	return 0
}

func (x *StringRules) GetLenBytes() uint64 {
	if x != nil && x.LenBytes != nil {
		return *x.LenBytes
	}
	return 0
}

func (x *StringRules) GetMinBytes() uint64 {
	if x != nil && x.MinBytes != nil {
		return *x.MinBytes
	}
	return 0
}

func (x *StringRules) GetMaxBytes() uint64 {
	if x != nil && x.MaxBytes != nil {
		return *x.MaxBytes
	}
	return 0
}

func (x *StringRules) GetPattern() string {
	if x != nil && x.Pattern != nil {
		return *x.Pattern
	}
	return ""
}

func (x *StringRules) GetPrefix() string {
	if x != nil && x.Prefix != nil {
		return *x.Prefix
	}
	return ""
}

func (x *StringRules) GetSuffix() string {
	if x != nil && x.Suffix != nil {
		return *x.Suffix
	}
	return ""
}

func (x *StringRules) GetContains() string {
	if x != nil && x.Contains != nil {
		return *x.Contains
	}
	return ""
}

func (x *StringRules) GetNotContains() string {
	if x != nil && x.NotContains != nil {
		return *x.NotContains
	}
	return ""
}

func (x *StringRules) GetIn() []string {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *StringRules) GetNotIn() []string {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *StringRules) GetWellKnown() isStringRules_WellKnown {
	if x != nil {
		return x.WellKnown
	}
	return nil
}

func (x *StringRules) GetEmail() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Email); ok {
			return x.Email
		}
	}
	return false
}

func (x *StringRules) GetHostname() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Hostname); ok {
			return x.Hostname
		}
	}
	return false
}

func (x *StringRules) GetIp() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Ip); ok {
			return x.Ip
		}
	}
	return false
}

func (x *StringRules) GetIpv4() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Ipv4); ok {
			return x.Ipv4
		}
	}
	return false
}

func (x *StringRules) GetIpv6() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Ipv6); ok {
			return x.Ipv6
		}
	}
	return false
}

func (x *StringRules) GetUri() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Uri); ok {
			return x.Uri
		}
	}
	return false
}

func (x *StringRules) GetUriRef() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_UriRef); ok {
			return x.UriRef
		}
	}
	return false
}

func (x *StringRules) GetAddress() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Address); ok {
			return x.Address
		}
	}
	return false
}

func (x *StringRules) GetUuid() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Uuid); ok {
			return x.Uuid
		}
	}
	return false
}

func (x *StringRules) GetTuuid() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Tuuid); ok {
			return x.Tuuid
		}
	}
	return false
}

func (x *StringRules) GetIpWithPrefixlen() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_IpWithPrefixlen); ok {
			return x.IpWithPrefixlen
		}
	}
	return false
}

func (x *StringRules) GetIpv4WithPrefixlen() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Ipv4WithPrefixlen); ok {
			return x.Ipv4WithPrefixlen
		}
	}
	return false
}

func (x *StringRules) GetIpv6WithPrefixlen() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Ipv6WithPrefixlen); ok {
			return x.Ipv6WithPrefixlen
		}
	}
	return false
}

func (x *StringRules) GetIpPrefix() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_IpPrefix); ok {
			return x.IpPrefix
		}
	}
	return false
}

func (x *StringRules) GetIpv4Prefix() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Ipv4Prefix); ok {
			return x.Ipv4Prefix
		}
	}
	return false
}

func (x *StringRules) GetIpv6Prefix() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_Ipv6Prefix); ok {
			return x.Ipv6Prefix
		}
	}
	return false
}

func (x *StringRules) GetHostAndPort() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_HostAndPort); ok {
			return x.HostAndPort
		}
	}
	return false
}

func (x *StringRules) GetWellKnownRegex() KnownRegex {
	if x != nil {
		if x, ok := x.WellKnown.(*StringRules_WellKnownRegex); ok {
			return x.WellKnownRegex
		}
	}
	return KnownRegex_KNOWN_REGEX_UNSPECIFIED
}

func (x *StringRules) GetStrict() bool {
	if x != nil && x.Strict != nil {
		return *x.Strict
	}
	return false
}

func (x *StringRules) GetExample() []string {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *StringRules) SetConst(v string) {
	x.Const = &v
}

func (x *StringRules) SetLen(v uint64) {
	x.Len = &v
}

func (x *StringRules) SetMinLen(v uint64) {
	x.MinLen = &v
}

func (x *StringRules) SetMaxLen(v uint64) {
	x.MaxLen = &v
}

func (x *StringRules) SetLenBytes(v uint64) {
	x.LenBytes = &v
}

func (x *StringRules) SetMinBytes(v uint64) {
	x.MinBytes = &v
}

func (x *StringRules) SetMaxBytes(v uint64) {
	x.MaxBytes = &v
}

func (x *StringRules) SetPattern(v string) {
	x.Pattern = &v
}

func (x *StringRules) SetPrefix(v string) {
	x.Prefix = &v
}

func (x *StringRules) SetSuffix(v string) {
	x.Suffix = &v
}

func (x *StringRules) SetContains(v string) {
	x.Contains = &v
}

func (x *StringRules) SetNotContains(v string) {
	x.NotContains = &v
}

func (x *StringRules) SetIn(v []string) {
	x.In = v
}

func (x *StringRules) SetNotIn(v []string) {
	x.NotIn = v
}

func (x *StringRules) SetEmail(v bool) {
	x.WellKnown = &StringRules_Email{v}
}

func (x *StringRules) SetHostname(v bool) {
	x.WellKnown = &StringRules_Hostname{v}
}

func (x *StringRules) SetIp(v bool) {
	x.WellKnown = &StringRules_Ip{v}
}

func (x *StringRules) SetIpv4(v bool) {
	x.WellKnown = &StringRules_Ipv4{v}
}

func (x *StringRules) SetIpv6(v bool) {
	x.WellKnown = &StringRules_Ipv6{v}
}

func (x *StringRules) SetUri(v bool) {
	x.WellKnown = &StringRules_Uri{v}
}

func (x *StringRules) SetUriRef(v bool) {
	x.WellKnown = &StringRules_UriRef{v}
}

func (x *StringRules) SetAddress(v bool) {
	x.WellKnown = &StringRules_Address{v}
}

func (x *StringRules) SetUuid(v bool) {
	x.WellKnown = &StringRules_Uuid{v}
}

func (x *StringRules) SetTuuid(v bool) {
	x.WellKnown = &StringRules_Tuuid{v}
}

func (x *StringRules) SetIpWithPrefixlen(v bool) {
	x.WellKnown = &StringRules_IpWithPrefixlen{v}
}

func (x *StringRules) SetIpv4WithPrefixlen(v bool) {
	x.WellKnown = &StringRules_Ipv4WithPrefixlen{v}
}

func (x *StringRules) SetIpv6WithPrefixlen(v bool) {
	x.WellKnown = &StringRules_Ipv6WithPrefixlen{v}
}

func (x *StringRules) SetIpPrefix(v bool) {
	x.WellKnown = &StringRules_IpPrefix{v}
}

func (x *StringRules) SetIpv4Prefix(v bool) {
	x.WellKnown = &StringRules_Ipv4Prefix{v}
}

func (x *StringRules) SetIpv6Prefix(v bool) {
	x.WellKnown = &StringRules_Ipv6Prefix{v}
}

func (x *StringRules) SetHostAndPort(v bool) {
	x.WellKnown = &StringRules_HostAndPort{v}
}

func (x *StringRules) SetWellKnownRegex(v KnownRegex) {
	x.WellKnown = &StringRules_WellKnownRegex{v}
}

func (x *StringRules) SetStrict(v bool) {
	x.Strict = &v
}

func (x *StringRules) SetExample(v []string) {
	x.Example = v
}

func (x *StringRules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *StringRules) HasLen() bool {
	if x == nil {
		return false
	}
	return x.Len != nil
}

func (x *StringRules) HasMinLen() bool {
	if x == nil {
		return false
	}
	return x.MinLen != nil
}

func (x *StringRules) HasMaxLen() bool {
	if x == nil {
		return false
	}
	return x.MaxLen != nil
}

func (x *StringRules) HasLenBytes() bool {
	if x == nil {
		return false
	}
	return x.LenBytes != nil
}

func (x *StringRules) HasMinBytes() bool {
	if x == nil {
		return false
	}
	return x.MinBytes != nil
}

func (x *StringRules) HasMaxBytes() bool {
	if x == nil {
		return false
	}
	return x.MaxBytes != nil
}

func (x *StringRules) HasPattern() bool {
	if x == nil {
		return false
	}
	return x.Pattern != nil
}

func (x *StringRules) HasPrefix() bool {
	if x == nil {
		return false
	}
	return x.Prefix != nil
}

func (x *StringRules) HasSuffix() bool {
	if x == nil {
		return false
	}
	return x.Suffix != nil
}

func (x *StringRules) HasContains() bool {
	if x == nil {
		return false
	}
	return x.Contains != nil
}

func (x *StringRules) HasNotContains() bool {
	if x == nil {
		return false
	}
	return x.NotContains != nil
}

func (x *StringRules) HasWellKnown() bool {
	if x == nil {
		return false
	}
	return x.WellKnown != nil
}

func (x *StringRules) HasEmail() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Email)
	return ok
}

func (x *StringRules) HasHostname() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Hostname)
	return ok
}

func (x *StringRules) HasIp() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Ip)
	return ok
}

func (x *StringRules) HasIpv4() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Ipv4)
	return ok
}

func (x *StringRules) HasIpv6() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Ipv6)
	return ok
}

func (x *StringRules) HasUri() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Uri)
	return ok
}

func (x *StringRules) HasUriRef() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_UriRef)
	return ok
}

func (x *StringRules) HasAddress() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Address)
	return ok
}

func (x *StringRules) HasUuid() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Uuid)
	return ok
}

func (x *StringRules) HasTuuid() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Tuuid)
	return ok
}

func (x *StringRules) HasIpWithPrefixlen() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_IpWithPrefixlen)
	return ok
}

func (x *StringRules) HasIpv4WithPrefixlen() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Ipv4WithPrefixlen)
	return ok
}

func (x *StringRules) HasIpv6WithPrefixlen() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Ipv6WithPrefixlen)
	return ok
}

func (x *StringRules) HasIpPrefix() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_IpPrefix)
	return ok
}

func (x *StringRules) HasIpv4Prefix() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Ipv4Prefix)
	return ok
}

func (x *StringRules) HasIpv6Prefix() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_Ipv6Prefix)
	return ok
}

func (x *StringRules) HasHostAndPort() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_HostAndPort)
	return ok
}

func (x *StringRules) HasWellKnownRegex() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*StringRules_WellKnownRegex)
	return ok
}

func (x *StringRules) HasStrict() bool {
	if x == nil {
		return false
	}
	return x.Strict != nil
}

func (x *StringRules) ClearConst() {
	x.Const = nil
}

func (x *StringRules) ClearLen() {
	x.Len = nil
}

func (x *StringRules) ClearMinLen() {
	x.MinLen = nil
}

func (x *StringRules) ClearMaxLen() {
	x.MaxLen = nil
}

func (x *StringRules) ClearLenBytes() {
	x.LenBytes = nil
}

func (x *StringRules) ClearMinBytes() {
	x.MinBytes = nil
}

func (x *StringRules) ClearMaxBytes() {
	x.MaxBytes = nil
}

func (x *StringRules) ClearPattern() {
	x.Pattern = nil
}

func (x *StringRules) ClearPrefix() {
	x.Prefix = nil
}

func (x *StringRules) ClearSuffix() {
	x.Suffix = nil
}

func (x *StringRules) ClearContains() {
	x.Contains = nil
}

func (x *StringRules) ClearNotContains() {
	x.NotContains = nil
}

func (x *StringRules) ClearWellKnown() {
	x.WellKnown = nil
}

func (x *StringRules) ClearEmail() {
	if _, ok := x.WellKnown.(*StringRules_Email); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearHostname() {
	if _, ok := x.WellKnown.(*StringRules_Hostname); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearIp() {
	if _, ok := x.WellKnown.(*StringRules_Ip); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearIpv4() {
	if _, ok := x.WellKnown.(*StringRules_Ipv4); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearIpv6() {
	if _, ok := x.WellKnown.(*StringRules_Ipv6); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearUri() {
	if _, ok := x.WellKnown.(*StringRules_Uri); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearUriRef() {
	if _, ok := x.WellKnown.(*StringRules_UriRef); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearAddress() {
	if _, ok := x.WellKnown.(*StringRules_Address); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearUuid() {
	if _, ok := x.WellKnown.(*StringRules_Uuid); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearTuuid() {
	if _, ok := x.WellKnown.(*StringRules_Tuuid); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearIpWithPrefixlen() {
	if _, ok := x.WellKnown.(*StringRules_IpWithPrefixlen); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearIpv4WithPrefixlen() {
	if _, ok := x.WellKnown.(*StringRules_Ipv4WithPrefixlen); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearIpv6WithPrefixlen() {
	if _, ok := x.WellKnown.(*StringRules_Ipv6WithPrefixlen); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearIpPrefix() {
	if _, ok := x.WellKnown.(*StringRules_IpPrefix); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearIpv4Prefix() {
	if _, ok := x.WellKnown.(*StringRules_Ipv4Prefix); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearIpv6Prefix() {
	if _, ok := x.WellKnown.(*StringRules_Ipv6Prefix); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearHostAndPort() {
	if _, ok := x.WellKnown.(*StringRules_HostAndPort); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearWellKnownRegex() {
	if _, ok := x.WellKnown.(*StringRules_WellKnownRegex); ok {
		x.WellKnown = nil
	}
}

func (x *StringRules) ClearStrict() {
	x.Strict = nil
}

const StringRules_WellKnown_not_set_case case_StringRules_WellKnown = 0
const StringRules_Email_case case_StringRules_WellKnown = 12
const StringRules_Hostname_case case_StringRules_WellKnown = 13
const StringRules_Ip_case case_StringRules_WellKnown = 14
const StringRules_Ipv4_case case_StringRules_WellKnown = 15
const StringRules_Ipv6_case case_StringRules_WellKnown = 16
const StringRules_Uri_case case_StringRules_WellKnown = 17
const StringRules_UriRef_case case_StringRules_WellKnown = 18
const StringRules_Address_case case_StringRules_WellKnown = 21
const StringRules_Uuid_case case_StringRules_WellKnown = 22
const StringRules_Tuuid_case case_StringRules_WellKnown = 33
const StringRules_IpWithPrefixlen_case case_StringRules_WellKnown = 26
const StringRules_Ipv4WithPrefixlen_case case_StringRules_WellKnown = 27
const StringRules_Ipv6WithPrefixlen_case case_StringRules_WellKnown = 28
const StringRules_IpPrefix_case case_StringRules_WellKnown = 29
const StringRules_Ipv4Prefix_case case_StringRules_WellKnown = 30
const StringRules_Ipv6Prefix_case case_StringRules_WellKnown = 31
const StringRules_HostAndPort_case case_StringRules_WellKnown = 32
const StringRules_WellKnownRegex_case case_StringRules_WellKnown = 24

func (x *StringRules) WhichWellKnown() case_StringRules_WellKnown {
	if x == nil {
		return StringRules_WellKnown_not_set_case
	}
	switch x.WellKnown.(type) {
	case *StringRules_Email:
		return StringRules_Email_case
	case *StringRules_Hostname:
		return StringRules_Hostname_case
	case *StringRules_Ip:
		return StringRules_Ip_case
	case *StringRules_Ipv4:
		return StringRules_Ipv4_case
	case *StringRules_Ipv6:
		return StringRules_Ipv6_case
	case *StringRules_Uri:
		return StringRules_Uri_case
	case *StringRules_UriRef:
		return StringRules_UriRef_case
	case *StringRules_Address:
		return StringRules_Address_case
	case *StringRules_Uuid:
		return StringRules_Uuid_case
	case *StringRules_Tuuid:
		return StringRules_Tuuid_case
	case *StringRules_IpWithPrefixlen:
		return StringRules_IpWithPrefixlen_case
	case *StringRules_Ipv4WithPrefixlen:
		return StringRules_Ipv4WithPrefixlen_case
	case *StringRules_Ipv6WithPrefixlen:
		return StringRules_Ipv6WithPrefixlen_case
	case *StringRules_IpPrefix:
		return StringRules_IpPrefix_case
	case *StringRules_Ipv4Prefix:
		return StringRules_Ipv4Prefix_case
	case *StringRules_Ipv6Prefix:
		return StringRules_Ipv6Prefix_case
	case *StringRules_HostAndPort:
		return StringRules_HostAndPort_case
	case *StringRules_WellKnownRegex:
		return StringRules_WellKnownRegex_case
	default:
		return StringRules_WellKnown_not_set_case
	}
}

type StringRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified value. If
	// the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must equal `hello`
	//	  string value = 1 [(buf.validate.field).string.const = "hello"];
	//	}
	//
	// ```
	Const *string
	// `len` dictates that the field value must have the specified
	// number of characters (Unicode code points), which may differ from the number
	// of bytes in the string. If the field value does not meet the specified
	// length, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be 5 characters
	//	  string value = 1 [(buf.validate.field).string.len = 5];
	//	}
	//
	// ```
	Len *uint64
	// `min_len` specifies that the field value must have at least the specified
	// number of characters (Unicode code points), which may differ from the number
	// of bytes in the string. If the field value contains fewer characters, an error
	// message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at least 3 characters
	//	  string value = 1 [(buf.validate.field).string.min_len = 3];
	//	}
	//
	// ```
	MinLen *uint64
	// `max_len` specifies that the field value must have no more than the specified
	// number of characters (Unicode code points), which may differ from the
	// number of bytes in the string. If the field value contains more characters,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at most 10 characters
	//	  string value = 1 [(buf.validate.field).string.max_len = 10];
	//	}
	//
	// ```
	MaxLen *uint64
	// `len_bytes` dictates that the field value must have the specified number of
	// bytes. If the field value does not match the specified length in bytes,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be 6 bytes
	//	  string value = 1 [(buf.validate.field).string.len_bytes = 6];
	//	}
	//
	// ```
	LenBytes *uint64
	// `min_bytes` specifies that the field value must have at least the specified
	// number of bytes. If the field value contains fewer bytes, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at least 4 bytes
	//	  string value = 1 [(buf.validate.field).string.min_bytes = 4];
	//	}
	//
	// ```
	MinBytes *uint64
	// `max_bytes` specifies that the field value must have no more than the
	// specified number of bytes. If the field value contains more bytes, an
	// error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value length must be at most 8 bytes
	//	  string value = 1 [(buf.validate.field).string.max_bytes = 8];
	//	}
	//
	// ```
	MaxBytes *uint64
	// `pattern` specifies that the field value must match the specified
	// regular expression (RE2 syntax), with the expression provided without any
	// delimiters. If the field value doesn't match the regular expression, an
	// error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not match regex pattern `^[a-zA-Z]//$`
	//	  string value = 1 [(buf.validate.field).string.pattern = "^[a-zA-Z]//$"];
	//	}
	//
	// ```
	Pattern *string
	// `prefix` specifies that the field value must have the
	// specified substring at the beginning of the string. If the field value
	// doesn't start with the specified prefix, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not have prefix `pre`
	//	  string value = 1 [(buf.validate.field).string.prefix = "pre"];
	//	}
	//
	// ```
	Prefix *string
	// `suffix` specifies that the field value must have the
	// specified substring at the end of the string. If the field value doesn't
	// end with the specified suffix, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not have suffix `post`
	//	  string value = 1 [(buf.validate.field).string.suffix = "post"];
	//	}
	//
	// ```
	Suffix *string
	// `contains` specifies that the field value must have the
	// specified substring anywhere in the string. If the field value doesn't
	// contain the specified substring, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value does not contain substring `inside`.
	//	  string value = 1 [(buf.validate.field).string.contains = "inside"];
	//	}
	//
	// ```
	Contains *string
	// `not_contains` specifies that the field value must not have the
	// specified substring anywhere in the string. If the field value contains
	// the specified substring, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value contains substring `inside`.
	//	  string value = 1 [(buf.validate.field).string.not_contains = "inside"];
	//	}
	//
	// ```
	NotContains *string
	// `in` specifies that the field value must be equal to one of the specified
	// values. If the field value isn't one of the specified values, an error
	// message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be in list ["apple", "banana"]
	//	  string value = 1 [(buf.validate.field).string.in = "apple", (buf.validate.field).string.in = "banana"];
	//	}
	//
	// ```
	In []string
	// `not_in` specifies that the field value cannot be equal to any
	// of the specified values. If the field value is one of the specified values,
	// an error message will be generated.
	// ```proto
	//
	//	message MyString {
	//	  // value must not be in list ["orange", "grape"]
	//	  string value = 1 [(buf.validate.field).string.not_in = "orange", (buf.validate.field).string.not_in = "grape"];
	//	}
	//
	// ```
	NotIn []string
	// `WellKnown` rules provide advanced rules against common string
	// patterns.

	// Fields of oneof WellKnown:
	// `email` specifies that the field value must be a valid email address, for
	// example "foo@example.com".
	//
	// Conforms to the definition for a valid email address from the [HTML standard](https://html.spec.whatwg.org/multipage/input.html#valid-e-mail-address).
	// Note that this standard willfully deviates from [RFC 5322](https://datatracker.ietf.org/doc/html/rfc5322),
	// which allows many unexpected forms of email addresses and will easily match
	// a typographical error.
	//
	// If the field value isn't a valid email address, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid email address
	//	  string value = 1 [(buf.validate.field).string.email = true];
	//	}
	//
	// ```
	Email *bool
	// `hostname` specifies that the field value must be a valid hostname, for
	// example "foo.example.com".
	//
	// A valid hostname follows the rules below:
	// - The name consists of one or more labels, separated by a dot (".").
	// - Each label can be 1 to 63 alphanumeric characters.
	// - A label can contain hyphens ("-"), but must not start or end with a hyphen.
	// - The right-most label must not be digits only.
	// - The name can have a trailing dot—for example, "foo.example.com.".
	// - The name can be 253 characters at most, excluding the optional trailing dot.
	//
	// If the field value isn't a valid hostname, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid hostname
	//	  string value = 1 [(buf.validate.field).string.hostname = true];
	//	}
	//
	// ```
	Hostname *bool
	// `ip` specifies that the field value must be a valid IP (v4 or v6) address.
	//
	// IPv4 addresses are expected in the dotted decimal format—for example, "192.168.5.21".
	// IPv6 addresses are expected in their text representation—for example, "::1",
	// or "2001:0DB8:ABCD:0012::0".
	//
	// Both formats are well-defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
	// Zone identifiers for IPv6 addresses (for example, "fe80::a%en1") are supported.
	//
	// If the field value isn't a valid IP address, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IP address
	//	  string value = 1 [(buf.validate.field).string.ip = true];
	//	}
	//
	// ```
	Ip *bool
	// `ipv4` specifies that the field value must be a valid IPv4 address—for
	// example "192.168.5.21". If the field value isn't a valid IPv4 address, an
	// error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv4 address
	//	  string value = 1 [(buf.validate.field).string.ipv4 = true];
	//	}
	//
	// ```
	Ipv4 *bool
	// `ipv6` specifies that the field value must be a valid IPv6 address—for
	// example "::1", or "d7a:115c:a1e0:ab12:4843:cd96:626b:430b". If the field
	// value is not a valid IPv6 address, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv6 address
	//	  string value = 1 [(buf.validate.field).string.ipv6 = true];
	//	}
	//
	// ```
	Ipv6 *bool
	// `uri` specifies that the field value must be a valid URI, for example
	// "https://example.com/foo/bar?baz=quux#frag".
	//
	// URI is defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
	// Zone Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).
	//
	// If the field value isn't a valid URI, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid URI
	//	  string value = 1 [(buf.validate.field).string.uri = true];
	//	}
	//
	// ```
	Uri *bool
	// `uri_ref` specifies that the field value must be a valid URI Reference—either
	// a URI such as "https://example.com/foo/bar?baz=quux#frag", or a Relative
	// Reference such as "./foo/bar?query".
	//
	// URI, URI Reference, and Relative Reference are defined in the internet
	// standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986). Zone
	// Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).
	//
	// If the field value isn't a valid URI Reference, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid URI Reference
	//	  string value = 1 [(buf.validate.field).string.uri_ref = true];
	//	}
	//
	// ```
	UriRef *bool
	// `address` specifies that the field value must be either a valid hostname
	// (for example, "example.com"), or a valid IP (v4 or v6) address (for example,
	// "192.168.0.1", or "::1"). If the field value isn't a valid hostname or IP,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid hostname, or ip address
	//	  string value = 1 [(buf.validate.field).string.address = true];
	//	}
	//
	// ```
	Address *bool
	// `uuid` specifies that the field value must be a valid UUID as defined by
	// [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2). If the
	// field value isn't a valid UUID, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid UUID
	//	  string value = 1 [(buf.validate.field).string.uuid = true];
	//	}
	//
	// ```
	Uuid *bool
	// `tuuid` (trimmed UUID) specifies that the field value must be a valid UUID as
	// defined by [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2) with all dashes
	// omitted. If the field value isn't a valid UUID without dashes, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid trimmed UUID
	//	  string value = 1 [(buf.validate.field).string.tuuid = true];
	//	}
	//
	// ```
	Tuuid *bool
	// `ip_with_prefixlen` specifies that the field value must be a valid IP
	// (v4 or v6) address with prefix length—for example, "192.168.5.21/16" or
	// "2001:0DB8:ABCD:0012::F1/64". If the field value isn't a valid IP with
	// prefix length, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IP with prefix length
	//	   string value = 1 [(buf.validate.field).string.ip_with_prefixlen = true];
	//	}
	//
	// ```
	IpWithPrefixlen *bool
	// `ipv4_with_prefixlen` specifies that the field value must be a valid
	// IPv4 address with prefix length—for example, "192.168.5.21/16". If the
	// field value isn't a valid IPv4 address with prefix length, an error
	// message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv4 address with prefix length
	//	   string value = 1 [(buf.validate.field).string.ipv4_with_prefixlen = true];
	//	}
	//
	// ```
	Ipv4WithPrefixlen *bool
	// `ipv6_with_prefixlen` specifies that the field value must be a valid
	// IPv6 address with prefix length—for example, "2001:0DB8:ABCD:0012::F1/64".
	// If the field value is not a valid IPv6 address with prefix length,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv6 address prefix length
	//	   string value = 1 [(buf.validate.field).string.ipv6_with_prefixlen = true];
	//	}
	//
	// ```
	Ipv6WithPrefixlen *bool
	// `ip_prefix` specifies that the field value must be a valid IP (v4 or v6)
	// prefix—for example, "192.168.0.0/16" or "2001:0DB8:ABCD:0012::0/64".
	//
	// The prefix must have all zeros for the unmasked bits. For example,
	// "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
	// prefix, and the remaining 64 bits must be zero.
	//
	// If the field value isn't a valid IP prefix, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IP prefix
	//	   string value = 1 [(buf.validate.field).string.ip_prefix = true];
	//	}
	//
	// ```
	IpPrefix *bool
	// `ipv4_prefix` specifies that the field value must be a valid IPv4
	// prefix, for example "192.168.0.0/16".
	//
	// The prefix must have all zeros for the unmasked bits. For example,
	// "192.168.0.0/16" designates the left-most 16 bits for the prefix,
	// and the remaining 16 bits must be zero.
	//
	// If the field value isn't a valid IPv4 prefix, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv4 prefix
	//	   string value = 1 [(buf.validate.field).string.ipv4_prefix = true];
	//	}
	//
	// ```
	Ipv4Prefix *bool
	// `ipv6_prefix` specifies that the field value must be a valid IPv6 prefix—for
	// example, "2001:0DB8:ABCD:0012::0/64".
	//
	// The prefix must have all zeros for the unmasked bits. For example,
	// "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
	// prefix, and the remaining 64 bits must be zero.
	//
	// If the field value is not a valid IPv6 prefix, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv6 prefix
	//	   string value = 1 [(buf.validate.field).string.ipv6_prefix = true];
	//	}
	//
	// ```
	Ipv6Prefix *bool
	// `host_and_port` specifies that the field value must be valid host/port
	// pair—for example, "example.com:8080".
	//
	// The host can be one of:
	// - An IPv4 address in dotted decimal format—for example, "192.168.5.21".
	// - An IPv6 address enclosed in square brackets—for example, "[2001:0DB8:ABCD:0012::F1]".
	// - A hostname—for example, "example.com".
	//
	// The port is separated by a colon. It must be non-empty, with a decimal number
	// in the range of 0-65535, inclusive.
	HostAndPort *bool
	// `well_known_regex` specifies a common well-known pattern
	// defined as a regex. If the field value doesn't match the well-known
	// regex, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid HTTP header value
	//	  string value = 1 [(buf.validate.field).string.well_known_regex = KNOWN_REGEX_HTTP_HEADER_VALUE];
	//	}
	//
	// ```
	//
	// #### KnownRegex
	//
	// `well_known_regex` contains some well-known patterns.
	//
	// | Name                          | Number | Description                               |
	// |-------------------------------|--------|-------------------------------------------|
	// | KNOWN_REGEX_UNSPECIFIED       | 0      |                                           |
	// | KNOWN_REGEX_HTTP_HEADER_NAME  | 1      | HTTP header name as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2)  |
	// | KNOWN_REGEX_HTTP_HEADER_VALUE | 2      | HTTP header value as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.4) |
	WellKnownRegex *KnownRegex
	// -- end of WellKnown
	// This applies to regexes `HTTP_HEADER_NAME` and `HTTP_HEADER_VALUE` to
	// enable strict header validation. By default, this is true, and HTTP header
	// validations are [RFC-compliant](https://datatracker.ietf.org/doc/html/rfc7230#section-3). Setting to false will enable looser
	// validations that only disallow `\r\n\0` characters, which can be used to
	// bypass header matching rules.
	//
	// ```proto
	//
	//	message MyString {
	//	  // The field `value` must have be a valid HTTP headers, but not enforced with strict rules.
	//	  string value = 1 [(buf.validate.field).string.strict = false];
	//	}
	//
	// ```
	Strict *bool
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyString {
	//	  string value = 1 [
	//	    (buf.validate.field).string.example = "hello",
	//	    (buf.validate.field).string.example = "world"
	//	  ];
	//	}
	//
	// ```
	Example []string
}

func (b0 StringRules_builder) Build() *StringRules {
	m0 := &StringRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	x.Len = b.Len
	x.MinLen = b.MinLen
	x.MaxLen = b.MaxLen
	x.LenBytes = b.LenBytes
	x.MinBytes = b.MinBytes
	x.MaxBytes = b.MaxBytes
	x.Pattern = b.Pattern
	x.Prefix = b.Prefix
	x.Suffix = b.Suffix
	x.Contains = b.Contains
	x.NotContains = b.NotContains
	x.In = b.In
	x.NotIn = b.NotIn
	if b.Email != nil {
		x.WellKnown = &StringRules_Email{*b.Email}
	}
	if b.Hostname != nil {
		x.WellKnown = &StringRules_Hostname{*b.Hostname}
	}
	if b.Ip != nil {
		x.WellKnown = &StringRules_Ip{*b.Ip}
	}
	if b.Ipv4 != nil {
		x.WellKnown = &StringRules_Ipv4{*b.Ipv4}
	}
	if b.Ipv6 != nil {
		x.WellKnown = &StringRules_Ipv6{*b.Ipv6}
	}
	if b.Uri != nil {
		x.WellKnown = &StringRules_Uri{*b.Uri}
	}
	if b.UriRef != nil {
		x.WellKnown = &StringRules_UriRef{*b.UriRef}
	}
	if b.Address != nil {
		x.WellKnown = &StringRules_Address{*b.Address}
	}
	if b.Uuid != nil {
		x.WellKnown = &StringRules_Uuid{*b.Uuid}
	}
	if b.Tuuid != nil {
		x.WellKnown = &StringRules_Tuuid{*b.Tuuid}
	}
	if b.IpWithPrefixlen != nil {
		x.WellKnown = &StringRules_IpWithPrefixlen{*b.IpWithPrefixlen}
	}
	if b.Ipv4WithPrefixlen != nil {
		x.WellKnown = &StringRules_Ipv4WithPrefixlen{*b.Ipv4WithPrefixlen}
	}
	if b.Ipv6WithPrefixlen != nil {
		x.WellKnown = &StringRules_Ipv6WithPrefixlen{*b.Ipv6WithPrefixlen}
	}
	if b.IpPrefix != nil {
		x.WellKnown = &StringRules_IpPrefix{*b.IpPrefix}
	}
	if b.Ipv4Prefix != nil {
		x.WellKnown = &StringRules_Ipv4Prefix{*b.Ipv4Prefix}
	}
	if b.Ipv6Prefix != nil {
		x.WellKnown = &StringRules_Ipv6Prefix{*b.Ipv6Prefix}
	}
	if b.HostAndPort != nil {
		x.WellKnown = &StringRules_HostAndPort{*b.HostAndPort}
	}
	if b.WellKnownRegex != nil {
		x.WellKnown = &StringRules_WellKnownRegex{*b.WellKnownRegex}
	}
	x.Strict = b.Strict
	x.Example = b.Example
	return m0
}

type case_StringRules_WellKnown protoreflect.FieldNumber

func (x case_StringRules_WellKnown) String() string {
	md := file_buf_validate_validate_proto_msgTypes[19].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isStringRules_WellKnown interface {
	isStringRules_WellKnown()
}

type StringRules_Email struct {
	// `email` specifies that the field value must be a valid email address, for
	// example "foo@example.com".
	//
	// Conforms to the definition for a valid email address from the [HTML standard](https://html.spec.whatwg.org/multipage/input.html#valid-e-mail-address).
	// Note that this standard willfully deviates from [RFC 5322](https://datatracker.ietf.org/doc/html/rfc5322),
	// which allows many unexpected forms of email addresses and will easily match
	// a typographical error.
	//
	// If the field value isn't a valid email address, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid email address
	//	  string value = 1 [(buf.validate.field).string.email = true];
	//	}
	//
	// ```
	Email bool `protobuf:"varint,12,opt,name=email,oneof"`
}

type StringRules_Hostname struct {
	// `hostname` specifies that the field value must be a valid hostname, for
	// example "foo.example.com".
	//
	// A valid hostname follows the rules below:
	// - The name consists of one or more labels, separated by a dot (".").
	// - Each label can be 1 to 63 alphanumeric characters.
	// - A label can contain hyphens ("-"), but must not start or end with a hyphen.
	// - The right-most label must not be digits only.
	// - The name can have a trailing dot—for example, "foo.example.com.".
	// - The name can be 253 characters at most, excluding the optional trailing dot.
	//
	// If the field value isn't a valid hostname, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid hostname
	//	  string value = 1 [(buf.validate.field).string.hostname = true];
	//	}
	//
	// ```
	Hostname bool `protobuf:"varint,13,opt,name=hostname,oneof"`
}

type StringRules_Ip struct {
	// `ip` specifies that the field value must be a valid IP (v4 or v6) address.
	//
	// IPv4 addresses are expected in the dotted decimal format—for example, "192.168.5.21".
	// IPv6 addresses are expected in their text representation—for example, "::1",
	// or "2001:0DB8:ABCD:0012::0".
	//
	// Both formats are well-defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
	// Zone identifiers for IPv6 addresses (for example, "fe80::a%en1") are supported.
	//
	// If the field value isn't a valid IP address, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IP address
	//	  string value = 1 [(buf.validate.field).string.ip = true];
	//	}
	//
	// ```
	Ip bool `protobuf:"varint,14,opt,name=ip,oneof"`
}

type StringRules_Ipv4 struct {
	// `ipv4` specifies that the field value must be a valid IPv4 address—for
	// example "192.168.5.21". If the field value isn't a valid IPv4 address, an
	// error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv4 address
	//	  string value = 1 [(buf.validate.field).string.ipv4 = true];
	//	}
	//
	// ```
	Ipv4 bool `protobuf:"varint,15,opt,name=ipv4,oneof"`
}

type StringRules_Ipv6 struct {
	// `ipv6` specifies that the field value must be a valid IPv6 address—for
	// example "::1", or "d7a:115c:a1e0:ab12:4843:cd96:626b:430b". If the field
	// value is not a valid IPv6 address, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv6 address
	//	  string value = 1 [(buf.validate.field).string.ipv6 = true];
	//	}
	//
	// ```
	Ipv6 bool `protobuf:"varint,16,opt,name=ipv6,oneof"`
}

type StringRules_Uri struct {
	// `uri` specifies that the field value must be a valid URI, for example
	// "https://example.com/foo/bar?baz=quux#frag".
	//
	// URI is defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
	// Zone Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).
	//
	// If the field value isn't a valid URI, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid URI
	//	  string value = 1 [(buf.validate.field).string.uri = true];
	//	}
	//
	// ```
	Uri bool `protobuf:"varint,17,opt,name=uri,oneof"`
}

type StringRules_UriRef struct {
	// `uri_ref` specifies that the field value must be a valid URI Reference—either
	// a URI such as "https://example.com/foo/bar?baz=quux#frag", or a Relative
	// Reference such as "./foo/bar?query".
	//
	// URI, URI Reference, and Relative Reference are defined in the internet
	// standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986). Zone
	// Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).
	//
	// If the field value isn't a valid URI Reference, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid URI Reference
	//	  string value = 1 [(buf.validate.field).string.uri_ref = true];
	//	}
	//
	// ```
	UriRef bool `protobuf:"varint,18,opt,name=uri_ref,json=uriRef,oneof"`
}

type StringRules_Address struct {
	// `address` specifies that the field value must be either a valid hostname
	// (for example, "example.com"), or a valid IP (v4 or v6) address (for example,
	// "192.168.0.1", or "::1"). If the field value isn't a valid hostname or IP,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid hostname, or ip address
	//	  string value = 1 [(buf.validate.field).string.address = true];
	//	}
	//
	// ```
	Address bool `protobuf:"varint,21,opt,name=address,oneof"`
}

type StringRules_Uuid struct {
	// `uuid` specifies that the field value must be a valid UUID as defined by
	// [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2). If the
	// field value isn't a valid UUID, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid UUID
	//	  string value = 1 [(buf.validate.field).string.uuid = true];
	//	}
	//
	// ```
	Uuid bool `protobuf:"varint,22,opt,name=uuid,oneof"`
}

type StringRules_Tuuid struct {
	// `tuuid` (trimmed UUID) specifies that the field value must be a valid UUID as
	// defined by [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2) with all dashes
	// omitted. If the field value isn't a valid UUID without dashes, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid trimmed UUID
	//	  string value = 1 [(buf.validate.field).string.tuuid = true];
	//	}
	//
	// ```
	Tuuid bool `protobuf:"varint,33,opt,name=tuuid,oneof"`
}

type StringRules_IpWithPrefixlen struct {
	// `ip_with_prefixlen` specifies that the field value must be a valid IP
	// (v4 or v6) address with prefix length—for example, "192.168.5.21/16" or
	// "2001:0DB8:ABCD:0012::F1/64". If the field value isn't a valid IP with
	// prefix length, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IP with prefix length
	//	   string value = 1 [(buf.validate.field).string.ip_with_prefixlen = true];
	//	}
	//
	// ```
	IpWithPrefixlen bool `protobuf:"varint,26,opt,name=ip_with_prefixlen,json=ipWithPrefixlen,oneof"`
}

type StringRules_Ipv4WithPrefixlen struct {
	// `ipv4_with_prefixlen` specifies that the field value must be a valid
	// IPv4 address with prefix length—for example, "192.168.5.21/16". If the
	// field value isn't a valid IPv4 address with prefix length, an error
	// message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv4 address with prefix length
	//	   string value = 1 [(buf.validate.field).string.ipv4_with_prefixlen = true];
	//	}
	//
	// ```
	Ipv4WithPrefixlen bool `protobuf:"varint,27,opt,name=ipv4_with_prefixlen,json=ipv4WithPrefixlen,oneof"`
}

type StringRules_Ipv6WithPrefixlen struct {
	// `ipv6_with_prefixlen` specifies that the field value must be a valid
	// IPv6 address with prefix length—for example, "2001:0DB8:ABCD:0012::F1/64".
	// If the field value is not a valid IPv6 address with prefix length,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv6 address prefix length
	//	   string value = 1 [(buf.validate.field).string.ipv6_with_prefixlen = true];
	//	}
	//
	// ```
	Ipv6WithPrefixlen bool `protobuf:"varint,28,opt,name=ipv6_with_prefixlen,json=ipv6WithPrefixlen,oneof"`
}

type StringRules_IpPrefix struct {
	// `ip_prefix` specifies that the field value must be a valid IP (v4 or v6)
	// prefix—for example, "192.168.0.0/16" or "2001:0DB8:ABCD:0012::0/64".
	//
	// The prefix must have all zeros for the unmasked bits. For example,
	// "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
	// prefix, and the remaining 64 bits must be zero.
	//
	// If the field value isn't a valid IP prefix, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IP prefix
	//	   string value = 1 [(buf.validate.field).string.ip_prefix = true];
	//	}
	//
	// ```
	IpPrefix bool `protobuf:"varint,29,opt,name=ip_prefix,json=ipPrefix,oneof"`
}

type StringRules_Ipv4Prefix struct {
	// `ipv4_prefix` specifies that the field value must be a valid IPv4
	// prefix, for example "192.168.0.0/16".
	//
	// The prefix must have all zeros for the unmasked bits. For example,
	// "192.168.0.0/16" designates the left-most 16 bits for the prefix,
	// and the remaining 16 bits must be zero.
	//
	// If the field value isn't a valid IPv4 prefix, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv4 prefix
	//	   string value = 1 [(buf.validate.field).string.ipv4_prefix = true];
	//	}
	//
	// ```
	Ipv4Prefix bool `protobuf:"varint,30,opt,name=ipv4_prefix,json=ipv4Prefix,oneof"`
}

type StringRules_Ipv6Prefix struct {
	// `ipv6_prefix` specifies that the field value must be a valid IPv6 prefix—for
	// example, "2001:0DB8:ABCD:0012::0/64".
	//
	// The prefix must have all zeros for the unmasked bits. For example,
	// "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
	// prefix, and the remaining 64 bits must be zero.
	//
	// If the field value is not a valid IPv6 prefix, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid IPv6 prefix
	//	   string value = 1 [(buf.validate.field).string.ipv6_prefix = true];
	//	}
	//
	// ```
	Ipv6Prefix bool `protobuf:"varint,31,opt,name=ipv6_prefix,json=ipv6Prefix,oneof"`
}

type StringRules_HostAndPort struct {
	// `host_and_port` specifies that the field value must be valid host/port
	// pair—for example, "example.com:8080".
	//
	// The host can be one of:
	// - An IPv4 address in dotted decimal format—for example, "192.168.5.21".
	// - An IPv6 address enclosed in square brackets—for example, "[2001:0DB8:ABCD:0012::F1]".
	// - A hostname—for example, "example.com".
	//
	// The port is separated by a colon. It must be non-empty, with a decimal number
	// in the range of 0-65535, inclusive.
	HostAndPort bool `protobuf:"varint,32,opt,name=host_and_port,json=hostAndPort,oneof"`
}

type StringRules_WellKnownRegex struct {
	// `well_known_regex` specifies a common well-known pattern
	// defined as a regex. If the field value doesn't match the well-known
	// regex, an error message will be generated.
	//
	// ```proto
	//
	//	message MyString {
	//	  // value must be a valid HTTP header value
	//	  string value = 1 [(buf.validate.field).string.well_known_regex = KNOWN_REGEX_HTTP_HEADER_VALUE];
	//	}
	//
	// ```
	//
	// #### KnownRegex
	//
	// `well_known_regex` contains some well-known patterns.
	//
	// | Name                          | Number | Description                               |
	// |-------------------------------|--------|-------------------------------------------|
	// | KNOWN_REGEX_UNSPECIFIED       | 0      |                                           |
	// | KNOWN_REGEX_HTTP_HEADER_NAME  | 1      | HTTP header name as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2)  |
	// | KNOWN_REGEX_HTTP_HEADER_VALUE | 2      | HTTP header value as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.4) |
	WellKnownRegex KnownRegex `protobuf:"varint,24,opt,name=well_known_regex,json=wellKnownRegex,enum=buf.validate.KnownRegex,oneof"`
}

func (*StringRules_Email) isStringRules_WellKnown() {}

func (*StringRules_Hostname) isStringRules_WellKnown() {}

func (*StringRules_Ip) isStringRules_WellKnown() {}

func (*StringRules_Ipv4) isStringRules_WellKnown() {}

func (*StringRules_Ipv6) isStringRules_WellKnown() {}

func (*StringRules_Uri) isStringRules_WellKnown() {}

func (*StringRules_UriRef) isStringRules_WellKnown() {}

func (*StringRules_Address) isStringRules_WellKnown() {}

func (*StringRules_Uuid) isStringRules_WellKnown() {}

func (*StringRules_Tuuid) isStringRules_WellKnown() {}

func (*StringRules_IpWithPrefixlen) isStringRules_WellKnown() {}

func (*StringRules_Ipv4WithPrefixlen) isStringRules_WellKnown() {}

func (*StringRules_Ipv6WithPrefixlen) isStringRules_WellKnown() {}

func (*StringRules_IpPrefix) isStringRules_WellKnown() {}

func (*StringRules_Ipv4Prefix) isStringRules_WellKnown() {}

func (*StringRules_Ipv6Prefix) isStringRules_WellKnown() {}

func (*StringRules_HostAndPort) isStringRules_WellKnown() {}

func (*StringRules_WellKnownRegex) isStringRules_WellKnown() {}

// BytesRules describe the rules applied to `bytes` values. These rules
// may also be applied to the `google.protobuf.BytesValue` Well-Known-Type.
type BytesRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified bytes
	// value. If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be "\x01\x02\x03\x04"
	//	  bytes value = 1 [(buf.validate.field).bytes.const = "\x01\x02\x03\x04"];
	//	}
	//
	// ```
	Const []byte `protobuf:"bytes,1,opt,name=const" json:"const,omitempty"`
	// `len` requires the field value to have the specified length in bytes.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value length must be 4 bytes.
	//	  optional bytes value = 1 [(buf.validate.field).bytes.len = 4];
	//	}
	//
	// ```
	Len *uint64 `protobuf:"varint,13,opt,name=len" json:"len,omitempty"`
	// `min_len` requires the field value to have at least the specified minimum
	// length in bytes.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value length must be at least 2 bytes.
	//	  optional bytes value = 1 [(buf.validate.field).bytes.min_len = 2];
	//	}
	//
	// ```
	MinLen *uint64 `protobuf:"varint,2,opt,name=min_len,json=minLen" json:"min_len,omitempty"`
	// `max_len` requires the field value to have at most the specified maximum
	// length in bytes.
	// If the field value exceeds the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be at most 6 bytes.
	//	  optional bytes value = 1 [(buf.validate.field).bytes.max_len = 6];
	//	}
	//
	// ```
	MaxLen *uint64 `protobuf:"varint,3,opt,name=max_len,json=maxLen" json:"max_len,omitempty"`
	// `pattern` requires the field value to match the specified regular
	// expression ([RE2 syntax](https://github.com/google/re2/wiki/Syntax)).
	// The value of the field must be valid UTF-8 or validation will fail with a
	// runtime error.
	// If the field value doesn't match the pattern, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must match regex pattern "^[a-zA-Z0-9]+$".
	//	  optional bytes value = 1 [(buf.validate.field).bytes.pattern = "^[a-zA-Z0-9]+$"];
	//	}
	//
	// ```
	Pattern *string `protobuf:"bytes,4,opt,name=pattern" json:"pattern,omitempty"`
	// `prefix` requires the field value to have the specified bytes at the
	// beginning of the string.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value does not have prefix \x01\x02
	//	  optional bytes value = 1 [(buf.validate.field).bytes.prefix = "\x01\x02"];
	//	}
	//
	// ```
	Prefix []byte `protobuf:"bytes,5,opt,name=prefix" json:"prefix,omitempty"`
	// `suffix` requires the field value to have the specified bytes at the end
	// of the string.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value does not have suffix \x03\x04
	//	  optional bytes value = 1 [(buf.validate.field).bytes.suffix = "\x03\x04"];
	//	}
	//
	// ```
	Suffix []byte `protobuf:"bytes,6,opt,name=suffix" json:"suffix,omitempty"`
	// `contains` requires the field value to have the specified bytes anywhere in
	// the string.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```protobuf
	//
	//	message MyBytes {
	//	  // value does not contain \x02\x03
	//	  optional bytes value = 1 [(buf.validate.field).bytes.contains = "\x02\x03"];
	//	}
	//
	// ```
	Contains []byte `protobuf:"bytes,7,opt,name=contains" json:"contains,omitempty"`
	// `in` requires the field value to be equal to one of the specified
	// values. If the field value doesn't match any of the specified values, an
	// error message is generated.
	//
	// ```protobuf
	//
	//	message MyBytes {
	//	  // value must in ["\x01\x02", "\x02\x03", "\x03\x04"]
	//	  optional bytes value = 1 [(buf.validate.field).bytes.in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
	//	}
	//
	// ```
	In [][]byte `protobuf:"bytes,8,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to be not equal to any of the specified
	// values.
	// If the field value matches any of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must not in ["\x01\x02", "\x02\x03", "\x03\x04"]
	//	  optional bytes value = 1 [(buf.validate.field).bytes.not_in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
	//	}
	//
	// ```
	NotIn [][]byte `protobuf:"bytes,9,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// WellKnown rules provide advanced rules against common byte
	// patterns
	//
	// Types that are valid to be assigned to WellKnown:
	//
	//	*BytesRules_Ip
	//	*BytesRules_Ipv4
	//	*BytesRules_Ipv6
	WellKnown isBytesRules_WellKnown `protobuf_oneof:"well_known"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  bytes value = 1 [
	//	    (buf.validate.field).bytes.example = "\x01\x02",
	//	    (buf.validate.field).bytes.example = "\x02\x03"
	//	  ];
	//	}
	//
	// ```
	Example         [][]byte `protobuf:"bytes,14,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *BytesRules) Reset() {
	*x = BytesRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BytesRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BytesRules) ProtoMessage() {}

func (x *BytesRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *BytesRules) GetConst() []byte {
	if x != nil {
		return x.Const
	}
	return nil
}

func (x *BytesRules) GetLen() uint64 {
	if x != nil && x.Len != nil {
		return *x.Len
	}
	return 0
}

func (x *BytesRules) GetMinLen() uint64 {
	if x != nil && x.MinLen != nil {
		return *x.MinLen
	}
	return 0
}

func (x *BytesRules) GetMaxLen() uint64 {
	if x != nil && x.MaxLen != nil {
		return *x.MaxLen
	}
	return 0
}

func (x *BytesRules) GetPattern() string {
	if x != nil && x.Pattern != nil {
		return *x.Pattern
	}
	return ""
}

func (x *BytesRules) GetPrefix() []byte {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *BytesRules) GetSuffix() []byte {
	if x != nil {
		return x.Suffix
	}
	return nil
}

func (x *BytesRules) GetContains() []byte {
	if x != nil {
		return x.Contains
	}
	return nil
}

func (x *BytesRules) GetIn() [][]byte {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *BytesRules) GetNotIn() [][]byte {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *BytesRules) GetWellKnown() isBytesRules_WellKnown {
	if x != nil {
		return x.WellKnown
	}
	return nil
}

func (x *BytesRules) GetIp() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*BytesRules_Ip); ok {
			return x.Ip
		}
	}
	return false
}

func (x *BytesRules) GetIpv4() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*BytesRules_Ipv4); ok {
			return x.Ipv4
		}
	}
	return false
}

func (x *BytesRules) GetIpv6() bool {
	if x != nil {
		if x, ok := x.WellKnown.(*BytesRules_Ipv6); ok {
			return x.Ipv6
		}
	}
	return false
}

func (x *BytesRules) GetExample() [][]byte {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *BytesRules) SetConst(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.Const = v
}

func (x *BytesRules) SetLen(v uint64) {
	x.Len = &v
}

func (x *BytesRules) SetMinLen(v uint64) {
	x.MinLen = &v
}

func (x *BytesRules) SetMaxLen(v uint64) {
	x.MaxLen = &v
}

func (x *BytesRules) SetPattern(v string) {
	x.Pattern = &v
}

func (x *BytesRules) SetPrefix(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.Prefix = v
}

func (x *BytesRules) SetSuffix(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.Suffix = v
}

func (x *BytesRules) SetContains(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.Contains = v
}

func (x *BytesRules) SetIn(v [][]byte) {
	x.In = v
}

func (x *BytesRules) SetNotIn(v [][]byte) {
	x.NotIn = v
}

func (x *BytesRules) SetIp(v bool) {
	x.WellKnown = &BytesRules_Ip{v}
}

func (x *BytesRules) SetIpv4(v bool) {
	x.WellKnown = &BytesRules_Ipv4{v}
}

func (x *BytesRules) SetIpv6(v bool) {
	x.WellKnown = &BytesRules_Ipv6{v}
}

func (x *BytesRules) SetExample(v [][]byte) {
	x.Example = v
}

func (x *BytesRules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *BytesRules) HasLen() bool {
	if x == nil {
		return false
	}
	return x.Len != nil
}

func (x *BytesRules) HasMinLen() bool {
	if x == nil {
		return false
	}
	return x.MinLen != nil
}

func (x *BytesRules) HasMaxLen() bool {
	if x == nil {
		return false
	}
	return x.MaxLen != nil
}

func (x *BytesRules) HasPattern() bool {
	if x == nil {
		return false
	}
	return x.Pattern != nil
}

func (x *BytesRules) HasPrefix() bool {
	if x == nil {
		return false
	}
	return x.Prefix != nil
}

func (x *BytesRules) HasSuffix() bool {
	if x == nil {
		return false
	}
	return x.Suffix != nil
}

func (x *BytesRules) HasContains() bool {
	if x == nil {
		return false
	}
	return x.Contains != nil
}

func (x *BytesRules) HasWellKnown() bool {
	if x == nil {
		return false
	}
	return x.WellKnown != nil
}

func (x *BytesRules) HasIp() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*BytesRules_Ip)
	return ok
}

func (x *BytesRules) HasIpv4() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*BytesRules_Ipv4)
	return ok
}

func (x *BytesRules) HasIpv6() bool {
	if x == nil {
		return false
	}
	_, ok := x.WellKnown.(*BytesRules_Ipv6)
	return ok
}

func (x *BytesRules) ClearConst() {
	x.Const = nil
}

func (x *BytesRules) ClearLen() {
	x.Len = nil
}

func (x *BytesRules) ClearMinLen() {
	x.MinLen = nil
}

func (x *BytesRules) ClearMaxLen() {
	x.MaxLen = nil
}

func (x *BytesRules) ClearPattern() {
	x.Pattern = nil
}

func (x *BytesRules) ClearPrefix() {
	x.Prefix = nil
}

func (x *BytesRules) ClearSuffix() {
	x.Suffix = nil
}

func (x *BytesRules) ClearContains() {
	x.Contains = nil
}

func (x *BytesRules) ClearWellKnown() {
	x.WellKnown = nil
}

func (x *BytesRules) ClearIp() {
	if _, ok := x.WellKnown.(*BytesRules_Ip); ok {
		x.WellKnown = nil
	}
}

func (x *BytesRules) ClearIpv4() {
	if _, ok := x.WellKnown.(*BytesRules_Ipv4); ok {
		x.WellKnown = nil
	}
}

func (x *BytesRules) ClearIpv6() {
	if _, ok := x.WellKnown.(*BytesRules_Ipv6); ok {
		x.WellKnown = nil
	}
}

const BytesRules_WellKnown_not_set_case case_BytesRules_WellKnown = 0
const BytesRules_Ip_case case_BytesRules_WellKnown = 10
const BytesRules_Ipv4_case case_BytesRules_WellKnown = 11
const BytesRules_Ipv6_case case_BytesRules_WellKnown = 12

func (x *BytesRules) WhichWellKnown() case_BytesRules_WellKnown {
	if x == nil {
		return BytesRules_WellKnown_not_set_case
	}
	switch x.WellKnown.(type) {
	case *BytesRules_Ip:
		return BytesRules_Ip_case
	case *BytesRules_Ipv4:
		return BytesRules_Ipv4_case
	case *BytesRules_Ipv6:
		return BytesRules_Ipv6_case
	default:
		return BytesRules_WellKnown_not_set_case
	}
}

type BytesRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified bytes
	// value. If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be "\x01\x02\x03\x04"
	//	  bytes value = 1 [(buf.validate.field).bytes.const = "\x01\x02\x03\x04"];
	//	}
	//
	// ```
	Const []byte
	// `len` requires the field value to have the specified length in bytes.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value length must be 4 bytes.
	//	  optional bytes value = 1 [(buf.validate.field).bytes.len = 4];
	//	}
	//
	// ```
	Len *uint64
	// `min_len` requires the field value to have at least the specified minimum
	// length in bytes.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value length must be at least 2 bytes.
	//	  optional bytes value = 1 [(buf.validate.field).bytes.min_len = 2];
	//	}
	//
	// ```
	MinLen *uint64
	// `max_len` requires the field value to have at most the specified maximum
	// length in bytes.
	// If the field value exceeds the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be at most 6 bytes.
	//	  optional bytes value = 1 [(buf.validate.field).bytes.max_len = 6];
	//	}
	//
	// ```
	MaxLen *uint64
	// `pattern` requires the field value to match the specified regular
	// expression ([RE2 syntax](https://github.com/google/re2/wiki/Syntax)).
	// The value of the field must be valid UTF-8 or validation will fail with a
	// runtime error.
	// If the field value doesn't match the pattern, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must match regex pattern "^[a-zA-Z0-9]+$".
	//	  optional bytes value = 1 [(buf.validate.field).bytes.pattern = "^[a-zA-Z0-9]+$"];
	//	}
	//
	// ```
	Pattern *string
	// `prefix` requires the field value to have the specified bytes at the
	// beginning of the string.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value does not have prefix \x01\x02
	//	  optional bytes value = 1 [(buf.validate.field).bytes.prefix = "\x01\x02"];
	//	}
	//
	// ```
	Prefix []byte
	// `suffix` requires the field value to have the specified bytes at the end
	// of the string.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value does not have suffix \x03\x04
	//	  optional bytes value = 1 [(buf.validate.field).bytes.suffix = "\x03\x04"];
	//	}
	//
	// ```
	Suffix []byte
	// `contains` requires the field value to have the specified bytes anywhere in
	// the string.
	// If the field value doesn't meet the requirement, an error message is generated.
	//
	// ```protobuf
	//
	//	message MyBytes {
	//	  // value does not contain \x02\x03
	//	  optional bytes value = 1 [(buf.validate.field).bytes.contains = "\x02\x03"];
	//	}
	//
	// ```
	Contains []byte
	// `in` requires the field value to be equal to one of the specified
	// values. If the field value doesn't match any of the specified values, an
	// error message is generated.
	//
	// ```protobuf
	//
	//	message MyBytes {
	//	  // value must in ["\x01\x02", "\x02\x03", "\x03\x04"]
	//	  optional bytes value = 1 [(buf.validate.field).bytes.in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
	//	}
	//
	// ```
	In [][]byte
	// `not_in` requires the field value to be not equal to any of the specified
	// values.
	// If the field value matches any of the specified values, an error message is
	// generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must not in ["\x01\x02", "\x02\x03", "\x03\x04"]
	//	  optional bytes value = 1 [(buf.validate.field).bytes.not_in = {"\x01\x02", "\x02\x03", "\x03\x04"}];
	//	}
	//
	// ```
	NotIn [][]byte
	// WellKnown rules provide advanced rules against common byte
	// patterns

	// Fields of oneof WellKnown:
	// `ip` ensures that the field `value` is a valid IP address (v4 or v6) in byte format.
	// If the field value doesn't meet this rule, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be a valid IP address
	//	  optional bytes value = 1 [(buf.validate.field).bytes.ip = true];
	//	}
	//
	// ```
	Ip *bool
	// `ipv4` ensures that the field `value` is a valid IPv4 address in byte format.
	// If the field value doesn't meet this rule, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be a valid IPv4 address
	//	  optional bytes value = 1 [(buf.validate.field).bytes.ipv4 = true];
	//	}
	//
	// ```
	Ipv4 *bool
	// `ipv6` ensures that the field `value` is a valid IPv6 address in byte format.
	// If the field value doesn't meet this rule, an error message is generated.
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be a valid IPv6 address
	//	  optional bytes value = 1 [(buf.validate.field).bytes.ipv6 = true];
	//	}
	//
	// ```
	Ipv6 *bool
	// -- end of WellKnown
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  bytes value = 1 [
	//	    (buf.validate.field).bytes.example = "\x01\x02",
	//	    (buf.validate.field).bytes.example = "\x02\x03"
	//	  ];
	//	}
	//
	// ```
	Example [][]byte
}

func (b0 BytesRules_builder) Build() *BytesRules {
	m0 := &BytesRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	x.Len = b.Len
	x.MinLen = b.MinLen
	x.MaxLen = b.MaxLen
	x.Pattern = b.Pattern
	x.Prefix = b.Prefix
	x.Suffix = b.Suffix
	x.Contains = b.Contains
	x.In = b.In
	x.NotIn = b.NotIn
	if b.Ip != nil {
		x.WellKnown = &BytesRules_Ip{*b.Ip}
	}
	if b.Ipv4 != nil {
		x.WellKnown = &BytesRules_Ipv4{*b.Ipv4}
	}
	if b.Ipv6 != nil {
		x.WellKnown = &BytesRules_Ipv6{*b.Ipv6}
	}
	x.Example = b.Example
	return m0
}

type case_BytesRules_WellKnown protoreflect.FieldNumber

func (x case_BytesRules_WellKnown) String() string {
	md := file_buf_validate_validate_proto_msgTypes[20].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isBytesRules_WellKnown interface {
	isBytesRules_WellKnown()
}

type BytesRules_Ip struct {
	// `ip` ensures that the field `value` is a valid IP address (v4 or v6) in byte format.
	// If the field value doesn't meet this rule, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be a valid IP address
	//	  optional bytes value = 1 [(buf.validate.field).bytes.ip = true];
	//	}
	//
	// ```
	Ip bool `protobuf:"varint,10,opt,name=ip,oneof"`
}

type BytesRules_Ipv4 struct {
	// `ipv4` ensures that the field `value` is a valid IPv4 address in byte format.
	// If the field value doesn't meet this rule, an error message is generated.
	//
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be a valid IPv4 address
	//	  optional bytes value = 1 [(buf.validate.field).bytes.ipv4 = true];
	//	}
	//
	// ```
	Ipv4 bool `protobuf:"varint,11,opt,name=ipv4,oneof"`
}

type BytesRules_Ipv6 struct {
	// `ipv6` ensures that the field `value` is a valid IPv6 address in byte format.
	// If the field value doesn't meet this rule, an error message is generated.
	// ```proto
	//
	//	message MyBytes {
	//	  // value must be a valid IPv6 address
	//	  optional bytes value = 1 [(buf.validate.field).bytes.ipv6 = true];
	//	}
	//
	// ```
	Ipv6 bool `protobuf:"varint,12,opt,name=ipv6,oneof"`
}

func (*BytesRules_Ip) isBytesRules_WellKnown() {}

func (*BytesRules_Ipv4) isBytesRules_WellKnown() {}

func (*BytesRules_Ipv6) isBytesRules_WellKnown() {}

// EnumRules describe the rules applied to `enum` values.
type EnumRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` requires the field value to exactly match the specified enum value.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must be exactly MY_ENUM_VALUE1.
	//	  MyEnum value = 1 [(buf.validate.field).enum.const = 1];
	//	}
	//
	// ```
	Const *int32 `protobuf:"varint,1,opt,name=const" json:"const,omitempty"`
	// `defined_only` requires the field value to be one of the defined values for
	// this enum, failing on any undefined value.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must be a defined value of MyEnum.
	//	  MyEnum value = 1 [(buf.validate.field).enum.defined_only = true];
	//	}
	//
	// ```
	DefinedOnly *bool `protobuf:"varint,2,opt,name=defined_only,json=definedOnly" json:"defined_only,omitempty"`
	// `in` requires the field value to be equal to one of the
	// specified enum values. If the field value doesn't match any of the
	// specified values, an error message is generated.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must be equal to one of the specified values.
	//	  MyEnum value = 1 [(buf.validate.field).enum = { in: [1, 2]}];
	//	}
	//
	// ```
	In []int32 `protobuf:"varint,3,rep,name=in" json:"in,omitempty"`
	// `not_in` requires the field value to be not equal to any of the
	// specified enum values. If the field value matches one of the specified
	// values, an error message is generated.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must not be equal to any of the specified values.
	//	  MyEnum value = 1 [(buf.validate.field).enum = { not_in: [1, 2]}];
	//	}
	//
	// ```
	NotIn []int32 `protobuf:"varint,4,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	    (buf.validate.field).enum.example = 1,
	//	    (buf.validate.field).enum.example = 2
	//	}
	//
	// ```
	Example         []int32 `protobuf:"varint,5,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *EnumRules) Reset() {
	*x = EnumRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumRules) ProtoMessage() {}

func (x *EnumRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *EnumRules) GetConst() int32 {
	if x != nil && x.Const != nil {
		return *x.Const
	}
	return 0
}

func (x *EnumRules) GetDefinedOnly() bool {
	if x != nil && x.DefinedOnly != nil {
		return *x.DefinedOnly
	}
	return false
}

func (x *EnumRules) GetIn() []int32 {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *EnumRules) GetNotIn() []int32 {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *EnumRules) GetExample() []int32 {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *EnumRules) SetConst(v int32) {
	x.Const = &v
}

func (x *EnumRules) SetDefinedOnly(v bool) {
	x.DefinedOnly = &v
}

func (x *EnumRules) SetIn(v []int32) {
	x.In = v
}

func (x *EnumRules) SetNotIn(v []int32) {
	x.NotIn = v
}

func (x *EnumRules) SetExample(v []int32) {
	x.Example = v
}

func (x *EnumRules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *EnumRules) HasDefinedOnly() bool {
	if x == nil {
		return false
	}
	return x.DefinedOnly != nil
}

func (x *EnumRules) ClearConst() {
	x.Const = nil
}

func (x *EnumRules) ClearDefinedOnly() {
	x.DefinedOnly = nil
}

type EnumRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` requires the field value to exactly match the specified enum value.
	// If the field value doesn't match, an error message is generated.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must be exactly MY_ENUM_VALUE1.
	//	  MyEnum value = 1 [(buf.validate.field).enum.const = 1];
	//	}
	//
	// ```
	Const *int32
	// `defined_only` requires the field value to be one of the defined values for
	// this enum, failing on any undefined value.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must be a defined value of MyEnum.
	//	  MyEnum value = 1 [(buf.validate.field).enum.defined_only = true];
	//	}
	//
	// ```
	DefinedOnly *bool
	// `in` requires the field value to be equal to one of the
	// specified enum values. If the field value doesn't match any of the
	// specified values, an error message is generated.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must be equal to one of the specified values.
	//	  MyEnum value = 1 [(buf.validate.field).enum = { in: [1, 2]}];
	//	}
	//
	// ```
	In []int32
	// `not_in` requires the field value to be not equal to any of the
	// specified enum values. If the field value matches one of the specified
	// values, an error message is generated.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	  // The field `value` must not be equal to any of the specified values.
	//	  MyEnum value = 1 [(buf.validate.field).enum = { not_in: [1, 2]}];
	//	}
	//
	// ```
	NotIn []int32
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	enum MyEnum {
	//	  MY_ENUM_UNSPECIFIED = 0;
	//	  MY_ENUM_VALUE1 = 1;
	//	  MY_ENUM_VALUE2 = 2;
	//	}
	//
	//	message MyMessage {
	//	    (buf.validate.field).enum.example = 1,
	//	    (buf.validate.field).enum.example = 2
	//	}
	//
	// ```
	Example []int32
}

func (b0 EnumRules_builder) Build() *EnumRules {
	m0 := &EnumRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	x.DefinedOnly = b.DefinedOnly
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

// RepeatedRules describe the rules applied to `repeated` values.
type RepeatedRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `min_items` requires that this field must contain at least the specified
	// minimum number of items.
	//
	// Note that `min_items = 1` is equivalent to setting a field as `required`.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // value must contain at least  2 items
	//	  repeated string value = 1 [(buf.validate.field).repeated.min_items = 2];
	//	}
	//
	// ```
	MinItems *uint64 `protobuf:"varint,1,opt,name=min_items,json=minItems" json:"min_items,omitempty"`
	// `max_items` denotes that this field must not exceed a
	// certain number of items as the upper limit. If the field contains more
	// items than specified, an error message will be generated, requiring the
	// field to maintain no more than the specified number of items.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // value must contain no more than 3 item(s)
	//	  repeated string value = 1 [(buf.validate.field).repeated.max_items = 3];
	//	}
	//
	// ```
	MaxItems *uint64 `protobuf:"varint,2,opt,name=max_items,json=maxItems" json:"max_items,omitempty"`
	// `unique` indicates that all elements in this field must
	// be unique. This rule is strictly applicable to scalar and enum
	// types, with message types not being supported.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // repeated value must contain unique items
	//	  repeated string value = 1 [(buf.validate.field).repeated.unique = true];
	//	}
	//
	// ```
	Unique *bool `protobuf:"varint,3,opt,name=unique" json:"unique,omitempty"`
	// `items` details the rules to be applied to each item
	// in the field. Even for repeated message fields, validation is executed
	// against each item unless `ignore` is specified.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // The items in the field `value` must follow the specified rules.
	//	  repeated string value = 1 [(buf.validate.field).repeated.items = {
	//	    string: {
	//	      min_len: 3
	//	      max_len: 10
	//	    }
	//	  }];
	//	}
	//
	// ```
	//
	// Note that the `required` rule does not apply. Repeated items
	// cannot be unset.
	Items           *FieldRules `protobuf:"bytes,4,opt,name=items" json:"items,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *RepeatedRules) Reset() {
	*x = RepeatedRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepeatedRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepeatedRules) ProtoMessage() {}

func (x *RepeatedRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepeatedRules) GetMinItems() uint64 {
	if x != nil && x.MinItems != nil {
		return *x.MinItems
	}
	return 0
}

func (x *RepeatedRules) GetMaxItems() uint64 {
	if x != nil && x.MaxItems != nil {
		return *x.MaxItems
	}
	return 0
}

func (x *RepeatedRules) GetUnique() bool {
	if x != nil && x.Unique != nil {
		return *x.Unique
	}
	return false
}

func (x *RepeatedRules) GetItems() *FieldRules {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *RepeatedRules) SetMinItems(v uint64) {
	x.MinItems = &v
}

func (x *RepeatedRules) SetMaxItems(v uint64) {
	x.MaxItems = &v
}

func (x *RepeatedRules) SetUnique(v bool) {
	x.Unique = &v
}

func (x *RepeatedRules) SetItems(v *FieldRules) {
	x.Items = v
}

func (x *RepeatedRules) HasMinItems() bool {
	if x == nil {
		return false
	}
	return x.MinItems != nil
}

func (x *RepeatedRules) HasMaxItems() bool {
	if x == nil {
		return false
	}
	return x.MaxItems != nil
}

func (x *RepeatedRules) HasUnique() bool {
	if x == nil {
		return false
	}
	return x.Unique != nil
}

func (x *RepeatedRules) HasItems() bool {
	if x == nil {
		return false
	}
	return x.Items != nil
}

func (x *RepeatedRules) ClearMinItems() {
	x.MinItems = nil
}

func (x *RepeatedRules) ClearMaxItems() {
	x.MaxItems = nil
}

func (x *RepeatedRules) ClearUnique() {
	x.Unique = nil
}

func (x *RepeatedRules) ClearItems() {
	x.Items = nil
}

type RepeatedRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `min_items` requires that this field must contain at least the specified
	// minimum number of items.
	//
	// Note that `min_items = 1` is equivalent to setting a field as `required`.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // value must contain at least  2 items
	//	  repeated string value = 1 [(buf.validate.field).repeated.min_items = 2];
	//	}
	//
	// ```
	MinItems *uint64
	// `max_items` denotes that this field must not exceed a
	// certain number of items as the upper limit. If the field contains more
	// items than specified, an error message will be generated, requiring the
	// field to maintain no more than the specified number of items.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // value must contain no more than 3 item(s)
	//	  repeated string value = 1 [(buf.validate.field).repeated.max_items = 3];
	//	}
	//
	// ```
	MaxItems *uint64
	// `unique` indicates that all elements in this field must
	// be unique. This rule is strictly applicable to scalar and enum
	// types, with message types not being supported.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // repeated value must contain unique items
	//	  repeated string value = 1 [(buf.validate.field).repeated.unique = true];
	//	}
	//
	// ```
	Unique *bool
	// `items` details the rules to be applied to each item
	// in the field. Even for repeated message fields, validation is executed
	// against each item unless `ignore` is specified.
	//
	// ```proto
	//
	//	message MyRepeated {
	//	  // The items in the field `value` must follow the specified rules.
	//	  repeated string value = 1 [(buf.validate.field).repeated.items = {
	//	    string: {
	//	      min_len: 3
	//	      max_len: 10
	//	    }
	//	  }];
	//	}
	//
	// ```
	//
	// Note that the `required` rule does not apply. Repeated items
	// cannot be unset.
	Items *FieldRules
}

func (b0 RepeatedRules_builder) Build() *RepeatedRules {
	m0 := &RepeatedRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.MinItems = b.MinItems
	x.MaxItems = b.MaxItems
	x.Unique = b.Unique
	x.Items = b.Items
	return m0
}

// MapRules describe the rules applied to `map` values.
type MapRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Specifies the minimum number of key-value pairs allowed. If the field has
	// fewer key-value pairs than specified, an error message is generated.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The field `value` must have at least 2 key-value pairs.
	//	  map<string, string> value = 1 [(buf.validate.field).map.min_pairs = 2];
	//	}
	//
	// ```
	MinPairs *uint64 `protobuf:"varint,1,opt,name=min_pairs,json=minPairs" json:"min_pairs,omitempty"`
	// Specifies the maximum number of key-value pairs allowed. If the field has
	// more key-value pairs than specified, an error message is generated.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The field `value` must have at most 3 key-value pairs.
	//	  map<string, string> value = 1 [(buf.validate.field).map.max_pairs = 3];
	//	}
	//
	// ```
	MaxPairs *uint64 `protobuf:"varint,2,opt,name=max_pairs,json=maxPairs" json:"max_pairs,omitempty"`
	// Specifies the rules to be applied to each key in the field.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The keys in the field `value` must follow the specified rules.
	//	  map<string, string> value = 1 [(buf.validate.field).map.keys = {
	//	    string: {
	//	      min_len: 3
	//	      max_len: 10
	//	    }
	//	  }];
	//	}
	//
	// ```
	//
	// Note that the `required` rule does not apply. Map keys cannot be unset.
	Keys *FieldRules `protobuf:"bytes,4,opt,name=keys" json:"keys,omitempty"`
	// Specifies the rules to be applied to the value of each key in the
	// field. Message values will still have their validations evaluated unless
	// `ignore` is specified.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The values in the field `value` must follow the specified rules.
	//	  map<string, string> value = 1 [(buf.validate.field).map.values = {
	//	    string: {
	//	      min_len: 5
	//	      max_len: 20
	//	    }
	//	  }];
	//	}
	//
	// ```
	// Note that the `required` rule does not apply. Map values cannot be unset.
	Values          *FieldRules `protobuf:"bytes,5,opt,name=values" json:"values,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *MapRules) Reset() {
	*x = MapRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MapRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapRules) ProtoMessage() {}

func (x *MapRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MapRules) GetMinPairs() uint64 {
	if x != nil && x.MinPairs != nil {
		return *x.MinPairs
	}
	return 0
}

func (x *MapRules) GetMaxPairs() uint64 {
	if x != nil && x.MaxPairs != nil {
		return *x.MaxPairs
	}
	return 0
}

func (x *MapRules) GetKeys() *FieldRules {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *MapRules) GetValues() *FieldRules {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *MapRules) SetMinPairs(v uint64) {
	x.MinPairs = &v
}

func (x *MapRules) SetMaxPairs(v uint64) {
	x.MaxPairs = &v
}

func (x *MapRules) SetKeys(v *FieldRules) {
	x.Keys = v
}

func (x *MapRules) SetValues(v *FieldRules) {
	x.Values = v
}

func (x *MapRules) HasMinPairs() bool {
	if x == nil {
		return false
	}
	return x.MinPairs != nil
}

func (x *MapRules) HasMaxPairs() bool {
	if x == nil {
		return false
	}
	return x.MaxPairs != nil
}

func (x *MapRules) HasKeys() bool {
	if x == nil {
		return false
	}
	return x.Keys != nil
}

func (x *MapRules) HasValues() bool {
	if x == nil {
		return false
	}
	return x.Values != nil
}

func (x *MapRules) ClearMinPairs() {
	x.MinPairs = nil
}

func (x *MapRules) ClearMaxPairs() {
	x.MaxPairs = nil
}

func (x *MapRules) ClearKeys() {
	x.Keys = nil
}

func (x *MapRules) ClearValues() {
	x.Values = nil
}

type MapRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Specifies the minimum number of key-value pairs allowed. If the field has
	// fewer key-value pairs than specified, an error message is generated.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The field `value` must have at least 2 key-value pairs.
	//	  map<string, string> value = 1 [(buf.validate.field).map.min_pairs = 2];
	//	}
	//
	// ```
	MinPairs *uint64
	// Specifies the maximum number of key-value pairs allowed. If the field has
	// more key-value pairs than specified, an error message is generated.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The field `value` must have at most 3 key-value pairs.
	//	  map<string, string> value = 1 [(buf.validate.field).map.max_pairs = 3];
	//	}
	//
	// ```
	MaxPairs *uint64
	// Specifies the rules to be applied to each key in the field.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The keys in the field `value` must follow the specified rules.
	//	  map<string, string> value = 1 [(buf.validate.field).map.keys = {
	//	    string: {
	//	      min_len: 3
	//	      max_len: 10
	//	    }
	//	  }];
	//	}
	//
	// ```
	//
	// Note that the `required` rule does not apply. Map keys cannot be unset.
	Keys *FieldRules
	// Specifies the rules to be applied to the value of each key in the
	// field. Message values will still have their validations evaluated unless
	// `ignore` is specified.
	//
	// ```proto
	//
	//	message MyMap {
	//	  // The values in the field `value` must follow the specified rules.
	//	  map<string, string> value = 1 [(buf.validate.field).map.values = {
	//	    string: {
	//	      min_len: 5
	//	      max_len: 20
	//	    }
	//	  }];
	//	}
	//
	// ```
	// Note that the `required` rule does not apply. Map values cannot be unset.
	Values *FieldRules
}

func (b0 MapRules_builder) Build() *MapRules {
	m0 := &MapRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.MinPairs = b.MinPairs
	x.MaxPairs = b.MaxPairs
	x.Keys = b.Keys
	x.Values = b.Values
	return m0
}

// AnyRules describe rules applied exclusively to the `google.protobuf.Any` well-known type.
type AnyRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `in` requires the field's `type_url` to be equal to one of the
	// specified values. If it doesn't match any of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyAny {
	//	  //  The `value` field must have a `type_url` equal to one of the specified values.
	//	  google.protobuf.Any value = 1 [(buf.validate.field).any = {
	//	      in: ["type.googleapis.com/MyType1", "type.googleapis.com/MyType2"]
	//	  }];
	//	}
	//
	// ```
	In []string `protobuf:"bytes,2,rep,name=in" json:"in,omitempty"`
	// requires the field's type_url to be not equal to any of the specified values. If it matches any of the specified values, an error message is generated.
	//
	// ```proto
	//
	//	message MyAny {
	//	  //  The `value` field must not have a `type_url` equal to any of the specified values.
	//	  google.protobuf.Any value = 1 [(buf.validate.field).any = {
	//	      not_in: ["type.googleapis.com/ForbiddenType1", "type.googleapis.com/ForbiddenType2"]
	//	  }];
	//	}
	//
	// ```
	NotIn         []string `protobuf:"bytes,3,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AnyRules) Reset() {
	*x = AnyRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnyRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnyRules) ProtoMessage() {}

func (x *AnyRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *AnyRules) GetIn() []string {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *AnyRules) GetNotIn() []string {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *AnyRules) SetIn(v []string) {
	x.In = v
}

func (x *AnyRules) SetNotIn(v []string) {
	x.NotIn = v
}

type AnyRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `in` requires the field's `type_url` to be equal to one of the
	// specified values. If it doesn't match any of the specified values, an error
	// message is generated.
	//
	// ```proto
	//
	//	message MyAny {
	//	  //  The `value` field must have a `type_url` equal to one of the specified values.
	//	  google.protobuf.Any value = 1 [(buf.validate.field).any = {
	//	      in: ["type.googleapis.com/MyType1", "type.googleapis.com/MyType2"]
	//	  }];
	//	}
	//
	// ```
	In []string
	// requires the field's type_url to be not equal to any of the specified values. If it matches any of the specified values, an error message is generated.
	//
	// ```proto
	//
	//	message MyAny {
	//	  //  The `value` field must not have a `type_url` equal to any of the specified values.
	//	  google.protobuf.Any value = 1 [(buf.validate.field).any = {
	//	      not_in: ["type.googleapis.com/ForbiddenType1", "type.googleapis.com/ForbiddenType2"]
	//	  }];
	//	}
	//
	// ```
	NotIn []string
}

func (b0 AnyRules_builder) Build() *AnyRules {
	m0 := &AnyRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.In = b.In
	x.NotIn = b.NotIn
	return m0
}

// DurationRules describe the rules applied exclusively to the `google.protobuf.Duration` well-known type.
type DurationRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` dictates that the field must match the specified value of the `google.protobuf.Duration` type exactly.
	// If the field's value deviates from the specified value, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must equal 5s
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.const = "5s"];
	//	}
	//
	// ```
	Const *durationpb.Duration `protobuf:"bytes,2,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*DurationRules_Lt
	//	*DurationRules_Lte
	LessThan isDurationRules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*DurationRules_Gt
	//	*DurationRules_Gte
	GreaterThan isDurationRules_GreaterThan `protobuf_oneof:"greater_than"`
	// `in` asserts that the field must be equal to one of the specified values of the `google.protobuf.Duration` type.
	// If the field's value doesn't correspond to any of the specified values,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must be in list [1s, 2s, 3s]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.in = ["1s", "2s", "3s"]];
	//	}
	//
	// ```
	In []*durationpb.Duration `protobuf:"bytes,7,rep,name=in" json:"in,omitempty"`
	// `not_in` denotes that the field must not be equal to
	// any of the specified values of the `google.protobuf.Duration` type.
	// If the field's value matches any of these values, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must not be in list [1s, 2s, 3s]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.not_in = ["1s", "2s", "3s"]];
	//	}
	//
	// ```
	NotIn []*durationpb.Duration `protobuf:"bytes,8,rep,name=not_in,json=notIn" json:"not_in,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  google.protobuf.Duration value = 1 [
	//	    (buf.validate.field).duration.example = { seconds: 1 },
	//	    (buf.validate.field).duration.example = { seconds: 2 },
	//	  ];
	//	}
	//
	// ```
	Example         []*durationpb.Duration `protobuf:"bytes,9,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *DurationRules) Reset() {
	*x = DurationRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DurationRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DurationRules) ProtoMessage() {}

func (x *DurationRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DurationRules) GetConst() *durationpb.Duration {
	if x != nil {
		return x.Const
	}
	return nil
}

func (x *DurationRules) GetLessThan() isDurationRules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *DurationRules) GetLt() *durationpb.Duration {
	if x != nil {
		if x, ok := x.LessThan.(*DurationRules_Lt); ok {
			return x.Lt
		}
	}
	return nil
}

func (x *DurationRules) GetLte() *durationpb.Duration {
	if x != nil {
		if x, ok := x.LessThan.(*DurationRules_Lte); ok {
			return x.Lte
		}
	}
	return nil
}

func (x *DurationRules) GetGreaterThan() isDurationRules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *DurationRules) GetGt() *durationpb.Duration {
	if x != nil {
		if x, ok := x.GreaterThan.(*DurationRules_Gt); ok {
			return x.Gt
		}
	}
	return nil
}

func (x *DurationRules) GetGte() *durationpb.Duration {
	if x != nil {
		if x, ok := x.GreaterThan.(*DurationRules_Gte); ok {
			return x.Gte
		}
	}
	return nil
}

func (x *DurationRules) GetIn() []*durationpb.Duration {
	if x != nil {
		return x.In
	}
	return nil
}

func (x *DurationRules) GetNotIn() []*durationpb.Duration {
	if x != nil {
		return x.NotIn
	}
	return nil
}

func (x *DurationRules) GetExample() []*durationpb.Duration {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *DurationRules) SetConst(v *durationpb.Duration) {
	x.Const = v
}

func (x *DurationRules) SetLt(v *durationpb.Duration) {
	if v == nil {
		x.LessThan = nil
		return
	}
	x.LessThan = &DurationRules_Lt{v}
}

func (x *DurationRules) SetLte(v *durationpb.Duration) {
	if v == nil {
		x.LessThan = nil
		return
	}
	x.LessThan = &DurationRules_Lte{v}
}

func (x *DurationRules) SetGt(v *durationpb.Duration) {
	if v == nil {
		x.GreaterThan = nil
		return
	}
	x.GreaterThan = &DurationRules_Gt{v}
}

func (x *DurationRules) SetGte(v *durationpb.Duration) {
	if v == nil {
		x.GreaterThan = nil
		return
	}
	x.GreaterThan = &DurationRules_Gte{v}
}

func (x *DurationRules) SetIn(v []*durationpb.Duration) {
	x.In = v
}

func (x *DurationRules) SetNotIn(v []*durationpb.Duration) {
	x.NotIn = v
}

func (x *DurationRules) SetExample(v []*durationpb.Duration) {
	x.Example = v
}

func (x *DurationRules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *DurationRules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *DurationRules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*DurationRules_Lt)
	return ok
}

func (x *DurationRules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*DurationRules_Lte)
	return ok
}

func (x *DurationRules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *DurationRules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*DurationRules_Gt)
	return ok
}

func (x *DurationRules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*DurationRules_Gte)
	return ok
}

func (x *DurationRules) ClearConst() {
	x.Const = nil
}

func (x *DurationRules) ClearLessThan() {
	x.LessThan = nil
}

func (x *DurationRules) ClearLt() {
	if _, ok := x.LessThan.(*DurationRules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *DurationRules) ClearLte() {
	if _, ok := x.LessThan.(*DurationRules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *DurationRules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *DurationRules) ClearGt() {
	if _, ok := x.GreaterThan.(*DurationRules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *DurationRules) ClearGte() {
	if _, ok := x.GreaterThan.(*DurationRules_Gte); ok {
		x.GreaterThan = nil
	}
}

const DurationRules_LessThan_not_set_case case_DurationRules_LessThan = 0
const DurationRules_Lt_case case_DurationRules_LessThan = 3
const DurationRules_Lte_case case_DurationRules_LessThan = 4

func (x *DurationRules) WhichLessThan() case_DurationRules_LessThan {
	if x == nil {
		return DurationRules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *DurationRules_Lt:
		return DurationRules_Lt_case
	case *DurationRules_Lte:
		return DurationRules_Lte_case
	default:
		return DurationRules_LessThan_not_set_case
	}
}

const DurationRules_GreaterThan_not_set_case case_DurationRules_GreaterThan = 0
const DurationRules_Gt_case case_DurationRules_GreaterThan = 5
const DurationRules_Gte_case case_DurationRules_GreaterThan = 6

func (x *DurationRules) WhichGreaterThan() case_DurationRules_GreaterThan {
	if x == nil {
		return DurationRules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *DurationRules_Gt:
		return DurationRules_Gt_case
	case *DurationRules_Gte:
		return DurationRules_Gte_case
	default:
		return DurationRules_GreaterThan_not_set_case
	}
}

type DurationRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` dictates that the field must match the specified value of the `google.protobuf.Duration` type exactly.
	// If the field's value deviates from the specified value, an error message
	// will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must equal 5s
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.const = "5s"];
	//	}
	//
	// ```
	Const *durationpb.Duration
	// Fields of oneof LessThan:
	// `lt` stipulates that the field must be less than the specified value of the `google.protobuf.Duration` type,
	// exclusive. If the field's value is greater than or equal to the specified
	// value, an error message will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must be less than 5s
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = "5s"];
	//	}
	//
	// ```
	Lt *durationpb.Duration
	// `lte` indicates that the field must be less than or equal to the specified
	// value of the `google.protobuf.Duration` type, inclusive. If the field's value is greater than the specified value,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must be less than or equal to 10s
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.lte = "10s"];
	//	}
	//
	// ```
	Lte *durationpb.Duration
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the duration field value to be greater than the specified
	// value (exclusive). If the value of `gt` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // duration must be greater than 5s [duration.gt]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.gt = { seconds: 5 }];
	//
	//	  // duration must be greater than 5s and less than 10s [duration.gt_lt]
	//	  google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gt: { seconds: 5 }, lt: { seconds: 10 } }];
	//
	//	  // duration must be greater than 10s or less than 5s [duration.gt_lt_exclusive]
	//	  google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gt: { seconds: 10 }, lt: { seconds: 5 } }];
	//	}
	//
	// ```
	Gt *durationpb.Duration
	// `gte` requires the duration field value to be greater than or equal to the
	// specified value (exclusive). If the value of `gte` is larger than a
	// specified `lt` or `lte`, the range is reversed, and the field value must
	// be outside the specified range. If the field value doesn't meet the
	// required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	 // duration must be greater than or equal to 5s [duration.gte]
	//	 google.protobuf.Duration value = 1 [(buf.validate.field).duration.gte = { seconds: 5 }];
	//
	//	 // duration must be greater than or equal to 5s and less than 10s [duration.gte_lt]
	//	 google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gte: { seconds: 5 }, lt: { seconds: 10 } }];
	//
	//	 // duration must be greater than or equal to 10s or less than 5s [duration.gte_lt_exclusive]
	//	 google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gte: { seconds: 10 }, lt: { seconds: 5 } }];
	//	}
	//
	// ```
	Gte *durationpb.Duration
	// -- end of GreaterThan
	// `in` asserts that the field must be equal to one of the specified values of the `google.protobuf.Duration` type.
	// If the field's value doesn't correspond to any of the specified values,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must be in list [1s, 2s, 3s]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.in = ["1s", "2s", "3s"]];
	//	}
	//
	// ```
	In []*durationpb.Duration
	// `not_in` denotes that the field must not be equal to
	// any of the specified values of the `google.protobuf.Duration` type.
	// If the field's value matches any of these values, an error message will be
	// generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must not be in list [1s, 2s, 3s]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.not_in = ["1s", "2s", "3s"]];
	//	}
	//
	// ```
	NotIn []*durationpb.Duration
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  google.protobuf.Duration value = 1 [
	//	    (buf.validate.field).duration.example = { seconds: 1 },
	//	    (buf.validate.field).duration.example = { seconds: 2 },
	//	  ];
	//	}
	//
	// ```
	Example []*durationpb.Duration
}

func (b0 DurationRules_builder) Build() *DurationRules {
	m0 := &DurationRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &DurationRules_Lt{b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &DurationRules_Lte{b.Lte}
	}
	if b.Gt != nil {
		x.GreaterThan = &DurationRules_Gt{b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &DurationRules_Gte{b.Gte}
	}
	x.In = b.In
	x.NotIn = b.NotIn
	x.Example = b.Example
	return m0
}

type case_DurationRules_LessThan protoreflect.FieldNumber

func (x case_DurationRules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[25].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_DurationRules_GreaterThan protoreflect.FieldNumber

func (x case_DurationRules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[25].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isDurationRules_LessThan interface {
	isDurationRules_LessThan()
}

type DurationRules_Lt struct {
	// `lt` stipulates that the field must be less than the specified value of the `google.protobuf.Duration` type,
	// exclusive. If the field's value is greater than or equal to the specified
	// value, an error message will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must be less than 5s
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = "5s"];
	//	}
	//
	// ```
	Lt *durationpb.Duration `protobuf:"bytes,3,opt,name=lt,oneof"`
}

type DurationRules_Lte struct {
	// `lte` indicates that the field must be less than or equal to the specified
	// value of the `google.protobuf.Duration` type, inclusive. If the field's value is greater than the specified value,
	// an error message will be generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // value must be less than or equal to 10s
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.lte = "10s"];
	//	}
	//
	// ```
	Lte *durationpb.Duration `protobuf:"bytes,4,opt,name=lte,oneof"`
}

func (*DurationRules_Lt) isDurationRules_LessThan() {}

func (*DurationRules_Lte) isDurationRules_LessThan() {}

type isDurationRules_GreaterThan interface {
	isDurationRules_GreaterThan()
}

type DurationRules_Gt struct {
	// `gt` requires the duration field value to be greater than the specified
	// value (exclusive). If the value of `gt` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // duration must be greater than 5s [duration.gt]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.gt = { seconds: 5 }];
	//
	//	  // duration must be greater than 5s and less than 10s [duration.gt_lt]
	//	  google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gt: { seconds: 5 }, lt: { seconds: 10 } }];
	//
	//	  // duration must be greater than 10s or less than 5s [duration.gt_lt_exclusive]
	//	  google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gt: { seconds: 10 }, lt: { seconds: 5 } }];
	//	}
	//
	// ```
	Gt *durationpb.Duration `protobuf:"bytes,5,opt,name=gt,oneof"`
}

type DurationRules_Gte struct {
	// `gte` requires the duration field value to be greater than or equal to the
	// specified value (exclusive). If the value of `gte` is larger than a
	// specified `lt` or `lte`, the range is reversed, and the field value must
	// be outside the specified range. If the field value doesn't meet the
	// required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	 // duration must be greater than or equal to 5s [duration.gte]
	//	 google.protobuf.Duration value = 1 [(buf.validate.field).duration.gte = { seconds: 5 }];
	//
	//	 // duration must be greater than or equal to 5s and less than 10s [duration.gte_lt]
	//	 google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gte: { seconds: 5 }, lt: { seconds: 10 } }];
	//
	//	 // duration must be greater than or equal to 10s or less than 5s [duration.gte_lt_exclusive]
	//	 google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gte: { seconds: 10 }, lt: { seconds: 5 } }];
	//	}
	//
	// ```
	Gte *durationpb.Duration `protobuf:"bytes,6,opt,name=gte,oneof"`
}

func (*DurationRules_Gt) isDurationRules_GreaterThan() {}

func (*DurationRules_Gte) isDurationRules_GreaterThan() {}

// TimestampRules describe the rules applied exclusively to the `google.protobuf.Timestamp` well-known type.
type TimestampRules struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `const` dictates that this field, of the `google.protobuf.Timestamp` type, must exactly match the specified value. If the field value doesn't correspond to the specified timestamp, an error message will be generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // value must equal 2023-05-03T10:00:00Z
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.const = {seconds: 1727998800}];
	//	}
	//
	// ```
	Const *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=const" json:"const,omitempty"`
	// Types that are valid to be assigned to LessThan:
	//
	//	*TimestampRules_Lt
	//	*TimestampRules_Lte
	//	*TimestampRules_LtNow
	LessThan isTimestampRules_LessThan `protobuf_oneof:"less_than"`
	// Types that are valid to be assigned to GreaterThan:
	//
	//	*TimestampRules_Gt
	//	*TimestampRules_Gte
	//	*TimestampRules_GtNow
	GreaterThan isTimestampRules_GreaterThan `protobuf_oneof:"greater_than"`
	// `within` specifies that this field, of the `google.protobuf.Timestamp` type, must be within the specified duration of the current time. If the field value isn't within the duration, an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // value must be within 1 hour of now
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.within = {seconds: 3600}];
	//	}
	//
	// ```
	Within *durationpb.Duration `protobuf:"bytes,9,opt,name=within" json:"within,omitempty"`
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  google.protobuf.Timestamp value = 1 [
	//	    (buf.validate.field).timestamp.example = { seconds: 1672444800 },
	//	    (buf.validate.field).timestamp.example = { seconds: 1672531200 },
	//	  ];
	//	}
	//
	// ```
	Example         []*timestamppb.Timestamp `protobuf:"bytes,10,rep,name=example" json:"example,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *TimestampRules) Reset() {
	*x = TimestampRules{}
	mi := &file_buf_validate_validate_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimestampRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimestampRules) ProtoMessage() {}

func (x *TimestampRules) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TimestampRules) GetConst() *timestamppb.Timestamp {
	if x != nil {
		return x.Const
	}
	return nil
}

func (x *TimestampRules) GetLessThan() isTimestampRules_LessThan {
	if x != nil {
		return x.LessThan
	}
	return nil
}

func (x *TimestampRules) GetLt() *timestamppb.Timestamp {
	if x != nil {
		if x, ok := x.LessThan.(*TimestampRules_Lt); ok {
			return x.Lt
		}
	}
	return nil
}

func (x *TimestampRules) GetLte() *timestamppb.Timestamp {
	if x != nil {
		if x, ok := x.LessThan.(*TimestampRules_Lte); ok {
			return x.Lte
		}
	}
	return nil
}

func (x *TimestampRules) GetLtNow() bool {
	if x != nil {
		if x, ok := x.LessThan.(*TimestampRules_LtNow); ok {
			return x.LtNow
		}
	}
	return false
}

func (x *TimestampRules) GetGreaterThan() isTimestampRules_GreaterThan {
	if x != nil {
		return x.GreaterThan
	}
	return nil
}

func (x *TimestampRules) GetGt() *timestamppb.Timestamp {
	if x != nil {
		if x, ok := x.GreaterThan.(*TimestampRules_Gt); ok {
			return x.Gt
		}
	}
	return nil
}

func (x *TimestampRules) GetGte() *timestamppb.Timestamp {
	if x != nil {
		if x, ok := x.GreaterThan.(*TimestampRules_Gte); ok {
			return x.Gte
		}
	}
	return nil
}

func (x *TimestampRules) GetGtNow() bool {
	if x != nil {
		if x, ok := x.GreaterThan.(*TimestampRules_GtNow); ok {
			return x.GtNow
		}
	}
	return false
}

func (x *TimestampRules) GetWithin() *durationpb.Duration {
	if x != nil {
		return x.Within
	}
	return nil
}

func (x *TimestampRules) GetExample() []*timestamppb.Timestamp {
	if x != nil {
		return x.Example
	}
	return nil
}

func (x *TimestampRules) SetConst(v *timestamppb.Timestamp) {
	x.Const = v
}

func (x *TimestampRules) SetLt(v *timestamppb.Timestamp) {
	if v == nil {
		x.LessThan = nil
		return
	}
	x.LessThan = &TimestampRules_Lt{v}
}

func (x *TimestampRules) SetLte(v *timestamppb.Timestamp) {
	if v == nil {
		x.LessThan = nil
		return
	}
	x.LessThan = &TimestampRules_Lte{v}
}

func (x *TimestampRules) SetLtNow(v bool) {
	x.LessThan = &TimestampRules_LtNow{v}
}

func (x *TimestampRules) SetGt(v *timestamppb.Timestamp) {
	if v == nil {
		x.GreaterThan = nil
		return
	}
	x.GreaterThan = &TimestampRules_Gt{v}
}

func (x *TimestampRules) SetGte(v *timestamppb.Timestamp) {
	if v == nil {
		x.GreaterThan = nil
		return
	}
	x.GreaterThan = &TimestampRules_Gte{v}
}

func (x *TimestampRules) SetGtNow(v bool) {
	x.GreaterThan = &TimestampRules_GtNow{v}
}

func (x *TimestampRules) SetWithin(v *durationpb.Duration) {
	x.Within = v
}

func (x *TimestampRules) SetExample(v []*timestamppb.Timestamp) {
	x.Example = v
}

func (x *TimestampRules) HasConst() bool {
	if x == nil {
		return false
	}
	return x.Const != nil
}

func (x *TimestampRules) HasLessThan() bool {
	if x == nil {
		return false
	}
	return x.LessThan != nil
}

func (x *TimestampRules) HasLt() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*TimestampRules_Lt)
	return ok
}

func (x *TimestampRules) HasLte() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*TimestampRules_Lte)
	return ok
}

func (x *TimestampRules) HasLtNow() bool {
	if x == nil {
		return false
	}
	_, ok := x.LessThan.(*TimestampRules_LtNow)
	return ok
}

func (x *TimestampRules) HasGreaterThan() bool {
	if x == nil {
		return false
	}
	return x.GreaterThan != nil
}

func (x *TimestampRules) HasGt() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*TimestampRules_Gt)
	return ok
}

func (x *TimestampRules) HasGte() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*TimestampRules_Gte)
	return ok
}

func (x *TimestampRules) HasGtNow() bool {
	if x == nil {
		return false
	}
	_, ok := x.GreaterThan.(*TimestampRules_GtNow)
	return ok
}

func (x *TimestampRules) HasWithin() bool {
	if x == nil {
		return false
	}
	return x.Within != nil
}

func (x *TimestampRules) ClearConst() {
	x.Const = nil
}

func (x *TimestampRules) ClearLessThan() {
	x.LessThan = nil
}

func (x *TimestampRules) ClearLt() {
	if _, ok := x.LessThan.(*TimestampRules_Lt); ok {
		x.LessThan = nil
	}
}

func (x *TimestampRules) ClearLte() {
	if _, ok := x.LessThan.(*TimestampRules_Lte); ok {
		x.LessThan = nil
	}
}

func (x *TimestampRules) ClearLtNow() {
	if _, ok := x.LessThan.(*TimestampRules_LtNow); ok {
		x.LessThan = nil
	}
}

func (x *TimestampRules) ClearGreaterThan() {
	x.GreaterThan = nil
}

func (x *TimestampRules) ClearGt() {
	if _, ok := x.GreaterThan.(*TimestampRules_Gt); ok {
		x.GreaterThan = nil
	}
}

func (x *TimestampRules) ClearGte() {
	if _, ok := x.GreaterThan.(*TimestampRules_Gte); ok {
		x.GreaterThan = nil
	}
}

func (x *TimestampRules) ClearGtNow() {
	if _, ok := x.GreaterThan.(*TimestampRules_GtNow); ok {
		x.GreaterThan = nil
	}
}

func (x *TimestampRules) ClearWithin() {
	x.Within = nil
}

const TimestampRules_LessThan_not_set_case case_TimestampRules_LessThan = 0
const TimestampRules_Lt_case case_TimestampRules_LessThan = 3
const TimestampRules_Lte_case case_TimestampRules_LessThan = 4
const TimestampRules_LtNow_case case_TimestampRules_LessThan = 7

func (x *TimestampRules) WhichLessThan() case_TimestampRules_LessThan {
	if x == nil {
		return TimestampRules_LessThan_not_set_case
	}
	switch x.LessThan.(type) {
	case *TimestampRules_Lt:
		return TimestampRules_Lt_case
	case *TimestampRules_Lte:
		return TimestampRules_Lte_case
	case *TimestampRules_LtNow:
		return TimestampRules_LtNow_case
	default:
		return TimestampRules_LessThan_not_set_case
	}
}

const TimestampRules_GreaterThan_not_set_case case_TimestampRules_GreaterThan = 0
const TimestampRules_Gt_case case_TimestampRules_GreaterThan = 5
const TimestampRules_Gte_case case_TimestampRules_GreaterThan = 6
const TimestampRules_GtNow_case case_TimestampRules_GreaterThan = 8

func (x *TimestampRules) WhichGreaterThan() case_TimestampRules_GreaterThan {
	if x == nil {
		return TimestampRules_GreaterThan_not_set_case
	}
	switch x.GreaterThan.(type) {
	case *TimestampRules_Gt:
		return TimestampRules_Gt_case
	case *TimestampRules_Gte:
		return TimestampRules_Gte_case
	case *TimestampRules_GtNow:
		return TimestampRules_GtNow_case
	default:
		return TimestampRules_GreaterThan_not_set_case
	}
}

type TimestampRules_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `const` dictates that this field, of the `google.protobuf.Timestamp` type, must exactly match the specified value. If the field value doesn't correspond to the specified timestamp, an error message will be generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // value must equal 2023-05-03T10:00:00Z
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.const = {seconds: 1727998800}];
	//	}
	//
	// ```
	Const *timestamppb.Timestamp
	// Fields of oneof LessThan:
	// requires the duration field value to be less than the specified value (field < value). If the field value doesn't meet the required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // duration must be less than 'P3D' [duration.lt]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = { seconds: 259200 }];
	//	}
	//
	// ```
	Lt *timestamppb.Timestamp
	// requires the timestamp field value to be less than or equal to the specified value (field <= value). If the field value doesn't meet the required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // timestamp must be less than or equal to '2023-05-14T00:00:00Z' [timestamp.lte]
	//	  google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.lte = { seconds: 1678867200 }];
	//	}
	//
	// ```
	Lte *timestamppb.Timestamp
	// `lt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be less than the current time. `lt_now` can only be used with the `within` rule.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	 // value must be less than now
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.lt_now = true];
	//	}
	//
	// ```
	LtNow *bool
	// -- end of LessThan
	// Fields of oneof GreaterThan:
	// `gt` requires the timestamp field value to be greater than the specified
	// value (exclusive). If the value of `gt` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // timestamp must be greater than '2023-01-01T00:00:00Z' [timestamp.gt]
	//	  google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gt = { seconds: 1672444800 }];
	//
	//	  // timestamp must be greater than '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gt_lt]
	//	  google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gt: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
	//
	//	  // timestamp must be greater than '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gt_lt_exclusive]
	//	  google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gt: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
	//	}
	//
	// ```
	Gt *timestamppb.Timestamp
	// `gte` requires the timestamp field value to be greater than or equal to the
	// specified value (exclusive). If the value of `gte` is larger than a
	// specified `lt` or `lte`, the range is reversed, and the field value
	// must be outside the specified range. If the field value doesn't meet
	// the required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' [timestamp.gte]
	//	  google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gte = { seconds: 1672444800 }];
	//
	//	  // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gte_lt]
	//	  google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gte: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
	//
	//	  // timestamp must be greater than or equal to '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gte_lt_exclusive]
	//	  google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gte: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
	//	}
	//
	// ```
	Gte *timestamppb.Timestamp
	// `gt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be greater than the current time. `gt_now` can only be used with the `within` rule.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // value must be greater than now
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.gt_now = true];
	//	}
	//
	// ```
	GtNow *bool
	// -- end of GreaterThan
	// `within` specifies that this field, of the `google.protobuf.Timestamp` type, must be within the specified duration of the current time. If the field value isn't within the duration, an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // value must be within 1 hour of now
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.within = {seconds: 3600}];
	//	}
	//
	// ```
	Within *durationpb.Duration
	// `example` specifies values that the field may have. These values SHOULD
	// conform to other rules. `example` values will not impact validation
	// but may be used as helpful guidance on how to populate the given field.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  google.protobuf.Timestamp value = 1 [
	//	    (buf.validate.field).timestamp.example = { seconds: 1672444800 },
	//	    (buf.validate.field).timestamp.example = { seconds: 1672531200 },
	//	  ];
	//	}
	//
	// ```
	Example []*timestamppb.Timestamp
}

func (b0 TimestampRules_builder) Build() *TimestampRules {
	m0 := &TimestampRules{}
	b, x := &b0, m0
	_, _ = b, x
	x.Const = b.Const
	if b.Lt != nil {
		x.LessThan = &TimestampRules_Lt{b.Lt}
	}
	if b.Lte != nil {
		x.LessThan = &TimestampRules_Lte{b.Lte}
	}
	if b.LtNow != nil {
		x.LessThan = &TimestampRules_LtNow{*b.LtNow}
	}
	if b.Gt != nil {
		x.GreaterThan = &TimestampRules_Gt{b.Gt}
	}
	if b.Gte != nil {
		x.GreaterThan = &TimestampRules_Gte{b.Gte}
	}
	if b.GtNow != nil {
		x.GreaterThan = &TimestampRules_GtNow{*b.GtNow}
	}
	x.Within = b.Within
	x.Example = b.Example
	return m0
}

type case_TimestampRules_LessThan protoreflect.FieldNumber

func (x case_TimestampRules_LessThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[26].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_TimestampRules_GreaterThan protoreflect.FieldNumber

func (x case_TimestampRules_GreaterThan) String() string {
	md := file_buf_validate_validate_proto_msgTypes[26].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isTimestampRules_LessThan interface {
	isTimestampRules_LessThan()
}

type TimestampRules_Lt struct {
	// requires the duration field value to be less than the specified value (field < value). If the field value doesn't meet the required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyDuration {
	//	  // duration must be less than 'P3D' [duration.lt]
	//	  google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = { seconds: 259200 }];
	//	}
	//
	// ```
	Lt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=lt,oneof"`
}

type TimestampRules_Lte struct {
	// requires the timestamp field value to be less than or equal to the specified value (field <= value). If the field value doesn't meet the required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // timestamp must be less than or equal to '2023-05-14T00:00:00Z' [timestamp.lte]
	//	  google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.lte = { seconds: 1678867200 }];
	//	}
	//
	// ```
	Lte *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=lte,oneof"`
}

type TimestampRules_LtNow struct {
	// `lt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be less than the current time. `lt_now` can only be used with the `within` rule.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	 // value must be less than now
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.lt_now = true];
	//	}
	//
	// ```
	LtNow bool `protobuf:"varint,7,opt,name=lt_now,json=ltNow,oneof"`
}

func (*TimestampRules_Lt) isTimestampRules_LessThan() {}

func (*TimestampRules_Lte) isTimestampRules_LessThan() {}

func (*TimestampRules_LtNow) isTimestampRules_LessThan() {}

type isTimestampRules_GreaterThan interface {
	isTimestampRules_GreaterThan()
}

type TimestampRules_Gt struct {
	// `gt` requires the timestamp field value to be greater than the specified
	// value (exclusive). If the value of `gt` is larger than a specified `lt`
	// or `lte`, the range is reversed, and the field value must be outside the
	// specified range. If the field value doesn't meet the required conditions,
	// an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // timestamp must be greater than '2023-01-01T00:00:00Z' [timestamp.gt]
	//	  google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gt = { seconds: 1672444800 }];
	//
	//	  // timestamp must be greater than '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gt_lt]
	//	  google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gt: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
	//
	//	  // timestamp must be greater than '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gt_lt_exclusive]
	//	  google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gt: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
	//	}
	//
	// ```
	Gt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=gt,oneof"`
}

type TimestampRules_Gte struct {
	// `gte` requires the timestamp field value to be greater than or equal to the
	// specified value (exclusive). If the value of `gte` is larger than a
	// specified `lt` or `lte`, the range is reversed, and the field value
	// must be outside the specified range. If the field value doesn't meet
	// the required conditions, an error message is generated.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' [timestamp.gte]
	//	  google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gte = { seconds: 1672444800 }];
	//
	//	  // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gte_lt]
	//	  google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gte: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];
	//
	//	  // timestamp must be greater than or equal to '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gte_lt_exclusive]
	//	  google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gte: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
	//	}
	//
	// ```
	Gte *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=gte,oneof"`
}

type TimestampRules_GtNow struct {
	// `gt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be greater than the current time. `gt_now` can only be used with the `within` rule.
	//
	// ```proto
	//
	//	message MyTimestamp {
	//	  // value must be greater than now
	//	  google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.gt_now = true];
	//	}
	//
	// ```
	GtNow bool `protobuf:"varint,8,opt,name=gt_now,json=gtNow,oneof"`
}

func (*TimestampRules_Gt) isTimestampRules_GreaterThan() {}

func (*TimestampRules_Gte) isTimestampRules_GreaterThan() {}

func (*TimestampRules_GtNow) isTimestampRules_GreaterThan() {}

// `Violations` is a collection of `Violation` messages. This message type is returned by
// Protovalidate when a proto message fails to meet the requirements set by the `Rule` validation rules.
// Each individual violation is represented by a `Violation` message.
type Violations struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `violations` is a repeated field that contains all the `Violation` messages corresponding to the violations detected.
	Violations    []*Violation `protobuf:"bytes,1,rep,name=violations" json:"violations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Violations) Reset() {
	*x = Violations{}
	mi := &file_buf_validate_validate_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Violations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violations) ProtoMessage() {}

func (x *Violations) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Violations) GetViolations() []*Violation {
	if x != nil {
		return x.Violations
	}
	return nil
}

func (x *Violations) SetViolations(v []*Violation) {
	x.Violations = v
}

type Violations_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `violations` is a repeated field that contains all the `Violation` messages corresponding to the violations detected.
	Violations []*Violation
}

func (b0 Violations_builder) Build() *Violations {
	m0 := &Violations{}
	b, x := &b0, m0
	_, _ = b, x
	x.Violations = b.Violations
	return m0
}

// `Violation` represents a single instance where a validation rule, expressed
// as a `Rule`, was not met. It provides information about the field that
// caused the violation, the specific rule that wasn't fulfilled, and a
// human-readable error message.
//
// For example, consider the following message:
//
// ```proto
//
//	message User {
//	    int32 age = 1 [(buf.validate.field).cel = {
//	        id: "user.age",
//	        expression: "this < 18 ? 'User must be at least 18 years old' : ''",
//	    }];
//	}
//
// ```
//
// It could produce the following violation:
//
// ```json
//
//	{
//	  "ruleId": "user.age",
//	  "message": "User must be at least 18 years old",
//	  "field": {
//	    "elements": [
//	      {
//	        "fieldNumber": 1,
//	        "fieldName": "age",
//	        "fieldType": "TYPE_INT32"
//	      }
//	    ]
//	  },
//	  "rule": {
//	    "elements": [
//	      {
//	        "fieldNumber": 23,
//	        "fieldName": "cel",
//	        "fieldType": "TYPE_MESSAGE",
//	        "index": "0"
//	      }
//	    ]
//	  }
//	}
//
// ```
type Violation struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `field` is a machine-readable path to the field that failed validation.
	// This could be a nested field, in which case the path will include all the parent fields leading to the actual field that caused the violation.
	//
	// For example, consider the following message:
	//
	// ```proto
	//
	//	message Message {
	//	  bool a = 1 [(buf.validate.field).required = true];
	//	}
	//
	// ```
	//
	// It could produce the following violation:
	//
	// ```textproto
	//
	//	violation {
	//	  field { element { field_number: 1, field_name: "a", field_type: 8 } }
	//	  ...
	//	}
	//
	// ```
	Field *FieldPath `protobuf:"bytes,5,opt,name=field" json:"field,omitempty"`
	// `rule` is a machine-readable path that points to the specific rule that failed validation.
	// This will be a nested field starting from the FieldRules of the field that failed validation.
	// For custom rules, this will provide the path of the rule, e.g. `cel[0]`.
	//
	// For example, consider the following message:
	//
	// ```proto
	//
	//	message Message {
	//	  bool a = 1 [(buf.validate.field).required = true];
	//	  bool b = 2 [(buf.validate.field).cel = {
	//	    id: "custom_rule",
	//	    expression: "!this ? 'b must be true': ''"
	//	  }]
	//	}
	//
	// ```
	//
	// It could produce the following violations:
	//
	// ```textproto
	//
	//	violation {
	//	  rule { element { field_number: 25, field_name: "required", field_type: 8 } }
	//	  ...
	//	}
	//
	//	violation {
	//	  rule { element { field_number: 23, field_name: "cel", field_type: 11, index: 0 } }
	//	  ...
	//	}
	//
	// ```
	Rule *FieldPath `protobuf:"bytes,6,opt,name=rule" json:"rule,omitempty"`
	// `rule_id` is the unique identifier of the `Rule` that was not fulfilled.
	// This is the same `id` that was specified in the `Rule` message, allowing easy tracing of which rule was violated.
	RuleId *string `protobuf:"bytes,2,opt,name=rule_id,json=ruleId" json:"rule_id,omitempty"`
	// `message` is a human-readable error message that describes the nature of the violation.
	// This can be the default error message from the violated `Rule`, or it can be a custom message that gives more context about the violation.
	Message *string `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
	// `for_key` indicates whether the violation was caused by a map key, rather than a value.
	ForKey        *bool `protobuf:"varint,4,opt,name=for_key,json=forKey" json:"for_key,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Violation) Reset() {
	*x = Violation{}
	mi := &file_buf_validate_validate_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Violation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Violation) ProtoMessage() {}

func (x *Violation) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Violation) GetField() *FieldPath {
	if x != nil {
		return x.Field
	}
	return nil
}

func (x *Violation) GetRule() *FieldPath {
	if x != nil {
		return x.Rule
	}
	return nil
}

func (x *Violation) GetRuleId() string {
	if x != nil && x.RuleId != nil {
		return *x.RuleId
	}
	return ""
}

func (x *Violation) GetMessage() string {
	if x != nil && x.Message != nil {
		return *x.Message
	}
	return ""
}

func (x *Violation) GetForKey() bool {
	if x != nil && x.ForKey != nil {
		return *x.ForKey
	}
	return false
}

func (x *Violation) SetField(v *FieldPath) {
	x.Field = v
}

func (x *Violation) SetRule(v *FieldPath) {
	x.Rule = v
}

func (x *Violation) SetRuleId(v string) {
	x.RuleId = &v
}

func (x *Violation) SetMessage(v string) {
	x.Message = &v
}

func (x *Violation) SetForKey(v bool) {
	x.ForKey = &v
}

func (x *Violation) HasField() bool {
	if x == nil {
		return false
	}
	return x.Field != nil
}

func (x *Violation) HasRule() bool {
	if x == nil {
		return false
	}
	return x.Rule != nil
}

func (x *Violation) HasRuleId() bool {
	if x == nil {
		return false
	}
	return x.RuleId != nil
}

func (x *Violation) HasMessage() bool {
	if x == nil {
		return false
	}
	return x.Message != nil
}

func (x *Violation) HasForKey() bool {
	if x == nil {
		return false
	}
	return x.ForKey != nil
}

func (x *Violation) ClearField() {
	x.Field = nil
}

func (x *Violation) ClearRule() {
	x.Rule = nil
}

func (x *Violation) ClearRuleId() {
	x.RuleId = nil
}

func (x *Violation) ClearMessage() {
	x.Message = nil
}

func (x *Violation) ClearForKey() {
	x.ForKey = nil
}

type Violation_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `field` is a machine-readable path to the field that failed validation.
	// This could be a nested field, in which case the path will include all the parent fields leading to the actual field that caused the violation.
	//
	// For example, consider the following message:
	//
	// ```proto
	//
	//	message Message {
	//	  bool a = 1 [(buf.validate.field).required = true];
	//	}
	//
	// ```
	//
	// It could produce the following violation:
	//
	// ```textproto
	//
	//	violation {
	//	  field { element { field_number: 1, field_name: "a", field_type: 8 } }
	//	  ...
	//	}
	//
	// ```
	Field *FieldPath
	// `rule` is a machine-readable path that points to the specific rule that failed validation.
	// This will be a nested field starting from the FieldRules of the field that failed validation.
	// For custom rules, this will provide the path of the rule, e.g. `cel[0]`.
	//
	// For example, consider the following message:
	//
	// ```proto
	//
	//	message Message {
	//	  bool a = 1 [(buf.validate.field).required = true];
	//	  bool b = 2 [(buf.validate.field).cel = {
	//	    id: "custom_rule",
	//	    expression: "!this ? 'b must be true': ''"
	//	  }]
	//	}
	//
	// ```
	//
	// It could produce the following violations:
	//
	// ```textproto
	//
	//	violation {
	//	  rule { element { field_number: 25, field_name: "required", field_type: 8 } }
	//	  ...
	//	}
	//
	//	violation {
	//	  rule { element { field_number: 23, field_name: "cel", field_type: 11, index: 0 } }
	//	  ...
	//	}
	//
	// ```
	Rule *FieldPath
	// `rule_id` is the unique identifier of the `Rule` that was not fulfilled.
	// This is the same `id` that was specified in the `Rule` message, allowing easy tracing of which rule was violated.
	RuleId *string
	// `message` is a human-readable error message that describes the nature of the violation.
	// This can be the default error message from the violated `Rule`, or it can be a custom message that gives more context about the violation.
	Message *string
	// `for_key` indicates whether the violation was caused by a map key, rather than a value.
	ForKey *bool
}

func (b0 Violation_builder) Build() *Violation {
	m0 := &Violation{}
	b, x := &b0, m0
	_, _ = b, x
	x.Field = b.Field
	x.Rule = b.Rule
	x.RuleId = b.RuleId
	x.Message = b.Message
	x.ForKey = b.ForKey
	return m0
}

// `FieldPath` provides a path to a nested protobuf field.
//
// This message provides enough information to render a dotted field path even without protobuf descriptors.
// It also provides enough information to resolve a nested field through unknown wire data.
type FieldPath struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `elements` contains each element of the path, starting from the root and recursing downward.
	Elements      []*FieldPathElement `protobuf:"bytes,1,rep,name=elements" json:"elements,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FieldPath) Reset() {
	*x = FieldPath{}
	mi := &file_buf_validate_validate_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldPath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldPath) ProtoMessage() {}

func (x *FieldPath) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FieldPath) GetElements() []*FieldPathElement {
	if x != nil {
		return x.Elements
	}
	return nil
}

func (x *FieldPath) SetElements(v []*FieldPathElement) {
	x.Elements = v
}

type FieldPath_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `elements` contains each element of the path, starting from the root and recursing downward.
	Elements []*FieldPathElement
}

func (b0 FieldPath_builder) Build() *FieldPath {
	m0 := &FieldPath{}
	b, x := &b0, m0
	_, _ = b, x
	x.Elements = b.Elements
	return m0
}

// `FieldPathElement` provides enough information to nest through a single protobuf field.
//
// If the selected field is a map or repeated field, the `subscript` value selects a specific element from it.
// A path that refers to a value nested under a map key or repeated field index will have a `subscript` value.
// The `field_type` field allows unambiguous resolution of a field even if descriptors are not available.
type FieldPathElement struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// `field_number` is the field number this path element refers to.
	FieldNumber *int32 `protobuf:"varint,1,opt,name=field_number,json=fieldNumber" json:"field_number,omitempty"`
	// `field_name` contains the field name this path element refers to.
	// This can be used to display a human-readable path even if the field number is unknown.
	FieldName *string `protobuf:"bytes,2,opt,name=field_name,json=fieldName" json:"field_name,omitempty"`
	// `field_type` specifies the type of this field. When using reflection, this value is not needed.
	//
	// This value is provided to make it possible to traverse unknown fields through wire data.
	// When traversing wire data, be mindful of both packed[1] and delimited[2] encoding schemes.
	//
	// N.B.: Although groups are deprecated, the corresponding delimited encoding scheme is not, and
	// can be explicitly used in Protocol Buffers 2023 Edition.
	//
	// [1]: https://protobuf.dev/programming-guides/encoding/#packed
	// [2]: https://protobuf.dev/programming-guides/encoding/#groups
	FieldType *descriptorpb.FieldDescriptorProto_Type `protobuf:"varint,3,opt,name=field_type,json=fieldType,enum=google.protobuf.FieldDescriptorProto_Type" json:"field_type,omitempty"`
	// `key_type` specifies the map key type of this field. This value is useful when traversing
	// unknown fields through wire data: specifically, it allows handling the differences between
	// different integer encodings.
	KeyType *descriptorpb.FieldDescriptorProto_Type `protobuf:"varint,4,opt,name=key_type,json=keyType,enum=google.protobuf.FieldDescriptorProto_Type" json:"key_type,omitempty"`
	// `value_type` specifies map value type of this field. This is useful if you want to display a
	// value inside unknown fields through wire data.
	ValueType *descriptorpb.FieldDescriptorProto_Type `protobuf:"varint,5,opt,name=value_type,json=valueType,enum=google.protobuf.FieldDescriptorProto_Type" json:"value_type,omitempty"`
	// `subscript` contains a repeated index or map key, if this path element nests into a repeated or map field.
	//
	// Types that are valid to be assigned to Subscript:
	//
	//	*FieldPathElement_Index
	//	*FieldPathElement_BoolKey
	//	*FieldPathElement_IntKey
	//	*FieldPathElement_UintKey
	//	*FieldPathElement_StringKey
	Subscript     isFieldPathElement_Subscript `protobuf_oneof:"subscript"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FieldPathElement) Reset() {
	*x = FieldPathElement{}
	mi := &file_buf_validate_validate_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldPathElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldPathElement) ProtoMessage() {}

func (x *FieldPathElement) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_validate_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *FieldPathElement) GetFieldNumber() int32 {
	if x != nil && x.FieldNumber != nil {
		return *x.FieldNumber
	}
	return 0
}

func (x *FieldPathElement) GetFieldName() string {
	if x != nil && x.FieldName != nil {
		return *x.FieldName
	}
	return ""
}

func (x *FieldPathElement) GetFieldType() descriptorpb.FieldDescriptorProto_Type {
	if x != nil && x.FieldType != nil {
		return *x.FieldType
	}
	return descriptorpb.FieldDescriptorProto_Type(1)
}

func (x *FieldPathElement) GetKeyType() descriptorpb.FieldDescriptorProto_Type {
	if x != nil && x.KeyType != nil {
		return *x.KeyType
	}
	return descriptorpb.FieldDescriptorProto_Type(1)
}

func (x *FieldPathElement) GetValueType() descriptorpb.FieldDescriptorProto_Type {
	if x != nil && x.ValueType != nil {
		return *x.ValueType
	}
	return descriptorpb.FieldDescriptorProto_Type(1)
}

func (x *FieldPathElement) GetSubscript() isFieldPathElement_Subscript {
	if x != nil {
		return x.Subscript
	}
	return nil
}

func (x *FieldPathElement) GetIndex() uint64 {
	if x != nil {
		if x, ok := x.Subscript.(*FieldPathElement_Index); ok {
			return x.Index
		}
	}
	return 0
}

func (x *FieldPathElement) GetBoolKey() bool {
	if x != nil {
		if x, ok := x.Subscript.(*FieldPathElement_BoolKey); ok {
			return x.BoolKey
		}
	}
	return false
}

func (x *FieldPathElement) GetIntKey() int64 {
	if x != nil {
		if x, ok := x.Subscript.(*FieldPathElement_IntKey); ok {
			return x.IntKey
		}
	}
	return 0
}

func (x *FieldPathElement) GetUintKey() uint64 {
	if x != nil {
		if x, ok := x.Subscript.(*FieldPathElement_UintKey); ok {
			return x.UintKey
		}
	}
	return 0
}

func (x *FieldPathElement) GetStringKey() string {
	if x != nil {
		if x, ok := x.Subscript.(*FieldPathElement_StringKey); ok {
			return x.StringKey
		}
	}
	return ""
}

func (x *FieldPathElement) SetFieldNumber(v int32) {
	x.FieldNumber = &v
}

func (x *FieldPathElement) SetFieldName(v string) {
	x.FieldName = &v
}

func (x *FieldPathElement) SetFieldType(v descriptorpb.FieldDescriptorProto_Type) {
	x.FieldType = &v
}

func (x *FieldPathElement) SetKeyType(v descriptorpb.FieldDescriptorProto_Type) {
	x.KeyType = &v
}

func (x *FieldPathElement) SetValueType(v descriptorpb.FieldDescriptorProto_Type) {
	x.ValueType = &v
}

func (x *FieldPathElement) SetIndex(v uint64) {
	x.Subscript = &FieldPathElement_Index{v}
}

func (x *FieldPathElement) SetBoolKey(v bool) {
	x.Subscript = &FieldPathElement_BoolKey{v}
}

func (x *FieldPathElement) SetIntKey(v int64) {
	x.Subscript = &FieldPathElement_IntKey{v}
}

func (x *FieldPathElement) SetUintKey(v uint64) {
	x.Subscript = &FieldPathElement_UintKey{v}
}

func (x *FieldPathElement) SetStringKey(v string) {
	x.Subscript = &FieldPathElement_StringKey{v}
}

func (x *FieldPathElement) HasFieldNumber() bool {
	if x == nil {
		return false
	}
	return x.FieldNumber != nil
}

func (x *FieldPathElement) HasFieldName() bool {
	if x == nil {
		return false
	}
	return x.FieldName != nil
}

func (x *FieldPathElement) HasFieldType() bool {
	if x == nil {
		return false
	}
	return x.FieldType != nil
}

func (x *FieldPathElement) HasKeyType() bool {
	if x == nil {
		return false
	}
	return x.KeyType != nil
}

func (x *FieldPathElement) HasValueType() bool {
	if x == nil {
		return false
	}
	return x.ValueType != nil
}

func (x *FieldPathElement) HasSubscript() bool {
	if x == nil {
		return false
	}
	return x.Subscript != nil
}

func (x *FieldPathElement) HasIndex() bool {
	if x == nil {
		return false
	}
	_, ok := x.Subscript.(*FieldPathElement_Index)
	return ok
}

func (x *FieldPathElement) HasBoolKey() bool {
	if x == nil {
		return false
	}
	_, ok := x.Subscript.(*FieldPathElement_BoolKey)
	return ok
}

func (x *FieldPathElement) HasIntKey() bool {
	if x == nil {
		return false
	}
	_, ok := x.Subscript.(*FieldPathElement_IntKey)
	return ok
}

func (x *FieldPathElement) HasUintKey() bool {
	if x == nil {
		return false
	}
	_, ok := x.Subscript.(*FieldPathElement_UintKey)
	return ok
}

func (x *FieldPathElement) HasStringKey() bool {
	if x == nil {
		return false
	}
	_, ok := x.Subscript.(*FieldPathElement_StringKey)
	return ok
}

func (x *FieldPathElement) ClearFieldNumber() {
	x.FieldNumber = nil
}

func (x *FieldPathElement) ClearFieldName() {
	x.FieldName = nil
}

func (x *FieldPathElement) ClearFieldType() {
	x.FieldType = nil
}

func (x *FieldPathElement) ClearKeyType() {
	x.KeyType = nil
}

func (x *FieldPathElement) ClearValueType() {
	x.ValueType = nil
}

func (x *FieldPathElement) ClearSubscript() {
	x.Subscript = nil
}

func (x *FieldPathElement) ClearIndex() {
	if _, ok := x.Subscript.(*FieldPathElement_Index); ok {
		x.Subscript = nil
	}
}

func (x *FieldPathElement) ClearBoolKey() {
	if _, ok := x.Subscript.(*FieldPathElement_BoolKey); ok {
		x.Subscript = nil
	}
}

func (x *FieldPathElement) ClearIntKey() {
	if _, ok := x.Subscript.(*FieldPathElement_IntKey); ok {
		x.Subscript = nil
	}
}

func (x *FieldPathElement) ClearUintKey() {
	if _, ok := x.Subscript.(*FieldPathElement_UintKey); ok {
		x.Subscript = nil
	}
}

func (x *FieldPathElement) ClearStringKey() {
	if _, ok := x.Subscript.(*FieldPathElement_StringKey); ok {
		x.Subscript = nil
	}
}

const FieldPathElement_Subscript_not_set_case case_FieldPathElement_Subscript = 0
const FieldPathElement_Index_case case_FieldPathElement_Subscript = 6
const FieldPathElement_BoolKey_case case_FieldPathElement_Subscript = 7
const FieldPathElement_IntKey_case case_FieldPathElement_Subscript = 8
const FieldPathElement_UintKey_case case_FieldPathElement_Subscript = 9
const FieldPathElement_StringKey_case case_FieldPathElement_Subscript = 10

func (x *FieldPathElement) WhichSubscript() case_FieldPathElement_Subscript {
	if x == nil {
		return FieldPathElement_Subscript_not_set_case
	}
	switch x.Subscript.(type) {
	case *FieldPathElement_Index:
		return FieldPathElement_Index_case
	case *FieldPathElement_BoolKey:
		return FieldPathElement_BoolKey_case
	case *FieldPathElement_IntKey:
		return FieldPathElement_IntKey_case
	case *FieldPathElement_UintKey:
		return FieldPathElement_UintKey_case
	case *FieldPathElement_StringKey:
		return FieldPathElement_StringKey_case
	default:
		return FieldPathElement_Subscript_not_set_case
	}
}

type FieldPathElement_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// `field_number` is the field number this path element refers to.
	FieldNumber *int32
	// `field_name` contains the field name this path element refers to.
	// This can be used to display a human-readable path even if the field number is unknown.
	FieldName *string
	// `field_type` specifies the type of this field. When using reflection, this value is not needed.
	//
	// This value is provided to make it possible to traverse unknown fields through wire data.
	// When traversing wire data, be mindful of both packed[1] and delimited[2] encoding schemes.
	//
	// N.B.: Although groups are deprecated, the corresponding delimited encoding scheme is not, and
	// can be explicitly used in Protocol Buffers 2023 Edition.
	//
	// [1]: https://protobuf.dev/programming-guides/encoding/#packed
	// [2]: https://protobuf.dev/programming-guides/encoding/#groups
	FieldType *descriptorpb.FieldDescriptorProto_Type
	// `key_type` specifies the map key type of this field. This value is useful when traversing
	// unknown fields through wire data: specifically, it allows handling the differences between
	// different integer encodings.
	KeyType *descriptorpb.FieldDescriptorProto_Type
	// `value_type` specifies map value type of this field. This is useful if you want to display a
	// value inside unknown fields through wire data.
	ValueType *descriptorpb.FieldDescriptorProto_Type
	// `subscript` contains a repeated index or map key, if this path element nests into a repeated or map field.

	// Fields of oneof Subscript:
	// `index` specifies a 0-based index into a repeated field.
	Index *uint64
	// `bool_key` specifies a map key of type bool.
	BoolKey *bool
	// `int_key` specifies a map key of type int32, int64, sint32, sint64, sfixed32 or sfixed64.
	IntKey *int64
	// `uint_key` specifies a map key of type uint32, uint64, fixed32 or fixed64.
	UintKey *uint64
	// `string_key` specifies a map key of type string.
	StringKey *string
	// -- end of Subscript
}

func (b0 FieldPathElement_builder) Build() *FieldPathElement {
	m0 := &FieldPathElement{}
	b, x := &b0, m0
	_, _ = b, x
	x.FieldNumber = b.FieldNumber
	x.FieldName = b.FieldName
	x.FieldType = b.FieldType
	x.KeyType = b.KeyType
	x.ValueType = b.ValueType
	if b.Index != nil {
		x.Subscript = &FieldPathElement_Index{*b.Index}
	}
	if b.BoolKey != nil {
		x.Subscript = &FieldPathElement_BoolKey{*b.BoolKey}
	}
	if b.IntKey != nil {
		x.Subscript = &FieldPathElement_IntKey{*b.IntKey}
	}
	if b.UintKey != nil {
		x.Subscript = &FieldPathElement_UintKey{*b.UintKey}
	}
	if b.StringKey != nil {
		x.Subscript = &FieldPathElement_StringKey{*b.StringKey}
	}
	return m0
}

type case_FieldPathElement_Subscript protoreflect.FieldNumber

func (x case_FieldPathElement_Subscript) String() string {
	md := file_buf_validate_validate_proto_msgTypes[30].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isFieldPathElement_Subscript interface {
	isFieldPathElement_Subscript()
}

type FieldPathElement_Index struct {
	// `index` specifies a 0-based index into a repeated field.
	Index uint64 `protobuf:"varint,6,opt,name=index,oneof"`
}

type FieldPathElement_BoolKey struct {
	// `bool_key` specifies a map key of type bool.
	BoolKey bool `protobuf:"varint,7,opt,name=bool_key,json=boolKey,oneof"`
}

type FieldPathElement_IntKey struct {
	// `int_key` specifies a map key of type int32, int64, sint32, sint64, sfixed32 or sfixed64.
	IntKey int64 `protobuf:"varint,8,opt,name=int_key,json=intKey,oneof"`
}

type FieldPathElement_UintKey struct {
	// `uint_key` specifies a map key of type uint32, uint64, fixed32 or fixed64.
	UintKey uint64 `protobuf:"varint,9,opt,name=uint_key,json=uintKey,oneof"`
}

type FieldPathElement_StringKey struct {
	// `string_key` specifies a map key of type string.
	StringKey string `protobuf:"bytes,10,opt,name=string_key,json=stringKey,oneof"`
}

func (*FieldPathElement_Index) isFieldPathElement_Subscript() {}

func (*FieldPathElement_BoolKey) isFieldPathElement_Subscript() {}

func (*FieldPathElement_IntKey) isFieldPathElement_Subscript() {}

func (*FieldPathElement_UintKey) isFieldPathElement_Subscript() {}

func (*FieldPathElement_StringKey) isFieldPathElement_Subscript() {}

var file_buf_validate_validate_proto_extTypes = []protoimpl.ExtensionInfo{
	{
		ExtendedType:  (*descriptorpb.MessageOptions)(nil),
		ExtensionType: (*MessageRules)(nil),
		Field:         1159,
		Name:          "buf.validate.message",
		Tag:           "bytes,1159,opt,name=message",
		Filename:      "buf/validate/validate.proto",
	},
	{
		ExtendedType:  (*descriptorpb.OneofOptions)(nil),
		ExtensionType: (*OneofRules)(nil),
		Field:         1159,
		Name:          "buf.validate.oneof",
		Tag:           "bytes,1159,opt,name=oneof",
		Filename:      "buf/validate/validate.proto",
	},
	{
		ExtendedType:  (*descriptorpb.FieldOptions)(nil),
		ExtensionType: (*FieldRules)(nil),
		Field:         1159,
		Name:          "buf.validate.field",
		Tag:           "bytes,1159,opt,name=field",
		Filename:      "buf/validate/validate.proto",
	},
	{
		ExtendedType:  (*descriptorpb.FieldOptions)(nil),
		ExtensionType: (*PredefinedRules)(nil),
		Field:         1160,
		Name:          "buf.validate.predefined",
		Tag:           "bytes,1160,opt,name=predefined",
		Filename:      "buf/validate/validate.proto",
	},
}

// Extension fields to descriptorpb.MessageOptions.
var (
	// Rules specify the validations to be performed on this message. By default,
	// no validation is performed against a message.
	//
	// optional buf.validate.MessageRules message = 1159;
	E_Message = &file_buf_validate_validate_proto_extTypes[0]
)

// Extension fields to descriptorpb.OneofOptions.
var (
	// Rules specify the validations to be performed on this oneof. By default,
	// no validation is performed against a oneof.
	//
	// optional buf.validate.OneofRules oneof = 1159;
	E_Oneof = &file_buf_validate_validate_proto_extTypes[1]
)

// Extension fields to descriptorpb.FieldOptions.
var (
	// Rules specify the validations to be performed on this field. By default,
	// no validation is performed against a field.
	//
	// optional buf.validate.FieldRules field = 1159;
	E_Field = &file_buf_validate_validate_proto_extTypes[2]
	// Specifies predefined rules. When extending a standard rule message,
	// this adds additional CEL expressions that apply when the extension is used.
	//
	// ```proto
	//
	//	extend buf.validate.Int32Rules {
	//	  bool is_zero [(buf.validate.predefined).cel = {
	//	    id: "int32.is_zero",
	//	    message: "value must be zero",
	//	    expression: "!rule || this == 0",
	//	  }];
	//	}
	//
	//	message Foo {
	//	  int32 reserved = 1 [(buf.validate.field).int32.(is_zero) = true];
	//	}
	//
	// ```
	//
	// optional buf.validate.PredefinedRules predefined = 1160;
	E_Predefined = &file_buf_validate_validate_proto_extTypes[3]
)

var File_buf_validate_validate_proto protoreflect.FileDescriptor

const file_buf_validate_validate_proto_rawDesc = "" +
	"\n" +
	"\x1bbuf/validate/validate.proto\x12\fbuf.validate\x1a google/protobuf/descriptor.proto\x1a\x1egoogle/protobuf/duration.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"P\n" +
	"\x04Rule\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x18\n" +
	"\amessage\x18\x02 \x01(\tR\amessage\x12\x1e\n" +
	"\n" +
	"expression\x18\x03 \x01(\tR\n" +
	"expression\"z\n" +
	"\fMessageRules\x12$\n" +
	"\x03cel\x18\x03 \x03(\v2\x12.buf.validate.RuleR\x03cel\x124\n" +
	"\x05oneof\x18\x04 \x03(\v2\x1e.buf.validate.MessageOneofRuleR\x05oneofJ\x04\b\x01\x10\x02R\bdisabled\"F\n" +
	"\x10MessageOneofRule\x12\x16\n" +
	"\x06fields\x18\x01 \x03(\tR\x06fields\x12\x1a\n" +
	"\brequired\x18\x02 \x01(\bR\brequired\"(\n" +
	"\n" +
	"OneofRules\x12\x1a\n" +
	"\brequired\x18\x01 \x01(\bR\brequired\"\xfd\t\n" +
	"\n" +
	"FieldRules\x12$\n" +
	"\x03cel\x18\x17 \x03(\v2\x12.buf.validate.RuleR\x03cel\x12\x1a\n" +
	"\brequired\x18\x19 \x01(\bR\brequired\x12,\n" +
	"\x06ignore\x18\x1b \x01(\x0e2\x14.buf.validate.IgnoreR\x06ignore\x120\n" +
	"\x05float\x18\x01 \x01(\v2\x18.buf.validate.FloatRulesH\x00R\x05float\x123\n" +
	"\x06double\x18\x02 \x01(\v2\x19.buf.validate.DoubleRulesH\x00R\x06double\x120\n" +
	"\x05int32\x18\x03 \x01(\v2\x18.buf.validate.Int32RulesH\x00R\x05int32\x120\n" +
	"\x05int64\x18\x04 \x01(\v2\x18.buf.validate.Int64RulesH\x00R\x05int64\x123\n" +
	"\x06uint32\x18\x05 \x01(\v2\x19.buf.validate.UInt32RulesH\x00R\x06uint32\x123\n" +
	"\x06uint64\x18\x06 \x01(\v2\x19.buf.validate.UInt64RulesH\x00R\x06uint64\x123\n" +
	"\x06sint32\x18\a \x01(\v2\x19.buf.validate.SInt32RulesH\x00R\x06sint32\x123\n" +
	"\x06sint64\x18\b \x01(\v2\x19.buf.validate.SInt64RulesH\x00R\x06sint64\x126\n" +
	"\afixed32\x18\t \x01(\v2\x1a.buf.validate.Fixed32RulesH\x00R\afixed32\x126\n" +
	"\afixed64\x18\n" +
	" \x01(\v2\x1a.buf.validate.Fixed64RulesH\x00R\afixed64\x129\n" +
	"\bsfixed32\x18\v \x01(\v2\x1b.buf.validate.SFixed32RulesH\x00R\bsfixed32\x129\n" +
	"\bsfixed64\x18\f \x01(\v2\x1b.buf.validate.SFixed64RulesH\x00R\bsfixed64\x12-\n" +
	"\x04bool\x18\r \x01(\v2\x17.buf.validate.BoolRulesH\x00R\x04bool\x123\n" +
	"\x06string\x18\x0e \x01(\v2\x19.buf.validate.StringRulesH\x00R\x06string\x120\n" +
	"\x05bytes\x18\x0f \x01(\v2\x18.buf.validate.BytesRulesH\x00R\x05bytes\x12-\n" +
	"\x04enum\x18\x10 \x01(\v2\x17.buf.validate.EnumRulesH\x00R\x04enum\x129\n" +
	"\brepeated\x18\x12 \x01(\v2\x1b.buf.validate.RepeatedRulesH\x00R\brepeated\x12*\n" +
	"\x03map\x18\x13 \x01(\v2\x16.buf.validate.MapRulesH\x00R\x03map\x12*\n" +
	"\x03any\x18\x14 \x01(\v2\x16.buf.validate.AnyRulesH\x00R\x03any\x129\n" +
	"\bduration\x18\x15 \x01(\v2\x1b.buf.validate.DurationRulesH\x00R\bduration\x12<\n" +
	"\ttimestamp\x18\x16 \x01(\v2\x1c.buf.validate.TimestampRulesH\x00R\ttimestampB\x06\n" +
	"\x04typeJ\x04\b\x18\x10\x19J\x04\b\x1a\x10\x1bR\askippedR\fignore_empty\"Z\n" +
	"\x0fPredefinedRules\x12$\n" +
	"\x03cel\x18\x01 \x03(\v2\x12.buf.validate.RuleR\x03celJ\x04\b\x18\x10\x19J\x04\b\x1a\x10\x1bR\askippedR\fignore_empty\"\x90\x18\n" +
	"\n" +
	"FloatRules\x12\x8a\x01\n" +
	"\x05const\x18\x01 \x01(\x02Bt\xc2Hq\n" +
	"o\n" +
	"\vfloat.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\xa3\x01\n" +
	"\x02lt\x18\x02 \x01(\x02B\x90\x01\xc2H\x8c\x01\n" +
	"\x89\x01\n" +
	"\bfloat.lt\x1a}!has(rules.gte) && !has(rules.gt) && (this.isNan() || this >= rules.lt)? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xb4\x01\n" +
	"\x03lte\x18\x03 \x01(\x02B\x9f\x01\xc2H\x9b\x01\n" +
	"\x98\x01\n" +
	"\tfloat.lte\x1a\x8a\x01!has(rules.gte) && !has(rules.gt) && (this.isNan() || this > rules.lte)? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xf3\a\n" +
	"\x02gt\x18\x04 \x01(\x02B\xe0\a\xc2H\xdc\a\n" +
	"\x8d\x01\n" +
	"\bfloat.gt\x1a\x80\x01!has(rules.lt) && !has(rules.lte) && (this.isNan() || this <= rules.gt)? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xc3\x01\n" +
	"\vfloat.gt_lt\x1a\xb3\x01has(rules.lt) && rules.lt >= rules.gt && (this.isNan() || this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xcd\x01\n" +
	"\x15float.gt_lt_exclusive\x1a\xb3\x01has(rules.lt) && rules.lt < rules.gt && (this.isNan() || (rules.lt <= this && this <= rules.gt))? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xd3\x01\n" +
	"\ffloat.gt_lte\x1a\xc2\x01has(rules.lte) && rules.lte >= rules.gt && (this.isNan() || this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xdd\x01\n" +
	"\x16float.gt_lte_exclusive\x1a\xc2\x01has(rules.lte) && rules.lte < rules.gt && (this.isNan() || (rules.lte < this && this <= rules.gt))? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xbf\b\n" +
	"\x03gte\x18\x05 \x01(\x02B\xaa\b\xc2H\xa6\b\n" +
	"\x9b\x01\n" +
	"\tfloat.gte\x1a\x8d\x01!has(rules.lt) && !has(rules.lte) && (this.isNan() || this < rules.gte)? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xd2\x01\n" +
	"\ffloat.gte_lt\x1a\xc1\x01has(rules.lt) && rules.lt >= rules.gte && (this.isNan() || this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xdc\x01\n" +
	"\x16float.gte_lt_exclusive\x1a\xc1\x01has(rules.lt) && rules.lt < rules.gte && (this.isNan() || (rules.lt <= this && this < rules.gte))? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xe2\x01\n" +
	"\rfloat.gte_lte\x1a\xd0\x01has(rules.lte) && rules.lte >= rules.gte && (this.isNan() || this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xec\x01\n" +
	"\x17float.gte_lte_exclusive\x1a\xd0\x01has(rules.lte) && rules.lte < rules.gte && (this.isNan() || (rules.lte < this && this < rules.gte))? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x83\x01\n" +
	"\x02in\x18\x06 \x03(\x02Bs\xc2Hp\n" +
	"n\n" +
	"\bfloat.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12}\n" +
	"\x06not_in\x18\a \x03(\x02Bf\xc2Hc\n" +
	"a\n" +
	"\ffloat.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x12}\n" +
	"\x06finite\x18\b \x01(\bBe\xc2Hb\n" +
	"`\n" +
	"\ffloat.finite\x1aPrules.finite ? (this.isNan() || this.isInf() ? 'value must be finite' : '') : ''R\x06finite\x124\n" +
	"\aexample\x18\t \x03(\x02B\x1a\xc2H\x17\n" +
	"\x15\n" +
	"\rfloat.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xa2\x18\n" +
	"\vDoubleRules\x12\x8b\x01\n" +
	"\x05const\x18\x01 \x01(\x01Bu\xc2Hr\n" +
	"p\n" +
	"\fdouble.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\xa4\x01\n" +
	"\x02lt\x18\x02 \x01(\x01B\x91\x01\xc2H\x8d\x01\n" +
	"\x8a\x01\n" +
	"\tdouble.lt\x1a}!has(rules.gte) && !has(rules.gt) && (this.isNan() || this >= rules.lt)? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xb5\x01\n" +
	"\x03lte\x18\x03 \x01(\x01B\xa0\x01\xc2H\x9c\x01\n" +
	"\x99\x01\n" +
	"\n" +
	"double.lte\x1a\x8a\x01!has(rules.gte) && !has(rules.gt) && (this.isNan() || this > rules.lte)? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xf8\a\n" +
	"\x02gt\x18\x04 \x01(\x01B\xe5\a\xc2H\xe1\a\n" +
	"\x8e\x01\n" +
	"\tdouble.gt\x1a\x80\x01!has(rules.lt) && !has(rules.lte) && (this.isNan() || this <= rules.gt)? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xc4\x01\n" +
	"\fdouble.gt_lt\x1a\xb3\x01has(rules.lt) && rules.lt >= rules.gt && (this.isNan() || this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xce\x01\n" +
	"\x16double.gt_lt_exclusive\x1a\xb3\x01has(rules.lt) && rules.lt < rules.gt && (this.isNan() || (rules.lt <= this && this <= rules.gt))? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xd4\x01\n" +
	"\rdouble.gt_lte\x1a\xc2\x01has(rules.lte) && rules.lte >= rules.gt && (this.isNan() || this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xde\x01\n" +
	"\x17double.gt_lte_exclusive\x1a\xc2\x01has(rules.lte) && rules.lte < rules.gt && (this.isNan() || (rules.lte < this && this <= rules.gt))? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xc4\b\n" +
	"\x03gte\x18\x05 \x01(\x01B\xaf\b\xc2H\xab\b\n" +
	"\x9c\x01\n" +
	"\n" +
	"double.gte\x1a\x8d\x01!has(rules.lt) && !has(rules.lte) && (this.isNan() || this < rules.gte)? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xd3\x01\n" +
	"\rdouble.gte_lt\x1a\xc1\x01has(rules.lt) && rules.lt >= rules.gte && (this.isNan() || this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xdd\x01\n" +
	"\x17double.gte_lt_exclusive\x1a\xc1\x01has(rules.lt) && rules.lt < rules.gte && (this.isNan() || (rules.lt <= this && this < rules.gte))? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xe3\x01\n" +
	"\x0edouble.gte_lte\x1a\xd0\x01has(rules.lte) && rules.lte >= rules.gte && (this.isNan() || this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xed\x01\n" +
	"\x18double.gte_lte_exclusive\x1a\xd0\x01has(rules.lte) && rules.lte < rules.gte && (this.isNan() || (rules.lte < this && this < rules.gte))? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x84\x01\n" +
	"\x02in\x18\x06 \x03(\x01Bt\xc2Hq\n" +
	"o\n" +
	"\tdouble.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12~\n" +
	"\x06not_in\x18\a \x03(\x01Bg\xc2Hd\n" +
	"b\n" +
	"\rdouble.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x12~\n" +
	"\x06finite\x18\b \x01(\bBf\xc2Hc\n" +
	"a\n" +
	"\rdouble.finite\x1aPrules.finite ? (this.isNan() || this.isInf() ? 'value must be finite' : '') : ''R\x06finite\x125\n" +
	"\aexample\x18\t \x03(\x01B\x1b\xc2H\x18\n" +
	"\x16\n" +
	"\x0edouble.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xba\x15\n" +
	"\n" +
	"Int32Rules\x12\x8a\x01\n" +
	"\x05const\x18\x01 \x01(\x05Bt\xc2Hq\n" +
	"o\n" +
	"\vint32.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x8e\x01\n" +
	"\x02lt\x18\x02 \x01(\x05B|\xc2Hy\n" +
	"w\n" +
	"\bint32.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa1\x01\n" +
	"\x03lte\x18\x03 \x01(\x05B\x8c\x01\xc2H\x88\x01\n" +
	"\x85\x01\n" +
	"\tint32.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\x9b\a\n" +
	"\x02gt\x18\x04 \x01(\x05B\x88\a\xc2H\x84\a\n" +
	"z\n" +
	"\bint32.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb3\x01\n" +
	"\vint32.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbb\x01\n" +
	"\x15int32.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc3\x01\n" +
	"\fint32.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xcb\x01\n" +
	"\x16int32.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xe8\a\n" +
	"\x03gte\x18\x05 \x01(\x05B\xd3\a\xc2H\xcf\a\n" +
	"\x88\x01\n" +
	"\tint32.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc2\x01\n" +
	"\fint32.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xca\x01\n" +
	"\x16int32.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd2\x01\n" +
	"\rint32.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xda\x01\n" +
	"\x17int32.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x83\x01\n" +
	"\x02in\x18\x06 \x03(\x05Bs\xc2Hp\n" +
	"n\n" +
	"\bint32.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12}\n" +
	"\x06not_in\x18\a \x03(\x05Bf\xc2Hc\n" +
	"a\n" +
	"\fint32.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x124\n" +
	"\aexample\x18\b \x03(\x05B\x1a\xc2H\x17\n" +
	"\x15\n" +
	"\rint32.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xba\x15\n" +
	"\n" +
	"Int64Rules\x12\x8a\x01\n" +
	"\x05const\x18\x01 \x01(\x03Bt\xc2Hq\n" +
	"o\n" +
	"\vint64.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x8e\x01\n" +
	"\x02lt\x18\x02 \x01(\x03B|\xc2Hy\n" +
	"w\n" +
	"\bint64.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa1\x01\n" +
	"\x03lte\x18\x03 \x01(\x03B\x8c\x01\xc2H\x88\x01\n" +
	"\x85\x01\n" +
	"\tint64.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\x9b\a\n" +
	"\x02gt\x18\x04 \x01(\x03B\x88\a\xc2H\x84\a\n" +
	"z\n" +
	"\bint64.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb3\x01\n" +
	"\vint64.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbb\x01\n" +
	"\x15int64.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc3\x01\n" +
	"\fint64.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xcb\x01\n" +
	"\x16int64.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xe8\a\n" +
	"\x03gte\x18\x05 \x01(\x03B\xd3\a\xc2H\xcf\a\n" +
	"\x88\x01\n" +
	"\tint64.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc2\x01\n" +
	"\fint64.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xca\x01\n" +
	"\x16int64.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd2\x01\n" +
	"\rint64.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xda\x01\n" +
	"\x17int64.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x83\x01\n" +
	"\x02in\x18\x06 \x03(\x03Bs\xc2Hp\n" +
	"n\n" +
	"\bint64.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12}\n" +
	"\x06not_in\x18\a \x03(\x03Bf\xc2Hc\n" +
	"a\n" +
	"\fint64.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x124\n" +
	"\aexample\x18\t \x03(\x03B\x1a\xc2H\x17\n" +
	"\x15\n" +
	"\rint64.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xcb\x15\n" +
	"\vUInt32Rules\x12\x8b\x01\n" +
	"\x05const\x18\x01 \x01(\rBu\xc2Hr\n" +
	"p\n" +
	"\fuint32.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x8f\x01\n" +
	"\x02lt\x18\x02 \x01(\rB}\xc2Hz\n" +
	"x\n" +
	"\tuint32.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa2\x01\n" +
	"\x03lte\x18\x03 \x01(\rB\x8d\x01\xc2H\x89\x01\n" +
	"\x86\x01\n" +
	"\n" +
	"uint32.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xa0\a\n" +
	"\x02gt\x18\x04 \x01(\rB\x8d\a\xc2H\x89\a\n" +
	"{\n" +
	"\tuint32.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb4\x01\n" +
	"\fuint32.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbc\x01\n" +
	"\x16uint32.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc4\x01\n" +
	"\ruint32.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xcc\x01\n" +
	"\x17uint32.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xed\a\n" +
	"\x03gte\x18\x05 \x01(\rB\xd8\a\xc2H\xd4\a\n" +
	"\x89\x01\n" +
	"\n" +
	"uint32.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc3\x01\n" +
	"\ruint32.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xcb\x01\n" +
	"\x17uint32.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd3\x01\n" +
	"\x0euint32.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xdb\x01\n" +
	"\x18uint32.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x84\x01\n" +
	"\x02in\x18\x06 \x03(\rBt\xc2Hq\n" +
	"o\n" +
	"\tuint32.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12~\n" +
	"\x06not_in\x18\a \x03(\rBg\xc2Hd\n" +
	"b\n" +
	"\ruint32.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x125\n" +
	"\aexample\x18\b \x03(\rB\x1b\xc2H\x18\n" +
	"\x16\n" +
	"\x0euint32.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xcb\x15\n" +
	"\vUInt64Rules\x12\x8b\x01\n" +
	"\x05const\x18\x01 \x01(\x04Bu\xc2Hr\n" +
	"p\n" +
	"\fuint64.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x8f\x01\n" +
	"\x02lt\x18\x02 \x01(\x04B}\xc2Hz\n" +
	"x\n" +
	"\tuint64.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa2\x01\n" +
	"\x03lte\x18\x03 \x01(\x04B\x8d\x01\xc2H\x89\x01\n" +
	"\x86\x01\n" +
	"\n" +
	"uint64.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xa0\a\n" +
	"\x02gt\x18\x04 \x01(\x04B\x8d\a\xc2H\x89\a\n" +
	"{\n" +
	"\tuint64.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb4\x01\n" +
	"\fuint64.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbc\x01\n" +
	"\x16uint64.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc4\x01\n" +
	"\ruint64.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xcc\x01\n" +
	"\x17uint64.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xed\a\n" +
	"\x03gte\x18\x05 \x01(\x04B\xd8\a\xc2H\xd4\a\n" +
	"\x89\x01\n" +
	"\n" +
	"uint64.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc3\x01\n" +
	"\ruint64.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xcb\x01\n" +
	"\x17uint64.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd3\x01\n" +
	"\x0euint64.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xdb\x01\n" +
	"\x18uint64.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x84\x01\n" +
	"\x02in\x18\x06 \x03(\x04Bt\xc2Hq\n" +
	"o\n" +
	"\tuint64.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12~\n" +
	"\x06not_in\x18\a \x03(\x04Bg\xc2Hd\n" +
	"b\n" +
	"\ruint64.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x125\n" +
	"\aexample\x18\b \x03(\x04B\x1b\xc2H\x18\n" +
	"\x16\n" +
	"\x0euint64.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xcb\x15\n" +
	"\vSInt32Rules\x12\x8b\x01\n" +
	"\x05const\x18\x01 \x01(\x11Bu\xc2Hr\n" +
	"p\n" +
	"\fsint32.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x8f\x01\n" +
	"\x02lt\x18\x02 \x01(\x11B}\xc2Hz\n" +
	"x\n" +
	"\tsint32.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa2\x01\n" +
	"\x03lte\x18\x03 \x01(\x11B\x8d\x01\xc2H\x89\x01\n" +
	"\x86\x01\n" +
	"\n" +
	"sint32.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xa0\a\n" +
	"\x02gt\x18\x04 \x01(\x11B\x8d\a\xc2H\x89\a\n" +
	"{\n" +
	"\tsint32.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb4\x01\n" +
	"\fsint32.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbc\x01\n" +
	"\x16sint32.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc4\x01\n" +
	"\rsint32.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xcc\x01\n" +
	"\x17sint32.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xed\a\n" +
	"\x03gte\x18\x05 \x01(\x11B\xd8\a\xc2H\xd4\a\n" +
	"\x89\x01\n" +
	"\n" +
	"sint32.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc3\x01\n" +
	"\rsint32.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xcb\x01\n" +
	"\x17sint32.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd3\x01\n" +
	"\x0esint32.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xdb\x01\n" +
	"\x18sint32.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x84\x01\n" +
	"\x02in\x18\x06 \x03(\x11Bt\xc2Hq\n" +
	"o\n" +
	"\tsint32.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12~\n" +
	"\x06not_in\x18\a \x03(\x11Bg\xc2Hd\n" +
	"b\n" +
	"\rsint32.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x125\n" +
	"\aexample\x18\b \x03(\x11B\x1b\xc2H\x18\n" +
	"\x16\n" +
	"\x0esint32.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xcb\x15\n" +
	"\vSInt64Rules\x12\x8b\x01\n" +
	"\x05const\x18\x01 \x01(\x12Bu\xc2Hr\n" +
	"p\n" +
	"\fsint64.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x8f\x01\n" +
	"\x02lt\x18\x02 \x01(\x12B}\xc2Hz\n" +
	"x\n" +
	"\tsint64.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa2\x01\n" +
	"\x03lte\x18\x03 \x01(\x12B\x8d\x01\xc2H\x89\x01\n" +
	"\x86\x01\n" +
	"\n" +
	"sint64.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xa0\a\n" +
	"\x02gt\x18\x04 \x01(\x12B\x8d\a\xc2H\x89\a\n" +
	"{\n" +
	"\tsint64.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb4\x01\n" +
	"\fsint64.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbc\x01\n" +
	"\x16sint64.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc4\x01\n" +
	"\rsint64.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xcc\x01\n" +
	"\x17sint64.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xed\a\n" +
	"\x03gte\x18\x05 \x01(\x12B\xd8\a\xc2H\xd4\a\n" +
	"\x89\x01\n" +
	"\n" +
	"sint64.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc3\x01\n" +
	"\rsint64.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xcb\x01\n" +
	"\x17sint64.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd3\x01\n" +
	"\x0esint64.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xdb\x01\n" +
	"\x18sint64.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x84\x01\n" +
	"\x02in\x18\x06 \x03(\x12Bt\xc2Hq\n" +
	"o\n" +
	"\tsint64.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12~\n" +
	"\x06not_in\x18\a \x03(\x12Bg\xc2Hd\n" +
	"b\n" +
	"\rsint64.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x125\n" +
	"\aexample\x18\b \x03(\x12B\x1b\xc2H\x18\n" +
	"\x16\n" +
	"\x0esint64.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xdc\x15\n" +
	"\fFixed32Rules\x12\x8c\x01\n" +
	"\x05const\x18\x01 \x01(\aBv\xc2Hs\n" +
	"q\n" +
	"\rfixed32.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x90\x01\n" +
	"\x02lt\x18\x02 \x01(\aB~\xc2H{\n" +
	"y\n" +
	"\n" +
	"fixed32.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa3\x01\n" +
	"\x03lte\x18\x03 \x01(\aB\x8e\x01\xc2H\x8a\x01\n" +
	"\x87\x01\n" +
	"\vfixed32.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xa5\a\n" +
	"\x02gt\x18\x04 \x01(\aB\x92\a\xc2H\x8e\a\n" +
	"|\n" +
	"\n" +
	"fixed32.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb5\x01\n" +
	"\rfixed32.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbd\x01\n" +
	"\x17fixed32.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc5\x01\n" +
	"\x0efixed32.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xcd\x01\n" +
	"\x18fixed32.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xf2\a\n" +
	"\x03gte\x18\x05 \x01(\aB\xdd\a\xc2H\xd9\a\n" +
	"\x8a\x01\n" +
	"\vfixed32.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc4\x01\n" +
	"\x0efixed32.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xcc\x01\n" +
	"\x18fixed32.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd4\x01\n" +
	"\x0ffixed32.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xdc\x01\n" +
	"\x19fixed32.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x85\x01\n" +
	"\x02in\x18\x06 \x03(\aBu\xc2Hr\n" +
	"p\n" +
	"\n" +
	"fixed32.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12\x7f\n" +
	"\x06not_in\x18\a \x03(\aBh\xc2He\n" +
	"c\n" +
	"\x0efixed32.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x126\n" +
	"\aexample\x18\b \x03(\aB\x1c\xc2H\x19\n" +
	"\x17\n" +
	"\x0ffixed32.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xdc\x15\n" +
	"\fFixed64Rules\x12\x8c\x01\n" +
	"\x05const\x18\x01 \x01(\x06Bv\xc2Hs\n" +
	"q\n" +
	"\rfixed64.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x90\x01\n" +
	"\x02lt\x18\x02 \x01(\x06B~\xc2H{\n" +
	"y\n" +
	"\n" +
	"fixed64.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa3\x01\n" +
	"\x03lte\x18\x03 \x01(\x06B\x8e\x01\xc2H\x8a\x01\n" +
	"\x87\x01\n" +
	"\vfixed64.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xa5\a\n" +
	"\x02gt\x18\x04 \x01(\x06B\x92\a\xc2H\x8e\a\n" +
	"|\n" +
	"\n" +
	"fixed64.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb5\x01\n" +
	"\rfixed64.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbd\x01\n" +
	"\x17fixed64.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc5\x01\n" +
	"\x0efixed64.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xcd\x01\n" +
	"\x18fixed64.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xf2\a\n" +
	"\x03gte\x18\x05 \x01(\x06B\xdd\a\xc2H\xd9\a\n" +
	"\x8a\x01\n" +
	"\vfixed64.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc4\x01\n" +
	"\x0efixed64.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xcc\x01\n" +
	"\x18fixed64.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd4\x01\n" +
	"\x0ffixed64.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xdc\x01\n" +
	"\x19fixed64.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x85\x01\n" +
	"\x02in\x18\x06 \x03(\x06Bu\xc2Hr\n" +
	"p\n" +
	"\n" +
	"fixed64.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12\x7f\n" +
	"\x06not_in\x18\a \x03(\x06Bh\xc2He\n" +
	"c\n" +
	"\x0efixed64.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x126\n" +
	"\aexample\x18\b \x03(\x06B\x1c\xc2H\x19\n" +
	"\x17\n" +
	"\x0ffixed64.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xee\x15\n" +
	"\rSFixed32Rules\x12\x8d\x01\n" +
	"\x05const\x18\x01 \x01(\x0fBw\xc2Ht\n" +
	"r\n" +
	"\x0esfixed32.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x91\x01\n" +
	"\x02lt\x18\x02 \x01(\x0fB\x7f\xc2H|\n" +
	"z\n" +
	"\vsfixed32.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa4\x01\n" +
	"\x03lte\x18\x03 \x01(\x0fB\x8f\x01\xc2H\x8b\x01\n" +
	"\x88\x01\n" +
	"\fsfixed32.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xaa\a\n" +
	"\x02gt\x18\x04 \x01(\x0fB\x97\a\xc2H\x93\a\n" +
	"}\n" +
	"\vsfixed32.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb6\x01\n" +
	"\x0esfixed32.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbe\x01\n" +
	"\x18sfixed32.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc6\x01\n" +
	"\x0fsfixed32.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xce\x01\n" +
	"\x19sfixed32.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xf7\a\n" +
	"\x03gte\x18\x05 \x01(\x0fB\xe2\a\xc2H\xde\a\n" +
	"\x8b\x01\n" +
	"\fsfixed32.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc5\x01\n" +
	"\x0fsfixed32.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xcd\x01\n" +
	"\x19sfixed32.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd5\x01\n" +
	"\x10sfixed32.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xdd\x01\n" +
	"\x1asfixed32.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x86\x01\n" +
	"\x02in\x18\x06 \x03(\x0fBv\xc2Hs\n" +
	"q\n" +
	"\vsfixed32.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12\x80\x01\n" +
	"\x06not_in\x18\a \x03(\x0fBi\xc2Hf\n" +
	"d\n" +
	"\x0fsfixed32.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x127\n" +
	"\aexample\x18\b \x03(\x0fB\x1d\xc2H\x1a\n" +
	"\x18\n" +
	"\x10sfixed32.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xee\x15\n" +
	"\rSFixed64Rules\x12\x8d\x01\n" +
	"\x05const\x18\x01 \x01(\x10Bw\xc2Ht\n" +
	"r\n" +
	"\x0esfixed64.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\x91\x01\n" +
	"\x02lt\x18\x02 \x01(\x10B\x7f\xc2H|\n" +
	"z\n" +
	"\vsfixed64.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xa4\x01\n" +
	"\x03lte\x18\x03 \x01(\x10B\x8f\x01\xc2H\x8b\x01\n" +
	"\x88\x01\n" +
	"\fsfixed64.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xaa\a\n" +
	"\x02gt\x18\x04 \x01(\x10B\x97\a\xc2H\x93\a\n" +
	"}\n" +
	"\vsfixed64.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb6\x01\n" +
	"\x0esfixed64.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbe\x01\n" +
	"\x18sfixed64.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc6\x01\n" +
	"\x0fsfixed64.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xce\x01\n" +
	"\x19sfixed64.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\xf7\a\n" +
	"\x03gte\x18\x05 \x01(\x10B\xe2\a\xc2H\xde\a\n" +
	"\x8b\x01\n" +
	"\fsfixed64.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc5\x01\n" +
	"\x0fsfixed64.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xcd\x01\n" +
	"\x19sfixed64.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd5\x01\n" +
	"\x10sfixed64.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xdd\x01\n" +
	"\x1asfixed64.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\x86\x01\n" +
	"\x02in\x18\x06 \x03(\x10Bv\xc2Hs\n" +
	"q\n" +
	"\vsfixed64.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12\x80\x01\n" +
	"\x06not_in\x18\a \x03(\x10Bi\xc2Hf\n" +
	"d\n" +
	"\x0fsfixed64.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x127\n" +
	"\aexample\x18\b \x03(\x10B\x1d\xc2H\x1a\n" +
	"\x18\n" +
	"\x10sfixed64.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xd7\x01\n" +
	"\tBoolRules\x12\x89\x01\n" +
	"\x05const\x18\x01 \x01(\bBs\xc2Hp\n" +
	"n\n" +
	"\n" +
	"bool.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x123\n" +
	"\aexample\x18\x02 \x03(\bB\x19\xc2H\x16\n" +
	"\x14\n" +
	"\fbool.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02\"\xd19\n" +
	"\vStringRules\x12\x8d\x01\n" +
	"\x05const\x18\x01 \x01(\tBw\xc2Ht\n" +
	"r\n" +
	"\fstring.const\x1abthis != getField(rules, 'const') ? 'value must equal `%s`'.format([getField(rules, 'const')]) : ''R\x05const\x12\x83\x01\n" +
	"\x03len\x18\x13 \x01(\x04Bq\xc2Hn\n" +
	"l\n" +
	"\n" +
	"string.len\x1a^uint(this.size()) != rules.len ? 'value length must be %s characters'.format([rules.len]) : ''R\x03len\x12\xa1\x01\n" +
	"\amin_len\x18\x02 \x01(\x04B\x87\x01\xc2H\x83\x01\n" +
	"\x80\x01\n" +
	"\x0estring.min_len\x1anuint(this.size()) < rules.min_len ? 'value length must be at least %s characters'.format([rules.min_len]) : ''R\x06minLen\x12\x9f\x01\n" +
	"\amax_len\x18\x03 \x01(\x04B\x85\x01\xc2H\x81\x01\n" +
	"\x7f\n" +
	"\x0estring.max_len\x1amuint(this.size()) > rules.max_len ? 'value length must be at most %s characters'.format([rules.max_len]) : ''R\x06maxLen\x12\xa5\x01\n" +
	"\tlen_bytes\x18\x14 \x01(\x04B\x87\x01\xc2H\x83\x01\n" +
	"\x80\x01\n" +
	"\x10string.len_bytes\x1aluint(bytes(this).size()) != rules.len_bytes ? 'value length must be %s bytes'.format([rules.len_bytes]) : ''R\blenBytes\x12\xad\x01\n" +
	"\tmin_bytes\x18\x04 \x01(\x04B\x8f\x01\xc2H\x8b\x01\n" +
	"\x88\x01\n" +
	"\x10string.min_bytes\x1atuint(bytes(this).size()) < rules.min_bytes ? 'value length must be at least %s bytes'.format([rules.min_bytes]) : ''R\bminBytes\x12\xac\x01\n" +
	"\tmax_bytes\x18\x05 \x01(\x04B\x8e\x01\xc2H\x8a\x01\n" +
	"\x87\x01\n" +
	"\x10string.max_bytes\x1asuint(bytes(this).size()) > rules.max_bytes ? 'value length must be at most %s bytes'.format([rules.max_bytes]) : ''R\bmaxBytes\x12\x96\x01\n" +
	"\apattern\x18\x06 \x01(\tB|\xc2Hy\n" +
	"w\n" +
	"\x0estring.pattern\x1ae!this.matches(rules.pattern) ? 'value does not match regex pattern `%s`'.format([rules.pattern]) : ''R\apattern\x12\x8c\x01\n" +
	"\x06prefix\x18\a \x01(\tBt\xc2Hq\n" +
	"o\n" +
	"\rstring.prefix\x1a^!this.startsWith(rules.prefix) ? 'value does not have prefix `%s`'.format([rules.prefix]) : ''R\x06prefix\x12\x8a\x01\n" +
	"\x06suffix\x18\b \x01(\tBr\xc2Ho\n" +
	"m\n" +
	"\rstring.suffix\x1a\\!this.endsWith(rules.suffix) ? 'value does not have suffix `%s`'.format([rules.suffix]) : ''R\x06suffix\x12\x9a\x01\n" +
	"\bcontains\x18\t \x01(\tB~\xc2H{\n" +
	"y\n" +
	"\x0fstring.contains\x1af!this.contains(rules.contains) ? 'value does not contain substring `%s`'.format([rules.contains]) : ''R\bcontains\x12\xa5\x01\n" +
	"\fnot_contains\x18\x17 \x01(\tB\x81\x01\xc2H~\n" +
	"|\n" +
	"\x13string.not_contains\x1aethis.contains(rules.not_contains) ? 'value contains substring `%s`'.format([rules.not_contains]) : ''R\vnotContains\x12\x84\x01\n" +
	"\x02in\x18\n" +
	" \x03(\tBt\xc2Hq\n" +
	"o\n" +
	"\tstring.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12~\n" +
	"\x06not_in\x18\v \x03(\tBg\xc2Hd\n" +
	"b\n" +
	"\rstring.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x12\xe6\x01\n" +
	"\x05email\x18\f \x01(\bB\xcd\x01\xc2H\xc9\x01\n" +
	"a\n" +
	"\fstring.email\x12#value must be a valid email address\x1a,!rules.email || this == '' || this.isEmail()\n" +
	"d\n" +
	"\x12string.email_empty\x122value is empty, which is not a valid email address\x1a\x1a!rules.email || this != ''H\x00R\x05email\x12\xf1\x01\n" +
	"\bhostname\x18\r \x01(\bB\xd2\x01\xc2H\xce\x01\n" +
	"e\n" +
	"\x0fstring.hostname\x12\x1evalue must be a valid hostname\x1a2!rules.hostname || this == '' || this.isHostname()\n" +
	"e\n" +
	"\x15string.hostname_empty\x12-value is empty, which is not a valid hostname\x1a\x1d!rules.hostname || this != ''H\x00R\bhostname\x12\xcb\x01\n" +
	"\x02ip\x18\x0e \x01(\bB\xb8\x01\xc2H\xb4\x01\n" +
	"U\n" +
	"\tstring.ip\x12 value must be a valid IP address\x1a&!rules.ip || this == '' || this.isIp()\n" +
	"[\n" +
	"\x0fstring.ip_empty\x12/value is empty, which is not a valid IP address\x1a\x17!rules.ip || this != ''H\x00R\x02ip\x12\xdc\x01\n" +
	"\x04ipv4\x18\x0f \x01(\bB\xc5\x01\xc2H\xc1\x01\n" +
	"\\\n" +
	"\vstring.ipv4\x12\"value must be a valid IPv4 address\x1a)!rules.ipv4 || this == '' || this.isIp(4)\n" +
	"a\n" +
	"\x11string.ipv4_empty\x121value is empty, which is not a valid IPv4 address\x1a\x19!rules.ipv4 || this != ''H\x00R\x04ipv4\x12\xdc\x01\n" +
	"\x04ipv6\x18\x10 \x01(\bB\xc5\x01\xc2H\xc1\x01\n" +
	"\\\n" +
	"\vstring.ipv6\x12\"value must be a valid IPv6 address\x1a)!rules.ipv6 || this == '' || this.isIp(6)\n" +
	"a\n" +
	"\x11string.ipv6_empty\x121value is empty, which is not a valid IPv6 address\x1a\x19!rules.ipv6 || this != ''H\x00R\x04ipv6\x12\xc4\x01\n" +
	"\x03uri\x18\x11 \x01(\bB\xaf\x01\xc2H\xab\x01\n" +
	"Q\n" +
	"\n" +
	"string.uri\x12\x19value must be a valid URI\x1a(!rules.uri || this == '' || this.isUri()\n" +
	"V\n" +
	"\x10string.uri_empty\x12(value is empty, which is not a valid URI\x1a\x18!rules.uri || this != ''H\x00R\x03uri\x12x\n" +
	"\auri_ref\x18\x12 \x01(\bB]\xc2HZ\n" +
	"X\n" +
	"\x0estring.uri_ref\x12#value must be a valid URI Reference\x1a!!rules.uri_ref || this.isUriRef()H\x00R\x06uriRef\x12\x99\x02\n" +
	"\aaddress\x18\x15 \x01(\bB\xfc\x01\xc2H\xf8\x01\n" +
	"\x81\x01\n" +
	"\x0estring.address\x12-value must be a valid hostname, or ip address\x1a@!rules.address || this == '' || this.isHostname() || this.isIp()\n" +
	"r\n" +
	"\x14string.address_empty\x12<value is empty, which is not a valid hostname, or ip address\x1a\x1c!rules.address || this != ''H\x00R\aaddress\x12\x9e\x02\n" +
	"\x04uuid\x18\x16 \x01(\bB\x87\x02\xc2H\x83\x02\n" +
	"\xa5\x01\n" +
	"\vstring.uuid\x12\x1avalue must be a valid UUID\x1az!rules.uuid || this == '' || this.matches('^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$')\n" +
	"Y\n" +
	"\x11string.uuid_empty\x12)value is empty, which is not a valid UUID\x1a\x19!rules.uuid || this != ''H\x00R\x04uuid\x12\xf7\x01\n" +
	"\x05tuuid\x18! \x01(\bB\xde\x01\xc2H\xda\x01\n" +
	"s\n" +
	"\fstring.tuuid\x12\"value must be a valid trimmed UUID\x1a?!rules.tuuid || this == '' || this.matches('^[0-9a-fA-F]{32}$')\n" +
	"c\n" +
	"\x12string.tuuid_empty\x121value is empty, which is not a valid trimmed UUID\x1a\x1a!rules.tuuid || this != ''H\x00R\x05tuuid\x12\xa7\x02\n" +
	"\x11ip_with_prefixlen\x18\x1a \x01(\bB\xf8\x01\xc2H\xf4\x01\n" +
	"x\n" +
	"\x18string.ip_with_prefixlen\x12\x1fvalue must be a valid IP prefix\x1a;!rules.ip_with_prefixlen || this == '' || this.isIpPrefix()\n" +
	"x\n" +
	"\x1estring.ip_with_prefixlen_empty\x12.value is empty, which is not a valid IP prefix\x1a&!rules.ip_with_prefixlen || this != ''H\x00R\x0fipWithPrefixlen\x12\xe2\x02\n" +
	"\x13ipv4_with_prefixlen\x18\x1b \x01(\bB\xaf\x02\xc2H\xab\x02\n" +
	"\x93\x01\n" +
	"\x1astring.ipv4_with_prefixlen\x125value must be a valid IPv4 address with prefix length\x1a>!rules.ipv4_with_prefixlen || this == '' || this.isIpPrefix(4)\n" +
	"\x92\x01\n" +
	" string.ipv4_with_prefixlen_empty\x12Dvalue is empty, which is not a valid IPv4 address with prefix length\x1a(!rules.ipv4_with_prefixlen || this != ''H\x00R\x11ipv4WithPrefixlen\x12\xe2\x02\n" +
	"\x13ipv6_with_prefixlen\x18\x1c \x01(\bB\xaf\x02\xc2H\xab\x02\n" +
	"\x93\x01\n" +
	"\x1astring.ipv6_with_prefixlen\x125value must be a valid IPv6 address with prefix length\x1a>!rules.ipv6_with_prefixlen || this == '' || this.isIpPrefix(6)\n" +
	"\x92\x01\n" +
	" string.ipv6_with_prefixlen_empty\x12Dvalue is empty, which is not a valid IPv6 address with prefix length\x1a(!rules.ipv6_with_prefixlen || this != ''H\x00R\x11ipv6WithPrefixlen\x12\xfc\x01\n" +
	"\tip_prefix\x18\x1d \x01(\bB\xdc\x01\xc2H\xd8\x01\n" +
	"l\n" +
	"\x10string.ip_prefix\x12\x1fvalue must be a valid IP prefix\x1a7!rules.ip_prefix || this == '' || this.isIpPrefix(true)\n" +
	"h\n" +
	"\x16string.ip_prefix_empty\x12.value is empty, which is not a valid IP prefix\x1a\x1e!rules.ip_prefix || this != ''H\x00R\bipPrefix\x12\x8f\x02\n" +
	"\vipv4_prefix\x18\x1e \x01(\bB\xeb\x01\xc2H\xe7\x01\n" +
	"u\n" +
	"\x12string.ipv4_prefix\x12!value must be a valid IPv4 prefix\x1a<!rules.ipv4_prefix || this == '' || this.isIpPrefix(4, true)\n" +
	"n\n" +
	"\x18string.ipv4_prefix_empty\x120value is empty, which is not a valid IPv4 prefix\x1a !rules.ipv4_prefix || this != ''H\x00R\n" +
	"ipv4Prefix\x12\x8f\x02\n" +
	"\vipv6_prefix\x18\x1f \x01(\bB\xeb\x01\xc2H\xe7\x01\n" +
	"u\n" +
	"\x12string.ipv6_prefix\x12!value must be a valid IPv6 prefix\x1a<!rules.ipv6_prefix || this == '' || this.isIpPrefix(6, true)\n" +
	"n\n" +
	"\x18string.ipv6_prefix_empty\x120value is empty, which is not a valid IPv6 prefix\x1a !rules.ipv6_prefix || this != ''H\x00R\n" +
	"ipv6Prefix\x12\xc2\x02\n" +
	"\rhost_and_port\x18  \x01(\bB\x9b\x02\xc2H\x97\x02\n" +
	"\x99\x01\n" +
	"\x14string.host_and_port\x12Avalue must be a valid host (hostname or IP address) and port pair\x1a>!rules.host_and_port || this == '' || this.isHostAndPort(true)\n" +
	"y\n" +
	"\x1astring.host_and_port_empty\x127value is empty, which is not a valid host and port pair\x1a\"!rules.host_and_port || this != ''H\x00R\vhostAndPort\x12\xb8\x05\n" +
	"\x10well_known_regex\x18\x18 \x01(\x0e2\x18.buf.validate.KnownRegexB\xf1\x04\xc2H\xed\x04\n" +
	"\xf0\x01\n" +
	"#string.well_known_regex.header_name\x12&value must be a valid HTTP header name\x1a\xa0\x01rules.well_known_regex != 1 || this == '' || this.matches(!has(rules.strict) || rules.strict ?'^:?[0-9a-zA-Z!#$%&\\'*+-.^_|~\\x60]+$' :'^[^\\u0000\\u000A\\u000D]+$')\n" +
	"\x8d\x01\n" +
	")string.well_known_regex.header_name_empty\x125value is empty, which is not a valid HTTP header name\x1a)rules.well_known_regex != 1 || this != ''\n" +
	"\xe7\x01\n" +
	"$string.well_known_regex.header_value\x12'value must be a valid HTTP header value\x1a\x95\x01rules.well_known_regex != 2 || this.matches(!has(rules.strict) || rules.strict ?'^[^\\u0000-\\u0008\\u000A-\\u001F\\u007F]*$' :'^[^\\u0000\\u000A\\u000D]*$')H\x00R\x0ewellKnownRegex\x12\x16\n" +
	"\x06strict\x18\x19 \x01(\bR\x06strict\x125\n" +
	"\aexample\x18\" \x03(\tB\x1b\xc2H\x18\n" +
	"\x16\n" +
	"\x0estring.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\f\n" +
	"\n" +
	"well_known\"\xce\x11\n" +
	"\n" +
	"BytesRules\x12\x87\x01\n" +
	"\x05const\x18\x01 \x01(\fBq\xc2Hn\n" +
	"l\n" +
	"\vbytes.const\x1a]this != getField(rules, 'const') ? 'value must be %x'.format([getField(rules, 'const')]) : ''R\x05const\x12}\n" +
	"\x03len\x18\r \x01(\x04Bk\xc2Hh\n" +
	"f\n" +
	"\tbytes.len\x1aYuint(this.size()) != rules.len ? 'value length must be %s bytes'.format([rules.len]) : ''R\x03len\x12\x98\x01\n" +
	"\amin_len\x18\x02 \x01(\x04B\x7f\xc2H|\n" +
	"z\n" +
	"\rbytes.min_len\x1aiuint(this.size()) < rules.min_len ? 'value length must be at least %s bytes'.format([rules.min_len]) : ''R\x06minLen\x12\x90\x01\n" +
	"\amax_len\x18\x03 \x01(\x04Bw\xc2Ht\n" +
	"r\n" +
	"\rbytes.max_len\x1aauint(this.size()) > rules.max_len ? 'value must be at most %s bytes'.format([rules.max_len]) : ''R\x06maxLen\x12\x99\x01\n" +
	"\apattern\x18\x04 \x01(\tB\x7f\xc2H|\n" +
	"z\n" +
	"\rbytes.pattern\x1ai!string(this).matches(rules.pattern) ? 'value must match regex pattern `%s`'.format([rules.pattern]) : ''R\apattern\x12\x89\x01\n" +
	"\x06prefix\x18\x05 \x01(\fBq\xc2Hn\n" +
	"l\n" +
	"\fbytes.prefix\x1a\\!this.startsWith(rules.prefix) ? 'value does not have prefix %x'.format([rules.prefix]) : ''R\x06prefix\x12\x87\x01\n" +
	"\x06suffix\x18\x06 \x01(\fBo\xc2Hl\n" +
	"j\n" +
	"\fbytes.suffix\x1aZ!this.endsWith(rules.suffix) ? 'value does not have suffix %x'.format([rules.suffix]) : ''R\x06suffix\x12\x8d\x01\n" +
	"\bcontains\x18\a \x01(\fBq\xc2Hn\n" +
	"l\n" +
	"\x0ebytes.contains\x1aZ!this.contains(rules.contains) ? 'value does not contain %x'.format([rules.contains]) : ''R\bcontains\x12\xab\x01\n" +
	"\x02in\x18\b \x03(\fB\x9a\x01\xc2H\x96\x01\n" +
	"\x93\x01\n" +
	"\bbytes.in\x1a\x86\x01getField(rules, 'in').size() > 0 && !(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12}\n" +
	"\x06not_in\x18\t \x03(\fBf\xc2Hc\n" +
	"a\n" +
	"\fbytes.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x12\xef\x01\n" +
	"\x02ip\x18\n" +
	" \x01(\bB\xdc\x01\xc2H\xd8\x01\n" +
	"t\n" +
	"\bbytes.ip\x12 value must be a valid IP address\x1aF!rules.ip || this.size() == 0 || this.size() == 4 || this.size() == 16\n" +
	"`\n" +
	"\x0ebytes.ip_empty\x12/value is empty, which is not a valid IP address\x1a\x1d!rules.ip || this.size() != 0H\x00R\x02ip\x12\xea\x01\n" +
	"\x04ipv4\x18\v \x01(\bB\xd3\x01\xc2H\xcf\x01\n" +
	"e\n" +
	"\n" +
	"bytes.ipv4\x12\"value must be a valid IPv4 address\x1a3!rules.ipv4 || this.size() == 0 || this.size() == 4\n" +
	"f\n" +
	"\x10bytes.ipv4_empty\x121value is empty, which is not a valid IPv4 address\x1a\x1f!rules.ipv4 || this.size() != 0H\x00R\x04ipv4\x12\xeb\x01\n" +
	"\x04ipv6\x18\f \x01(\bB\xd4\x01\xc2H\xd0\x01\n" +
	"f\n" +
	"\n" +
	"bytes.ipv6\x12\"value must be a valid IPv6 address\x1a4!rules.ipv6 || this.size() == 0 || this.size() == 16\n" +
	"f\n" +
	"\x10bytes.ipv6_empty\x121value is empty, which is not a valid IPv6 address\x1a\x1f!rules.ipv6 || this.size() != 0H\x00R\x04ipv6\x124\n" +
	"\aexample\x18\x0e \x03(\fB\x1a\xc2H\x17\n" +
	"\x15\n" +
	"\rbytes.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\f\n" +
	"\n" +
	"well_known\"\xfd\x03\n" +
	"\tEnumRules\x12\x89\x01\n" +
	"\x05const\x18\x01 \x01(\x05Bs\xc2Hp\n" +
	"n\n" +
	"\n" +
	"enum.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12!\n" +
	"\fdefined_only\x18\x02 \x01(\bR\vdefinedOnly\x12\x82\x01\n" +
	"\x02in\x18\x03 \x03(\x05Br\xc2Ho\n" +
	"m\n" +
	"\aenum.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12|\n" +
	"\x06not_in\x18\x04 \x03(\x05Be\xc2Hb\n" +
	"`\n" +
	"\venum.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x123\n" +
	"\aexample\x18\x05 \x03(\x05B\x19\xc2H\x16\n" +
	"\x14\n" +
	"\fenum.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02\"\x9e\x04\n" +
	"\rRepeatedRules\x12\xa8\x01\n" +
	"\tmin_items\x18\x01 \x01(\x04B\x8a\x01\xc2H\x86\x01\n" +
	"\x83\x01\n" +
	"\x12repeated.min_items\x1amuint(this.size()) < rules.min_items ? 'value must contain at least %d item(s)'.format([rules.min_items]) : ''R\bminItems\x12\xac\x01\n" +
	"\tmax_items\x18\x02 \x01(\x04B\x8e\x01\xc2H\x8a\x01\n" +
	"\x87\x01\n" +
	"\x12repeated.max_items\x1aquint(this.size()) > rules.max_items ? 'value must contain no more than %s item(s)'.format([rules.max_items]) : ''R\bmaxItems\x12x\n" +
	"\x06unique\x18\x03 \x01(\bB`\xc2H]\n" +
	"[\n" +
	"\x0frepeated.unique\x12(repeated value must contain unique items\x1a\x1e!rules.unique || this.unique()R\x06unique\x12.\n" +
	"\x05items\x18\x04 \x01(\v2\x18.buf.validate.FieldRulesR\x05items*\t\b\xe8\a\x10\x80\x80\x80\x80\x02\"\xac\x03\n" +
	"\bMapRules\x12\x99\x01\n" +
	"\tmin_pairs\x18\x01 \x01(\x04B|\xc2Hy\n" +
	"w\n" +
	"\rmap.min_pairs\x1afuint(this.size()) < rules.min_pairs ? 'map must be at least %d entries'.format([rules.min_pairs]) : ''R\bminPairs\x12\x98\x01\n" +
	"\tmax_pairs\x18\x02 \x01(\x04B{\xc2Hx\n" +
	"v\n" +
	"\rmap.max_pairs\x1aeuint(this.size()) > rules.max_pairs ? 'map must be at most %d entries'.format([rules.max_pairs]) : ''R\bmaxPairs\x12,\n" +
	"\x04keys\x18\x04 \x01(\v2\x18.buf.validate.FieldRulesR\x04keys\x120\n" +
	"\x06values\x18\x05 \x01(\v2\x18.buf.validate.FieldRulesR\x06values*\t\b\xe8\a\x10\x80\x80\x80\x80\x02\"1\n" +
	"\bAnyRules\x12\x0e\n" +
	"\x02in\x18\x02 \x03(\tR\x02in\x12\x15\n" +
	"\x06not_in\x18\x03 \x03(\tR\x05notIn\"\xc6\x17\n" +
	"\rDurationRules\x12\xa8\x01\n" +
	"\x05const\x18\x02 \x01(\v2\x19.google.protobuf.DurationBw\xc2Ht\n" +
	"r\n" +
	"\x0eduration.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\xac\x01\n" +
	"\x02lt\x18\x03 \x01(\v2\x19.google.protobuf.DurationB\x7f\xc2H|\n" +
	"z\n" +
	"\vduration.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xbf\x01\n" +
	"\x03lte\x18\x04 \x01(\v2\x19.google.protobuf.DurationB\x8f\x01\xc2H\x8b\x01\n" +
	"\x88\x01\n" +
	"\fduration.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12\xc5\a\n" +
	"\x02gt\x18\x05 \x01(\v2\x19.google.protobuf.DurationB\x97\a\xc2H\x93\a\n" +
	"}\n" +
	"\vduration.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb6\x01\n" +
	"\x0eduration.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbe\x01\n" +
	"\x18duration.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc6\x01\n" +
	"\x0fduration.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xce\x01\n" +
	"\x19duration.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\x92\b\n" +
	"\x03gte\x18\x06 \x01(\v2\x19.google.protobuf.DurationB\xe2\a\xc2H\xde\a\n" +
	"\x8b\x01\n" +
	"\fduration.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc5\x01\n" +
	"\x0fduration.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xcd\x01\n" +
	"\x19duration.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd5\x01\n" +
	"\x10duration.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xdd\x01\n" +
	"\x1aduration.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12\xa1\x01\n" +
	"\x02in\x18\a \x03(\v2\x19.google.protobuf.DurationBv\xc2Hs\n" +
	"q\n" +
	"\vduration.in\x1ab!(this in getField(rules, 'in')) ? 'value must be in list %s'.format([getField(rules, 'in')]) : ''R\x02in\x12\x9b\x01\n" +
	"\x06not_in\x18\b \x03(\v2\x19.google.protobuf.DurationBi\xc2Hf\n" +
	"d\n" +
	"\x0fduration.not_in\x1aQthis in rules.not_in ? 'value must not be in list %s'.format([rules.not_in]) : ''R\x05notIn\x12R\n" +
	"\aexample\x18\t \x03(\v2\x19.google.protobuf.DurationB\x1d\xc2H\x1a\n" +
	"\x18\n" +
	"\x10duration.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"\xca\x18\n" +
	"\x0eTimestampRules\x12\xaa\x01\n" +
	"\x05const\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampBx\xc2Hu\n" +
	"s\n" +
	"\x0ftimestamp.const\x1a`this != getField(rules, 'const') ? 'value must equal %s'.format([getField(rules, 'const')]) : ''R\x05const\x12\xaf\x01\n" +
	"\x02lt\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampB\x80\x01\xc2H}\n" +
	"{\n" +
	"\ftimestamp.lt\x1ak!has(rules.gte) && !has(rules.gt) && this >= rules.lt? 'value must be less than %s'.format([rules.lt]) : ''H\x00R\x02lt\x12\xc1\x01\n" +
	"\x03lte\x18\x04 \x01(\v2\x1a.google.protobuf.TimestampB\x90\x01\xc2H\x8c\x01\n" +
	"\x89\x01\n" +
	"\rtimestamp.lte\x1ax!has(rules.gte) && !has(rules.gt) && this > rules.lte? 'value must be less than or equal to %s'.format([rules.lte]) : ''H\x00R\x03lte\x12s\n" +
	"\x06lt_now\x18\a \x01(\bBZ\xc2HW\n" +
	"U\n" +
	"\x10timestamp.lt_now\x1aA(rules.lt_now && this > now) ? 'value must be less than now' : ''H\x00R\x05ltNow\x12\xcb\a\n" +
	"\x02gt\x18\x05 \x01(\v2\x1a.google.protobuf.TimestampB\x9c\a\xc2H\x98\a\n" +
	"~\n" +
	"\ftimestamp.gt\x1an!has(rules.lt) && !has(rules.lte) && this <= rules.gt? 'value must be greater than %s'.format([rules.gt]) : ''\n" +
	"\xb7\x01\n" +
	"\x0ftimestamp.gt_lt\x1a\xa3\x01has(rules.lt) && rules.lt >= rules.gt && (this >= rules.lt || this <= rules.gt)? 'value must be greater than %s and less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xbf\x01\n" +
	"\x19timestamp.gt_lt_exclusive\x1a\xa1\x01has(rules.lt) && rules.lt < rules.gt && (rules.lt <= this && this <= rules.gt)? 'value must be greater than %s or less than %s'.format([rules.gt, rules.lt]) : ''\n" +
	"\xc7\x01\n" +
	"\x10timestamp.gt_lte\x1a\xb2\x01has(rules.lte) && rules.lte >= rules.gt && (this > rules.lte || this <= rules.gt)? 'value must be greater than %s and less than or equal to %s'.format([rules.gt, rules.lte]) : ''\n" +
	"\xcf\x01\n" +
	"\x1atimestamp.gt_lte_exclusive\x1a\xb0\x01has(rules.lte) && rules.lte < rules.gt && (rules.lte < this && this <= rules.gt)? 'value must be greater than %s or less than or equal to %s'.format([rules.gt, rules.lte]) : ''H\x01R\x02gt\x12\x98\b\n" +
	"\x03gte\x18\x06 \x01(\v2\x1a.google.protobuf.TimestampB\xe7\a\xc2H\xe3\a\n" +
	"\x8c\x01\n" +
	"\rtimestamp.gte\x1a{!has(rules.lt) && !has(rules.lte) && this < rules.gte? 'value must be greater than or equal to %s'.format([rules.gte]) : ''\n" +
	"\xc6\x01\n" +
	"\x10timestamp.gte_lt\x1a\xb1\x01has(rules.lt) && rules.lt >= rules.gte && (this >= rules.lt || this < rules.gte)? 'value must be greater than or equal to %s and less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xce\x01\n" +
	"\x1atimestamp.gte_lt_exclusive\x1a\xaf\x01has(rules.lt) && rules.lt < rules.gte && (rules.lt <= this && this < rules.gte)? 'value must be greater than or equal to %s or less than %s'.format([rules.gte, rules.lt]) : ''\n" +
	"\xd6\x01\n" +
	"\x11timestamp.gte_lte\x1a\xc0\x01has(rules.lte) && rules.lte >= rules.gte && (this > rules.lte || this < rules.gte)? 'value must be greater than or equal to %s and less than or equal to %s'.format([rules.gte, rules.lte]) : ''\n" +
	"\xde\x01\n" +
	"\x1btimestamp.gte_lte_exclusive\x1a\xbe\x01has(rules.lte) && rules.lte < rules.gte && (rules.lte < this && this < rules.gte)? 'value must be greater than or equal to %s or less than or equal to %s'.format([rules.gte, rules.lte]) : ''H\x01R\x03gte\x12v\n" +
	"\x06gt_now\x18\b \x01(\bB]\xc2HZ\n" +
	"X\n" +
	"\x10timestamp.gt_now\x1aD(rules.gt_now && this < now) ? 'value must be greater than now' : ''H\x01R\x05gtNow\x12\xc0\x01\n" +
	"\x06within\x18\t \x01(\v2\x19.google.protobuf.DurationB\x8c\x01\xc2H\x88\x01\n" +
	"\x85\x01\n" +
	"\x10timestamp.within\x1aqthis < now-rules.within || this > now+rules.within ? 'value must be within %s of now'.format([rules.within]) : ''R\x06within\x12T\n" +
	"\aexample\x18\n" +
	" \x03(\v2\x1a.google.protobuf.TimestampB\x1e\xc2H\x1b\n" +
	"\x19\n" +
	"\x11timestamp.example\x1a\x04trueR\aexample*\t\b\xe8\a\x10\x80\x80\x80\x80\x02B\v\n" +
	"\tless_thanB\x0e\n" +
	"\fgreater_than\"E\n" +
	"\n" +
	"Violations\x127\n" +
	"\n" +
	"violations\x18\x01 \x03(\v2\x17.buf.validate.ViolationR\n" +
	"violations\"\xc5\x01\n" +
	"\tViolation\x12-\n" +
	"\x05field\x18\x05 \x01(\v2\x17.buf.validate.FieldPathR\x05field\x12+\n" +
	"\x04rule\x18\x06 \x01(\v2\x17.buf.validate.FieldPathR\x04rule\x12\x17\n" +
	"\arule_id\x18\x02 \x01(\tR\x06ruleId\x12\x18\n" +
	"\amessage\x18\x03 \x01(\tR\amessage\x12\x17\n" +
	"\afor_key\x18\x04 \x01(\bR\x06forKeyJ\x04\b\x01\x10\x02R\n" +
	"field_path\"G\n" +
	"\tFieldPath\x12:\n" +
	"\belements\x18\x01 \x03(\v2\x1e.buf.validate.FieldPathElementR\belements\"\xcc\x03\n" +
	"\x10FieldPathElement\x12!\n" +
	"\ffield_number\x18\x01 \x01(\x05R\vfieldNumber\x12\x1d\n" +
	"\n" +
	"field_name\x18\x02 \x01(\tR\tfieldName\x12I\n" +
	"\n" +
	"field_type\x18\x03 \x01(\x0e2*.google.protobuf.FieldDescriptorProto.TypeR\tfieldType\x12E\n" +
	"\bkey_type\x18\x04 \x01(\x0e2*.google.protobuf.FieldDescriptorProto.TypeR\akeyType\x12I\n" +
	"\n" +
	"value_type\x18\x05 \x01(\x0e2*.google.protobuf.FieldDescriptorProto.TypeR\tvalueType\x12\x16\n" +
	"\x05index\x18\x06 \x01(\x04H\x00R\x05index\x12\x1b\n" +
	"\bbool_key\x18\a \x01(\bH\x00R\aboolKey\x12\x19\n" +
	"\aint_key\x18\b \x01(\x03H\x00R\x06intKey\x12\x1b\n" +
	"\buint_key\x18\t \x01(\x04H\x00R\auintKey\x12\x1f\n" +
	"\n" +
	"string_key\x18\n" +
	" \x01(\tH\x00R\tstringKeyB\v\n" +
	"\tsubscript*\xa1\x01\n" +
	"\x06Ignore\x12\x16\n" +
	"\x12IGNORE_UNSPECIFIED\x10\x00\x12\x18\n" +
	"\x14IGNORE_IF_ZERO_VALUE\x10\x01\x12\x11\n" +
	"\rIGNORE_ALWAYS\x10\x03\"\x04\b\x02\x10\x02*\fIGNORE_EMPTY*\x0eIGNORE_DEFAULT*\x17IGNORE_IF_DEFAULT_VALUE*\x15IGNORE_IF_UNPOPULATED*n\n" +
	"\n" +
	"KnownRegex\x12\x1b\n" +
	"\x17KNOWN_REGEX_UNSPECIFIED\x10\x00\x12 \n" +
	"\x1cKNOWN_REGEX_HTTP_HEADER_NAME\x10\x01\x12!\n" +
	"\x1dKNOWN_REGEX_HTTP_HEADER_VALUE\x10\x02:V\n" +
	"\amessage\x12\x1f.google.protobuf.MessageOptions\x18\x87\t \x01(\v2\x1a.buf.validate.MessageRulesR\amessage:N\n" +
	"\x05oneof\x12\x1d.google.protobuf.OneofOptions\x18\x87\t \x01(\v2\x18.buf.validate.OneofRulesR\x05oneof:N\n" +
	"\x05field\x12\x1d.google.protobuf.FieldOptions\x18\x87\t \x01(\v2\x18.buf.validate.FieldRulesR\x05field:]\n" +
	"\n" +
	"predefined\x12\x1d.google.protobuf.FieldOptions\x18\x88\t \x01(\v2\x1d.buf.validate.PredefinedRulesR\n" +
	"predefinedBn\n" +
	"\x12build.buf.validateB\rValidateProtoP\x01ZGbuf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"

var file_buf_validate_validate_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_buf_validate_validate_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_buf_validate_validate_proto_goTypes = []any{
	(Ignore)(0),                                 // 0: buf.validate.Ignore
	(KnownRegex)(0),                             // 1: buf.validate.KnownRegex
	(*Rule)(nil),                                // 2: buf.validate.Rule
	(*MessageRules)(nil),                        // 3: buf.validate.MessageRules
	(*MessageOneofRule)(nil),                    // 4: buf.validate.MessageOneofRule
	(*OneofRules)(nil),                          // 5: buf.validate.OneofRules
	(*FieldRules)(nil),                          // 6: buf.validate.FieldRules
	(*PredefinedRules)(nil),                     // 7: buf.validate.PredefinedRules
	(*FloatRules)(nil),                          // 8: buf.validate.FloatRules
	(*DoubleRules)(nil),                         // 9: buf.validate.DoubleRules
	(*Int32Rules)(nil),                          // 10: buf.validate.Int32Rules
	(*Int64Rules)(nil),                          // 11: buf.validate.Int64Rules
	(*UInt32Rules)(nil),                         // 12: buf.validate.UInt32Rules
	(*UInt64Rules)(nil),                         // 13: buf.validate.UInt64Rules
	(*SInt32Rules)(nil),                         // 14: buf.validate.SInt32Rules
	(*SInt64Rules)(nil),                         // 15: buf.validate.SInt64Rules
	(*Fixed32Rules)(nil),                        // 16: buf.validate.Fixed32Rules
	(*Fixed64Rules)(nil),                        // 17: buf.validate.Fixed64Rules
	(*SFixed32Rules)(nil),                       // 18: buf.validate.SFixed32Rules
	(*SFixed64Rules)(nil),                       // 19: buf.validate.SFixed64Rules
	(*BoolRules)(nil),                           // 20: buf.validate.BoolRules
	(*StringRules)(nil),                         // 21: buf.validate.StringRules
	(*BytesRules)(nil),                          // 22: buf.validate.BytesRules
	(*EnumRules)(nil),                           // 23: buf.validate.EnumRules
	(*RepeatedRules)(nil),                       // 24: buf.validate.RepeatedRules
	(*MapRules)(nil),                            // 25: buf.validate.MapRules
	(*AnyRules)(nil),                            // 26: buf.validate.AnyRules
	(*DurationRules)(nil),                       // 27: buf.validate.DurationRules
	(*TimestampRules)(nil),                      // 28: buf.validate.TimestampRules
	(*Violations)(nil),                          // 29: buf.validate.Violations
	(*Violation)(nil),                           // 30: buf.validate.Violation
	(*FieldPath)(nil),                           // 31: buf.validate.FieldPath
	(*FieldPathElement)(nil),                    // 32: buf.validate.FieldPathElement
	(*durationpb.Duration)(nil),                 // 33: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),               // 34: google.protobuf.Timestamp
	(descriptorpb.FieldDescriptorProto_Type)(0), // 35: google.protobuf.FieldDescriptorProto.Type
	(*descriptorpb.MessageOptions)(nil),         // 36: google.protobuf.MessageOptions
	(*descriptorpb.OneofOptions)(nil),           // 37: google.protobuf.OneofOptions
	(*descriptorpb.FieldOptions)(nil),           // 38: google.protobuf.FieldOptions
}
var file_buf_validate_validate_proto_depIdxs = []int32{
	2,  // 0: buf.validate.MessageRules.cel:type_name -> buf.validate.Rule
	4,  // 1: buf.validate.MessageRules.oneof:type_name -> buf.validate.MessageOneofRule
	2,  // 2: buf.validate.FieldRules.cel:type_name -> buf.validate.Rule
	0,  // 3: buf.validate.FieldRules.ignore:type_name -> buf.validate.Ignore
	8,  // 4: buf.validate.FieldRules.float:type_name -> buf.validate.FloatRules
	9,  // 5: buf.validate.FieldRules.double:type_name -> buf.validate.DoubleRules
	10, // 6: buf.validate.FieldRules.int32:type_name -> buf.validate.Int32Rules
	11, // 7: buf.validate.FieldRules.int64:type_name -> buf.validate.Int64Rules
	12, // 8: buf.validate.FieldRules.uint32:type_name -> buf.validate.UInt32Rules
	13, // 9: buf.validate.FieldRules.uint64:type_name -> buf.validate.UInt64Rules
	14, // 10: buf.validate.FieldRules.sint32:type_name -> buf.validate.SInt32Rules
	15, // 11: buf.validate.FieldRules.sint64:type_name -> buf.validate.SInt64Rules
	16, // 12: buf.validate.FieldRules.fixed32:type_name -> buf.validate.Fixed32Rules
	17, // 13: buf.validate.FieldRules.fixed64:type_name -> buf.validate.Fixed64Rules
	18, // 14: buf.validate.FieldRules.sfixed32:type_name -> buf.validate.SFixed32Rules
	19, // 15: buf.validate.FieldRules.sfixed64:type_name -> buf.validate.SFixed64Rules
	20, // 16: buf.validate.FieldRules.bool:type_name -> buf.validate.BoolRules
	21, // 17: buf.validate.FieldRules.string:type_name -> buf.validate.StringRules
	22, // 18: buf.validate.FieldRules.bytes:type_name -> buf.validate.BytesRules
	23, // 19: buf.validate.FieldRules.enum:type_name -> buf.validate.EnumRules
	24, // 20: buf.validate.FieldRules.repeated:type_name -> buf.validate.RepeatedRules
	25, // 21: buf.validate.FieldRules.map:type_name -> buf.validate.MapRules
	26, // 22: buf.validate.FieldRules.any:type_name -> buf.validate.AnyRules
	27, // 23: buf.validate.FieldRules.duration:type_name -> buf.validate.DurationRules
	28, // 24: buf.validate.FieldRules.timestamp:type_name -> buf.validate.TimestampRules
	2,  // 25: buf.validate.PredefinedRules.cel:type_name -> buf.validate.Rule
	1,  // 26: buf.validate.StringRules.well_known_regex:type_name -> buf.validate.KnownRegex
	6,  // 27: buf.validate.RepeatedRules.items:type_name -> buf.validate.FieldRules
	6,  // 28: buf.validate.MapRules.keys:type_name -> buf.validate.FieldRules
	6,  // 29: buf.validate.MapRules.values:type_name -> buf.validate.FieldRules
	33, // 30: buf.validate.DurationRules.const:type_name -> google.protobuf.Duration
	33, // 31: buf.validate.DurationRules.lt:type_name -> google.protobuf.Duration
	33, // 32: buf.validate.DurationRules.lte:type_name -> google.protobuf.Duration
	33, // 33: buf.validate.DurationRules.gt:type_name -> google.protobuf.Duration
	33, // 34: buf.validate.DurationRules.gte:type_name -> google.protobuf.Duration
	33, // 35: buf.validate.DurationRules.in:type_name -> google.protobuf.Duration
	33, // 36: buf.validate.DurationRules.not_in:type_name -> google.protobuf.Duration
	33, // 37: buf.validate.DurationRules.example:type_name -> google.protobuf.Duration
	34, // 38: buf.validate.TimestampRules.const:type_name -> google.protobuf.Timestamp
	34, // 39: buf.validate.TimestampRules.lt:type_name -> google.protobuf.Timestamp
	34, // 40: buf.validate.TimestampRules.lte:type_name -> google.protobuf.Timestamp
	34, // 41: buf.validate.TimestampRules.gt:type_name -> google.protobuf.Timestamp
	34, // 42: buf.validate.TimestampRules.gte:type_name -> google.protobuf.Timestamp
	33, // 43: buf.validate.TimestampRules.within:type_name -> google.protobuf.Duration
	34, // 44: buf.validate.TimestampRules.example:type_name -> google.protobuf.Timestamp
	30, // 45: buf.validate.Violations.violations:type_name -> buf.validate.Violation
	31, // 46: buf.validate.Violation.field:type_name -> buf.validate.FieldPath
	31, // 47: buf.validate.Violation.rule:type_name -> buf.validate.FieldPath
	32, // 48: buf.validate.FieldPath.elements:type_name -> buf.validate.FieldPathElement
	35, // 49: buf.validate.FieldPathElement.field_type:type_name -> google.protobuf.FieldDescriptorProto.Type
	35, // 50: buf.validate.FieldPathElement.key_type:type_name -> google.protobuf.FieldDescriptorProto.Type
	35, // 51: buf.validate.FieldPathElement.value_type:type_name -> google.protobuf.FieldDescriptorProto.Type
	36, // 52: buf.validate.message:extendee -> google.protobuf.MessageOptions
	37, // 53: buf.validate.oneof:extendee -> google.protobuf.OneofOptions
	38, // 54: buf.validate.field:extendee -> google.protobuf.FieldOptions
	38, // 55: buf.validate.predefined:extendee -> google.protobuf.FieldOptions
	3,  // 56: buf.validate.message:type_name -> buf.validate.MessageRules
	5,  // 57: buf.validate.oneof:type_name -> buf.validate.OneofRules
	6,  // 58: buf.validate.field:type_name -> buf.validate.FieldRules
	7,  // 59: buf.validate.predefined:type_name -> buf.validate.PredefinedRules
	60, // [60:60] is the sub-list for method output_type
	60, // [60:60] is the sub-list for method input_type
	56, // [56:60] is the sub-list for extension type_name
	52, // [52:56] is the sub-list for extension extendee
	0,  // [0:52] is the sub-list for field type_name
}

func init() { file_buf_validate_validate_proto_init() }
func file_buf_validate_validate_proto_init() {
	if File_buf_validate_validate_proto != nil {
		return
	}
	file_buf_validate_validate_proto_msgTypes[4].OneofWrappers = []any{
		(*FieldRules_Float)(nil),
		(*FieldRules_Double)(nil),
		(*FieldRules_Int32)(nil),
		(*FieldRules_Int64)(nil),
		(*FieldRules_Uint32)(nil),
		(*FieldRules_Uint64)(nil),
		(*FieldRules_Sint32)(nil),
		(*FieldRules_Sint64)(nil),
		(*FieldRules_Fixed32)(nil),
		(*FieldRules_Fixed64)(nil),
		(*FieldRules_Sfixed32)(nil),
		(*FieldRules_Sfixed64)(nil),
		(*FieldRules_Bool)(nil),
		(*FieldRules_String_)(nil),
		(*FieldRules_Bytes)(nil),
		(*FieldRules_Enum)(nil),
		(*FieldRules_Repeated)(nil),
		(*FieldRules_Map)(nil),
		(*FieldRules_Any)(nil),
		(*FieldRules_Duration)(nil),
		(*FieldRules_Timestamp)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[6].OneofWrappers = []any{
		(*FloatRules_Lt)(nil),
		(*FloatRules_Lte)(nil),
		(*FloatRules_Gt)(nil),
		(*FloatRules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[7].OneofWrappers = []any{
		(*DoubleRules_Lt)(nil),
		(*DoubleRules_Lte)(nil),
		(*DoubleRules_Gt)(nil),
		(*DoubleRules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[8].OneofWrappers = []any{
		(*Int32Rules_Lt)(nil),
		(*Int32Rules_Lte)(nil),
		(*Int32Rules_Gt)(nil),
		(*Int32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[9].OneofWrappers = []any{
		(*Int64Rules_Lt)(nil),
		(*Int64Rules_Lte)(nil),
		(*Int64Rules_Gt)(nil),
		(*Int64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[10].OneofWrappers = []any{
		(*UInt32Rules_Lt)(nil),
		(*UInt32Rules_Lte)(nil),
		(*UInt32Rules_Gt)(nil),
		(*UInt32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[11].OneofWrappers = []any{
		(*UInt64Rules_Lt)(nil),
		(*UInt64Rules_Lte)(nil),
		(*UInt64Rules_Gt)(nil),
		(*UInt64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[12].OneofWrappers = []any{
		(*SInt32Rules_Lt)(nil),
		(*SInt32Rules_Lte)(nil),
		(*SInt32Rules_Gt)(nil),
		(*SInt32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[13].OneofWrappers = []any{
		(*SInt64Rules_Lt)(nil),
		(*SInt64Rules_Lte)(nil),
		(*SInt64Rules_Gt)(nil),
		(*SInt64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[14].OneofWrappers = []any{
		(*Fixed32Rules_Lt)(nil),
		(*Fixed32Rules_Lte)(nil),
		(*Fixed32Rules_Gt)(nil),
		(*Fixed32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[15].OneofWrappers = []any{
		(*Fixed64Rules_Lt)(nil),
		(*Fixed64Rules_Lte)(nil),
		(*Fixed64Rules_Gt)(nil),
		(*Fixed64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[16].OneofWrappers = []any{
		(*SFixed32Rules_Lt)(nil),
		(*SFixed32Rules_Lte)(nil),
		(*SFixed32Rules_Gt)(nil),
		(*SFixed32Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[17].OneofWrappers = []any{
		(*SFixed64Rules_Lt)(nil),
		(*SFixed64Rules_Lte)(nil),
		(*SFixed64Rules_Gt)(nil),
		(*SFixed64Rules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[19].OneofWrappers = []any{
		(*StringRules_Email)(nil),
		(*StringRules_Hostname)(nil),
		(*StringRules_Ip)(nil),
		(*StringRules_Ipv4)(nil),
		(*StringRules_Ipv6)(nil),
		(*StringRules_Uri)(nil),
		(*StringRules_UriRef)(nil),
		(*StringRules_Address)(nil),
		(*StringRules_Uuid)(nil),
		(*StringRules_Tuuid)(nil),
		(*StringRules_IpWithPrefixlen)(nil),
		(*StringRules_Ipv4WithPrefixlen)(nil),
		(*StringRules_Ipv6WithPrefixlen)(nil),
		(*StringRules_IpPrefix)(nil),
		(*StringRules_Ipv4Prefix)(nil),
		(*StringRules_Ipv6Prefix)(nil),
		(*StringRules_HostAndPort)(nil),
		(*StringRules_WellKnownRegex)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[20].OneofWrappers = []any{
		(*BytesRules_Ip)(nil),
		(*BytesRules_Ipv4)(nil),
		(*BytesRules_Ipv6)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[25].OneofWrappers = []any{
		(*DurationRules_Lt)(nil),
		(*DurationRules_Lte)(nil),
		(*DurationRules_Gt)(nil),
		(*DurationRules_Gte)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[26].OneofWrappers = []any{
		(*TimestampRules_Lt)(nil),
		(*TimestampRules_Lte)(nil),
		(*TimestampRules_LtNow)(nil),
		(*TimestampRules_Gt)(nil),
		(*TimestampRules_Gte)(nil),
		(*TimestampRules_GtNow)(nil),
	}
	file_buf_validate_validate_proto_msgTypes[30].OneofWrappers = []any{
		(*FieldPathElement_Index)(nil),
		(*FieldPathElement_BoolKey)(nil),
		(*FieldPathElement_IntKey)(nil),
		(*FieldPathElement_UintKey)(nil),
		(*FieldPathElement_StringKey)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_validate_validate_proto_rawDesc), len(file_buf_validate_validate_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   31,
			NumExtensions: 4,
			NumServices:   0,
		},
		GoTypes:           file_buf_validate_validate_proto_goTypes,
		DependencyIndexes: file_buf_validate_validate_proto_depIdxs,
		EnumInfos:         file_buf_validate_validate_proto_enumTypes,
		MessageInfos:      file_buf_validate_validate_proto_msgTypes,
		ExtensionInfos:    file_buf_validate_validate_proto_extTypes,
	}.Build()
	File_buf_validate_validate_proto = out.File
	file_buf_validate_validate_proto_goTypes = nil
	file_buf_validate_validate_proto_depIdxs = nil
}
