/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse;

public class ListImagesInRecycleBinPublisher
implements SdkPublisher<ListImagesInRecycleBinResponse> {
    private final Ec2AsyncClient client;
    private final ListImagesInRecycleBinRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImagesInRecycleBinPublisher(Ec2AsyncClient client, ListImagesInRecycleBinRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImagesInRecycleBinPublisher(Ec2AsyncClient client, ListImagesInRecycleBinRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImagesInRecycleBinResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImagesInRecycleBinResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageRecycleBinInfo> images() {
        Function<ListImagesInRecycleBinResponse, Iterator> getIterator = response -> {
            if (response != null && response.images() != null) {
                return response.images().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImagesInRecycleBinResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImagesInRecycleBinResponseFetcher
    implements AsyncPageFetcher<ListImagesInRecycleBinResponse> {
        private ListImagesInRecycleBinResponseFetcher() {
        }

        public boolean hasNextPage(ListImagesInRecycleBinResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImagesInRecycleBinResponse> nextPage(ListImagesInRecycleBinResponse previousPage) {
            if (previousPage == null) {
                return ListImagesInRecycleBinPublisher.this.client.listImagesInRecycleBin(ListImagesInRecycleBinPublisher.this.firstRequest);
            }
            return ListImagesInRecycleBinPublisher.this.client.listImagesInRecycleBin((ListImagesInRecycleBinRequest)((Object)ListImagesInRecycleBinPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

