/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.Token;
import org.apache.lucene.analysis.ko.dict.KoMorphData;
import org.apache.lucene.analysis.morph.TokenType;

public class DictionaryToken
extends Token {
    private final int wordId;
    private final KoMorphData morphAtts;

    public DictionaryToken(TokenType type, KoMorphData morphAtts, int wordId, char[] surfaceForm, int offset, int length, int startOffset, int endOffset) {
        super(surfaceForm, offset, length, startOffset, endOffset, type);
        this.morphAtts = morphAtts;
        this.wordId = wordId;
    }

    public String toString() {
        return "DictionaryToken(\"" + this.getSurfaceFormString() + "\" pos=" + this.getStartOffset() + " length=" + this.getLength() + " posLen=" + this.getPositionLength() + " type=" + String.valueOf(this.type) + " wordId=" + this.wordId + " leftID=" + this.morphAtts.getLeftId(this.wordId) + ")";
    }

    public boolean isKnown() {
        return this.type == TokenType.KNOWN;
    }

    public boolean isUnknown() {
        return this.type == TokenType.UNKNOWN;
    }

    public boolean isUser() {
        return this.type == TokenType.USER;
    }

    @Override
    public POS.Type getPOSType() {
        return this.morphAtts.getPOSType(this.wordId);
    }

    @Override
    public POS.Tag getLeftPOS() {
        return this.morphAtts.getLeftPOS(this.wordId);
    }

    @Override
    public POS.Tag getRightPOS() {
        return this.morphAtts.getRightPOS(this.wordId);
    }

    @Override
    public String getReading() {
        return this.morphAtts.getReading(this.wordId);
    }

    @Override
    public KoMorphData.Morpheme[] getMorphemes() {
        return this.morphAtts.getMorphemes(this.wordId, this.getSurfaceForm(), this.getOffset(), this.getLength());
    }
}

