/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import oracle.ons.Message;
import oracle.ons.MessageReader;

public class MessageReaderTest {
    private final Random random = new Random();

    public static void main(String[] stringArray) {
        new MessageReaderTest().go(Integer.parseInt(stringArray[0]));
    }

    private boolean prob(double d) {
        return this.random.nextDouble() < d;
    }

    private String randString(int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < n; ++n3) {
            stringBuilder.append(Character.toChars(this.random.nextInt(27) + 65));
        }
        for (n3 = 0; n3 < n2 && !this.prob(1.0 / (double)n2); ++n3) {
            stringBuilder.append(Character.toChars(this.random.nextInt(27) + 65));
        }
        return stringBuilder.toString();
    }

    private void go(int n) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0x6500000);
        int n2 = 0;
        System.out.println(String.format("Generating %d messages...", n));
        try {
            for (int i = 0; i < n; ++i) {
                Message message = this.createMessage();
                if (byteArrayOutputStream.size() > 0x6400000) {
                    System.out.println(String.format("100M (%d) exceeded, new buffer", byteArrayOutputStream.size() / 1024));
                    byteArrayOutputStream.close();
                    n2 += byteArrayOutputStream.size();
                    arrayList.add(byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream = new ByteArrayOutputStream();
                }
                message.send(byteArrayOutputStream);
            }
            byteArrayOutputStream.close();
            arrayList.add(byteArrayOutputStream.toByteArray());
            n2 += byteArrayOutputStream.size();
            byteArrayOutputStream = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MessageReader messageReader = new MessageReader();
        System.out.println("Total length : " + Integer.toString(n2));
        System.out.println("Parsing...");
        int n3 = 0;
        long l = System.currentTimeMillis();
        for (byte[] byArray : arrayList) {
            int n4 = 0;
            while (n4 < byArray.length) {
                int n5 = Math.min(this.random.nextInt(8192) + 16384, byArray.length - n4);
                messageReader.feedBuffer(byArray, n4, n5);
                n4 += n5;
                while (messageReader.available()) {
                    messageReader.remove();
                    ++n3;
                }
            }
        }
        long l2 = System.currentTimeMillis();
        double d = 0.953674 * ((double)n2 / (double)(l2 - l)) / 1000.0;
        System.out.println(String.format("Parsed %d messages in %d msec (%f Mb/sec)", n3, (int)(l2 - l), d));
    }

    private Message createMessage() {
        Message message = new Message(this.randString(5, 5));
        while (this.prob(0.7)) {
            message.put(this.randString(5, 15), this.randString(2, 20));
        }
        if (this.prob(0.2)) {
            byte[] byArray = new byte[this.random.nextInt(128)];
            this.random.nextBytes(byArray);
            try {
                message.getBodyOutputStream().write(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        message.ready();
        return message;
    }
}

