/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.util.NumberUtil;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusAspect;
import org.gradle.process.internal.health.memory.OsMemoryStatusListener;
import org.jspecify.annotations.Nullable;

public class LowMemoryDaemonExpirationStrategy
implements DaemonExpirationStrategy,
OsMemoryStatusListener {
    private ReentrantLock lock = new ReentrantLock();
    private OsMemoryStatus memoryStatus;
    private final double minFreeMemoryPercentage;
    private long physicalMemoryThresholdInBytes;
    private long virtualMemoryThresholdInBytes;
    private static final Logger LOGGER = Logging.getLogger(LowMemoryDaemonExpirationStrategy.class);
    public static final long MIN_THRESHOLD_BYTES = 0x18000000L;
    public static final long MAX_THRESHOLD_BYTES = 0x40000000L;

    public LowMemoryDaemonExpirationStrategy(double minFreeMemoryPercentage) {
        Preconditions.checkArgument((minFreeMemoryPercentage >= 0.0 ? 1 : 0) != 0, (Object)"Free memory percentage must be >= 0");
        Preconditions.checkArgument((minFreeMemoryPercentage <= 1.0 ? 1 : 0) != 0, (Object)"Free memory percentage must be <= 1");
        this.minFreeMemoryPercentage = minFreeMemoryPercentage;
    }

    private long normalizeThreshold(long thresholdIn, long minValue, long maxValue) {
        return Math.min(maxValue, Math.max(minValue, thresholdIn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DaemonExpirationResult checkExpiration() {
        this.lock.lock();
        try {
            if (this.memoryStatus != null) {
                DaemonExpirationResult result = this.checkExpiry(this.memoryStatus.getPhysicalMemory(), this.physicalMemoryThresholdInBytes);
                if (result != null) {
                    DaemonExpirationResult daemonExpirationResult = result;
                    return daemonExpirationResult;
                }
                OsMemoryStatusAspect virtualMemory = this.memoryStatus.getVirtualMemory();
                if (virtualMemory instanceof OsMemoryStatusAspect.Available && (result = this.checkExpiry((OsMemoryStatusAspect.Available)virtualMemory, this.virtualMemoryThresholdInBytes)) != null) {
                    DaemonExpirationResult daemonExpirationResult = result;
                    return daemonExpirationResult;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }

    private @Nullable DaemonExpirationResult checkExpiry(OsMemoryStatusAspect.Available memory, long memoryThresholdInBytes) {
        long freeMem = memory.getFree();
        if (freeMem < memoryThresholdInBytes) {
            LOGGER.info("after free system {} memory ({}) fell below threshold of {}", new Object[]{memory.getName(), NumberUtil.formatBytes((Long)freeMem), NumberUtil.formatBytes((Long)memoryThresholdInBytes)});
            return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, "to reclaim system " + memory.getName() + " memory");
        }
        if (freeMem < memoryThresholdInBytes * 2L) {
            LOGGER.debug("Nearing low {} memory threshold - {}", (Object)memory.getName(), (Object)this.memoryStatus);
        }
        return null;
    }

    public void onOsMemoryStatus(OsMemoryStatus newStatus) {
        this.lock.lock();
        try {
            this.memoryStatus = newStatus;
            this.physicalMemoryThresholdInBytes = this.normalizeThreshold((long)((double)this.memoryStatus.getPhysicalMemory().getTotal() * this.minFreeMemoryPercentage), 0x18000000L, 0x40000000L);
            OsMemoryStatusAspect virtualMemory = this.memoryStatus.getVirtualMemory();
            if (virtualMemory instanceof OsMemoryStatusAspect.Available) {
                this.virtualMemoryThresholdInBytes = this.normalizeThreshold((long)((double)((OsMemoryStatusAspect.Available)virtualMemory).getTotal() * this.minFreeMemoryPercentage), 0x18000000L, 0x40000000L);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

