/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorFunction;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import java.util.Arrays;
import java.util.Objects;
import org.w3c.dom.DOMException;

class BaseProfiledColor
extends BaseColor {
    private static final long serialVersionUID = 1L;
    private String profileName;
    private PrimitiveValue[] components;

    BaseProfiledColor(String string) {
        this(string, new PrimitiveValue[0]);
    }

    BaseProfiledColor(String string, PrimitiveValue[] primitiveValueArray) {
        this.profileName = string;
        this.components = primitiveValueArray;
    }

    BaseProfiledColor(BaseProfiledColor baseProfiledColor) {
        this.alpha = baseProfiledColor.alpha.clone();
        this.profileName = baseProfiledColor.profileName;
        this.components = new PrimitiveValue[baseProfiledColor.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = baseProfiledColor.components[i].clone();
        }
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.PROFILE;
    }

    @Override
    public String getColorSpace() {
        return this.profileName;
    }

    @Override
    BaseColor.Space getSpace() {
        return BaseColor.Space.OTHER;
    }

    @Override
    void set(BaseColor baseColor) {
        super.set(baseColor);
        BaseProfiledColor baseProfiledColor = (BaseProfiledColor)baseColor;
        if (baseProfiledColor.components.length != this.components.length) {
            throw new DOMException(13, "This value can only be set to a color in the " + (Object)((Object)this.getColorModel()) + " color model with " + this.components.length + " components.");
        }
        this.components = new PrimitiveValue[baseProfiledColor.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = baseProfiledColor.components[i].clone();
        }
        this.profileName = baseColor.getColorSpace();
    }

    @Override
    public PrimitiveValue item(int n) {
        if (n == 0) {
            return this.getAlpha();
        }
        try {
            return this.components[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public int getLength() {
        return this.components.length + 1;
    }

    @Override
    public boolean hasConvertibleComponents() {
        for (PrimitiveValue primitiveValue : this.components) {
            if (BaseProfiledColor.isConvertibleComponent(primitiveValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    void setComponent(int n, PrimitiveValue primitiveValue) {
        if (n == 0) {
            this.setAlpha(primitiveValue);
        } else {
            try {
                this.components[n - 1] = primitiveValue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    void setColorComponents(double[] dArray) {
        int n;
        if (dArray.length > this.components.length) {
            this.components = new PrimitiveValue[dArray.length];
        }
        for (n = 0; n < dArray.length; ++n) {
            double d = dArray[n];
            NumberValue numberValue = new NumberValue();
            numberValue.setFloatValue((short)0, (float)d);
            numberValue.setSubproperty(true);
            numberValue.setAbsolutizedUnit();
            numberValue.setMaximumFractionDigits(6);
            this.components[n] = numberValue;
        }
        for (n = dArray.length; n < this.components.length; ++n) {
            NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, 0.0f);
            numberValue.setSubproperty(true);
            this.components[n] = numberValue;
        }
    }

    @Override
    public double[] toNumberArray() throws DOMException {
        if (!this.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        double[] dArray = new double[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            dArray[i] = ColorUtil.floatNumber((TypedValue)this.components[i]);
        }
        return dArray;
    }

    @Override
    double[] toSRGB(boolean bl) {
        throw new DOMException(9, "Cannot convert profiled colors.");
    }

    @Override
    public double[] toXYZ(Illuminant illuminant) {
        throw new DOMException(9, "Cannot convert profiled colors.");
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + Arrays.hashCode(this.components);
        n2 = 31 * n2 + Objects.hash(this.profileName);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BaseProfiledColor baseProfiledColor = (BaseProfiledColor)object;
        return Arrays.equals(this.components, baseProfiledColor.components) && Objects.equals(this.profileName, baseProfiledColor.profileName);
    }

    @Override
    public ColorValue packInValue() {
        return new ColorFunction(this);
    }

    @Override
    public BaseProfiledColor clone() {
        return new BaseProfiledColor(this);
    }
}

