{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GtkShortcutsShortcut@ represents a single keyboard shortcut or gesture
-- with a short text.
-- 
-- This widget is only meant to be used with @GtkShortcutsWindow@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ShortcutsShortcut
    ( 

-- * Exported types
    ShortcutsShortcut(..)                   ,
    IsShortcutsShortcut                     ,
    toShortcutsShortcut                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveShortcutsShortcutMethod          ,
#endif



 -- * Properties


-- ** accelSizeGroup #attr:accelSizeGroup#
-- | The size group for the accelerator portion of this shortcut.
-- 
-- This is used internally by GTK, and must not be modified by applications.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutAccelSizeGroupPropertyInfo,
#endif
    clearShortcutsShortcutAccelSizeGroup    ,
    constructShortcutsShortcutAccelSizeGroup,
    setShortcutsShortcutAccelSizeGroup      ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutAccelSizeGroup         ,
#endif


-- ** accelerator #attr:accelerator#
-- | The accelerator(s) represented by this object.
-- 
-- This property is used if [ShortcutsShortcut:shortcutType]("GI.Gtk.Objects.ShortcutsShortcut#g:attr:shortcutType")
-- is set to 'GI.Gtk.Enums.ShortcutTypeAccelerator'.
-- 
-- The syntax of this property is (an extension of) the syntax understood
-- by 'GI.Gtk.Functions.acceleratorParse'. Multiple accelerators can be specified
-- by separating them with a space, but keep in mind that the available width
-- is limited.
-- 
-- It is also possible to specify ranges of shortcuts, using @...@ between
-- the keys. Sequences of keys can be specified using a @+@ or @&@ between
-- the keys.
-- 
-- Examples:
-- 
-- * A single shortcut: @\<ctl>\<alt>delete@
-- * Two alternative shortcuts: @\<shift>a Home@
-- * A range of shortcuts: @\<alt>1...\<alt>9@
-- * Several keys pressed together: @Control_L&Control_R@
-- * A sequence of shortcuts or keys: @\<ctl>c+\<ctl>x@
-- 
-- 
-- Use \"+\" instead of \"&\" when the keys may (or have to be) pressed
-- sequentially (e.g use \"t+t\" for \'press the t key twice\').
-- 
-- Note that @\<@, @>@ and @&@ need to be escaped as @&lt;@, @&gt@; and @&amp@; when used
-- in .ui files.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutAcceleratorPropertyInfo,
#endif
    clearShortcutsShortcutAccelerator       ,
    constructShortcutsShortcutAccelerator   ,
    getShortcutsShortcutAccelerator         ,
    setShortcutsShortcutAccelerator         ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutAccelerator            ,
#endif


-- ** actionName #attr:actionName#
-- | A detailed action name.
-- 
-- If this is set for a shortcut of type 'GI.Gtk.Enums.ShortcutTypeAccelerator',
-- then GTK will use the accelerators that are associated with the
-- action via 'GI.Gtk.Objects.Application.applicationSetAccelsForAction', and
-- setting [ShortcutsShortcut:accelerator]("GI.Gtk.Objects.ShortcutsShortcut#g:attr:accelerator") is not necessary.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutActionNamePropertyInfo ,
#endif
    clearShortcutsShortcutActionName        ,
    constructShortcutsShortcutActionName    ,
    getShortcutsShortcutActionName          ,
    setShortcutsShortcutActionName          ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutActionName             ,
#endif


-- ** direction #attr:direction#
-- | The text direction for which this shortcut is active.
-- 
-- If the shortcut is used regardless of the text direction,
-- set this property to 'GI.Gtk.Enums.TextDirectionNone'.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutDirectionPropertyInfo  ,
#endif
    constructShortcutsShortcutDirection     ,
    getShortcutsShortcutDirection           ,
    setShortcutsShortcutDirection           ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutDirection              ,
#endif


-- ** icon #attr:icon#
-- | An icon to represent the shortcut or gesture.
-- 
-- This property is used if [ShortcutsShortcut:shortcutType]("GI.Gtk.Objects.ShortcutsShortcut#g:attr:shortcutType")
-- is set to 'GI.Gtk.Enums.ShortcutTypeGesture'.
-- 
-- For the other predefined gesture types, GTK provides an icon on its own.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutIconPropertyInfo       ,
#endif
    clearShortcutsShortcutIcon              ,
    constructShortcutsShortcutIcon          ,
    getShortcutsShortcutIcon                ,
    setShortcutsShortcutIcon                ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutIcon                   ,
#endif


-- ** iconSet #attr:iconSet#
-- | 'P.True' if an icon has been set.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutIconSetPropertyInfo    ,
#endif
    constructShortcutsShortcutIconSet       ,
    getShortcutsShortcutIconSet             ,
    setShortcutsShortcutIconSet             ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutIconSet                ,
#endif


-- ** shortcutType #attr:shortcutType#
-- | The type of shortcut that is represented.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutShortcutTypePropertyInfo,
#endif
    constructShortcutsShortcutShortcutType  ,
    getShortcutsShortcutShortcutType        ,
    setShortcutsShortcutShortcutType        ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutShortcutType           ,
#endif


-- ** subtitle #attr:subtitle#
-- | The subtitle for the shortcut or gesture.
-- 
-- This is typically used for gestures and should be a short, one-line
-- text that describes the gesture itself. For the predefined gesture
-- types, GTK provides a subtitle on its own.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutSubtitlePropertyInfo   ,
#endif
    clearShortcutsShortcutSubtitle          ,
    constructShortcutsShortcutSubtitle      ,
    getShortcutsShortcutSubtitle            ,
    setShortcutsShortcutSubtitle            ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutSubtitle               ,
#endif


-- ** subtitleSet #attr:subtitleSet#
-- | 'P.True' if a subtitle has been set.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutSubtitleSetPropertyInfo,
#endif
    constructShortcutsShortcutSubtitleSet   ,
    getShortcutsShortcutSubtitleSet         ,
    setShortcutsShortcutSubtitleSet         ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutSubtitleSet            ,
#endif


-- ** title #attr:title#
-- | The textual description for the shortcut or gesture represented by
-- this object.
-- 
-- This should be a short string that can fit in a single line.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutTitlePropertyInfo      ,
#endif
    clearShortcutsShortcutTitle             ,
    constructShortcutsShortcutTitle         ,
    getShortcutsShortcutTitle               ,
    setShortcutsShortcutTitle               ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutTitle                  ,
#endif


-- ** titleSizeGroup #attr:titleSizeGroup#
-- | The size group for the textual portion of this shortcut.
-- 
-- This is used internally by GTK, and must not be modified by applications.

#if defined(ENABLE_OVERLOADING)
    ShortcutsShortcutTitleSizeGroupPropertyInfo,
#endif
    clearShortcutsShortcutTitleSizeGroup    ,
    constructShortcutsShortcutTitleSizeGroup,
    setShortcutsShortcutTitleSizeGroup      ,
#if defined(ENABLE_OVERLOADING)
    shortcutsShortcutTitleSizeGroup         ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.SizeGroup as Gtk.SizeGroup
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.SizeGroup as Gtk.SizeGroup
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ShortcutsShortcut = ShortcutsShortcut (SP.ManagedPtr ShortcutsShortcut)
    deriving (Eq)

instance SP.ManagedPtrNewtype ShortcutsShortcut where
    toManagedPtr (ShortcutsShortcut p) = p

foreign import ccall "gtk_shortcuts_shortcut_get_type"
    c_gtk_shortcuts_shortcut_get_type :: IO B.Types.GType

instance B.Types.TypedObject ShortcutsShortcut where
    glibType = c_gtk_shortcuts_shortcut_get_type

instance B.Types.GObject ShortcutsShortcut

-- | Type class for types which can be safely cast to t'ShortcutsShortcut', for instance with `toShortcutsShortcut`.
class (SP.GObject o, O.IsDescendantOf ShortcutsShortcut o) => IsShortcutsShortcut o
instance (SP.GObject o, O.IsDescendantOf ShortcutsShortcut o) => IsShortcutsShortcut o

instance O.HasParentTypes ShortcutsShortcut
type instance O.ParentTypes ShortcutsShortcut = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'ShortcutsShortcut', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toShortcutsShortcut :: (MIO.MonadIO m, IsShortcutsShortcut o) => o -> m ShortcutsShortcut
toShortcutsShortcut = MIO.liftIO . B.ManagedPtr.unsafeCastTo ShortcutsShortcut

-- | Convert t'ShortcutsShortcut' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ShortcutsShortcut) where
    gvalueGType_ = c_gtk_shortcuts_shortcut_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ShortcutsShortcut)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ShortcutsShortcut)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ShortcutsShortcut ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveShortcutsShortcutMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveShortcutsShortcutMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveShortcutsShortcutMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveShortcutsShortcutMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveShortcutsShortcutMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveShortcutsShortcutMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveShortcutsShortcutMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveShortcutsShortcutMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveShortcutsShortcutMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveShortcutsShortcutMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveShortcutsShortcutMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveShortcutsShortcutMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveShortcutsShortcutMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveShortcutsShortcutMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveShortcutsShortcutMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveShortcutsShortcutMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveShortcutsShortcutMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveShortcutsShortcutMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveShortcutsShortcutMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveShortcutsShortcutMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveShortcutsShortcutMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveShortcutsShortcutMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveShortcutsShortcutMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveShortcutsShortcutMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveShortcutsShortcutMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveShortcutsShortcutMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveShortcutsShortcutMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveShortcutsShortcutMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveShortcutsShortcutMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveShortcutsShortcutMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveShortcutsShortcutMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveShortcutsShortcutMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveShortcutsShortcutMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveShortcutsShortcutMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveShortcutsShortcutMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveShortcutsShortcutMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveShortcutsShortcutMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveShortcutsShortcutMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveShortcutsShortcutMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveShortcutsShortcutMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveShortcutsShortcutMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveShortcutsShortcutMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveShortcutsShortcutMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveShortcutsShortcutMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveShortcutsShortcutMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveShortcutsShortcutMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveShortcutsShortcutMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveShortcutsShortcutMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveShortcutsShortcutMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveShortcutsShortcutMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveShortcutsShortcutMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveShortcutsShortcutMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveShortcutsShortcutMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveShortcutsShortcutMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveShortcutsShortcutMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveShortcutsShortcutMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveShortcutsShortcutMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveShortcutsShortcutMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveShortcutsShortcutMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveShortcutsShortcutMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveShortcutsShortcutMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveShortcutsShortcutMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveShortcutsShortcutMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveShortcutsShortcutMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveShortcutsShortcutMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveShortcutsShortcutMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveShortcutsShortcutMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveShortcutsShortcutMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveShortcutsShortcutMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveShortcutsShortcutMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveShortcutsShortcutMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveShortcutsShortcutMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveShortcutsShortcutMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveShortcutsShortcutMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveShortcutsShortcutMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveShortcutsShortcutMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveShortcutsShortcutMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveShortcutsShortcutMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveShortcutsShortcutMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveShortcutsShortcutMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveShortcutsShortcutMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveShortcutsShortcutMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveShortcutsShortcutMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveShortcutsShortcutMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveShortcutsShortcutMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveShortcutsShortcutMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveShortcutsShortcutMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveShortcutsShortcutMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveShortcutsShortcutMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveShortcutsShortcutMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveShortcutsShortcutMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveShortcutsShortcutMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveShortcutsShortcutMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveShortcutsShortcutMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveShortcutsShortcutMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveShortcutsShortcutMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveShortcutsShortcutMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveShortcutsShortcutMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveShortcutsShortcutMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveShortcutsShortcutMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveShortcutsShortcutMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveShortcutsShortcutMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveShortcutsShortcutMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveShortcutsShortcutMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveShortcutsShortcutMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveShortcutsShortcutMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveShortcutsShortcutMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveShortcutsShortcutMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveShortcutsShortcutMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveShortcutsShortcutMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveShortcutsShortcutMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveShortcutsShortcutMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveShortcutsShortcutMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveShortcutsShortcutMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveShortcutsShortcutMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveShortcutsShortcutMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveShortcutsShortcutMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveShortcutsShortcutMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveShortcutsShortcutMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveShortcutsShortcutMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveShortcutsShortcutMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveShortcutsShortcutMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveShortcutsShortcutMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveShortcutsShortcutMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveShortcutsShortcutMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveShortcutsShortcutMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveShortcutsShortcutMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveShortcutsShortcutMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveShortcutsShortcutMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveShortcutsShortcutMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveShortcutsShortcutMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveShortcutsShortcutMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveShortcutsShortcutMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveShortcutsShortcutMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveShortcutsShortcutMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveShortcutsShortcutMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveShortcutsShortcutMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveShortcutsShortcutMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveShortcutsShortcutMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveShortcutsShortcutMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveShortcutsShortcutMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveShortcutsShortcutMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveShortcutsShortcutMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveShortcutsShortcutMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveShortcutsShortcutMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveShortcutsShortcutMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveShortcutsShortcutMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveShortcutsShortcutMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveShortcutsShortcutMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveShortcutsShortcutMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveShortcutsShortcutMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveShortcutsShortcutMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveShortcutsShortcutMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveShortcutsShortcutMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveShortcutsShortcutMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveShortcutsShortcutMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveShortcutsShortcutMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveShortcutsShortcutMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveShortcutsShortcutMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveShortcutsShortcutMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveShortcutsShortcutMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveShortcutsShortcutMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveShortcutsShortcutMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveShortcutsShortcutMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveShortcutsShortcutMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveShortcutsShortcutMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveShortcutsShortcutMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveShortcutsShortcutMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveShortcutsShortcutMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveShortcutsShortcutMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveShortcutsShortcutMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveShortcutsShortcutMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveShortcutsShortcutMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveShortcutsShortcutMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveShortcutsShortcutMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveShortcutsShortcutMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveShortcutsShortcutMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveShortcutsShortcutMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveShortcutsShortcutMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveShortcutsShortcutMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveShortcutsShortcutMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveShortcutsShortcutMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveShortcutsShortcutMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveShortcutsShortcutMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveShortcutsShortcutMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveShortcutsShortcutMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveShortcutsShortcutMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveShortcutsShortcutMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveShortcutsShortcutMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveShortcutsShortcutMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveShortcutsShortcutMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveShortcutsShortcutMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveShortcutsShortcutMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveShortcutsShortcutMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveShortcutsShortcutMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveShortcutsShortcutMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveShortcutsShortcutMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveShortcutsShortcutMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveShortcutsShortcutMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveShortcutsShortcutMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveShortcutsShortcutMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveShortcutsShortcutMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveShortcutsShortcutMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveShortcutsShortcutMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveShortcutsShortcutMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveShortcutsShortcutMethod t ShortcutsShortcut, O.OverloadedMethod info ShortcutsShortcut p) => OL.IsLabel t (ShortcutsShortcut -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveShortcutsShortcutMethod t ShortcutsShortcut, O.OverloadedMethod info ShortcutsShortcut p, R.HasField t ShortcutsShortcut p) => R.HasField t ShortcutsShortcut p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveShortcutsShortcutMethod t ShortcutsShortcut, O.OverloadedMethodInfo info ShortcutsShortcut) => OL.IsLabel t (O.MethodProxy info ShortcutsShortcut) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "accel-size-group"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SizeGroup"})
   -- Flags: [PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Set the value of the “@accel-size-group@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #accelSizeGroup 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutAccelSizeGroup :: (MonadIO m, IsShortcutsShortcut o, Gtk.SizeGroup.IsSizeGroup a) => o -> a -> m ()
setShortcutsShortcutAccelSizeGroup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "accel-size-group" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accel-size-group@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutAccelSizeGroup :: (IsShortcutsShortcut o, MIO.MonadIO m, Gtk.SizeGroup.IsSizeGroup a) => a -> m (GValueConstruct o)
constructShortcutsShortcutAccelSizeGroup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "accel-size-group" (P.Just val)

-- | Set the value of the “@accel-size-group@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accelSizeGroup
-- @
clearShortcutsShortcutAccelSizeGroup :: (MonadIO m, IsShortcutsShortcut o) => o -> m ()
clearShortcutsShortcutAccelSizeGroup obj = liftIO $ B.Properties.setObjectPropertyObject obj "accel-size-group" (Nothing :: Maybe Gtk.SizeGroup.SizeGroup)

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutAccelSizeGroupPropertyInfo
instance AttrInfo ShortcutsShortcutAccelSizeGroupPropertyInfo where
    type AttrAllowedOps ShortcutsShortcutAccelSizeGroupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsShortcutAccelSizeGroupPropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutAccelSizeGroupPropertyInfo = Gtk.SizeGroup.IsSizeGroup
    type AttrTransferTypeConstraint ShortcutsShortcutAccelSizeGroupPropertyInfo = Gtk.SizeGroup.IsSizeGroup
    type AttrTransferType ShortcutsShortcutAccelSizeGroupPropertyInfo = Gtk.SizeGroup.SizeGroup
    type AttrGetType ShortcutsShortcutAccelSizeGroupPropertyInfo = ()
    type AttrLabel ShortcutsShortcutAccelSizeGroupPropertyInfo = "accel-size-group"
    type AttrOrigin ShortcutsShortcutAccelSizeGroupPropertyInfo = ShortcutsShortcut
    attrGet = undefined
    attrSet = setShortcutsShortcutAccelSizeGroup
    attrTransfer _ v = do
        unsafeCastTo Gtk.SizeGroup.SizeGroup v
    attrConstruct = constructShortcutsShortcutAccelSizeGroup
    attrClear = clearShortcutsShortcutAccelSizeGroup
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.accelSizeGroup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:accelSizeGroup"
        })
#endif

-- VVV Prop "accelerator"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@accelerator@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsShortcut #accelerator
-- @
getShortcutsShortcutAccelerator :: (MonadIO m, IsShortcutsShortcut o) => o -> m (Maybe T.Text)
getShortcutsShortcutAccelerator obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "accelerator"

-- | Set the value of the “@accelerator@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #accelerator 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutAccelerator :: (MonadIO m, IsShortcutsShortcut o) => o -> T.Text -> m ()
setShortcutsShortcutAccelerator obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "accelerator" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@accelerator@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutAccelerator :: (IsShortcutsShortcut o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructShortcutsShortcutAccelerator val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "accelerator" (P.Just val)

-- | Set the value of the “@accelerator@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accelerator
-- @
clearShortcutsShortcutAccelerator :: (MonadIO m, IsShortcutsShortcut o) => o -> m ()
clearShortcutsShortcutAccelerator obj = liftIO $ B.Properties.setObjectPropertyString obj "accelerator" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutAcceleratorPropertyInfo
instance AttrInfo ShortcutsShortcutAcceleratorPropertyInfo where
    type AttrAllowedOps ShortcutsShortcutAcceleratorPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsShortcutAcceleratorPropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutAcceleratorPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ShortcutsShortcutAcceleratorPropertyInfo = (~) T.Text
    type AttrTransferType ShortcutsShortcutAcceleratorPropertyInfo = T.Text
    type AttrGetType ShortcutsShortcutAcceleratorPropertyInfo = (Maybe T.Text)
    type AttrLabel ShortcutsShortcutAcceleratorPropertyInfo = "accelerator"
    type AttrOrigin ShortcutsShortcutAcceleratorPropertyInfo = ShortcutsShortcut
    attrGet = getShortcutsShortcutAccelerator
    attrSet = setShortcutsShortcutAccelerator
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsShortcutAccelerator
    attrClear = clearShortcutsShortcutAccelerator
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.accelerator"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:accelerator"
        })
#endif

-- VVV Prop "action-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@action-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsShortcut #actionName
-- @
getShortcutsShortcutActionName :: (MonadIO m, IsShortcutsShortcut o) => o -> m (Maybe T.Text)
getShortcutsShortcutActionName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "action-name"

-- | Set the value of the “@action-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #actionName 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutActionName :: (MonadIO m, IsShortcutsShortcut o) => o -> T.Text -> m ()
setShortcutsShortcutActionName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "action-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@action-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutActionName :: (IsShortcutsShortcut o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructShortcutsShortcutActionName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "action-name" (P.Just val)

-- | Set the value of the “@action-name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #actionName
-- @
clearShortcutsShortcutActionName :: (MonadIO m, IsShortcutsShortcut o) => o -> m ()
clearShortcutsShortcutActionName obj = liftIO $ B.Properties.setObjectPropertyString obj "action-name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutActionNamePropertyInfo
instance AttrInfo ShortcutsShortcutActionNamePropertyInfo where
    type AttrAllowedOps ShortcutsShortcutActionNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsShortcutActionNamePropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutActionNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ShortcutsShortcutActionNamePropertyInfo = (~) T.Text
    type AttrTransferType ShortcutsShortcutActionNamePropertyInfo = T.Text
    type AttrGetType ShortcutsShortcutActionNamePropertyInfo = (Maybe T.Text)
    type AttrLabel ShortcutsShortcutActionNamePropertyInfo = "action-name"
    type AttrOrigin ShortcutsShortcutActionNamePropertyInfo = ShortcutsShortcut
    attrGet = getShortcutsShortcutActionName
    attrSet = setShortcutsShortcutActionName
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsShortcutActionName
    attrClear = clearShortcutsShortcutActionName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.actionName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:actionName"
        })
#endif

-- VVV Prop "direction"
   -- Type: TInterface (Name {namespace = "Gtk", name = "TextDirection"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@direction@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsShortcut #direction
-- @
getShortcutsShortcutDirection :: (MonadIO m, IsShortcutsShortcut o) => o -> m Gtk.Enums.TextDirection
getShortcutsShortcutDirection obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "direction"

-- | Set the value of the “@direction@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #direction 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutDirection :: (MonadIO m, IsShortcutsShortcut o) => o -> Gtk.Enums.TextDirection -> m ()
setShortcutsShortcutDirection obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "direction" val

-- | Construct a t'GValueConstruct' with valid value for the “@direction@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutDirection :: (IsShortcutsShortcut o, MIO.MonadIO m) => Gtk.Enums.TextDirection -> m (GValueConstruct o)
constructShortcutsShortcutDirection val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "direction" val

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutDirectionPropertyInfo
instance AttrInfo ShortcutsShortcutDirectionPropertyInfo where
    type AttrAllowedOps ShortcutsShortcutDirectionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ShortcutsShortcutDirectionPropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutDirectionPropertyInfo = (~) Gtk.Enums.TextDirection
    type AttrTransferTypeConstraint ShortcutsShortcutDirectionPropertyInfo = (~) Gtk.Enums.TextDirection
    type AttrTransferType ShortcutsShortcutDirectionPropertyInfo = Gtk.Enums.TextDirection
    type AttrGetType ShortcutsShortcutDirectionPropertyInfo = Gtk.Enums.TextDirection
    type AttrLabel ShortcutsShortcutDirectionPropertyInfo = "direction"
    type AttrOrigin ShortcutsShortcutDirectionPropertyInfo = ShortcutsShortcut
    attrGet = getShortcutsShortcutDirection
    attrSet = setShortcutsShortcutDirection
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsShortcutDirection
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.direction"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:direction"
        })
#endif

-- VVV Prop "icon"
   -- Type: TInterface (Name {namespace = "Gio", name = "Icon"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@icon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsShortcut #icon
-- @
getShortcutsShortcutIcon :: (MonadIO m, IsShortcutsShortcut o) => o -> m (Maybe Gio.Icon.Icon)
getShortcutsShortcutIcon obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "icon" Gio.Icon.Icon

-- | Set the value of the “@icon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #icon 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutIcon :: (MonadIO m, IsShortcutsShortcut o, Gio.Icon.IsIcon a) => o -> a -> m ()
setShortcutsShortcutIcon obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "icon" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@icon@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutIcon :: (IsShortcutsShortcut o, MIO.MonadIO m, Gio.Icon.IsIcon a) => a -> m (GValueConstruct o)
constructShortcutsShortcutIcon val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "icon" (P.Just val)

-- | Set the value of the “@icon@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #icon
-- @
clearShortcutsShortcutIcon :: (MonadIO m, IsShortcutsShortcut o) => o -> m ()
clearShortcutsShortcutIcon obj = liftIO $ B.Properties.setObjectPropertyObject obj "icon" (Nothing :: Maybe Gio.Icon.Icon)

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutIconPropertyInfo
instance AttrInfo ShortcutsShortcutIconPropertyInfo where
    type AttrAllowedOps ShortcutsShortcutIconPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsShortcutIconPropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutIconPropertyInfo = Gio.Icon.IsIcon
    type AttrTransferTypeConstraint ShortcutsShortcutIconPropertyInfo = Gio.Icon.IsIcon
    type AttrTransferType ShortcutsShortcutIconPropertyInfo = Gio.Icon.Icon
    type AttrGetType ShortcutsShortcutIconPropertyInfo = (Maybe Gio.Icon.Icon)
    type AttrLabel ShortcutsShortcutIconPropertyInfo = "icon"
    type AttrOrigin ShortcutsShortcutIconPropertyInfo = ShortcutsShortcut
    attrGet = getShortcutsShortcutIcon
    attrSet = setShortcutsShortcutIcon
    attrTransfer _ v = do
        unsafeCastTo Gio.Icon.Icon v
    attrConstruct = constructShortcutsShortcutIcon
    attrClear = clearShortcutsShortcutIcon
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.icon"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:icon"
        })
#endif

-- VVV Prop "icon-set"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@icon-set@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsShortcut #iconSet
-- @
getShortcutsShortcutIconSet :: (MonadIO m, IsShortcutsShortcut o) => o -> m Bool
getShortcutsShortcutIconSet obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "icon-set"

-- | Set the value of the “@icon-set@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #iconSet 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutIconSet :: (MonadIO m, IsShortcutsShortcut o) => o -> Bool -> m ()
setShortcutsShortcutIconSet obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "icon-set" val

-- | Construct a t'GValueConstruct' with valid value for the “@icon-set@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutIconSet :: (IsShortcutsShortcut o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructShortcutsShortcutIconSet val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "icon-set" val

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutIconSetPropertyInfo
instance AttrInfo ShortcutsShortcutIconSetPropertyInfo where
    type AttrAllowedOps ShortcutsShortcutIconSetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ShortcutsShortcutIconSetPropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutIconSetPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ShortcutsShortcutIconSetPropertyInfo = (~) Bool
    type AttrTransferType ShortcutsShortcutIconSetPropertyInfo = Bool
    type AttrGetType ShortcutsShortcutIconSetPropertyInfo = Bool
    type AttrLabel ShortcutsShortcutIconSetPropertyInfo = "icon-set"
    type AttrOrigin ShortcutsShortcutIconSetPropertyInfo = ShortcutsShortcut
    attrGet = getShortcutsShortcutIconSet
    attrSet = setShortcutsShortcutIconSet
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsShortcutIconSet
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.iconSet"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:iconSet"
        })
#endif

-- VVV Prop "shortcut-type"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ShortcutType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@shortcut-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsShortcut #shortcutType
-- @
getShortcutsShortcutShortcutType :: (MonadIO m, IsShortcutsShortcut o) => o -> m Gtk.Enums.ShortcutType
getShortcutsShortcutShortcutType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "shortcut-type"

-- | Set the value of the “@shortcut-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #shortcutType 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutShortcutType :: (MonadIO m, IsShortcutsShortcut o) => o -> Gtk.Enums.ShortcutType -> m ()
setShortcutsShortcutShortcutType obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "shortcut-type" val

-- | Construct a t'GValueConstruct' with valid value for the “@shortcut-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutShortcutType :: (IsShortcutsShortcut o, MIO.MonadIO m) => Gtk.Enums.ShortcutType -> m (GValueConstruct o)
constructShortcutsShortcutShortcutType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "shortcut-type" val

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutShortcutTypePropertyInfo
instance AttrInfo ShortcutsShortcutShortcutTypePropertyInfo where
    type AttrAllowedOps ShortcutsShortcutShortcutTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ShortcutsShortcutShortcutTypePropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutShortcutTypePropertyInfo = (~) Gtk.Enums.ShortcutType
    type AttrTransferTypeConstraint ShortcutsShortcutShortcutTypePropertyInfo = (~) Gtk.Enums.ShortcutType
    type AttrTransferType ShortcutsShortcutShortcutTypePropertyInfo = Gtk.Enums.ShortcutType
    type AttrGetType ShortcutsShortcutShortcutTypePropertyInfo = Gtk.Enums.ShortcutType
    type AttrLabel ShortcutsShortcutShortcutTypePropertyInfo = "shortcut-type"
    type AttrOrigin ShortcutsShortcutShortcutTypePropertyInfo = ShortcutsShortcut
    attrGet = getShortcutsShortcutShortcutType
    attrSet = setShortcutsShortcutShortcutType
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsShortcutShortcutType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.shortcutType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:shortcutType"
        })
#endif

-- VVV Prop "subtitle"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@subtitle@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsShortcut #subtitle
-- @
getShortcutsShortcutSubtitle :: (MonadIO m, IsShortcutsShortcut o) => o -> m (Maybe T.Text)
getShortcutsShortcutSubtitle obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "subtitle"

-- | Set the value of the “@subtitle@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #subtitle 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutSubtitle :: (MonadIO m, IsShortcutsShortcut o) => o -> T.Text -> m ()
setShortcutsShortcutSubtitle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "subtitle" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@subtitle@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutSubtitle :: (IsShortcutsShortcut o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructShortcutsShortcutSubtitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "subtitle" (P.Just val)

-- | Set the value of the “@subtitle@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #subtitle
-- @
clearShortcutsShortcutSubtitle :: (MonadIO m, IsShortcutsShortcut o) => o -> m ()
clearShortcutsShortcutSubtitle obj = liftIO $ B.Properties.setObjectPropertyString obj "subtitle" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutSubtitlePropertyInfo
instance AttrInfo ShortcutsShortcutSubtitlePropertyInfo where
    type AttrAllowedOps ShortcutsShortcutSubtitlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsShortcutSubtitlePropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutSubtitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ShortcutsShortcutSubtitlePropertyInfo = (~) T.Text
    type AttrTransferType ShortcutsShortcutSubtitlePropertyInfo = T.Text
    type AttrGetType ShortcutsShortcutSubtitlePropertyInfo = (Maybe T.Text)
    type AttrLabel ShortcutsShortcutSubtitlePropertyInfo = "subtitle"
    type AttrOrigin ShortcutsShortcutSubtitlePropertyInfo = ShortcutsShortcut
    attrGet = getShortcutsShortcutSubtitle
    attrSet = setShortcutsShortcutSubtitle
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsShortcutSubtitle
    attrClear = clearShortcutsShortcutSubtitle
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.subtitle"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:subtitle"
        })
#endif

-- VVV Prop "subtitle-set"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@subtitle-set@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsShortcut #subtitleSet
-- @
getShortcutsShortcutSubtitleSet :: (MonadIO m, IsShortcutsShortcut o) => o -> m Bool
getShortcutsShortcutSubtitleSet obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "subtitle-set"

-- | Set the value of the “@subtitle-set@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #subtitleSet 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutSubtitleSet :: (MonadIO m, IsShortcutsShortcut o) => o -> Bool -> m ()
setShortcutsShortcutSubtitleSet obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "subtitle-set" val

-- | Construct a t'GValueConstruct' with valid value for the “@subtitle-set@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutSubtitleSet :: (IsShortcutsShortcut o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructShortcutsShortcutSubtitleSet val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "subtitle-set" val

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutSubtitleSetPropertyInfo
instance AttrInfo ShortcutsShortcutSubtitleSetPropertyInfo where
    type AttrAllowedOps ShortcutsShortcutSubtitleSetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ShortcutsShortcutSubtitleSetPropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutSubtitleSetPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ShortcutsShortcutSubtitleSetPropertyInfo = (~) Bool
    type AttrTransferType ShortcutsShortcutSubtitleSetPropertyInfo = Bool
    type AttrGetType ShortcutsShortcutSubtitleSetPropertyInfo = Bool
    type AttrLabel ShortcutsShortcutSubtitleSetPropertyInfo = "subtitle-set"
    type AttrOrigin ShortcutsShortcutSubtitleSetPropertyInfo = ShortcutsShortcut
    attrGet = getShortcutsShortcutSubtitleSet
    attrSet = setShortcutsShortcutSubtitleSet
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsShortcutSubtitleSet
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.subtitleSet"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:subtitleSet"
        })
#endif

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsShortcut #title
-- @
getShortcutsShortcutTitle :: (MonadIO m, IsShortcutsShortcut o) => o -> m (Maybe T.Text)
getShortcutsShortcutTitle obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "title"

-- | Set the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #title 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutTitle :: (MonadIO m, IsShortcutsShortcut o) => o -> T.Text -> m ()
setShortcutsShortcutTitle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "title" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@title@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutTitle :: (IsShortcutsShortcut o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructShortcutsShortcutTitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "title" (P.Just val)

-- | Set the value of the “@title@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #title
-- @
clearShortcutsShortcutTitle :: (MonadIO m, IsShortcutsShortcut o) => o -> m ()
clearShortcutsShortcutTitle obj = liftIO $ B.Properties.setObjectPropertyString obj "title" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutTitlePropertyInfo
instance AttrInfo ShortcutsShortcutTitlePropertyInfo where
    type AttrAllowedOps ShortcutsShortcutTitlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsShortcutTitlePropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutTitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ShortcutsShortcutTitlePropertyInfo = (~) T.Text
    type AttrTransferType ShortcutsShortcutTitlePropertyInfo = T.Text
    type AttrGetType ShortcutsShortcutTitlePropertyInfo = (Maybe T.Text)
    type AttrLabel ShortcutsShortcutTitlePropertyInfo = "title"
    type AttrOrigin ShortcutsShortcutTitlePropertyInfo = ShortcutsShortcut
    attrGet = getShortcutsShortcutTitle
    attrSet = setShortcutsShortcutTitle
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsShortcutTitle
    attrClear = clearShortcutsShortcutTitle
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:title"
        })
#endif

-- VVV Prop "title-size-group"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SizeGroup"})
   -- Flags: [PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Set the value of the “@title-size-group@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsShortcut [ #titleSizeGroup 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsShortcutTitleSizeGroup :: (MonadIO m, IsShortcutsShortcut o, Gtk.SizeGroup.IsSizeGroup a) => o -> a -> m ()
setShortcutsShortcutTitleSizeGroup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "title-size-group" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@title-size-group@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsShortcutTitleSizeGroup :: (IsShortcutsShortcut o, MIO.MonadIO m, Gtk.SizeGroup.IsSizeGroup a) => a -> m (GValueConstruct o)
constructShortcutsShortcutTitleSizeGroup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "title-size-group" (P.Just val)

-- | Set the value of the “@title-size-group@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #titleSizeGroup
-- @
clearShortcutsShortcutTitleSizeGroup :: (MonadIO m, IsShortcutsShortcut o) => o -> m ()
clearShortcutsShortcutTitleSizeGroup obj = liftIO $ B.Properties.setObjectPropertyObject obj "title-size-group" (Nothing :: Maybe Gtk.SizeGroup.SizeGroup)

#if defined(ENABLE_OVERLOADING)
data ShortcutsShortcutTitleSizeGroupPropertyInfo
instance AttrInfo ShortcutsShortcutTitleSizeGroupPropertyInfo where
    type AttrAllowedOps ShortcutsShortcutTitleSizeGroupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsShortcutTitleSizeGroupPropertyInfo = IsShortcutsShortcut
    type AttrSetTypeConstraint ShortcutsShortcutTitleSizeGroupPropertyInfo = Gtk.SizeGroup.IsSizeGroup
    type AttrTransferTypeConstraint ShortcutsShortcutTitleSizeGroupPropertyInfo = Gtk.SizeGroup.IsSizeGroup
    type AttrTransferType ShortcutsShortcutTitleSizeGroupPropertyInfo = Gtk.SizeGroup.SizeGroup
    type AttrGetType ShortcutsShortcutTitleSizeGroupPropertyInfo = ()
    type AttrLabel ShortcutsShortcutTitleSizeGroupPropertyInfo = "title-size-group"
    type AttrOrigin ShortcutsShortcutTitleSizeGroupPropertyInfo = ShortcutsShortcut
    attrGet = undefined
    attrSet = setShortcutsShortcutTitleSizeGroup
    attrTransfer _ v = do
        unsafeCastTo Gtk.SizeGroup.SizeGroup v
    attrConstruct = constructShortcutsShortcutTitleSizeGroup
    attrClear = clearShortcutsShortcutTitleSizeGroup
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsShortcut.titleSizeGroup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ShortcutsShortcut.html#g:attr:titleSizeGroup"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ShortcutsShortcut
type instance O.AttributeList ShortcutsShortcut = ShortcutsShortcutAttributeList
type ShortcutsShortcutAttributeList = ('[ '("accelSizeGroup", ShortcutsShortcutAccelSizeGroupPropertyInfo), '("accelerator", ShortcutsShortcutAcceleratorPropertyInfo), '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("actionName", ShortcutsShortcutActionNamePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("direction", ShortcutsShortcutDirectionPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("icon", ShortcutsShortcutIconPropertyInfo), '("iconSet", ShortcutsShortcutIconSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("shortcutType", ShortcutsShortcutShortcutTypePropertyInfo), '("subtitle", ShortcutsShortcutSubtitlePropertyInfo), '("subtitleSet", ShortcutsShortcutSubtitleSetPropertyInfo), '("title", ShortcutsShortcutTitlePropertyInfo), '("titleSizeGroup", ShortcutsShortcutTitleSizeGroupPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
shortcutsShortcutAccelSizeGroup :: AttrLabelProxy "accelSizeGroup"
shortcutsShortcutAccelSizeGroup = AttrLabelProxy

shortcutsShortcutAccelerator :: AttrLabelProxy "accelerator"
shortcutsShortcutAccelerator = AttrLabelProxy

shortcutsShortcutActionName :: AttrLabelProxy "actionName"
shortcutsShortcutActionName = AttrLabelProxy

shortcutsShortcutDirection :: AttrLabelProxy "direction"
shortcutsShortcutDirection = AttrLabelProxy

shortcutsShortcutIcon :: AttrLabelProxy "icon"
shortcutsShortcutIcon = AttrLabelProxy

shortcutsShortcutIconSet :: AttrLabelProxy "iconSet"
shortcutsShortcutIconSet = AttrLabelProxy

shortcutsShortcutShortcutType :: AttrLabelProxy "shortcutType"
shortcutsShortcutShortcutType = AttrLabelProxy

shortcutsShortcutSubtitle :: AttrLabelProxy "subtitle"
shortcutsShortcutSubtitle = AttrLabelProxy

shortcutsShortcutSubtitleSet :: AttrLabelProxy "subtitleSet"
shortcutsShortcutSubtitleSet = AttrLabelProxy

shortcutsShortcutTitle :: AttrLabelProxy "title"
shortcutsShortcutTitle = AttrLabelProxy

shortcutsShortcutTitleSizeGroup :: AttrLabelProxy "titleSizeGroup"
shortcutsShortcutTitleSizeGroup = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ShortcutsShortcut = ShortcutsShortcutSignalList
type ShortcutsShortcutSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif


